/*
 * Decompiled with CFR 0.152.
 */
package com.gametechbc.traveloptics.data_manager;

import com.github.L_Ender.cataclysm.client.particle.LightningParticle;
import io.redspace.ironsspellbooks.capabilities.magic.MagicManager;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class GalenaChargeManager {
    public static final int MAX_GALENA_CHARGE = 50;
    private static final String AZURE_CHARGE_TAG = "AzureCharge";
    private static final String SCARLET_CHARGE_TAG = "ScarletCharge";
    public static final int AZURE_COLOR_R = 0;
    public static final int AZURE_COLOR_G = 191;
    public static final int AZURE_COLOR_B = 255;
    public static final int SCARLET_COLOR_R = 255;
    public static final int SCARLET_COLOR_G = 36;
    public static final int SCARLET_COLOR_B = 0;

    public static int getAzureCharge(ItemStack stack) {
        if (stack.m_41782_() && stack.m_41783_().m_128441_(AZURE_CHARGE_TAG)) {
            return stack.m_41783_().m_128451_(AZURE_CHARGE_TAG);
        }
        return 0;
    }

    public static void setAzureCharge(ItemStack stack, int charge) {
        int cappedCharge = Math.min(charge, 50);
        stack.m_41784_().m_128405_(AZURE_CHARGE_TAG, cappedCharge);
    }

    public static void addAzureCharge(ItemStack stack, LivingEntity entity, int amount) {
        int currentCharge = GalenaChargeManager.getAzureCharge(stack);
        int newCharge = Math.min(currentCharge + amount, 50);
        GalenaChargeManager.setAzureCharge(stack, newCharge);
        GalenaChargeManager.spawnAzureParticles(entity);
    }

    public static int getScarletCharge(ItemStack stack) {
        if (stack.m_41782_() && stack.m_41783_().m_128441_(SCARLET_CHARGE_TAG)) {
            return stack.m_41783_().m_128451_(SCARLET_CHARGE_TAG);
        }
        return 0;
    }

    public static void setScarletCharge(ItemStack stack, int charge) {
        int cappedCharge = Math.min(charge, 50);
        stack.m_41784_().m_128405_(SCARLET_CHARGE_TAG, cappedCharge);
    }

    public static void addScarletCharge(ItemStack stack, LivingEntity entity, int amount) {
        int currentCharge = GalenaChargeManager.getScarletCharge(stack);
        int newCharge = Math.min(currentCharge + amount, 50);
        GalenaChargeManager.setScarletCharge(stack, newCharge);
        GalenaChargeManager.spawnScarletParticles(entity);
    }

    public static int getTotalCharge(ItemStack stack) {
        return GalenaChargeManager.getAzureCharge(stack) + GalenaChargeManager.getScarletCharge(stack);
    }

    public static boolean hasAnyCharge(ItemStack stack) {
        return GalenaChargeManager.getAzureCharge(stack) > 0 || GalenaChargeManager.getScarletCharge(stack) > 0;
    }

    public static boolean isMaxCharged(ItemStack stack) {
        return GalenaChargeManager.getAzureCharge(stack) >= 50 || GalenaChargeManager.getScarletCharge(stack) >= 50;
    }

    public static void clearAllCharges(ItemStack stack) {
        GalenaChargeManager.setAzureCharge(stack, 0);
        GalenaChargeManager.setScarletCharge(stack, 0);
    }

    public static boolean consumeAzureCharge(ItemStack stack, int amount) {
        int currentCharge = GalenaChargeManager.getAzureCharge(stack);
        if (currentCharge >= amount) {
            GalenaChargeManager.setAzureCharge(stack, currentCharge - amount);
            return true;
        }
        return false;
    }

    public static boolean consumeScarletCharge(ItemStack stack, int amount) {
        int currentCharge = GalenaChargeManager.getScarletCharge(stack);
        if (currentCharge >= amount) {
            GalenaChargeManager.setScarletCharge(stack, currentCharge - amount);
            return true;
        }
        return false;
    }

    public static void transferAzureToScarlet(ItemStack stack, int amount) {
        int azureCharge = GalenaChargeManager.getAzureCharge(stack);
        int transferAmount = Math.min(amount, azureCharge);
        if (transferAmount > 0) {
            GalenaChargeManager.setAzureCharge(stack, azureCharge - transferAmount);
            GalenaChargeManager.addScarletCharge(stack, null, transferAmount);
        }
    }

    public static void transferScarletToAzure(ItemStack stack, int amount) {
        int scarletCharge = GalenaChargeManager.getScarletCharge(stack);
        int transferAmount = Math.min(amount, scarletCharge);
        if (transferAmount > 0) {
            GalenaChargeManager.setScarletCharge(stack, scarletCharge - transferAmount);
            GalenaChargeManager.addAzureCharge(stack, null, transferAmount);
        }
    }

    public static void addAzureCharge(ItemStack stack, int amount) {
        int currentCharge = GalenaChargeManager.getAzureCharge(stack);
        int newCharge = Math.min(currentCharge + amount, 50);
        GalenaChargeManager.setAzureCharge(stack, newCharge);
    }

    public static void addScarletCharge(ItemStack stack, int amount) {
        int currentCharge = GalenaChargeManager.getScarletCharge(stack);
        int newCharge = Math.min(currentCharge + amount, 50);
        GalenaChargeManager.setScarletCharge(stack, newCharge);
    }

    private static void spawnAzureParticles(LivingEntity entity) {
        if (!entity.m_9236_().f_46443_) {
            for (int i = 0; i < 5; ++i) {
                double offsetX = (entity.m_217043_().m_188500_() - 0.5) * (double)entity.m_20205_();
                double offsetY = entity.m_217043_().m_188500_() * (double)entity.m_20206_();
                double offsetZ = (entity.m_217043_().m_188500_() - 0.5) * (double)entity.m_20205_();
                MagicManager.spawnParticles((Level)entity.m_9236_(), (ParticleOptions)new LightningParticle.OrbData(0, 191, 255), (double)(entity.m_20185_() + offsetX), (double)(entity.m_20186_() + offsetY), (double)(entity.m_20189_() + offsetZ), (int)1, (double)0.0, (double)0.0, (double)0.0, (double)0.3, (boolean)false);
            }
        }
    }

    private static void spawnScarletParticles(LivingEntity entity) {
        if (!entity.m_9236_().f_46443_) {
            for (int i = 0; i < 5; ++i) {
                double offsetX = (entity.m_217043_().m_188500_() - 0.5) * (double)entity.m_20205_();
                double offsetY = entity.m_217043_().m_188500_() * (double)entity.m_20206_();
                double offsetZ = (entity.m_217043_().m_188500_() - 0.5) * (double)entity.m_20205_();
                MagicManager.spawnParticles((Level)entity.m_9236_(), (ParticleOptions)new LightningParticle.OrbData(255, 36, 0), (double)(entity.m_20185_() + offsetX), (double)(entity.m_20186_() + offsetY), (double)(entity.m_20189_() + offsetZ), (int)1, (double)0.0, (double)0.0, (double)0.0, (double)0.3, (boolean)false);
            }
        }
    }
}

