/*
 * Decompiled with CFR 0.152.
 */
package com.gametechbc.traveloptics.effects;

import com.gametechbc.traveloptics.init.TravelopticsEffects;
import com.gametechbc.traveloptics.util.TravelopticsTags;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.TripWireBlock;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class AstralSenseTreasureEffect
extends MobEffect {
    private static final int TNT_RADIUS = 8;
    private static final int LOOT_RADIUS = 12;
    private static final int TRAP_RADIUS = 8;

    public AstralSenseTreasureEffect() {
        super(MobEffectCategory.BENEFICIAL, 16766720);
    }

    public void m_6742_(LivingEntity entity, int amplifier) {
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        Level level = player.m_9236_();
        this.detectPrimedTNT(player, level, 8);
        this.detectLootChest(player, level, 12);
        this.detectTraps(player, level, 8);
        this.isValuableBlockNearby(player, level, 12);
    }

    private void detectLootChest(Player player, Level level, int radius) {
        BlockPos playerPos = player.m_20183_();
        BlockPos nearestChest = null;
        double nearestDistanceSqr = Double.MAX_VALUE;
        for (BlockPos pos : BlockPos.m_121940_((BlockPos)playerPos.m_7918_(-radius, -radius, -radius), (BlockPos)playerPos.m_7918_(radius, radius, radius))) {
            double distanceSqr;
            ChestBlockEntity chestEntity;
            BlockState state = level.m_8055_(pos);
            Block block = state.m_60734_();
            if (!(block instanceof ChestBlock)) continue;
            ChestBlock chest = (ChestBlock)block;
            block = level.m_7702_(pos);
            if (!(block instanceof ChestBlockEntity) || (chestEntity = (ChestBlockEntity)block).m_7983_() || !((distanceSqr = pos.m_123331_((Vec3i)playerPos)) < nearestDistanceSqr)) continue;
            nearestDistanceSqr = distanceSqr;
            nearestChest = pos;
        }
        if (nearestChest != null) {
            int distance = (int)Math.sqrt(nearestDistanceSqr);
            this.sendMessage(player, (Component)Component.m_237110_((String)"spell.traveloptics.message.astral_sense.loot_chest", (Object[])new Object[]{distance}).m_130940_(ChatFormatting.LIGHT_PURPLE));
        }
    }

    private void detectTraps(Player player, Level level, int radius) {
        this.getNearbyBlocks(player.m_20183_(), radius).map(arg_0 -> ((Level)level).m_8055_(arg_0)).filter(state -> state.m_60713_(Blocks.f_50267_) && (Boolean)state.m_61143_((Property)TripWireBlock.f_57591_) != false).anyMatch(state -> this.sendMessage(player, (Component)Component.m_237115_((String)"spell.traveloptics.message.astral_sense.trap").m_130940_(ChatFormatting.RED)));
    }

    private void detectPrimedTNT(Player player, Level level, int radius) {
        if (!level.m_45976_(PrimedTnt.class, player.m_20191_().m_82400_((double)radius)).isEmpty()) {
            this.sendMessage(player, (Component)Component.m_237115_((String)"spell.traveloptics.message.astral_sense.tnt").m_130940_(ChatFormatting.RED));
        }
    }

    private Stream<BlockPos> getNearbyBlocks(BlockPos center, int radius) {
        return BlockPos.m_121990_((BlockPos)center.m_7918_(-radius, -radius, -radius), (BlockPos)center.m_7918_(radius, radius, radius));
    }

    private void isValuableBlockNearby(Player player, Level level, int radius) {
        BlockPos playerPos = player.m_20183_();
        BlockPos nearestBlock = null;
        double nearestDistanceSqr = Double.MAX_VALUE;
        for (BlockPos pos : BlockPos.m_121940_((BlockPos)playerPos.m_7918_(-radius, -radius, -radius), (BlockPos)playerPos.m_7918_(radius, radius, radius))) {
            double distanceSqr;
            if (!level.m_8055_(pos).m_204336_(TravelopticsTags.EXTREMELY_VALUABLES) || !((distanceSqr = pos.m_123331_((Vec3i)playerPos)) < nearestDistanceSqr)) continue;
            nearestDistanceSqr = distanceSqr;
            nearestBlock = pos;
        }
        if (nearestBlock != null) {
            int distance = (int)Math.sqrt(nearestDistanceSqr);
            this.sendMessage(player, (Component)Component.m_237110_((String)"spell.traveloptics.message.astral_sense.valuable_block", (Object[])new Object[]{distance}).m_130940_(ChatFormatting.LIGHT_PURPLE));
        }
    }

    private boolean sendMessage(Player player, Component message) {
        player.m_5661_(message, true);
        return true;
    }

    public boolean m_6584_(int duration, int amplifier) {
        return duration % 5 == 0;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class AstralSenseFogFunction
    implements FogRenderer.MobEffectFogFunction {
        public MobEffect m_213948_() {
            return (MobEffect)TravelopticsEffects.ASTRAL_SENSE_TREASURE.get();
        }

        public void m_213725_(FogRenderer.FogData fogData, LivingEntity entity, MobEffectInstance mobEffectInstance, float p_234184_, float p_234185_) {
            float f = 160.0f;
            if (fogData.f_234199_ == FogRenderer.FogMode.FOG_SKY) {
                fogData.f_234200_ = 0.0f;
                fogData.f_234201_ = f * 0.25f;
            } else {
                fogData.f_234200_ = -f * 0.5f;
                fogData.f_234201_ = f;
            }
        }
    }
}

