/*
 * Decompiled with CFR 0.152.
 */
package com.gametechbc.traveloptics.entity.extended_projectiles.extended_wave;

import com.gametechbc.traveloptics.init.TravelopticsEffects;
import com.gametechbc.traveloptics.init.TravelopticsEntities;
import com.gametechbc.traveloptics.init.TravelopticsSpells;
import com.github.alexmodguy.alexscaves.server.entity.item.WaveEntity;
import com.github.alexmodguy.alexscaves.server.entity.living.DeepOneBaseEntity;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.damage.DamageSources;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.network.PlayMessages;

public class ReturningWaveEntity
extends WaveEntity {
    private float damageAmount;
    private int wetAmplifier = 1;
    private boolean isReturnWave = false;
    private boolean hasSpawnedReturn = false;

    public ReturningWaveEntity(EntityType<? extends WaveEntity> entityType, Level level) {
        super(entityType, level);
    }

    public ReturningWaveEntity(Level level, LivingEntity shooter) {
        super(level, shooter);
    }

    public ReturningWaveEntity(Level level, LivingEntity shooter, boolean isReturnWave) {
        super(level, shooter);
        this.isReturnWave = isReturnWave;
    }

    public ReturningWaveEntity(PlayMessages.SpawnEntity spawnEntity, Level level) {
        super((EntityType)TravelopticsEntities.EXTENDED_WAVE.get(), level);
    }

    public void setDamageAmount(float damageAmount) {
        this.damageAmount = damageAmount;
    }

    public float getDamageAmount() {
        return this.damageAmount;
    }

    public int getWetAmplifier() {
        return this.wetAmplifier;
    }

    public void setWetAmplifier(int wetAmplifier) {
        this.wetAmplifier = wetAmplifier;
    }

    public boolean isReturnWave() {
        return this.isReturnWave;
    }

    public void setReturnWave(boolean returnWave) {
        this.isReturnWave = returnWave;
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().f_46443_) {
            this.modifiedAttackEntities();
            if (!this.isReturnWave && !this.hasSpawnedReturn && this.shouldSpawnReturnWave()) {
                this.spawnReturnWave();
                this.hasSpawnedReturn = true;
            }
        }
    }

    private boolean shouldSpawnReturnWave() {
        return this.activeWaveTicks > this.getLifespan() - 1 || this.activeWaveTicks > 9 && this.m_20184_().m_165924_() < 0.04 || this.isSlamming();
    }

    private void spawnReturnWave() {
        if (this.m_9236_().f_46443_ || this.getOwner() == null) {
            return;
        }
        ReturningWaveEntity returnWave = new ReturningWaveEntity(this.m_9236_(), this.getOwner(), true);
        returnWave.m_6034_(this.m_20185_(), this.m_20186_(), this.m_20189_());
        float reverseYaw = this.m_146908_() + 180.0f;
        returnWave.m_146922_(reverseYaw);
        returnWave.setDamageAmount(this.getDamageAmount());
        returnWave.setWetAmplifier(this.getWetAmplifier());
        returnWave.setWaveScale(this.getWaveScale());
        returnWave.setLifespan(this.getLifespan());
        this.m_9236_().m_7967_((Entity)returnWave);
    }

    private void modifiedAttackEntities() {
        AABB bashBox = this.m_20191_().m_82377_(0.5, 0.5, 0.5);
        for (LivingEntity entity : this.m_9236_().m_45976_(LivingEntity.class, bashBox)) {
            if (this.m_7307_((Entity)entity) || entity instanceof DeepOneBaseEntity || this.getOwner() != null && (this.getOwner().equals((Object)entity) || this.getOwner().m_7307_((Entity)entity))) continue;
            DamageSources.applyDamage((Entity)entity, (float)this.getDamageAmount(), (DamageSource)((AbstractSpell)TravelopticsSpells.TSUNAMI_SPELL.get()).getDamageSource((Entity)this, (Entity)this.getOwner()));
            entity.m_7292_(new MobEffectInstance((MobEffect)TravelopticsEffects.WET.get(), 200, this.getWetAmplifier()));
        }
    }

    protected void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        if (tag.m_128441_("DamageAmount")) {
            this.damageAmount = tag.m_128457_("DamageAmount");
        }
        if (tag.m_128425_("WetAmplifier", 3)) {
            this.wetAmplifier = tag.m_128451_("WetAmplifier");
        }
        if (tag.m_128441_("IsReturnWave")) {
            this.isReturnWave = tag.m_128471_("IsReturnWave");
        }
        if (tag.m_128441_("HasSpawnedReturn")) {
            this.hasSpawnedReturn = tag.m_128471_("HasSpawnedReturn");
        }
    }

    protected void m_7380_(CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        compoundTag.m_128350_("DamageAmount", this.damageAmount);
        compoundTag.m_128405_("WetAmplifier", this.wetAmplifier);
        compoundTag.m_128379_("IsReturnWave", this.isReturnWave);
        compoundTag.m_128379_("HasSpawnedReturn", this.hasSpawnedReturn);
    }
}

