/*
 * Decompiled with CFR 0.152.
 */
package com.gametechbc.traveloptics.entity.misc.galena_mark;

import com.gametechbc.traveloptics.entity.misc.galena_mark.GalenaMarkEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class GalenaMarkRenderer
extends EntityRenderer<GalenaMarkEntity> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("traveloptics", "textures/entity/galena_mark/mark_low_res.png");
    private static final int AZURE_COLOR = 49151;
    private static final int SCARLET_COLOR = 16720896;

    public GalenaMarkRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.f_114477_ = 0.0f;
    }

    public void render(GalenaMarkEntity entity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        poseStack.m_85836_();
        poseStack.m_85837_(0.0, 0.3, 0.0);
        poseStack.m_252781_(this.f_114476_.m_253208_());
        float scale = 0.5f;
        poseStack.m_85841_(scale, scale, scale);
        int color = entity.isAzure() ? 49151 : 16720896;
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        float age = (float)entity.f_19797_ + partialTicks;
        float pulse = (float)(Math.sin((double)age * 0.2) * 0.15 + 0.85);
        VertexConsumer vertexConsumer = buffer.m_6299_(RenderType.m_110458_((ResourceLocation)TEXTURE));
        this.renderQuad(vertexConsumer, poseStack, -0.5f, 0.5f, 0.5f, -0.5f, red * pulse, green * pulse, blue * pulse, 1.0f, packedLight);
        poseStack.m_85849_();
    }

    private void renderQuad(VertexConsumer consumer, PoseStack poseStack, float minX, float maxX, float minY, float maxY, float red, float green, float blue, float alpha, int packedLight) {
        consumer.m_252986_(poseStack.m_85850_().m_252922_(), minX, minY, 0.0f).m_85950_(red, green, blue, alpha).m_7421_(0.0f, 1.0f).m_86008_(OverlayTexture.f_118083_).m_7120_(0xF000F0, 0xF000F0).m_252939_(poseStack.m_85850_().m_252943_(), 0.0f, 1.0f, 0.0f).m_5752_();
        consumer.m_252986_(poseStack.m_85850_().m_252922_(), maxX, minY, 0.0f).m_85950_(red, green, blue, alpha).m_7421_(1.0f, 1.0f).m_86008_(OverlayTexture.f_118083_).m_7120_(0xF000F0, 0xF000F0).m_252939_(poseStack.m_85850_().m_252943_(), 0.0f, 1.0f, 0.0f).m_5752_();
        consumer.m_252986_(poseStack.m_85850_().m_252922_(), maxX, maxY, 0.0f).m_85950_(red, green, blue, alpha).m_7421_(1.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_7120_(0xF000F0, 0xF000F0).m_252939_(poseStack.m_85850_().m_252943_(), 0.0f, 1.0f, 0.0f).m_5752_();
        consumer.m_252986_(poseStack.m_85850_().m_252922_(), minX, maxY, 0.0f).m_85950_(red, green, blue, alpha).m_7421_(0.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_7120_(0xF000F0, 0xF000F0).m_252939_(poseStack.m_85850_().m_252943_(), 0.0f, 1.0f, 0.0f).m_5752_();
    }

    public ResourceLocation getTextureLocation(GalenaMarkEntity entity) {
        return TEXTURE;
    }
}

