/*
 * Decompiled with CFR 0.152.
 */
package com.gametechbc.traveloptics.entity.mobs.fading_mage;

import com.gametechbc.traveloptics.TravelopticsMod;
import com.gametechbc.traveloptics.api.entity.AdvancedTrades;
import com.gametechbc.traveloptics.entity.mobs.nightwarden_boss.animated_particle.FadingMageDespawnSequence;
import com.gametechbc.traveloptics.entity.mobs.nightwarden_boss.animated_particle.FadingMageIdle;
import com.gametechbc.traveloptics.init.TravelopticsItems;
import com.gametechbc.traveloptics.init.TravelopticsSounds;
import com.github.alexmodguy.alexscaves.server.misc.ACSoundRegistry;
import com.google.common.collect.Sets;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.entity.mobs.AntiMagicSusceptible;
import io.redspace.ironsspellbooks.entity.mobs.abstract_spell_casting_mob.NeutralWizard;
import io.redspace.ironsspellbooks.entity.mobs.wizards.IMerchantWizard;
import io.redspace.ironsspellbooks.player.AdditionalWanderingTrades;
import io.redspace.ironsspellbooks.registries.ItemRegistry;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.item.trading.MerchantOffers;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class FadingMageEntity
extends NeutralWizard
implements IMerchantWizard,
AntiMagicSusceptible {
    private static final EntityDataAccessor<Boolean> DESPAWN_TRIGGERED = SynchedEntityData.m_135353_(FadingMageEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Float> FADE_OPACITY = SynchedEntityData.m_135353_(FadingMageEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private int despawnTimer = -1;
    private int dialogueIndex = 0;
    private int dialogueCooldown = 0;
    private static final int DESPAWN_DURATION = 100;
    private static final List<Component> LORE_DIALOGUE = List.of(Component.m_237115_((String)"entity.traveloptics.fading_mage.dialogue_1"), Component.m_237115_((String)"entity.traveloptics.fading_mage.dialogue_2"), Component.m_237115_((String)"entity.traveloptics.fading_mage.dialogue_3"), Component.m_237115_((String)"entity.traveloptics.fading_mage.dialogue_4"), Component.m_237115_((String)"entity.traveloptics.fading_mage.dialogue_5"), Component.m_237115_((String)"entity.traveloptics.fading_mage.dialogue_6"), Component.m_237115_((String)"entity.traveloptics.fading_mage.dialogue_7"), Component.m_237115_((String)"entity.traveloptics.fading_mage.dialogue_8"), Component.m_237115_((String)"entity.traveloptics.fading_mage.dialogue_9"), Component.m_237115_((String)"entity.traveloptics.fading_mage.dialogue_10"), Component.m_237115_((String)"entity.traveloptics.fading_mage.dialogue_11"), Component.m_237115_((String)"entity.traveloptics.fading_mage.dialogue_12"), Component.m_237115_((String)"entity.traveloptics.fading_mage.dialogue_13"), Component.m_237115_((String)"entity.traveloptics.fading_mage.dialogue_14"), Component.m_237115_((String)"entity.traveloptics.fading_mage.dialogue_15"), Component.m_237115_((String)"entity.traveloptics.fading_mage.dialogue_16"), Component.m_237115_((String)"entity.traveloptics.fading_mage.dialogue_17"));
    @javax.annotation.Nullable
    private Player tradingPlayer;
    @javax.annotation.Nullable
    protected MerchantOffers offers;
    private long lastRestockGameTime;
    private int numberOfRestocksToday;
    private long lastRestockCheckDayTime;
    private static final List<VillagerTrades.ItemListing> fillerOffers = List.of(new AdvancedTrades.FlexibleTrade(10, new ItemStack((ItemLike)TravelopticsItems.VOID_MANUSCRIPT.get()), 2, 4, new ItemStack((ItemLike)ItemRegistry.INK_EPIC.get()), 1, 1, 0.1f), new AdvancedTrades.FlexibleTrade(5, new ItemStack((ItemLike)TravelopticsItems.VOID_MANUSCRIPT.get()), 6, 8, new ItemStack((ItemLike)ItemRegistry.INK_LEGENDARY.get()), 1, 1, 0.15f), new AdvancedTrades.FlexibleTrade(6, new ItemStack((ItemLike)TravelopticsItems.VOID_MANUSCRIPT.get()), 6, 12, new ItemStack((ItemLike)TravelopticsItems.OBSIDIAN_BOOKSHELF.get()), 1, 1, 0.07f), new AdvancedTrades.DualItemTrade(3, new ItemStack((ItemLike)TravelopticsItems.VOID_MANUSCRIPT.get()), 58, 64, new ItemStack((ItemLike)ItemRegistry.UPGRADE_ORB.get()), 1, 1, new ItemStack((ItemLike)TravelopticsItems.ELDRITCH_UPGRADE_ORB.get()), 1, 1, 0.2f), new AdvancedTrades.FlexibleTrade(2, new ItemStack((ItemLike)TravelopticsItems.VOID_MANUSCRIPT.get()), 35, 42, new ItemStack((ItemLike)TravelopticsItems.ELDRITCH_ECHO.get()), 1, 1, 0.15f), new AdvancedTrades.FlexibleTrade(6, new ItemStack((ItemLike)TravelopticsItems.VOID_MANUSCRIPT.get()), 32, 48, new ItemStack((ItemLike)TravelopticsItems.POCKET_BLACK_HOLE_BELT.get()), 1, 1, 0.1f));
    private final RawAnimation idle = RawAnimation.begin().thenLoop("fading_mage_idle");
    private final RawAnimation counterspelled = RawAnimation.begin().thenPlay("fading_mage_counterspelled");

    public FadingMageEntity(EntityType<? extends PathfinderMob> type, Level level) {
        super(type, level);
        this.m_21530_();
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DESPAWN_TRIGGERED, (Object)false);
        this.f_19804_.m_135372_(FADE_OPACITY, (Object)Float.valueOf(1.0f));
    }

    public boolean isDespawnTriggered() {
        return (Boolean)this.f_19804_.m_135370_(DESPAWN_TRIGGERED);
    }

    public float getFadeOpacity() {
        return ((Float)this.f_19804_.m_135370_(FADE_OPACITY)).floatValue();
    }

    private void setFadeOpacity(float opacity) {
        this.f_19804_.m_135381_(FADE_OPACITY, (Object)Float.valueOf(Math.max(0.0f, Math.min(1.0f, opacity))));
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (source.m_269533_(DamageTypeTags.f_268738_)) {
            this.m_146870_();
            return true;
        }
        return false;
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.dialogueCooldown > 0) {
            --this.dialogueCooldown;
        }
        if (!this.m_9236_().f_46443_ && this.isDespawnTriggered()) {
            if (this.despawnTimer < 0) {
                this.despawnTimer = 100;
            } else if (this.despawnTimer > 0) {
                --this.despawnTimer;
                this.updateFadeOpacity();
                if (this.despawnTimer == 0) {
                    this.m_146870_();
                }
            }
        }
        if (this.m_9236_().f_46443_) {
            if (!this.isDespawnTriggered()) {
                FadingMageIdle.spawnFadingParticles(this, 0.12, 0.15, -0.12, 180.0, 1, 3);
            } else {
                FadingMageDespawnSequence.spawnDespawnTornado(this, this.despawnTimer, 100);
            }
        }
    }

    private void updateFadeOpacity() {
        if (this.despawnTimer >= 0) {
            float newOpacity;
            float progress = 1.0f - (float)this.despawnTimer / 100.0f;
            if (progress <= 0.8f) {
                float phase1Progress = progress / 0.8f;
                newOpacity = 1.0f - phase1Progress * 0.5f;
            } else {
                float phase2Progress = (progress - 0.8f) / 0.2f;
                newOpacity = 0.5f - phase2Progress * 0.5f;
            }
            this.setFadeOpacity(newOpacity);
        }
    }

    public void onAntiMagic(MagicData magicData) {
        if (!this.isDespawnTriggered()) {
            this.f_19804_.m_135381_(DESPAWN_TRIGGERED, (Object)true);
        }
    }

    public boolean m_6087_() {
        return true;
    }

    public boolean m_6094_() {
        return false;
    }

    public boolean m_5829_() {
        return true;
    }

    protected boolean m_8028_() {
        return false;
    }

    public boolean m_21532_() {
        return true;
    }

    public Optional<SoundEvent> getAngerSound() {
        return Optional.of((SoundEvent)TravelopticsSounds.SPECTRAL_BLINK_FAILED.get());
    }

    protected InteractionResult m_6071_(Player player, InteractionHand hand) {
        if (hand == InteractionHand.MAIN_HAND && !this.m_9236_().f_46443_) {
            boolean preventTrade;
            if (this.dialogueIndex < LORE_DIALOGUE.size()) {
                if (this.dialogueCooldown <= 0) {
                    player.m_5661_(LORE_DIALOGUE.get(this.dialogueIndex), true);
                    SoundEvent sound = this.f_19796_.m_188499_() ? (SoundEvent)TravelopticsSounds.SPIRIT_POINTS_THRESHOLD_ONE.get() : (SoundEvent)TravelopticsSounds.SPIRIT_POINTS_THRESHOLD_TWO.get();
                    float pitch = 0.8f + this.f_19796_.m_188501_() * 0.2f;
                    this.m_5496_(sound, 1.0f, pitch);
                    ++this.dialogueIndex;
                    this.dialogueCooldown = 10;
                    if (this.dialogueIndex >= LORE_DIALOGUE.size()) {
                        this.dialogueCooldown = 15;
                    }
                }
                return InteractionResult.SUCCESS;
            }
            if (this.dialogueCooldown <= 0 && !(preventTrade = this.m_6616_().isEmpty())) {
                if (this.shouldRestock()) {
                    this.restock();
                }
                this.startTrading(player);
                return InteractionResult.SUCCESS;
            }
        }
        return super.m_6071_(player, hand);
    }

    private void startTrading(Player pPlayer) {
        this.m_7189_(pPlayer);
        this.m_45301_(pPlayer, this.m_5446_(), 0);
    }

    public int getRestocksToday() {
        return this.numberOfRestocksToday;
    }

    public void setRestocksToday(int restocks) {
        this.numberOfRestocksToday = restocks;
    }

    public long getLastRestockGameTime() {
        return this.lastRestockGameTime;
    }

    public void setLastRestockGameTime(long time) {
        this.lastRestockGameTime = time;
    }

    public long getLastRestockCheckDayTime() {
        return this.lastRestockCheckDayTime;
    }

    public void setLastRestockCheckDayTime(long time) {
        this.lastRestockCheckDayTime = time;
    }

    public Level merchantLevel() {
        return this.m_9236_();
    }

    public void m_7189_(@Nullable Player pTradingPlayer) {
        this.tradingPlayer = pTradingPlayer;
    }

    public Player m_7962_() {
        return this.tradingPlayer;
    }

    public MerchantOffers m_6616_() {
        if (this.offers == null) {
            this.offers = new MerchantOffers();
            this.offers.addAll(this.createRandomOffers(3, 5));
            int journalTrade = this.f_19796_.m_188503_(3);
            switch (journalTrade) {
                case 0: {
                    this.offers.add((Object)new JournalOneToUpgradeOrb().m_213663_((Entity)this, this.f_19796_));
                    break;
                }
                case 1: {
                    this.offers.add((Object)new JournalTwoToUpgradeOrb().m_213663_((Entity)this, this.f_19796_));
                    break;
                }
                case 2: {
                    this.offers.add((Object)new JournalThreeToUpgradeOrb().m_213663_((Entity)this, this.f_19796_));
                }
            }
            this.offers.removeIf(Objects::isNull);
            ++this.numberOfRestocksToday;
        }
        return this.offers;
    }

    private Collection<MerchantOffer> createRandomOffers(int min, int max) {
        HashSet set = Sets.newHashSet();
        int fillerTrades = this.f_19796_.m_216332_(min, max);
        for (int i = 0; i < 10 && set.size() < fillerTrades; ++i) {
            set.add(this.f_19796_.m_188503_(fillerOffers.size()));
        }
        ArrayList<MerchantOffer> offers = new ArrayList<MerchantOffer>();
        for (Integer integer : set) {
            offers.add(fillerOffers.get(integer).m_213663_((Entity)this, this.f_19796_));
        }
        return offers;
    }

    public void m_6255_(MerchantOffers pOffers) {
    }

    protected boolean m_6107_() {
        return super.m_6107_() || this.isTrading();
    }

    public void m_6996_(MerchantOffer pOffer) {
        pOffer.m_45374_();
        this.f_21363_ = -this.m_8100_();
    }

    public void m_7713_(ItemStack pStack) {
        if (!this.m_9236_().f_46443_ && this.f_21363_ > -this.m_8100_() + 20) {
            this.f_21363_ = -this.m_8100_();
            this.m_5496_(this.getTradeUpdatedSound(!pStack.m_41619_()), this.m_6121_(), this.m_6100_());
        }
    }

    protected SoundEvent getTradeUpdatedSound(boolean pIsYesSound) {
        return pIsYesSound ? (SoundEvent)ACSoundRegistry.DEEP_ONE_MAGE_ADMIRE.get() : (SoundEvent)TravelopticsSounds.SPECTRAL_BLINK_FAILED.get();
    }

    public SoundEvent m_7596_() {
        return (SoundEvent)TravelopticsSounds.SPECTRAL_BLINK_FAILED.get();
    }

    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        this.serializeMerchant(pCompound, this.offers, this.lastRestockGameTime, this.numberOfRestocksToday);
        pCompound.m_128405_("FadingMageLoreDialogueIndex", this.dialogueIndex);
        pCompound.m_128379_("DespawnTriggered", this.isDespawnTriggered());
        pCompound.m_128405_("DespawnTimer", this.despawnTimer);
        pCompound.m_128350_("FadeOpacity", this.getFadeOpacity());
    }

    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.deserializeMerchant(pCompound, c -> {
            this.offers = c;
        });
        if (pCompound.m_128441_("FadingMageLoreDialogueIndex")) {
            this.dialogueIndex = pCompound.m_128451_("FadingMageLoreDialogueIndex");
        }
        if (pCompound.m_128441_("DespawnTriggered")) {
            this.f_19804_.m_135381_(DESPAWN_TRIGGERED, (Object)pCompound.m_128471_("DespawnTriggered"));
        }
        if (pCompound.m_128441_("DespawnTimer")) {
            this.despawnTimer = pCompound.m_128451_("DespawnTimer");
        }
        if (pCompound.m_128441_("FadeOpacity")) {
            this.setFadeOpacity(pCompound.m_128457_("FadeOpacity"));
        }
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "idle", 0, this::animationPredicate)});
    }

    private PlayState animationPredicate(AnimationState<?> event) {
        if (this.isDespawnTriggered()) {
            event.getController().setAnimation(this.counterspelled);
        } else {
            event.getController().setAnimation(this.idle);
        }
        return PlayState.CONTINUE;
    }

    public boolean shouldBeExtraAnimated() {
        return false;
    }

    public boolean shouldAlwaysAnimateHead() {
        return false;
    }

    static class JournalOneToUpgradeOrb
    extends AdditionalWanderingTrades.SimpleTrade {
        private JournalOneToUpgradeOrb() {
            super((trader, random) -> {
                LootParams context;
                LootTable loottable;
                ObjectArrayList items;
                if (!trader.m_9236_().f_46443_ && !(items = (loottable = trader.m_9236_().m_7654_().m_278653_().m_278676_(TravelopticsMod.id("magic_items/nightwarden_journal_one"))).m_287195_(context = new LootParams.Builder((ServerLevel)trader.m_9236_()).m_287235_(LootContextParamSets.f_81410_))).isEmpty()) {
                    ItemStack journal = (ItemStack)items.get(0);
                    ItemStack middleItem = new ItemStack((ItemLike)ItemRegistry.UPGRADE_ORB.get());
                    ItemStack output = new ItemStack((ItemLike)TravelopticsItems.ELDRITCH_UPGRADE_ORB.get());
                    return new MerchantOffer(journal, middleItem, output, 1, 5, 0.5f);
                }
                return new MerchantOffer(ItemStack.f_41583_, ItemStack.f_41583_, 0, 0, 0.0f);
            });
        }
    }

    static class JournalTwoToUpgradeOrb
    extends AdditionalWanderingTrades.SimpleTrade {
        private JournalTwoToUpgradeOrb() {
            super((trader, random) -> {
                LootParams context;
                LootTable loottable;
                ObjectArrayList items;
                if (!trader.m_9236_().f_46443_ && !(items = (loottable = trader.m_9236_().m_7654_().m_278653_().m_278676_(TravelopticsMod.id("magic_items/nightwarden_journal_two"))).m_287195_(context = new LootParams.Builder((ServerLevel)trader.m_9236_()).m_287235_(LootContextParamSets.f_81410_))).isEmpty()) {
                    ItemStack journal = (ItemStack)items.get(0);
                    ItemStack middleItem = new ItemStack((ItemLike)ItemRegistry.UPGRADE_ORB.get());
                    ItemStack output = new ItemStack((ItemLike)TravelopticsItems.ELDRITCH_UPGRADE_ORB.get());
                    return new MerchantOffer(journal, middleItem, output, 1, 5, 0.5f);
                }
                return new MerchantOffer(ItemStack.f_41583_, ItemStack.f_41583_, 0, 0, 0.0f);
            });
        }
    }

    static class JournalThreeToUpgradeOrb
    extends AdditionalWanderingTrades.SimpleTrade {
        private JournalThreeToUpgradeOrb() {
            super((trader, random) -> {
                LootParams context;
                LootTable loottable;
                ObjectArrayList items;
                if (!trader.m_9236_().f_46443_ && !(items = (loottable = trader.m_9236_().m_7654_().m_278653_().m_278676_(TravelopticsMod.id("magic_items/nightwarden_journal_three"))).m_287195_(context = new LootParams.Builder((ServerLevel)trader.m_9236_()).m_287235_(LootContextParamSets.f_81410_))).isEmpty()) {
                    ItemStack journal = (ItemStack)items.get(0);
                    ItemStack middleItem = new ItemStack((ItemLike)ItemRegistry.UPGRADE_ORB.get());
                    ItemStack output = new ItemStack((ItemLike)TravelopticsItems.ELDRITCH_UPGRADE_ORB.get());
                    return new MerchantOffer(journal, middleItem, output, 1, 5, 0.5f);
                }
                return new MerchantOffer(ItemStack.f_41583_, ItemStack.f_41583_, 0, 0, 0.0f);
            });
        }
    }
}

