/*
 * Decompiled with CFR 0.152.
 */
package com.gametechbc.traveloptics.overlay.armor_overlay;

import com.gametechbc.traveloptics.api.utils.TOArmorUtils;
import com.gametechbc.traveloptics.config.ClientConfig;
import com.gametechbc.traveloptics.data_manager.CooldownManager;
import com.gametechbc.traveloptics.data_manager.PhantomRageManager;
import com.gametechbc.traveloptics.init.TravelopticsItems;
import com.gametechbc.traveloptics.item.armor.CursedWraithguardArmorItem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class PhantomRageOverlay {
    private static final ResourceLocation PHANTOM_RAGE_TEXTURE = new ResourceLocation("traveloptics", "textures/gui/armor/phantom_rage_bar.png");
    private static final boolean USE_XP_BAR = (Boolean)ClientConfig.armorReplaceXPBars.get();
    private static long lastRageTime = 0L;
    private static boolean shouldRenderRageBar = true;
    private static double lastRecordedRage = -1.0;
    private static final int BASE_WIDTH = 130;
    private static final int BASE_HEIGHT = 21;
    private static final float BAR_SCALE = 1.0f;
    private static final int BAR_X_OFFSET = (Integer)ClientConfig.cursedWraithguardXOffset.get();
    private static final int BAR_Y_OFFSET = 95 + (Integer)ClientConfig.cursedWraithguardYOffset.get();
    private static final float BAR_ROTATION = 0.0f;
    private static final int XP_BAR_WIDTH = 182;
    private static final int XP_BAR_HEIGHT = 5;
    private static final int XP_BAR_U = 29;
    private static final int XP_BAR_V = 89;
    private static final int XP_FILL_U = 29;
    private static final int XP_FILL_V = 99;
    private static final int XP_BAR_X_OFFSET = 0;
    private static final int XP_BAR_Y_OFFSET = 9;

    public static void render(GuiGraphics guiGraphics, Player player, int screenWidth, int screenHeight) {
        if (player == null) {
            return;
        }
        ItemStack chestplate = player.m_6844_(EquipmentSlot.CHEST);
        if (!TOArmorUtils.isWearingFullSet(player, CursedWraithguardArmorItem.class)) {
            return;
        }
        int maxFuel = 350;
        int currentFuel = PhantomRageManager.getPhantomRage(chestplate);
        int cooldownTicks = CooldownManager.getCooldown(chestplate);
        double cooldownProgress = (double)cooldownTicks / 500.0;
        double progress = Math.max(cooldownProgress, (double)currentFuel / (double)maxFuel);
        if (progress == lastRecordedRage) {
            if (lastRageTime == 0L) {
                lastRageTime = System.currentTimeMillis();
            } else if (System.currentTimeMillis() - lastRageTime >= 3000L) {
                shouldRenderRageBar = false;
            }
        } else {
            lastRageTime = 0L;
            shouldRenderRageBar = true;
        }
        lastRecordedRage = progress;
        if (!shouldRenderRageBar) {
            return;
        }
        if (USE_XP_BAR) {
            int cooldownFillWidth;
            int x = screenWidth / 2 - 91 + 0;
            int y = screenHeight - 32 + 3 - 8 + 9;
            PoseStack poseStack = guiGraphics.m_280168_();
            poseStack.m_85836_();
            guiGraphics.m_280163_(PHANTOM_RAGE_TEXTURE, x, y, 29.0f, 89.0f, 182, 5, 241, 115);
            int fillWidth = (int)(182.0 * progress);
            if (fillWidth > 0) {
                guiGraphics.m_280163_(PHANTOM_RAGE_TEXTURE, x, y, 29.0f, 99.0f, fillWidth, 5, 241, 115);
            }
            if ((cooldownFillWidth = (int)(182.0 * cooldownProgress)) > 0) {
                guiGraphics.m_280163_(PHANTOM_RAGE_TEXTURE, x, y, 29.0f, 78.0f, cooldownFillWidth, 5, 241, 115);
            }
            poseStack.m_85849_();
        } else {
            int cooldownFillWidth;
            int barWidth = 130;
            int barHeight = 21;
            int x = (screenWidth - barWidth) / 2 + BAR_X_OFFSET;
            int y = screenHeight - BAR_Y_OFFSET;
            PoseStack poseStack = guiGraphics.m_280168_();
            poseStack.m_85836_();
            poseStack.m_85837_((double)x + (double)barWidth / 2.0, (double)y + (double)barHeight / 2.0, 0.0);
            poseStack.m_252781_(Axis.f_252403_.m_252977_(0.0f));
            poseStack.m_85841_(1.0f, 1.0f, 1.0f);
            poseStack.m_252880_((float)(-barWidth) / 2.0f, (float)(-barHeight) / 2.0f, 0.0f);
            guiGraphics.m_280163_(PHANTOM_RAGE_TEXTURE, 0, 0, 55.0f, 28.0f, 130, 21, 241, 115);
            int fillWidth = (int)(130.0 * progress);
            if (fillWidth > 0) {
                guiGraphics.m_280163_(PHANTOM_RAGE_TEXTURE, 0, 0, 55.0f, 51.0f, fillWidth, 21, 241, 115);
            }
            if ((cooldownFillWidth = (int)(130.0 * cooldownProgress)) > 0) {
                guiGraphics.m_280163_(PHANTOM_RAGE_TEXTURE, 0, 0, 55.0f, 6.0f, cooldownFillWidth, 21, 241, 115);
            }
            poseStack.m_85849_();
        }
    }

    public static boolean shouldCancelXpBar(Player player) {
        if (player == null) {
            return false;
        }
        ItemStack chestplate = player.m_6844_(EquipmentSlot.CHEST);
        if (chestplate.m_41619_() || chestplate.m_41720_() != TravelopticsItems.CURSED_WRAITHGUARD_ARMOR_CHESTPLATE.get()) {
            return false;
        }
        return USE_XP_BAR && shouldRenderRageBar;
    }
}

