/*
 * Decompiled with CFR 0.152.
 */
package com.gametechbc.traveloptics.spells.ender;

import com.github.L_Ender.cataclysm.entity.AnimationMonster.BossMonsters.The_Leviathan.Abyss_Orb_Entity;
import com.github.L_Ender.cataclysm.init.ModSounds;
import io.redspace.ironsspellbooks.api.config.DefaultConfig;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.registry.SchoolRegistry;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.AutoSpellConfig;
import io.redspace.ironsspellbooks.api.spells.CastSource;
import io.redspace.ironsspellbooks.api.spells.CastType;
import io.redspace.ironsspellbooks.api.spells.SpellAnimations;
import io.redspace.ironsspellbooks.api.spells.SpellRarity;
import io.redspace.ironsspellbooks.api.util.AnimationHolder;
import io.redspace.ironsspellbooks.api.util.CameraShakeData;
import io.redspace.ironsspellbooks.api.util.CameraShakeManager;
import io.redspace.ironsspellbooks.api.util.Utils;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

@AutoSpellConfig
public class OrbitalVoidSpell
extends AbstractSpell {
    private static final ResourceLocation SPELL_ID = ResourceLocation.fromNamespaceAndPath((String)"traveloptics", (String)"orbital_void");
    private static final double TRACKING_RANGE = 20.0;
    private static final double ORB_SPAWN_RADIUS = 6.0;
    private static final double ORB_INITIAL_SPEED = 3.0;
    private static final double ORB_SPAWN_HEIGHT = 1.65;
    private final DefaultConfig defaultConfig = new DefaultConfig().setMinRarity(SpellRarity.RARE).setSchoolResource(SchoolRegistry.ENDER_RESOURCE).setMaxLevel(5).setCooldownSeconds(25.0).build();

    public OrbitalVoidSpell() {
        this.baseManaCost = 40;
        this.manaCostPerLevel = 40;
        this.baseSpellPower = 1;
        this.spellPowerPerLevel = 1;
        this.castTime = 40;
    }

    public CastType getCastType() {
        return CastType.LONG;
    }

    public DefaultConfig getDefaultConfig() {
        return this.defaultConfig;
    }

    public ResourceLocation getSpellResource() {
        return SPELL_ID;
    }

    public AnimationHolder getCastStartAnimation() {
        return SpellAnimations.CHARGE_ANIMATION;
    }

    public AnimationHolder getCastFinishAnimation() {
        return SpellAnimations.SPIT_FINISH_ANIMATION;
    }

    public Optional<SoundEvent> getCastStartSound() {
        return Optional.of(SoundEvents.f_215772_);
    }

    public Optional<SoundEvent> getCastFinishSound() {
        return Optional.of((SoundEvent)ModSounds.LEVIATHAN_STUN_ROAR.get());
    }

    public void onCast(Level level, int spellLevel, LivingEntity caster, CastSource castSource, MagicData playerMagicData) {
        float damage = this.getDamage(spellLevel, caster);
        int orbCount = this.getOrbCount(spellLevel);
        boolean isRandomTargeting = caster.m_6047_();
        this.spawnAbyssalOrbs(level, caster, orbCount, damage, isRandomTargeting);
        CameraShakeManager.addCameraShake((CameraShakeData)new CameraShakeData(28, caster.m_20182_(), 15.0f));
        super.onCast(level, spellLevel, caster, castSource, playerMagicData);
    }

    private void spawnAbyssalOrbs(Level level, LivingEntity caster, int orbCount, float damage, boolean randomTargeting) {
        List<LivingEntity> possibleTargets = null;
        LivingEntity nearestTarget = null;
        if (randomTargeting) {
            possibleTargets = this.getAllValidTargets(level, caster);
        } else {
            nearestTarget = this.findNearestTarget(level, caster);
        }
        double angleIncrement = Math.PI * 2 / (double)orbCount;
        for (int i = 0; i < orbCount; ++i) {
            double angle = angleIncrement * (double)i;
            LivingEntity target = randomTargeting && possibleTargets != null && !possibleTargets.isEmpty() ? possibleTargets.get(caster.m_217043_().m_188503_(possibleTargets.size())) : nearestTarget;
            this.spawnSingleOrb(level, caster, angle, damage, target);
        }
    }

    private void spawnSingleOrb(Level level, LivingEntity caster, double angle, float damage, LivingEntity target) {
        Vec3 spawnOffset = this.calculateSpawnOffset(angle);
        Vec3 spawnPos = caster.m_20182_().m_82520_(0.0, 1.65, 0.0);
        Vec3 motion = spawnOffset.m_82541_().m_82490_(3.0);
        Abyss_Orb_Entity orb = new Abyss_Orb_Entity(caster, motion.f_82479_, motion.f_82480_, motion.f_82481_, level, damage, target);
        orb.m_7678_(spawnPos.f_82479_, spawnPos.f_82480_, spawnPos.f_82481_, 0.0f, 0.0f);
        orb.m_20334_(motion.f_82479_, motion.f_82480_, motion.f_82481_);
        orb.setTracking(true);
        orb.m_5602_((Entity)caster);
        orb.setDamage(damage);
        level.m_7967_((Entity)orb);
    }

    private Vec3 calculateSpawnOffset(double angle) {
        double offsetX = Math.sin(angle) * 6.0;
        double offsetZ = Math.cos(angle) * 6.0;
        return new Vec3(offsetX, 0.0, offsetZ);
    }

    private List<LivingEntity> getAllValidTargets(Level level, LivingEntity caster) {
        AABB searchBox = new AABB(caster.m_20185_() - 20.0, caster.m_20186_() - 20.0, caster.m_20189_() - 20.0, caster.m_20185_() + 20.0, caster.m_20186_() + 20.0, caster.m_20189_() + 20.0);
        return new ArrayList<LivingEntity>(level.m_6443_(LivingEntity.class, searchBox, entity -> this.isValidTarget((LivingEntity)entity, caster)));
    }

    private LivingEntity findNearestTarget(Level level, LivingEntity caster) {
        AABB searchBox = new AABB(caster.m_20185_() - 20.0, caster.m_20186_() - 20.0, caster.m_20189_() - 20.0, caster.m_20185_() + 20.0, caster.m_20186_() + 20.0, caster.m_20189_() + 20.0);
        List possibleTargets = level.m_6443_(LivingEntity.class, searchBox, entity -> this.isValidTarget((LivingEntity)entity, caster));
        return possibleTargets.stream().min(Comparator.comparingDouble(arg_0 -> ((LivingEntity)caster).m_20280_(arg_0))).orElse(null);
    }

    private boolean isValidTarget(LivingEntity entity, LivingEntity caster) {
        TamableAnimal tamable;
        if (entity == caster) {
            return false;
        }
        if (caster.m_7307_((Entity)entity)) {
            return false;
        }
        if (entity instanceof TamableAnimal && (tamable = (TamableAnimal)entity).m_21824_()) {
            return tamable.m_269323_() != caster;
        }
        return true;
    }

    private float getDamage(int spellLevel, LivingEntity caster) {
        return 5.0f + this.getSpellPower(spellLevel, (Entity)caster) * 2.5f;
    }

    private int getOrbCount(int spellLevel) {
        return spellLevel * 3;
    }

    public List<MutableComponent> getUniqueInfo(int spellLevel, LivingEntity caster) {
        return List.of(Component.m_237110_((String)"ui.traveloptics.damage", (Object[])new Object[]{Utils.stringTruncation((double)this.getDamage(spellLevel, caster), (int)2)}), Component.m_237110_((String)"ui.traveloptics.abyssal_orb_count", (Object[])new Object[]{String.valueOf(this.getOrbCount(spellLevel))}), Component.m_237115_((String)"ui.traveloptics.orbital_void_mode"));
    }

    public boolean stopSoundOnCancel() {
        return true;
    }
}

