/*
 * Decompiled with CFR 0.152.
 */
package com.gametechbc.traveloptics.spells.lightning;

import com.gametechbc.traveloptics.api.spells.AbstractUniqueSpell;
import com.gametechbc.traveloptics.api.utils.TOGeneralUtils;
import com.gametechbc.traveloptics.data_manager.GalenaChargeManager;
import com.gametechbc.traveloptics.entity.misc.TOScreenShakeEntity;
import com.gametechbc.traveloptics.entity.misc.galena_mark.GalenaMarkEntity;
import com.gametechbc.traveloptics.entity.misc.stack_entity.StackEntity;
import com.gametechbc.traveloptics.entity.projectiles.GalenaTremorAoe;
import com.gametechbc.traveloptics.init.TravelopticsEffects;
import com.gametechbc.traveloptics.init.TravelopticsItems;
import com.gametechbc.traveloptics.init.TravelopticsSounds;
import com.gametechbc.traveloptics.item.bossweapon.galenic_polarizer.GalenicPolarizerItem;
import com.gametechbc.traveloptics.particle.reverse_blastwave.ReverseBlastwaveParticleOptions;
import com.github.L_Ender.cataclysm.client.particle.CircleLightningParticle;
import com.github.L_Ender.cataclysm.client.particle.LightningParticle;
import com.github.L_Ender.cataclysm.init.ModSounds;
import com.github.alexmodguy.alexscaves.client.particle.ACParticleRegistry;
import com.github.alexmodguy.alexscaves.server.misc.ACSoundRegistry;
import io.redspace.ironsspellbooks.api.config.DefaultConfig;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.registry.SchoolRegistry;
import io.redspace.ironsspellbooks.api.spells.AutoSpellConfig;
import io.redspace.ironsspellbooks.api.spells.CastSource;
import io.redspace.ironsspellbooks.api.spells.CastType;
import io.redspace.ironsspellbooks.api.spells.SpellAnimations;
import io.redspace.ironsspellbooks.api.spells.SpellRarity;
import io.redspace.ironsspellbooks.api.util.AnimationHolder;
import io.redspace.ironsspellbooks.api.util.Utils;
import io.redspace.ironsspellbooks.capabilities.magic.MagicManager;
import io.redspace.ironsspellbooks.damage.DamageSources;
import io.redspace.ironsspellbooks.particle.BlastwaveParticleOptions;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;

@AutoSpellConfig
public class GalenaShatterSpell
extends AbstractUniqueSpell {
    private final ResourceLocation spellId = ResourceLocation.fromNamespaceAndPath((String)"traveloptics", (String)"galena_shatter");
    private final DefaultConfig defaultConfig = new DefaultConfig().setMinRarity(SpellRarity.LEGENDARY).setSchoolResource(SchoolRegistry.LIGHTNING_RESOURCE).setMaxLevel(1).setCooldownSeconds(20.0).build();

    public GalenaShatterSpell() {
        this.manaCostPerLevel = 0;
        this.baseSpellPower = 1;
        this.spellPowerPerLevel = 1;
        this.castTime = 16;
        this.baseManaCost = 200;
    }

    public CastType getCastType() {
        return CastType.LONG;
    }

    public DefaultConfig getDefaultConfig() {
        return this.defaultConfig;
    }

    public ResourceLocation getSpellResource() {
        return this.spellId;
    }

    public Optional<SoundEvent> getCastStartSound() {
        return Optional.of((SoundEvent)ACSoundRegistry.MAGNETRON_ASSEMBLE.get());
    }

    public Optional<SoundEvent> getCastFinishSound() {
        return Optional.of((SoundEvent)ACSoundRegistry.BOUNDROID_SLAM.get());
    }

    public boolean canBeInterrupted(Player player) {
        return false;
    }

    public int getEffectiveCastTime(int spellLevel, @Nullable LivingEntity entity) {
        return this.getCastTime(spellLevel);
    }

    public AnimationHolder getCastStartAnimation() {
        return SpellAnimations.OVERHEAD_MELEE_SWING_ANIMATION;
    }

    public AnimationHolder getCastFinishAnimation() {
        return AnimationHolder.pass();
    }

    public boolean checkPreCastConditions(Level level, int spellLevel, LivingEntity entity, MagicData playerMagicData) {
        List<Item> allowedWeapons = List.of((Item)TravelopticsItems.GALENIC_POLARIZER.get(), (Item)TravelopticsItems.GALENIC_POLARIZER_LEVEL_ONE.get(), (Item)TravelopticsItems.GALENIC_POLARIZER_LEVEL_TWO.get(), (Item)TravelopticsItems.GALENIC_POLARIZER_LEVEL_THREE.get());
        if (allowedWeapons.contains(entity.m_21205_().m_41720_())) {
            return true;
        }
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (!level.m_5776_()) {
                player.m_5661_((Component)Component.m_237115_((String)"spell.traveloptics.magnet.warning").m_130940_(ChatFormatting.RED), true);
            }
        }
        return false;
    }

    public void onServerCastTick(Level world, int spellLevel, LivingEntity entity, @Nullable MagicData playerMagicData) {
        if (playerMagicData != null) {
            int castTime = this.castTime - playerMagicData.getCastDurationRemaining();
            Vec3 casterPos = entity.m_20182_();
            double radius = this.getRadius(entity.m_21205_(), entity);
            if (castTime == 1) {
                world.m_5594_(null, entity.m_20183_(), (SoundEvent)ModSounds.HARBINGER_PREPARE.get(), entity.m_5720_(), 1.0f, 0.8f);
            } else if (castTime == 6) {
                this.spawnReverseBlastwaveParticles(world, casterPos, true, radius);
            } else if (castTime == 12) {
                this.spawnReverseBlastwaveParticles(world, casterPos, false, radius);
            }
            if (castTime % 2 == 0) {
                this.spawnChargingLightning(world, casterPos, entity, radius);
            }
        }
        super.onServerCastTick(world, spellLevel, entity, playerMagicData);
    }

    public void onCast(Level world, int spellLevel, LivingEntity caster, CastSource castSource, MagicData playerMagicData) {
        LivingEntity livingTarget;
        boolean markApplied;
        ItemStack mainHand = caster.m_21205_();
        double radius = this.getRadius(mainHand, caster);
        Vec3 casterPos = caster.m_20182_();
        this.spawnMainBlastwave(world, caster, casterPos, radius);
        this.spawnExpandingLightning(world, caster, casterPos, radius);
        this.spawnRandomMagnetParticles(world, casterPos, radius, caster);
        world.m_5594_(null, caster.m_20183_(), (SoundEvent)ACSoundRegistry.MAGNETRON_HURT.get(), caster.m_5720_(), 1.0f, 1.0f);
        boolean anyMarkApplied = false;
        List allTargets = world.m_6443_(LivingEntity.class, caster.m_20191_().m_82400_(radius), entity -> entity != caster && entity.m_20280_((Entity)caster) <= radius * radius);
        for (LivingEntity target : allTargets) {
            DamageSources.applyDamage((Entity)target, (float)2.0f, (DamageSource)this.getDamageSource((Entity)caster));
        }
        List<Entity> azureTargets = StackEntity.scanForStackedEntities(world, casterPos.f_82479_, casterPos.f_82480_, casterPos.f_82481_, radius, "azure_charged");
        List<Entity> scarletTargets = StackEntity.scanForStackedEntities(world, casterPos.f_82479_, casterPos.f_82480_, casterPos.f_82481_, radius, "scarlet_charged");
        for (Entity entity2 : azureTargets) {
            if (!(entity2 instanceof LivingEntity) || !(markApplied = this.processStackedTarget(livingTarget = (LivingEntity)entity2, "azure_charged", spellLevel, caster, true))) continue;
            anyMarkApplied = true;
        }
        for (Entity entity2 : scarletTargets) {
            if (!(entity2 instanceof LivingEntity) || !(markApplied = this.processStackedTarget(livingTarget = (LivingEntity)entity2, "scarlet_charged", spellLevel, caster, false))) continue;
            anyMarkApplied = true;
        }
        if (anyMarkApplied) {
            world.m_5594_(null, caster.m_20183_(), (SoundEvent)TravelopticsSounds.ORBITAL_VOID_PULSE.get(), caster.m_5720_(), 1.0f, 1.4f);
            GalenaTremorAoe tremorAoe = new GalenaTremorAoe(world, (float)radius);
            tremorAoe.m_5602_((Entity)caster);
            tremorAoe.m_20219_(casterPos);
            world.m_7967_((Entity)tremorAoe);
        }
        if (caster.m_6047_() && mainHand.m_41720_() == TravelopticsItems.GALENIC_POLARIZER_LEVEL_THREE.get()) {
            int scarletCharge;
            int azureCharge = GalenaChargeManager.getAzureCharge(mainHand);
            if (azureCharge >= 10) {
                caster.m_7292_(new MobEffectInstance((MobEffect)TravelopticsEffects.AZURE_FRENZY_EFFECT.get(), 300, 9));
                GalenaChargeManager.setAzureCharge(mainHand, azureCharge - 10);
            }
            if ((scarletCharge = GalenaChargeManager.getScarletCharge(mainHand)) >= 10) {
                GalenaChargeManager.setScarletCharge(mainHand, scarletCharge - 10);
            }
        }
        TOScreenShakeEntity.createScreenShake(caster.m_9236_(), caster.m_20182_(), 24.0f, 0.03f, 15, 0, 5, false);
        super.onCast(world, spellLevel, caster, castSource, playerMagicData);
    }

    private boolean processStackedTarget(LivingEntity target, String stackName, int spellLevel, LivingEntity caster, boolean isAzure) {
        int stacks = StackEntity.getStackCountFromEntity((Entity)target, stackName);
        if (stacks > 0) {
            float markDamage = this.getDamagePerStack(spellLevel, caster) * (float)stacks;
            GalenaMarkEntity.applyMarkToEntity((Entity)target, (Entity)caster, isAzure, markDamage, 1.5f);
            this.spawnDischargeParticles(target, stacks, isAzure);
            StackEntity.clearStacksFromEntity((Entity)target, stackName);
            return true;
        }
        return false;
    }

    private void spawnChargingLightning(Level world, Vec3 center, LivingEntity caster, double radius) {
        boolean useAzure = caster.m_217043_().m_188499_();
        int color = useAzure ? 24815 : 16711722;
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color & 0xFF;
        for (int i = 0; i < 2; ++i) {
            double theta = caster.m_217043_().m_188500_() * 2.0 * Math.PI;
            double posX = radius * Math.cos(theta);
            double posZ = radius * Math.sin(theta);
            MagicManager.spawnParticles((Level)world, (ParticleOptions)new CircleLightningParticle.CircleData(r, g, b), (double)(center.f_82479_ + posX), (double)(center.f_82480_ + 0.1), (double)(center.f_82481_ + posZ), (int)0, (double)center.f_82479_, (double)(center.f_82480_ + 0.1), (double)center.f_82481_, (double)1.0, (boolean)true);
        }
    }

    private void spawnExpandingLightning(Level world, LivingEntity caster, Vec3 center, double radius) {
        ItemStack mainHand = caster.m_21205_();
        boolean useAzure = true;
        if (mainHand.m_41720_() instanceof GalenicPolarizerItem) {
            int scarletCharge;
            int azureCharge = GalenaChargeManager.getAzureCharge(mainHand);
            useAzure = azureCharge > (scarletCharge = GalenaChargeManager.getScarletCharge(mainHand));
        }
        int color = useAzure ? 24815 : 16711722;
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color & 0xFF;
        for (int i = 0; i < 8 + caster.m_217043_().m_188503_(5); ++i) {
            double theta = caster.m_217043_().m_188500_() * 2.0 * Math.PI;
            double distance = radius * (0.8 + caster.m_217043_().m_188500_() * 0.2);
            double targetX = distance * Math.cos(theta);
            double targetZ = distance * Math.sin(theta);
            MagicManager.spawnParticles((Level)world, (ParticleOptions)new CircleLightningParticle.CircleData(r, g, b), (double)center.f_82479_, (double)(center.f_82480_ + 0.1), (double)center.f_82481_, (int)0, (double)(center.f_82479_ + targetX), (double)(center.f_82480_ + 0.1), (double)(center.f_82481_ + targetZ), (double)1.0, (boolean)false);
        }
    }

    private void spawnDischargeParticles(LivingEntity target, int stackCount, boolean isAzure) {
        Level world = target.m_9236_();
        int particleCount = Math.min(10 + stackCount, 30);
        int color = isAzure ? 24815 : 16711722;
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color & 0xFF;
        for (int i = 0; i < particleCount; ++i) {
            double offsetX = (target.m_217043_().m_188500_() - 0.5) * (double)target.m_20205_() * 2.0;
            double offsetY = target.m_217043_().m_188500_() * (double)target.m_20206_();
            double offsetZ = (target.m_217043_().m_188500_() - 0.5) * (double)target.m_20205_() * 2.0;
            MagicManager.spawnParticles((Level)world, (ParticleOptions)new LightningParticle.OrbData(r, g, b), (double)(target.m_20185_() + offsetX), (double)(target.m_20186_() + offsetY), (double)(target.m_20189_() + offsetZ), (int)1, (double)0.0, (double)0.5, (double)0.0, (double)0.5, (boolean)true);
        }
    }

    private void spawnReverseBlastwaveParticles(Level world, Vec3 position, boolean isScarlet, double radius) {
        int color = isScarlet ? 16711722 : 24815;
        Vector3f colorVec = TOGeneralUtils.hexToVector3f(color);
        MagicManager.spawnParticles((Level)world, (ParticleOptions)new ReverseBlastwaveParticleOptions(colorVec, (float)radius), (double)position.f_82479_, (double)(position.f_82480_ + 0.1), (double)position.f_82481_, (int)1, (double)0.0, (double)0.0, (double)0.0, (double)0.03, (boolean)true);
    }

    private void spawnMainBlastwave(Level world, LivingEntity caster, Vec3 position, double radius) {
        ItemStack mainHand = caster.m_21205_();
        boolean useAzure = false;
        if (mainHand.m_41720_() instanceof GalenicPolarizerItem) {
            int azureCharge = GalenaChargeManager.getAzureCharge(mainHand);
            int scarletCharge = GalenaChargeManager.getScarletCharge(mainHand);
            useAzure = scarletCharge > azureCharge;
        }
        int color = useAzure ? 24815 : 16711722;
        Vector3f colorVec = TOGeneralUtils.hexToVector3f(color);
        MagicManager.spawnParticles((Level)world, (ParticleOptions)new BlastwaveParticleOptions(colorVec, (float)radius), (double)position.f_82479_, (double)(position.f_82480_ + 0.1), (double)position.f_82481_, (int)1, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (boolean)true);
    }

    private void spawnRandomMagnetParticles(Level world, Vec3 casterPos, double radius, LivingEntity caster) {
        int particleCount = 6 + caster.m_217043_().m_188503_(4);
        for (int i = 0; i < particleCount; ++i) {
            double theta = caster.m_217043_().m_188500_() * 2.0 * Math.PI;
            double distance = caster.m_217043_().m_188500_() * radius;
            double posX = casterPos.f_82479_ + distance * Math.cos(theta);
            double posZ = casterPos.f_82481_ + distance * Math.sin(theta);
            double posY = casterPos.f_82480_;
            MagicManager.spawnParticles((Level)world, (ParticleOptions)((ParticleOptions)ACParticleRegistry.MAGNET_LIGHTNING.get()), (double)posX, (double)(posY + 0.1), (double)posZ, (int)1, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (boolean)true);
        }
    }

    private float getDamagePerStack(int spellLevel, LivingEntity caster) {
        return 1.5f + this.getSpellPower(spellLevel, (Entity)caster) * 1.5f;
    }

    private double getRadius(ItemStack mainHand, LivingEntity caster) {
        int scarletCharge;
        double baseRadius = 12.0;
        if (caster.m_6047_() && mainHand.m_41720_() == TravelopticsItems.GALENIC_POLARIZER_LEVEL_THREE.get() && (scarletCharge = GalenaChargeManager.getScarletCharge(mainHand)) >= 10) {
            return baseRadius * 1.5;
        }
        return baseRadius;
    }

    public List<MutableComponent> getUniqueInfo(int spellLevel, LivingEntity caster) {
        return List.of(Component.m_237110_((String)"ui.traveloptics.single_hit_aoe_damage", (Object[])new Object[]{"2"}), Component.m_237110_((String)"ui.traveloptics.mark_damage_per_stack", (Object[])new Object[]{Utils.stringTruncation((double)this.getDamagePerStack(spellLevel, caster), (int)2)}), Component.m_237115_((String)"ui.traveloptics.galena_shatter_evo_three.bonus"), Component.m_237110_((String)"ui.traveloptics.radius", (Object[])new Object[]{this.getRadius(caster.m_21205_(), caster)}));
    }
}

