/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.client.model.builder;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.client.model.generators.CustomLoaderBuilder;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.common.data.ExistingFileHelper;
import slimeknights.mantle.Mantle;

public class FallbackModelBuilder<T extends ModelBuilder<T>>
extends CustomLoaderBuilder<T> {
    private final List<DomainModel<T>> models = new ArrayList<DomainModel<T>>();

    public FallbackModelBuilder(ResourceLocation loaderId, T parent, ExistingFileHelper existingFileHelper) {
        super(Mantle.getResource("fallback"), parent, existingFileHelper);
    }

    public FallbackModelBuilder<T> fallback(T builder, @Nullable String modId) {
        this.models.add(new DomainModel<T>(builder, modId));
        return this;
    }

    public FallbackModelBuilder<T> fallback(T builder) {
        return this.fallback(builder, null);
    }

    public JsonObject toJson(JsonObject json) {
        json = super.toJson(json);
        if (this.models.size() < 2) {
            throw new IllegalStateException("Must have at least two models to use the fallback loader");
        }
        JsonArray fallbacks = new JsonArray();
        for (DomainModel<T> builder : this.models) {
            fallbacks.add((JsonElement)builder.toJson());
        }
        json.add("models", (JsonElement)fallbacks);
        return json;
    }

    private record DomainModel<T extends ModelBuilder<T>>(T model, @Nullable String domain) {
        public JsonObject toJson() {
            JsonObject json = this.model.toJson();
            if (this.domain != null) {
                json.addProperty("fallback_mod_id", this.domain);
            }
            return json;
        }
    }
}

