/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.inventory;

import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import slimeknights.mantle.block.entity.MantleBlockEntity;

public abstract class SingleItemHandler<T extends MantleBlockEntity>
implements IItemHandlerModifiable {
    protected final T parent;
    private final int maxStackSize;
    private ItemStack stack = ItemStack.f_41583_;

    public void setStack(ItemStack newStack) {
        this.stack = newStack;
        ((MantleBlockEntity)((Object)this.parent)).setChangedFast();
    }

    protected abstract boolean isItemValid(ItemStack var1);

    public boolean isItemValid(int slot, ItemStack stack) {
        return slot == 0 && this.isItemValid(stack);
    }

    public int getSlots() {
        return 1;
    }

    public int getSlotLimit(int slot) {
        return this.maxStackSize;
    }

    @Nonnull
    public ItemStack getStackInSlot(int slot) {
        if (slot == 0) {
            return this.stack;
        }
        return ItemStack.f_41583_;
    }

    public void setStackInSlot(int slot, ItemStack stack) {
        if (slot == 0) {
            this.setStack(stack);
        }
    }

    @Nonnull
    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        if (stack.m_41619_()) {
            return ItemStack.f_41583_;
        }
        if (slot == 0) {
            int added;
            ItemStack current = this.getStack();
            if (current.m_41619_()) {
                if (this.isItemValid(slot, stack)) {
                    int size = Math.min(stack.m_41613_(), this.getSlotLimit(0));
                    if (!simulate) {
                        this.setStack(ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)size));
                    }
                    return ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)(stack.m_41613_() - size));
                }
            } else if (ItemHandlerHelper.canItemStacksStack((ItemStack)current, (ItemStack)stack) && (added = Math.min(stack.m_41613_(), this.getSlotLimit(0) - current.m_41613_())) > 0) {
                if (!simulate) {
                    current.m_41769_(added);
                    this.setStack(current);
                }
                return ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)(stack.m_41613_() - added));
            }
        }
        return stack;
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (amount == 0 || slot != 0) {
            return ItemStack.f_41583_;
        }
        if (this.stack.m_41619_()) {
            return ItemStack.f_41583_;
        }
        if (amount < this.stack.m_41613_()) {
            ItemStack result = ItemHandlerHelper.copyStackWithSize((ItemStack)this.stack, (int)amount);
            if (!simulate) {
                this.setStack(ItemHandlerHelper.copyStackWithSize((ItemStack)this.stack, (int)(this.stack.m_41613_() - amount)));
            }
            return result;
        }
        if (simulate) {
            return this.stack.m_41777_();
        }
        ItemStack ret = this.stack;
        this.setStack(ItemStack.f_41583_);
        return ret;
    }

    public CompoundTag writeToNBT() {
        CompoundTag nbt = new CompoundTag();
        if (!this.stack.m_41619_()) {
            this.stack.m_41739_(nbt);
        }
        return nbt;
    }

    public void readFromNBT(CompoundTag nbt) {
        this.stack = ItemStack.m_41712_((CompoundTag)nbt);
    }

    public SingleItemHandler(T parent, int maxStackSize) {
        this.parent = parent;
        this.maxStackSize = maxStackSize;
    }

    public ItemStack getStack() {
        return this.stack;
    }
}

