/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.inventory.container.modular;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.lib.gui.modular.lib.container.DataSync;
import codechicken.lib.gui.modular.lib.container.SlotGroup;
import codechicken.lib.internal.network.CCLNetwork;
import codechicken.lib.packet.PacketCustom;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ModularGuiContainerMenu
extends AbstractContainerMenu {
    private static final Logger LOGGER = LogManager.getLogger();
    public final Inventory inventory;
    public final List<SlotGroup> slotGroups = new ArrayList<SlotGroup>();
    public final Map<Slot, SlotGroup> slotGroupMap = new HashMap<Slot, SlotGroup>();
    public final Map<Integer, List<Slot>> zonedSlots = new HashMap<Integer, List<Slot>>();
    public final List<DataSync<?>> dataSyncs = new ArrayList();

    protected ModularGuiContainerMenu(@Nullable MenuType<?> menuType, int containerId, Inventory inventory) {
        super(menuType, containerId);
        this.inventory = inventory;
    }

    protected SlotGroup createSlotGroup(int zoneId, int ... quickMoveTo) {
        SlotGroup group = new SlotGroup(this, zoneId, quickMoveTo);
        this.slotGroups.add(group);
        return group;
    }

    protected SlotGroup playerSlotGroup() {
        return this.createSlotGroup(0, 1);
    }

    protected SlotGroup remoteSlotGroup() {
        return this.createSlotGroup(1, 0);
    }

    public void sendPacketToClient(int packetId, Consumer<MCDataOutput> packetWriter) {
        Player player = this.inventory.f_35978_;
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            PacketCustom packet = new PacketCustom(CCLNetwork.NET_CHANNEL, 20);
            packet.writeByte(this.f_38840_);
            packet.writeByte((byte)packetId);
            packetWriter.accept(packet);
            packet.sendToPlayer(serverPlayer);
        }
    }

    public void sendPacketToServer(int packetId, Consumer<MCDataOutput> packetWriter) {
        PacketCustom packet = new PacketCustom(CCLNetwork.NET_CHANNEL, 20);
        packet.writeByte(this.f_38840_);
        packet.writeByte((byte)packetId);
        packetWriter.accept(packet);
        packet.sendToServer();
    }

    public static void handlePacketFromClient(Player player, MCDataInput packet) {
        byte containerId = packet.readByte();
        int packetId = packet.readByte() & 0xFF;
        AbstractContainerMenu abstractContainerMenu = player.f_36096_;
        if (abstractContainerMenu instanceof ModularGuiContainerMenu) {
            ModularGuiContainerMenu menu = (ModularGuiContainerMenu)abstractContainerMenu;
            if (menu.f_38840_ == containerId) {
                menu.handlePacketFromClient(player, packetId, packet);
            }
        }
    }

    public void handlePacketFromClient(Player player, int packetId, MCDataInput packet) {
    }

    public static void handlePacketFromServer(Player player, MCDataInput packet) {
        byte containerId = packet.readByte();
        int packetId = packet.readByte() & 0xFF;
        AbstractContainerMenu abstractContainerMenu = player.f_36096_;
        if (abstractContainerMenu instanceof ModularGuiContainerMenu) {
            ModularGuiContainerMenu menu = (ModularGuiContainerMenu)abstractContainerMenu;
            if (menu.f_38840_ == containerId) {
                menu.handlePacketFromServer(player, packetId, packet);
            }
        }
    }

    public void handlePacketFromServer(Player player, int packetId, MCDataInput packet) {
        if (packetId == 255) {
            int index = packet.readByte() & 0xFF;
            if (this.dataSyncs.size() > index) {
                this.dataSyncs.get(index).handleSyncPacket(packet);
            }
        }
    }

    public static boolean canStacksMerge(ItemStack stack1, ItemStack stack2) {
        if (stack1.m_41619_() || stack2.m_41619_()) {
            return false;
        }
        return ItemStack.m_41728_((ItemStack)stack1, (ItemStack)stack2);
    }

    public ItemStack m_7648_(@NotNull Player player, int slotIndex) {
        Slot slot = this.m_38853_(slotIndex);
        if (slot == null || !slot.m_6657_()) {
            return ItemStack.f_41583_;
        }
        SlotGroup group = this.slotGroupMap.get(slot);
        if (group == null) {
            return ItemStack.f_41583_;
        }
        ItemStack stack = slot.m_7993_();
        ItemStack result = stack.m_41777_();
        boolean movedAnything = false;
        for (Integer zone : group.quickMoveTo) {
            if (!this.zonedSlots.containsKey(zone)) {
                LOGGER.warn("Attempted to quick move to zone id {} but there are no slots assigned to this zone! This is a bug!", (Object)zone);
                continue;
            }
            if (!this.moveItemStackTo(stack, this.zonedSlots.get(zone), false)) continue;
            movedAnything = true;
            break;
        }
        if (!movedAnything) {
            return ItemStack.f_41583_;
        }
        if (stack.m_41619_()) {
            slot.m_5852_(ItemStack.f_41583_);
        } else {
            slot.m_6654_();
        }
        slot.m_142406_(player, stack);
        return result;
    }

    protected boolean moveItemStackTo(ItemStack stack, List<Slot> targets, boolean reverse) {
        ItemStack itemStack2;
        Slot slot;
        int start = 0;
        int end = targets.size();
        boolean moved = false;
        int position = start;
        if (reverse) {
            position = end - 1;
        }
        if (stack.m_41753_()) {
            while (!stack.m_41619_() && !(!reverse ? position >= end : position < start)) {
                slot = targets.get(position);
                itemStack2 = slot.m_7993_();
                if (!itemStack2.m_41619_() && ItemStack.m_150942_((ItemStack)stack, (ItemStack)itemStack2)) {
                    int l = itemStack2.m_41613_() + stack.m_41613_();
                    if (l <= Math.min(stack.m_41741_(), slot.m_5866_(stack))) {
                        stack.m_41764_(0);
                        itemStack2.m_41764_(l);
                        slot.m_6654_();
                        moved = true;
                    } else if (itemStack2.m_41613_() < Math.min(stack.m_41741_(), slot.m_5866_(stack))) {
                        stack.m_41774_(stack.m_41741_() - itemStack2.m_41613_());
                        itemStack2.m_41764_(stack.m_41741_());
                        slot.m_6654_();
                        moved = true;
                    }
                }
                if (reverse) {
                    --position;
                    continue;
                }
                ++position;
            }
        }
        if (!stack.m_41619_()) {
            position = reverse ? end - 1 : start;
            while (!(!reverse ? position >= end : position < start)) {
                slot = targets.get(position);
                itemStack2 = slot.m_7993_();
                if (itemStack2.m_41619_() && slot.m_5857_(stack)) {
                    if (stack.m_41613_() > slot.m_5866_(stack)) {
                        slot.m_5852_(stack.m_41620_(slot.m_5866_(stack)));
                    } else {
                        slot.m_5852_(stack.m_41620_(stack.m_41613_()));
                    }
                    slot.m_6654_();
                    moved = true;
                    break;
                }
                if (reverse) {
                    --position;
                    continue;
                }
                ++position;
            }
        }
        return moved;
    }

    public void mapSlot(Slot slot, SlotGroup slotGroup) {
        this.slotGroupMap.put(slot, slotGroup);
        this.zonedSlots.computeIfAbsent(slotGroup.zone, e -> new ArrayList()).add(slot);
    }

    public void m_38946_() {
        super.m_38946_();
        this.dataSyncs.forEach(DataSync::detectAndSend);
    }
}

