/*
 * Decompiled with CFR 0.152.
 */
package com.oblivioussp.spartanshields.config;

import com.google.common.collect.ImmutableList;
import com.oblivioussp.spartanshields.crafting.condition.TypeDisabledCondition;
import com.oblivioussp.spartanshields.init.ModItems;
import com.oblivioussp.spartanshields.item.ShieldBaseItem;
import com.oblivioussp.spartanshields.util.Log;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import org.apache.commons.lang3.tuple.Pair;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class Config {
    public static final String categoryGeneral = "general";
    public static final String categoryShieldBash = "shield_bash";
    public static final String categoryVanilla = "vanilla";
    public static final String categoryModdedCommon = "modded_common";
    public static final String categoryThermalMods = "modded_thermal";
    public static final String categoryModdedBotania = "modded_botania";
    public static final String categoryModdedAbyssalcraft = "modded_abyssalcraft";
    public static final String categoryModdedBWM = "modded_bwm";
    public static final String categoryModdedMekanism = "modded_mekanism";
    public static final String categoryPowered = "modded_powered";
    public static final Config INSTANCE;
    public static final ForgeConfigSpec CONFIG_SPEC;
    public ForgeConfigSpec.IntValue durabilityWoodShield;
    public ForgeConfigSpec.IntValue durabilityStoneShield;
    public ForgeConfigSpec.IntValue durabilityCopperShield;
    public ForgeConfigSpec.IntValue durabilityIronShield;
    public ForgeConfigSpec.IntValue durabilityGoldShield;
    public ForgeConfigSpec.IntValue durabilityDiamondShield;
    public ForgeConfigSpec.IntValue durabilityNetheriteShield;
    public ShieldValues obsidian;
    public ShieldValues tin;
    public ShieldValues bronze;
    public ShieldValues steel;
    public ShieldValues silver;
    public ShieldValues electrum;
    public ShieldValues lead;
    public ShieldValues nickel;
    public ShieldValues invar;
    public ShieldValues constantan;
    public ShieldValues platinum;
    public ShieldValues aluminum;
    public ForgeConfigSpec.IntValue durabilityManasteelShield;
    public ForgeConfigSpec.IntValue durabilityTerrasteelShield;
    public ForgeConfigSpec.IntValue durabilityElementiumShield;
    public ForgeConfigSpec.IntValue durabilityOsmiumShield;
    public ForgeConfigSpec.IntValue durabilityLapisLazuliShield;
    public ForgeConfigSpec.IntValue durabilityRefinedGlowstoneShield;
    public ForgeConfigSpec.IntValue durabilityRefinedObsidianShield;
    public ForgeConfigSpec.IntValue durabilitySignalumShield;
    public ForgeConfigSpec.IntValue durabilityLumiumShield;
    public ForgeConfigSpec.IntValue durabilityEnderiumShield;
    public ForgeConfigSpec.BooleanValue vanillaOnly;
    public ForgeConfigSpec.BooleanValue forceDisableUncraftableTooltips;
    public ForgeConfigSpec.DoubleValue towerShieldDurabilityMultiplier;
    public ForgeConfigSpec.IntValue cooldownShieldBash;
    public ForgeConfigSpec.IntValue cooldownTowerShieldBash;
    public ForgeConfigSpec.BooleanValue disableShieldBash;
    public ForgeConfigSpec.IntValue damageToFEMultiplier;

    private Config(ForgeConfigSpec.Builder builder) {
        builder.push(categoryGeneral);
        this.vanillaOnly = builder.comment("Set to true to have only Vanilla-based shields enabled. Note that this removes mod-based Shield recipes from the game!").translation("config.spartanshields.vanilla_only").define("vanilla_only", false);
        this.forceDisableUncraftableTooltips = builder.comment("Will force the uncraftable shield tooltip (highlighted in red) that show on some shields to not appear. Useful for modpack makers who wish to change recipes").translation("config.spartanshields.force_disable_uncraftable_tooltips").define("force_disable_uncraftable_tooltips", false);
        this.towerShieldDurabilityMultiplier = builder.comment("Durability Multiplier for Tower Shield variants compared to their basic Shield counterparts").translation("config.spartanshields.tower_shield_durability_multiplier").defineInRange("tower_shield_durability_multiplier", 1.25, 1.0, 10.0);
        builder.pop();
        builder.push(categoryShieldBash);
        this.cooldownShieldBash = builder.comment("Cooldown period for Shield Bashes").translation("config.spartanshields.cooldown_shield_bash").defineInRange("cooldown", 30, 1, 1000);
        this.cooldownTowerShieldBash = builder.comment("Cooldown period for Shield Bashes for Tower Shields").translation("config.spartanshields.cooldown_tower_shield_bash").defineInRange("cooldown_tower", 50, 1, 1000);
        this.disableShieldBash = builder.comment("Set to true to disable the Shield Bash feature. Shield bash enchantments will no longer have any effect").translation("config.spartanshields.disable_shield_bash").define("disabled", false);
        builder.pop();
        builder.push(categoryVanilla);
        this.durabilityWoodShield = this.defineDurability(builder, 104, "Wood");
        this.durabilityStoneShield = this.defineDurability(builder, 230, "Stone");
        this.durabilityCopperShield = this.defineDurability(builder, 400, "Copper");
        this.durabilityIronShield = this.defineDurability(builder, 538, "Iron");
        this.durabilityGoldShield = this.defineDurability(builder, 192, "Gold");
        this.durabilityDiamondShield = this.defineDurability(builder, 2560, "Diamond");
        this.durabilityNetheriteShield = this.defineDurability(builder, 3554, "Netherite");
        this.obsidian = new ShieldValues(builder, 1600, "Obsidian", "obsidian");
        builder.pop();
        builder.push(categoryModdedCommon);
        this.tin = new ShieldValues(builder, 320, "Tin", "tin");
        this.bronze = new ShieldValues(builder, 680, "Bronze", "bronze");
        this.steel = new ShieldValues(builder, 800, "Steel", "steel");
        this.silver = new ShieldValues(builder, 216, "Silver", "silver");
        this.electrum = new ShieldValues(builder, 320, "Electrum", "electrum");
        this.lead = new ShieldValues(builder, 480, "Lead", "lead");
        this.nickel = new ShieldValues(builder, 420, "Nickel", "nickel");
        this.invar = new ShieldValues(builder, 720, "Invar", "invar");
        this.constantan = new ShieldValues(builder, 640, "Constantan", "constantan");
        this.platinum = new ShieldValues(builder, 1536, "Platinum", "platinum");
        this.aluminum = new ShieldValues(builder, 720, "Aluminum", "aluminum");
        builder.pop();
        builder.push(categoryModdedBotania);
        this.durabilityManasteelShield = this.defineDurability(builder, 450, "Manasteel");
        this.durabilityTerrasteelShield = this.defineDurability(builder, 2920, "Terrasteel");
        this.durabilityElementiumShield = this.defineDurability(builder, 1080, "Elementium");
        builder.pop();
        builder.push(categoryModdedMekanism);
        this.durabilityOsmiumShield = this.defineDurability(builder, 750, "Osmium");
        this.durabilityLapisLazuliShield = this.defineDurability(builder, 300, "Lapis Lazuli");
        this.durabilityRefinedGlowstoneShield = this.defineDurability(builder, 450, "Refined Glowstone");
        this.durabilityRefinedObsidianShield = this.defineDurability(builder, 3750, "Refined Obsidian");
        builder.pop();
        builder.push(categoryThermalMods);
        this.durabilitySignalumShield = this.defineDurability(builder, 2048, "Signalum");
        this.durabilityLumiumShield = this.defineDurability(builder, 1280, "Lumium");
        this.durabilityEnderiumShield = this.defineDurability(builder, 3120, "Enderium");
        builder.pop();
        builder.push(categoryPowered);
        this.damageToFEMultiplier = builder.comment("Damage to FE Multiplier").translation("config.spartanshields.damageToFEMultpier").defineInRange("damageToFEMultpier", 50, 0, 1000000);
        builder.pop();
    }

    private ForgeConfigSpec.IntValue defineDurability(ForgeConfigSpec.Builder builder, int defaultDurability, String name) {
        String nameLower = name.toLowerCase().replace(' ', '_');
        builder.push(nameLower);
        ForgeConfigSpec.IntValue durability = builder.comment("Durability for " + name + " Shields").translation("config.spartanshields.durability").defineInRange("durability", defaultDurability, 0, 100000);
        builder.pop();
        return durability;
    }

    @SubscribeEvent
    public static void onConfigLoad(ModConfigEvent ev) {
        Log.info("Loading config " + ev.getConfig().getFileName());
        if (ev.getConfig().getSpec() == CONFIG_SPEC) {
            Log.debug("Reloading durability values for Shields!");
            Config.updateMaxDurability((ShieldBaseItem)((Object)ModItems.WOODEN_BASIC_SHIELD.get()), (ShieldBaseItem)((Object)ModItems.WOODEN_TOWER_SHIELD.get()), (Integer)Config.INSTANCE.durabilityWoodShield.get());
            Config.updateMaxDurability((ShieldBaseItem)((Object)ModItems.STONE_BASIC_SHIELD.get()), (ShieldBaseItem)((Object)ModItems.STONE_TOWER_SHIELD.get()), (Integer)Config.INSTANCE.durabilityStoneShield.get());
            Config.updateMaxDurability((ShieldBaseItem)((Object)ModItems.COPPER_BASIC_SHIELD.get()), (ShieldBaseItem)((Object)ModItems.COPPER_TOWER_SHIELD.get()), (Integer)Config.INSTANCE.durabilityCopperShield.get());
            Config.updateMaxDurability((ShieldBaseItem)((Object)ModItems.IRON_BASIC_SHIELD.get()), (ShieldBaseItem)((Object)ModItems.IRON_TOWER_SHIELD.get()), (Integer)Config.INSTANCE.durabilityIronShield.get());
            Config.updateMaxDurability((ShieldBaseItem)((Object)ModItems.GOLDEN_BASIC_SHIELD.get()), (ShieldBaseItem)((Object)ModItems.GOLDEN_TOWER_SHIELD.get()), (Integer)Config.INSTANCE.durabilityGoldShield.get());
            Config.updateMaxDurability((ShieldBaseItem)((Object)ModItems.DIAMOND_BASIC_SHIELD.get()), (ShieldBaseItem)((Object)ModItems.DIAMOND_TOWER_SHIELD.get()), (Integer)Config.INSTANCE.durabilityDiamondShield.get());
            Config.updateMaxDurability((ShieldBaseItem)((Object)ModItems.NETHERITE_BASIC_SHIELD.get()), (ShieldBaseItem)((Object)ModItems.NETHERITE_TOWER_SHIELD.get()), (Integer)Config.INSTANCE.durabilityNetheriteShield.get());
            Config.updateMaxDurability((ShieldBaseItem)((Object)ModItems.OBSIDIAN_BASIC_SHIELD.get()), (ShieldBaseItem)((Object)ModItems.OBSIDIAN_TOWER_SHIELD.get()), Config.INSTANCE.obsidian.getDurability());
            Config.updateMaxDurability((ShieldBaseItem)((Object)ModItems.TIN_BASIC_SHIELD.get()), (ShieldBaseItem)((Object)ModItems.TIN_TOWER_SHIELD.get()), Config.INSTANCE.tin.getDurability());
            Config.updateMaxDurability((ShieldBaseItem)((Object)ModItems.BRONZE_BASIC_SHIELD.get()), (ShieldBaseItem)((Object)ModItems.BRONZE_TOWER_SHIELD.get()), Config.INSTANCE.bronze.getDurability());
            Config.updateMaxDurability((ShieldBaseItem)((Object)ModItems.STEEL_BASIC_SHIELD.get()), (ShieldBaseItem)((Object)ModItems.STEEL_TOWER_SHIELD.get()), Config.INSTANCE.steel.getDurability());
            Config.updateMaxDurability((ShieldBaseItem)((Object)ModItems.SILVER_BASIC_SHIELD.get()), (ShieldBaseItem)((Object)ModItems.SILVER_TOWER_SHIELD.get()), Config.INSTANCE.silver.getDurability());
            Config.updateMaxDurability((ShieldBaseItem)((Object)ModItems.ELECTRUM_BASIC_SHIELD.get()), (ShieldBaseItem)((Object)ModItems.ELECTRUM_TOWER_SHIELD.get()), Config.INSTANCE.electrum.getDurability());
            Config.updateMaxDurability((ShieldBaseItem)((Object)ModItems.LEAD_BASIC_SHIELD.get()), (ShieldBaseItem)((Object)ModItems.LEAD_TOWER_SHIELD.get()), Config.INSTANCE.lead.getDurability());
            Config.updateMaxDurability((ShieldBaseItem)((Object)ModItems.NICKEL_BASIC_SHIELD.get()), (ShieldBaseItem)((Object)ModItems.NICKEL_TOWER_SHIELD.get()), Config.INSTANCE.nickel.getDurability());
            Config.updateMaxDurability((ShieldBaseItem)((Object)ModItems.INVAR_BASIC_SHIELD.get()), (ShieldBaseItem)((Object)ModItems.INVAR_TOWER_SHIELD.get()), Config.INSTANCE.invar.getDurability());
            Config.updateMaxDurability((ShieldBaseItem)((Object)ModItems.CONSTANTAN_BASIC_SHIELD.get()), (ShieldBaseItem)((Object)ModItems.CONSTANTAN_TOWER_SHIELD.get()), Config.INSTANCE.constantan.getDurability());
            Config.updateMaxDurability((ShieldBaseItem)((Object)ModItems.PLATINUM_BASIC_SHIELD.get()), (ShieldBaseItem)((Object)ModItems.PLATINUM_TOWER_SHIELD.get()), Config.INSTANCE.platinum.getDurability());
            Config.updateMaxDurability((ShieldBaseItem)((Object)ModItems.ALUMINUM_BASIC_SHIELD.get()), (ShieldBaseItem)((Object)ModItems.ALUMINUM_TOWER_SHIELD.get()), Config.INSTANCE.aluminum.getDurability());
            Config.updateMaxDurability((ShieldBaseItem)((Object)ModItems.MANASTEEL_BASIC_SHIELD.get()), (ShieldBaseItem)((Object)ModItems.MANASTEEL_TOWER_SHIELD.get()), (Integer)Config.INSTANCE.durabilityManasteelShield.get());
            Config.updateMaxDurability((ShieldBaseItem)((Object)ModItems.TERRASTEEL_BASIC_SHIELD.get()), (ShieldBaseItem)((Object)ModItems.TERRASTEEL_TOWER_SHIELD.get()), (Integer)Config.INSTANCE.durabilityTerrasteelShield.get());
            Config.updateMaxDurability((ShieldBaseItem)((Object)ModItems.ELEMENTIUM_BASIC_SHIELD.get()), (ShieldBaseItem)((Object)ModItems.ELEMENTIUM_TOWER_SHIELD.get()), (Integer)Config.INSTANCE.durabilityElementiumShield.get());
            Config.updateMaxDurability((ShieldBaseItem)((Object)ModItems.OSMIUM_BASIC_SHIELD.get()), null, (Integer)Config.INSTANCE.durabilityOsmiumShield.get());
            Config.updateMaxDurability((ShieldBaseItem)((Object)ModItems.LAPIS_BASIC_SHIELD.get()), null, (Integer)Config.INSTANCE.durabilityLapisLazuliShield.get());
            Config.updateMaxDurability((ShieldBaseItem)((Object)ModItems.REFINED_GLOWSTONE_BASIC_SHIELD.get()), null, (Integer)Config.INSTANCE.durabilityRefinedGlowstoneShield.get());
            Config.updateMaxDurability((ShieldBaseItem)((Object)ModItems.REFINED_OBSIDIAN_BASIC_SHIELD.get()), null, (Integer)Config.INSTANCE.durabilityRefinedObsidianShield.get());
            Config.updateMaxDurability((ShieldBaseItem)((Object)ModItems.SIGNALUM_BASIC_SHIELD.get()), (ShieldBaseItem)((Object)ModItems.SIGNALUM_TOWER_SHIELD.get()), (Integer)Config.INSTANCE.durabilitySignalumShield.get());
            Config.updateMaxDurability((ShieldBaseItem)((Object)ModItems.LUMIUM_BASIC_SHIELD.get()), (ShieldBaseItem)((Object)ModItems.LUMIUM_TOWER_SHIELD.get()), (Integer)Config.INSTANCE.durabilityLumiumShield.get());
            Config.updateMaxDurability((ShieldBaseItem)((Object)ModItems.ENDERIUM_BASIC_SHIELD.get()), (ShieldBaseItem)((Object)ModItems.ENDERIUM_TOWER_SHIELD.get()), (Integer)Config.INSTANCE.durabilityEnderiumShield.get());
            TypeDisabledCondition.clear();
            TypeDisabledCondition.updateType("modded", (Boolean)Config.INSTANCE.vanillaOnly.get());
            ImmutableList.of((Object)Config.INSTANCE.obsidian, (Object)Config.INSTANCE.tin, (Object)Config.INSTANCE.bronze, (Object)Config.INSTANCE.steel, (Object)Config.INSTANCE.silver, (Object)Config.INSTANCE.electrum, (Object)Config.INSTANCE.lead, (Object)Config.INSTANCE.nickel, (Object)Config.INSTANCE.invar, (Object)Config.INSTANCE.constantan, (Object)Config.INSTANCE.platinum, (Object)Config.INSTANCE.aluminum, (Object[])new ShieldValues[0]).forEach(type -> type.updateFromConfig());
        }
    }

    public static void updateMaxDurability(ShieldBaseItem basicShieldItem, ShieldBaseItem towerShieldItem, int value) {
        if (basicShieldItem != null) {
            basicShieldItem.setMaxDamage(value);
        }
        if (towerShieldItem != null) {
            towerShieldItem.setMaxDamage(value);
        }
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(Config::new);
        CONFIG_SPEC = (ForgeConfigSpec)specPair.getRight();
        INSTANCE = (Config)specPair.getLeft();
    }

    public class ShieldValues {
        private String disabledName;
        private ForgeConfigSpec.IntValue durability;
        private ForgeConfigSpec.BooleanValue isDisabled;

        public ShieldValues(ForgeConfigSpec.Builder builder, int defaultDurability, String name, String disableType) {
            this.disabledName = disableType;
            builder.push(name.toLowerCase());
            this.durability = builder.comment("Durability for " + name + " Shields").translation("config.spartanshields.durability").defineInRange("durability", defaultDurability, 0, 100000);
            this.isDisabled = builder.comment("Set to true to disable " + name + " Shields").translation("config.spartanshields.disable").define("disable", false);
            builder.pop();
        }

        public int getDurability() {
            return (Integer)this.durability.get();
        }

        public boolean getIsDisabled() {
            return (Boolean)this.isDisabled.get();
        }

        public void updateFromConfig() {
            TypeDisabledCondition.updateType(this.disabledName, this.getIsDisabled());
        }
    }
}

