/*
 * Decompiled with CFR 0.152.
 */
package com.oblivioussp.spartanshields.event;

import com.oblivioussp.spartanshields.client.ModKeyBinds;
import com.oblivioussp.spartanshields.config.Config;
import com.oblivioussp.spartanshields.network.NetworkHandler;
import com.oblivioussp.spartanshields.network.ShieldBashPacket;
import com.oblivioussp.spartanshields.tags.ModItemTags;
import com.oblivioussp.spartanshields.util.Log;
import net.minecraft.ChatFormatting;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class ClientEventHandler {
    @SubscribeEvent
    public static void onMouseInputEvent(InputEvent.MouseButton ev) {
        ClientEventHandler.checkForShieldBash();
    }

    @SubscribeEvent
    public static void onKeyboardInputEvent(InputEvent.Key ev) {
        ClientEventHandler.checkForShieldBash();
    }

    protected static void checkForShieldBash() {
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        if (((Boolean)Config.INSTANCE.disableShieldBash.get()).booleanValue() || mc.f_91073_ == null || mc.f_91080_ != null || Minecraft.m_91087_().m_91104_() || player == null) {
            return;
        }
        if (player.m_21254_()) {
            ItemStack shieldStack = ItemStack.f_41583_;
            InteractionHand shieldHand = null;
            ItemStack usedItem = player.m_21211_();
            if (!(usedItem.m_204117_(ModItemTags.SHIELDS_WITH_BASH) && usedItem.m_41720_().canPerformAction(usedItem, ToolActions.SHIELD_BLOCK) && (ModKeyBinds.KEY_ALT_SHIELD_BASH.m_90862_() ? mc.f_91066_.f_92096_.m_90859_() : ModKeyBinds.KEY_ALT_SHIELD_BASH.m_90857_()))) {
                return;
            }
            shieldStack = player.m_21211_();
            shieldHand = player.m_7655_();
            if (player.m_36335_().m_41519_(shieldStack.m_41720_())) {
                return;
            }
            HitResult result = ClientEventHandler.getEntityMouseOverExtended(mc.f_91072_.m_105286_());
            if (result != null) {
                int entId = -1;
                boolean attackEntity = true;
                EntityHitResult entityRayTrace = null;
                if (result instanceof EntityHitResult) {
                    entityRayTrace = (EntityHitResult)result;
                }
                if (entityRayTrace != null && entityRayTrace.m_82443_() != null && entityRayTrace.m_82443_() != player) {
                    Log.debug("Hit Entity with Shield Bash! - " + entityRayTrace.m_82443_().toString());
                    entId = entityRayTrace.m_82443_().m_19879_();
                }
                if (entId == -1) {
                    entId = 0;
                    attackEntity = false;
                }
                player.m_21011_(shieldHand, true);
                NetworkHandler.sendPacketToServer(new ShieldBashPacket(shieldHand, entId, attackEntity));
            }
        }
    }

    private static HitResult getEntityMouseOverExtended(float reach) {
        BlockHitResult result = null;
        Minecraft mc = Minecraft.m_91087_();
        Entity viewEntity = mc.m_91288_();
        if (viewEntity != null && mc.f_91073_ != null) {
            AABB expBounds;
            double d0 = reach;
            HitResult rayTrace = viewEntity.m_19907_(d0, 0.0f, false);
            Vec3 eyePos = viewEntity.m_20299_(0.0f);
            boolean flag = false;
            double d1 = d0;
            if (mc.f_91072_.m_105291_() && d1 < 6.0) {
                d0 = d1 = 6.0;
            } else if (d0 > (double)reach) {
                flag = true;
            }
            d1 *= d1;
            if (rayTrace != null) {
                d1 = rayTrace.m_82450_().m_82557_(eyePos);
            }
            Vec3 lookVec = viewEntity.m_20252_(1.0f);
            Vec3 attackVec = eyePos.m_82520_(lookVec.f_82479_ * d0, lookVec.f_82480_ * d0, lookVec.f_82481_ * d0);
            EntityHitResult entityRayTrace = ProjectileUtil.m_37287_((Entity)viewEntity, (Vec3)eyePos, (Vec3)attackVec, (AABB)(expBounds = viewEntity.m_20191_().m_82369_(lookVec.m_82490_(d0)).m_82377_(1.0, 1.0, 1.0)), entity -> !entity.m_5833_() && entity.m_6087_(), (double)d1);
            if (entityRayTrace != null) {
                Vec3 hitVec = entityRayTrace.m_82450_();
                double d2 = eyePos.m_82557_(hitVec);
                if (flag && d2 > (double)(reach * reach)) {
                    result = BlockHitResult.m_82426_((Vec3)hitVec, (Direction)Direction.m_122366_((double)lookVec.f_82479_, (double)lookVec.f_82480_, (double)lookVec.f_82481_), (BlockPos)BlockPos.m_274446_((Position)hitVec));
                } else if (d2 < d1 || result == null) {
                    result = entityRayTrace;
                }
            } else {
                result = BlockHitResult.m_82426_((Vec3)attackVec, (Direction)Direction.m_122366_((double)lookVec.f_82479_, (double)lookVec.f_82480_, (double)lookVec.f_82481_), (BlockPos)BlockPos.m_274446_((Position)attackVec));
            }
        }
        return result;
    }

    @SubscribeEvent
    public static void onTooltipEvent(ItemTooltipEvent ev) {
        ItemStack stack = ev.getItemStack();
        if (!stack.m_41619_() && !((Boolean)Config.INSTANCE.disableShieldBash.get()).booleanValue() && stack.m_204117_(ModItemTags.SHIELDS_WITH_BASH) && stack.m_41720_().canPerformAction(stack, ToolActions.SHIELD_BLOCK)) {
            KeyMapping boundKey = ModKeyBinds.KEY_ALT_SHIELD_BASH.m_90862_() ? Minecraft.m_91087_().f_91066_.f_92096_ : ModKeyBinds.KEY_ALT_SHIELD_BASH;
            ev.getToolTip().add(1, Component.m_237110_((String)"tooltip.spartanshields.shield_bash", (Object[])new Object[]{Component.m_237110_((String)"tooltip.spartanshields.shield_bash.value", (Object[])new Object[]{Component.m_237115_((String)boundKey.m_90863_().getString().toUpperCase()).m_130940_(ChatFormatting.AQUA)}).m_130940_(ChatFormatting.GRAY)}).m_130940_(ChatFormatting.GOLD));
        }
    }
}

