/*
 * Decompiled with CFR 0.152.
 */
package net.regions_unexplored.world.level.feature;

import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.regions_unexplored.block.RuBlocks;
import net.regions_unexplored.world.level.feature.configuration.SeaRockConfiguration;

public class SeaRockFeature
extends Feature<SeaRockConfiguration> {
    public SeaRockFeature(Codec<SeaRockConfiguration> p_66017_) {
        super(p_66017_);
    }

    public boolean m_142674_(FeaturePlaceContext<SeaRockConfiguration> p_159884_) {
        boolean flag2;
        int l;
        BlockPos blockpos = p_159884_.m_159777_();
        WorldGenLevel worldgenlevel = p_159884_.m_159774_();
        if (worldgenlevel.m_8055_((blockpos = new BlockPos(blockpos.m_123341_(), blockpos.m_123342_(), blockpos.m_123343_())).m_7495_()).m_60713_(Blocks.f_50354_)) {
            return false;
        }
        RandomSource randomsource = p_159884_.m_225041_();
        if (randomsource.m_188503_(2) == 0) {
            return false;
        }
        boolean flag = randomsource.m_188500_() > 0.7;
        BlockState blockstate = ((SeaRockConfiguration)p_159884_.m_159778_()).state;
        BlockState blockstateAlt = ((SeaRockConfiguration)p_159884_.m_159778_()).altState;
        double d0 = randomsource.m_188500_() * 2.0 * Math.PI;
        int i = 11 - randomsource.m_188503_(5);
        int j = 3 + randomsource.m_188503_(3);
        boolean flag1 = randomsource.m_188500_() > 0.7;
        int k = 11;
        int n = l = flag1 ? randomsource.m_188503_(6) + 6 : randomsource.m_188503_(15) + 3;
        if (!flag1 && randomsource.m_188500_() > 0.9) {
            l += randomsource.m_188503_(19) + 7;
        }
        int i1 = Math.min(l + randomsource.m_188503_(11), 18);
        int j1 = Math.min(l + randomsource.m_188503_(7) - randomsource.m_188503_(5), 11);
        int k1 = flag1 ? i : 11;
        for (int l1 = -k1; l1 < k1; ++l1) {
            for (int i2 = -k1; i2 < k1; ++i2) {
                for (int j2 = 0; j2 < l; ++j2) {
                    int k2;
                    int n2 = k2 = flag1 ? this.heightDependentRadiusEllipse(j2, l, j1) : this.heightDependentRadiusRound(randomsource, j2, l, j1);
                    if (!flag1 && l1 >= k2) continue;
                    this.generateIcebergBlock((LevelAccessor)worldgenlevel, randomsource, blockpos, l, l1, j2, i2, k2, k1, flag1, j, d0, flag, blockstate, blockstateAlt);
                }
            }
        }
        this.smooth((LevelAccessor)worldgenlevel, blockpos, j1, l, flag1, i);
        for (int i3 = -k1; i3 < k1; ++i3) {
            for (int j3 = -k1; j3 < k1; ++j3) {
                for (int k3 = -1; k3 > -i1; --k3) {
                    int l3 = flag1 ? Mth.m_14167_((float)((float)k1 * (1.0f - (float)Math.pow(k3, 2.0) / ((float)i1 * 8.0f)))) : k1;
                    int l2 = this.heightDependentRadiusSteep(randomsource, -k3, i1, j1);
                    if (i3 >= l2) continue;
                    this.generateIcebergBlock((LevelAccessor)worldgenlevel, randomsource, blockpos, i1, i3, k3, j3, l2, l3, flag1, j, d0, flag, blockstate, blockstateAlt);
                }
            }
        }
        boolean bl = flag1 ? randomsource.m_188500_() > 0.1 : (flag2 = randomsource.m_188500_() > 0.7);
        if (flag2) {
            // empty if block
        }
        return true;
    }

    private void generateIcebergBlock(LevelAccessor p_225110_, RandomSource p_225111_, BlockPos p_225112_, int p_225113_, int p_225114_, int p_225115_, int p_225116_, int p_225117_, int p_225118_, boolean p_225119_, int p_225120_, double p_225121_, boolean p_225122_, BlockState p_225123_, BlockState p_225123_1) {
        double d0;
        double d = d0 = p_225119_ ? this.signedDistanceEllipse(p_225114_, p_225116_, BlockPos.f_121853_, p_225118_, this.getEllipseC(p_225115_, p_225113_, p_225120_), p_225121_) : this.signedDistanceCircle(p_225114_, p_225116_, BlockPos.f_121853_, p_225117_, p_225111_);
        if (d0 < 0.0) {
            double d1;
            BlockPos blockpos = p_225112_.m_7918_(p_225114_, p_225115_, p_225116_);
            double d2 = d1 = p_225119_ ? -0.5 : (double)(-6 - p_225111_.m_188503_(3));
            if (d0 > d1 && p_225111_.m_188500_() > 0.9) {
                return;
            }
            this.setIcebergBlock(blockpos, p_225110_, p_225111_, p_225113_ - p_225115_, p_225113_, p_225119_, p_225122_, p_225123_, p_225123_1);
        }
    }

    private void setIcebergBlock(BlockPos p_225125_, LevelAccessor p_225126_, RandomSource p_225127_, int p_225128_, int p_225129_, boolean p_225130_, boolean p_225131_, BlockState p_225132_, BlockState p_225132_1) {
        BlockState blockstate = p_225126_.m_8055_(p_225125_);
        if (blockstate.m_60795_() || blockstate.m_60713_(Blocks.f_50127_) || blockstate.m_60713_(Blocks.f_50126_) || p_225126_.m_6425_(p_225125_).m_192917_((Fluid)Fluids.f_76193_)) {
            int i;
            boolean flag = !p_225130_ || p_225127_.m_188500_() > 0.05;
            int n = i = p_225130_ ? 3 : 2;
            if (p_225131_ && (double)p_225128_ <= (double)p_225127_.m_188503_(Math.max(1, p_225129_ / i)) + (double)p_225129_ * 0.6 && flag) {
                this.m_5974_((LevelWriter)p_225126_, p_225125_, p_225132_1);
            } else {
                if (p_225127_.m_188503_(4) == 0) {
                    this.m_5974_((LevelWriter)p_225126_, p_225125_, p_225132_1);
                }
                this.m_5974_((LevelWriter)p_225126_, p_225125_, p_225132_);
            }
        }
    }

    private int getEllipseC(int p_66019_, int p_66020_, int p_66021_) {
        int i = p_66021_;
        if (p_66019_ > 0 && p_66020_ - p_66019_ <= 3) {
            i = p_66021_ - (4 - (p_66020_ - p_66019_));
        }
        return i;
    }

    private double signedDistanceCircle(int p_225089_, int p_225090_, BlockPos p_225091_, int p_225092_, RandomSource p_225093_) {
        float f = 10.0f * Mth.m_14036_((float)p_225093_.m_188501_(), (float)0.2f, (float)0.8f) / (float)p_225092_;
        return (double)f + Math.pow(p_225089_ - p_225091_.m_123341_(), 2.0) + Math.pow(p_225090_ - p_225091_.m_123343_(), 2.0) - Math.pow(p_225092_, 2.0);
    }

    private double signedDistanceEllipse(int p_66023_, int p_66024_, BlockPos p_66025_, int p_66026_, int p_66027_, double p_66028_) {
        return Math.pow(((double)(p_66023_ - p_66025_.m_123341_()) * Math.cos(p_66028_) - (double)(p_66024_ - p_66025_.m_123343_()) * Math.sin(p_66028_)) / (double)p_66026_, 2.0) + Math.pow(((double)(p_66023_ - p_66025_.m_123341_()) * Math.sin(p_66028_) + (double)(p_66024_ - p_66025_.m_123343_()) * Math.cos(p_66028_)) / (double)p_66027_, 2.0) - 1.0;
    }

    private int heightDependentRadiusRound(RandomSource p_225095_, int p_225096_, int p_225097_, int p_225098_) {
        float f = 3.5f - p_225095_.m_188501_();
        float f1 = (1.0f - (float)Math.pow(p_225096_, 2.0) / ((float)p_225097_ * f)) * (float)p_225098_;
        if (p_225097_ > 15 + p_225095_.m_188503_(5)) {
            int i = p_225096_ < 3 + p_225095_.m_188503_(6) ? p_225096_ / 2 : p_225096_;
            f1 = (1.0f - (float)i / ((float)p_225097_ * f * 0.4f)) * (float)p_225098_;
        }
        return Mth.m_14167_((float)(f1 / 2.0f));
    }

    private int heightDependentRadiusEllipse(int p_66110_, int p_66111_, int p_66112_) {
        float f = 1.0f;
        float f1 = (1.0f - (float)Math.pow(p_66110_, 2.0) / ((float)p_66111_ * 1.0f)) * (float)p_66112_;
        return Mth.m_14167_((float)(f1 / 2.0f));
    }

    private int heightDependentRadiusSteep(RandomSource p_225134_, int p_225135_, int p_225136_, int p_225137_) {
        float f = 1.0f + p_225134_.m_188501_() / 2.0f;
        float f1 = (1.0f - (float)p_225135_ / ((float)p_225136_ * f)) * (float)p_225137_;
        return Mth.m_14167_((float)(f1 / 2.0f));
    }

    private static boolean isRockState(BlockState p_159886_) {
        return p_159886_.m_60713_(Blocks.f_50069_) || p_159886_.m_60713_((Block)RuBlocks.MOSSY_STONE.get()) || p_159886_.m_60713_(Blocks.f_50354_) || p_159886_.m_60713_(Blocks.f_152544_);
    }

    private boolean belowIsAir(BlockGetter p_66046_, BlockPos p_66047_) {
        return p_66046_.m_8055_(p_66047_.m_7495_()).m_60795_() || p_66046_.m_6425_(p_66047_.m_7495_()).m_192917_((Fluid)Fluids.f_76193_);
    }

    private void smooth(LevelAccessor level, BlockPos p_66053_, int p_66054_, int p_66055_, boolean p_66056_, int p_66057_) {
        int i = p_66056_ ? p_66057_ : p_66054_ / 2;
        for (int j = -i; j <= i; ++j) {
            for (int k = -i; k <= i; ++k) {
                for (int l = 0; l <= p_66055_; ++l) {
                    BlockPos blockpos = p_66053_.m_7918_(j, l, k);
                    BlockState blockstate = level.m_8055_(blockpos);
                    if (!SeaRockFeature.isRockState(blockstate) && !blockstate.m_60713_(Blocks.f_50125_)) continue;
                    if (this.belowIsAir((BlockGetter)level, blockpos)) {
                        if (blockpos.m_123342_() >= level.m_5736_()) {
                            this.m_5974_((LevelWriter)level, blockpos, Blocks.f_50016_.m_49966_());
                        } else {
                            this.m_5974_((LevelWriter)level, blockpos, Blocks.f_49990_.m_49966_());
                        }
                        if (blockpos.m_7494_().m_123342_() >= level.m_5736_()) {
                            this.m_5974_((LevelWriter)level, blockpos.m_7494_(), Blocks.f_50016_.m_49966_());
                            continue;
                        }
                        this.m_5974_((LevelWriter)level, blockpos.m_7494_(), Blocks.f_49990_.m_49966_());
                        continue;
                    }
                    if (!SeaRockFeature.isRockState(blockstate)) continue;
                    BlockState[] ablockstate = new BlockState[]{level.m_8055_(blockpos.m_122024_()), level.m_8055_(blockpos.m_122029_()), level.m_8055_(blockpos.m_122012_()), level.m_8055_(blockpos.m_122019_())};
                    int i1 = 0;
                    for (BlockState blockstate1 : ablockstate) {
                        if (SeaRockFeature.isRockState(blockstate1)) continue;
                        ++i1;
                    }
                    if (i1 < 3) continue;
                    if (blockpos.m_123342_() >= level.m_5736_()) {
                        this.m_5974_((LevelWriter)level, blockpos, Blocks.f_50016_.m_49966_());
                        continue;
                    }
                    this.m_5974_((LevelWriter)level, blockpos, Blocks.f_49990_.m_49966_());
                }
            }
        }
    }
}

