/*
 * Decompiled with CFR 0.152.
 */
package net.regions_unexplored.world.level.feature.tree;

import com.mojang.serialization.Codec;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.regions_unexplored.block.RuBlocks;
import net.regions_unexplored.data.tags.RuTags;
import net.regions_unexplored.world.level.block.plant.branch.BranchBlock;
import net.regions_unexplored.world.level.block.wood.AspenLogBlock;
import net.regions_unexplored.world.level.feature.configuration.RuTreeConfiguration;

public class AspenTreeFeature
extends Feature<RuTreeConfiguration> {
    public AspenTreeFeature(Codec<RuTreeConfiguration> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<RuTreeConfiguration> context) {
        RuTreeConfiguration treeConfiguration = (RuTreeConfiguration)context.m_159778_();
        BlockPos pos = context.m_159777_();
        RandomSource randomSource = context.m_225041_();
        WorldGenLevel level = context.m_159774_();
        int height_main = context.m_225041_().m_188503_(treeConfiguration.sizeVariation) + treeConfiguration.minimumSize;
        BlockPos.MutableBlockPos checkPos = pos.m_122032_();
        for (int check = 0; check <= height_main; ++check) {
            if (!this.checkReplaceable((LevelAccessor)level, (BlockPos)checkPos)) {
                return false;
            }
            checkPos.m_122173_(Direction.UP);
        }
        BlockPos.MutableBlockPos placePos = pos.m_122032_();
        for (int placeCheck = 0; placeCheck <= height_main; ++placeCheck) {
            this.placeLog((LevelAccessor)level, (BlockPos)placePos, randomSource, treeConfiguration, Direction.Axis.Y);
            if (placeCheck == 0) {
                this.placeRoot((LevelAccessor)level, (BlockPos)placePos, randomSource, treeConfiguration);
            }
            if (placeCheck == height_main - 2) {
                this.placeStem((LevelAccessor)level, (BlockPos)placePos, randomSource, treeConfiguration);
            }
            if (placeCheck == height_main) {
                this.placeBranches((LevelAccessor)level, (BlockPos)placePos, randomSource, treeConfiguration);
            }
            placePos.m_122173_(Direction.UP);
        }
        return true;
    }

    public boolean placeStem(LevelAccessor level, BlockPos pos, RandomSource randomSource, RuTreeConfiguration treeConfiguration) {
        int move = randomSource.m_188503_(3) - 3;
        int rd = randomSource.m_188503_(4);
        if (rd == 0 && AspenTreeFeature.isReplaceable((LevelSimulatedReader)level, pos.m_122012_()) && !level.m_151570_(pos.m_122012_())) {
            if (randomSource.m_188503_(3) != 0) {
                this.placeLog(level, pos.m_122012_(), randomSource, treeConfiguration, Direction.Axis.Z);
            } else {
                level.m_7731_(pos.m_122012_(), (BlockState)treeConfiguration.branchProvider.m_213972_(randomSource, pos).m_61124_((Property)BranchBlock.FACING, (Comparable)Direction.NORTH), 2);
                if (randomSource.m_188503_(2) == 0) {
                    this.placeLeavesBlock(level, pos.m_122012_().m_7494_(), randomSource, treeConfiguration);
                    this.placeLeavesBlock(level, pos.m_122012_().m_122012_(), randomSource, treeConfiguration);
                    this.placeLeavesBlock(level, pos.m_122012_().m_122029_(), randomSource, treeConfiguration);
                    this.placeLeavesBlock(level, pos.m_122012_().m_122024_(), randomSource, treeConfiguration);
                }
            }
        }
        if (rd == 1 && AspenTreeFeature.isReplaceable((LevelSimulatedReader)level, pos.m_122019_()) && !level.m_151570_(pos.m_122019_())) {
            if (randomSource.m_188503_(3) != 0) {
                this.placeLog(level, pos.m_122019_(), randomSource, treeConfiguration, Direction.Axis.Z);
            } else {
                level.m_7731_(pos.m_122019_(), (BlockState)treeConfiguration.branchProvider.m_213972_(randomSource, pos).m_61124_((Property)BranchBlock.FACING, (Comparable)Direction.SOUTH), 2);
                if (randomSource.m_188503_(2) == 0) {
                    this.placeLeavesBlock(level, pos.m_122019_().m_7494_(), randomSource, treeConfiguration);
                    this.placeLeavesBlock(level, pos.m_122019_().m_122019_(), randomSource, treeConfiguration);
                    this.placeLeavesBlock(level, pos.m_122019_().m_122029_(), randomSource, treeConfiguration);
                    this.placeLeavesBlock(level, pos.m_122019_().m_122024_(), randomSource, treeConfiguration);
                }
            }
        }
        if (rd == 2 && AspenTreeFeature.isReplaceable((LevelSimulatedReader)level, pos.m_122029_()) && !level.m_151570_(pos.m_122029_())) {
            if (randomSource.m_188503_(3) != 0) {
                this.placeLog(level, pos.m_122029_(), randomSource, treeConfiguration, Direction.Axis.X);
            } else {
                level.m_7731_(pos.m_122029_(), (BlockState)treeConfiguration.branchProvider.m_213972_(randomSource, pos).m_61124_((Property)BranchBlock.FACING, (Comparable)Direction.EAST), 2);
                if (randomSource.m_188503_(2) == 0) {
                    this.placeLeavesBlock(level, pos.m_122029_().m_7494_(), randomSource, treeConfiguration);
                    this.placeLeavesBlock(level, pos.m_122029_().m_122029_(), randomSource, treeConfiguration);
                    this.placeLeavesBlock(level, pos.m_122029_().m_122012_(), randomSource, treeConfiguration);
                    this.placeLeavesBlock(level, pos.m_122029_().m_122019_(), randomSource, treeConfiguration);
                }
            }
        }
        if (rd == 3 && AspenTreeFeature.isReplaceable((LevelSimulatedReader)level, pos.m_122024_()) && !level.m_151570_(pos.m_122024_())) {
            if (randomSource.m_188503_(3) != 0) {
                this.placeLog(level, pos.m_122024_(), randomSource, treeConfiguration, Direction.Axis.X);
            } else {
                level.m_7731_(pos.m_122024_(), (BlockState)treeConfiguration.branchProvider.m_213972_(randomSource, pos).m_61124_((Property)BranchBlock.FACING, (Comparable)Direction.WEST), 2);
                if (randomSource.m_188503_(2) == 0) {
                    this.placeLeavesBlock(level, pos.m_122024_().m_7494_(), randomSource, treeConfiguration);
                    this.placeLeavesBlock(level, pos.m_122024_().m_122024_(), randomSource, treeConfiguration);
                    this.placeLeavesBlock(level, pos.m_122024_().m_122012_(), randomSource, treeConfiguration);
                    this.placeLeavesBlock(level, pos.m_122024_().m_122019_(), randomSource, treeConfiguration);
                }
            }
        }
        return true;
    }

    public boolean placeBranches(LevelAccessor level, BlockPos pos, RandomSource randomSource, RuTreeConfiguration treeConfiguration) {
        Direction.Axis axis;
        Direction direction;
        int type = randomSource.m_188503_(3);
        BlockPos.MutableBlockPos placePos = pos.m_122032_();
        BlockPos.MutableBlockPos placePos2 = pos.m_122032_();
        int pickDirection = randomSource.m_188503_(4);
        if (pickDirection == 0) {
            direction = Direction.NORTH;
            axis = Direction.Axis.Z;
        } else if (pickDirection == 1) {
            direction = Direction.SOUTH;
            axis = Direction.Axis.Z;
        } else if (pickDirection == 2) {
            direction = Direction.EAST;
            axis = Direction.Axis.X;
        } else {
            direction = Direction.WEST;
            axis = Direction.Axis.X;
        }
        if (type == 0) {
            int s = randomSource.m_188503_(2);
            placePos2.m_122173_(direction.m_122424_());
            this.placeLog(level, (BlockPos)placePos2, randomSource, treeConfiguration, axis);
            this.placeLeavesBlob(level, (BlockPos)placePos2, randomSource, treeConfiguration);
            placePos.m_122173_(direction);
            placePos.m_122173_(Direction.UP);
            this.placeLog(level, (BlockPos)placePos, randomSource, treeConfiguration, Direction.Axis.Y);
            placePos.m_122173_(Direction.UP);
            this.placeLog(level, (BlockPos)placePos, randomSource, treeConfiguration, Direction.Axis.Y);
            if (s != 0) {
                this.placeLeavesBlob(level, (BlockPos)placePos, randomSource, treeConfiguration);
            } else {
                placePos.m_122173_(Direction.UP);
                this.placeLog(level, (BlockPos)placePos, randomSource, treeConfiguration, Direction.Axis.Y);
                this.placeLeavesBlob(level, (BlockPos)placePos, randomSource, treeConfiguration);
            }
        } else if (type == 1) {
            placePos.m_122173_(direction);
            placePos.m_122173_(Direction.UP);
            this.placeLog(level, (BlockPos)placePos, randomSource, treeConfiguration, Direction.Axis.Y);
            placePos.m_122173_(Direction.UP);
            this.placeLog(level, (BlockPos)placePos, randomSource, treeConfiguration, Direction.Axis.Y);
            this.placeLeavesBlob(level, (BlockPos)placePos, randomSource, treeConfiguration);
        } else {
            this.placeLeavesBlob(level, pos, randomSource, treeConfiguration);
        }
        return true;
    }

    public void placeRoot(LevelAccessor level, BlockPos pos, RandomSource randomSource, RuTreeConfiguration treeConfiguration) {
        Random random = new Random();
        int rd = random.nextInt(2) + 2;
        BlockPos.MutableBlockPos placePos = pos.m_122032_();
        for (int i = 0; i <= rd; ++i) {
            if (level.m_8055_((BlockPos)placePos).m_247087_() && level.m_8055_(placePos.m_7494_()).m_204336_(BlockTags.f_144274_)) {
                level.m_7731_((BlockPos)placePos, Blocks.f_152548_.m_49966_(), 2);
                break;
            }
            if (!level.m_8055_((BlockPos)placePos).m_204336_(BlockTags.f_144274_) && !level.m_8055_((BlockPos)placePos).m_204336_(BlockTags.f_278411_) && !level.m_46859_((BlockPos)placePos)) break;
            this.placeLog(level, (BlockPos)placePos, randomSource, treeConfiguration, Direction.Axis.Y);
            placePos.m_122173_(Direction.DOWN);
        }
    }

    public boolean placeLeavesBlob(LevelAccessor level, BlockPos pos, RandomSource randomSource, RuTreeConfiguration treeConfiguration) {
        Random random = new Random();
        this.placeLeavesBlock(level, pos, randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_122012_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_122012_().m_122012_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_122019_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_122019_().m_122019_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_122029_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_122029_().m_122029_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_122024_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_122024_().m_122024_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_122012_().m_122029_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_122012_().m_122024_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_122019_().m_122029_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_122019_().m_122024_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_7494_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_7494_().m_122012_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_7494_().m_122019_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_7494_().m_122029_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_7494_().m_122024_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_7494_().m_122012_().m_122029_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_7494_().m_122012_().m_122024_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_7494_().m_122019_().m_122029_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_7494_().m_122019_().m_122024_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_7494_().m_7494_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_7494_().m_7494_().m_122012_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_7494_().m_7494_().m_122019_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_7494_().m_7494_().m_122029_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_7494_().m_7494_().m_122024_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_7494_().m_7494_().m_7494_(), randomSource, treeConfiguration);
        if (random.nextInt(2) == 0) {
            this.placeLeavesBlock(level, pos.m_7494_().m_7494_().m_7494_().m_122012_(), randomSource, treeConfiguration);
        }
        if (random.nextInt(2) == 0) {
            this.placeLeavesBlock(level, pos.m_7494_().m_7494_().m_7494_().m_122019_(), randomSource, treeConfiguration);
        }
        if (random.nextInt(2) == 0) {
            this.placeLeavesBlock(level, pos.m_7494_().m_7494_().m_7494_().m_122029_(), randomSource, treeConfiguration);
        }
        if (random.nextInt(2) == 0) {
            this.placeLeavesBlock(level, pos.m_7494_().m_7494_().m_7494_().m_122024_(), randomSource, treeConfiguration);
        }
        return true;
    }

    public boolean placeLog(LevelAccessor level, BlockPos pos, RandomSource randomSource, RuTreeConfiguration treeConfiguration, Direction.Axis axis) {
        boolean isBase = false;
        if (level.m_8055_(pos.m_7495_()).m_204336_(BlockTags.f_144274_)) {
            isBase = true;
        }
        Random random = new Random();
        if (level.m_151570_(pos)) {
            return true;
        }
        if (level.m_8055_(pos).m_60713_((Block)RuBlocks.PEAT_GRASS_BLOCK.get())) {
            level.m_7731_(pos, ((Block)RuBlocks.PEAT_DIRT.get()).m_49966_(), 2);
        } else if (level.m_8055_(pos).m_60713_((Block)RuBlocks.SILT_GRASS_BLOCK.get())) {
            level.m_7731_(pos, ((Block)RuBlocks.SILT_DIRT.get()).m_49966_(), 2);
        } else if (level.m_8055_(pos).m_60713_((Block)RuBlocks.ALPHA_GRASS_BLOCK.get())) {
            level.m_7731_(pos, Blocks.f_50493_.m_49966_(), 2);
        } else if (level.m_8055_(pos).m_60713_(Blocks.f_50440_)) {
            level.m_7731_(pos, Blocks.f_50493_.m_49966_(), 2);
        } else if (AspenTreeFeature.isReplaceable((LevelSimulatedReader)level, pos)) {
            if (treeConfiguration.trunkProvider.m_213972_(randomSource, pos).m_60734_() instanceof AspenLogBlock) {
                level.m_7731_(pos, (BlockState)((BlockState)treeConfiguration.trunkProvider.m_213972_(randomSource, pos).m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)axis)).m_61124_((Property)AspenLogBlock.IS_BASE, (Comparable)Boolean.valueOf(isBase)), 2);
            } else {
                level.m_7731_(pos, (BlockState)treeConfiguration.trunkProvider.m_213972_(randomSource, pos).m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)axis), 2);
            }
        } else {
            return true;
        }
        if (level.m_8055_(pos.m_7495_()).m_60713_((Block)RuBlocks.PEAT_GRASS_BLOCK.get())) {
            level.m_7731_(pos.m_7495_(), ((Block)RuBlocks.PEAT_DIRT.get()).m_49966_(), 2);
        } else if (level.m_8055_(pos.m_7495_()).m_60713_((Block)RuBlocks.SILT_GRASS_BLOCK.get())) {
            level.m_7731_(pos.m_7495_(), ((Block)RuBlocks.SILT_DIRT.get()).m_49966_(), 2);
        } else if (level.m_8055_(pos.m_7495_()).m_60713_((Block)RuBlocks.ALPHA_GRASS_BLOCK.get())) {
            level.m_7731_(pos.m_7495_(), Blocks.f_50493_.m_49966_(), 2);
        } else if (level.m_8055_(pos.m_7495_()).m_60713_(Blocks.f_50440_)) {
            level.m_7731_(pos.m_7495_(), Blocks.f_50493_.m_49966_(), 2);
        }
        return true;
    }

    public boolean placeLeavesBlock(LevelAccessor level, BlockPos pos, RandomSource randomSource, RuTreeConfiguration treeConfiguration) {
        Random random = new Random();
        if (level.m_151570_(pos)) {
            return true;
        }
        if (level.m_8055_(pos).m_247087_()) {
            level.m_7731_(pos, (BlockState)treeConfiguration.foliageProvider.m_213972_(randomSource, pos).m_61124_((Property)LeavesBlock.f_54418_, (Comparable)Integer.valueOf(1)), 2);
        }
        return true;
    }

    public boolean checkReplaceable(LevelAccessor level, BlockPos pos) {
        if (level.m_151570_(pos)) {
            return false;
        }
        return AspenTreeFeature.isReplaceable((LevelSimulatedReader)level, pos);
    }

    public static boolean isReplaceableDirtBlock(BlockState state) {
        return state.m_204336_(RuTags.TREE_GRASS_REPLACEABLES);
    }

    public static boolean isReplaceableDirt(LevelSimulatedReader reader, BlockPos pos) {
        return reader.m_7433_(pos, AspenTreeFeature::isReplaceableDirtBlock);
    }

    public static boolean isReplaceableBlock(BlockState state) {
        return state.m_204336_(RuTags.REPLACEABLE_BLOCKS);
    }

    public static boolean isReplaceable(LevelSimulatedReader reader, BlockPos pos) {
        return reader.m_7433_(pos, AspenTreeFeature::isReplaceableBlock);
    }
}

