/*
 * Decompiled with CFR 0.152.
 */
package dev.hexnowloading.dungeonnowloading.block;

import dev.hexnowloading.dungeonnowloading.block.ChaosSpawnerBarrierCenterBlock;
import dev.hexnowloading.dungeonnowloading.block.property.AllSides;
import dev.hexnowloading.dungeonnowloading.registry.DNLBlocks;
import dev.hexnowloading.dungeonnowloading.registry.DNLProperties;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class ChaosSpawnerEdgeBlock
extends Block
implements SimpleWaterloggedBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final EnumProperty<AllSides> ALL_SIDES = DNLProperties.ALL_SIDES;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    protected static final VoxelShape TOP_NORTH_AABB = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape)Block.m_49796_((double)0.0, (double)0.0, (double)14.0, (double)16.0, (double)14.0, (double)16.0));
    protected static final VoxelShape TOP_EAST_AABB = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape)Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0));
    protected static final VoxelShape TOP_SOUTH_AABB = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape)Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)14.0, (double)2.0));
    protected static final VoxelShape TOP_WEST_AABB = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape)Block.m_49796_((double)14.0, (double)0.0, (double)0.0, (double)16.0, (double)14.0, (double)16.0));
    protected static final VoxelShape BOTTOM_NORTH_AABB = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), (VoxelShape)Block.m_49796_((double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)16.0, (double)16.0));
    protected static final VoxelShape BOTTOM_EAST_AABB = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), (VoxelShape)Block.m_49796_((double)0.0, (double)2.0, (double)0.0, (double)2.0, (double)16.0, (double)16.0));
    protected static final VoxelShape BOTTOM_SOUTH_AABB = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), (VoxelShape)Block.m_49796_((double)0.0, (double)2.0, (double)0.0, (double)16.0, (double)16.0, (double)2.0));
    protected static final VoxelShape BOTTOM_WEST_AABB = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), (VoxelShape)Block.m_49796_((double)14.0, (double)2.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0));
    protected static final VoxelShape VERTICAL_NORTH_AABB = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)0.0, (double)0.0, (double)14.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape)Block.m_49796_((double)14.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)14.0));
    protected static final VoxelShape VERTICAL_EAST_AABB = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)2.0, (double)16.0, (double)16.0), (VoxelShape)Block.m_49796_((double)2.0, (double)0.0, (double)14.0, (double)16.0, (double)16.0, (double)16.0));
    protected static final VoxelShape VERTICAL_SOUTH_AABB = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)2.0), (VoxelShape)Block.m_49796_((double)0.0, (double)0.0, (double)2.0, (double)2.0, (double)16.0, (double)16.0));
    protected static final VoxelShape VERTICAL_WEST_AABB = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)14.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape)Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)14.0, (double)16.0, (double)2.0));

    public ChaosSpawnerEdgeBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_(ALL_SIDES, (Comparable)((Object)AllSides.BOTTOM))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.FALSE));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> stateBuilder) {
        stateBuilder.m_61104_(new Property[]{FACING, ALL_SIDES, WATERLOGGED});
    }

    public VoxelShape m_5940_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        switch ((AllSides)((Object)blockState.m_61143_(ALL_SIDES))) {
            default: {
                switch ((Direction)blockState.m_61143_((Property)FACING)) {
                    default: {
                        return TOP_NORTH_AABB;
                    }
                    case EAST: {
                        return TOP_EAST_AABB;
                    }
                    case SOUTH: {
                        return TOP_SOUTH_AABB;
                    }
                    case WEST: 
                }
                return TOP_WEST_AABB;
            }
            case BOTTOM: {
                switch ((Direction)blockState.m_61143_((Property)FACING)) {
                    default: {
                        return BOTTOM_NORTH_AABB;
                    }
                    case EAST: {
                        return BOTTOM_EAST_AABB;
                    }
                    case SOUTH: {
                        return BOTTOM_SOUTH_AABB;
                    }
                    case WEST: 
                }
                return BOTTOM_WEST_AABB;
            }
            case VERTICAL: 
        }
        switch ((Direction)blockState.m_61143_((Property)FACING)) {
            default: {
                return VERTICAL_NORTH_AABB;
            }
            case EAST: {
                return VERTICAL_EAST_AABB;
            }
            case SOUTH: {
                return VERTICAL_SOUTH_AABB;
            }
            case WEST: 
        }
        return VERTICAL_WEST_AABB;
    }

    public BlockState m_6843_(BlockState blockState, Rotation rotation) {
        return (BlockState)blockState.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)blockState.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState blockState, Mirror mirror) {
        return blockState.m_60717_(mirror.m_54846_((Direction)blockState.m_61143_((Property)FACING)));
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext ctx) {
        Direction direction = ctx.m_8125_();
        BlockPos blockPos = ctx.m_8083_();
        FluidState fluidstate = ctx.m_43725_().m_6425_(ctx.m_8083_());
        AllSides allSides = ctx.m_43723_().m_6047_() ? AllSides.VERTICAL : (!(direction == Direction.DOWN || direction != Direction.UP && ctx.m_43720_().f_82480_ - (double)blockPos.m_123342_() > 0.5) ? AllSides.BOTTOM : AllSides.TOP);
        return (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)ctx.m_8125_())).m_61124_(ALL_SIDES, (Comparable)((Object)allSides))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.m_76152_() == Fluids.f_76193_));
    }

    public void m_5871_(ItemStack itemStack, @Nullable BlockGetter blockGetter, List<Component> componentList, TooltipFlag tooltipFlag) {
        super.m_5871_(itemStack, blockGetter, componentList, tooltipFlag);
        componentList.add((Component)Component.m_237115_((String)"block.dungeonnowloading.chaos_spawner_edge.tooltip").m_130940_(ChatFormatting.GRAY));
    }

    public void m_6810_(BlockState blockState, Level level, BlockPos blockPos, BlockState blockState1, boolean b) {
        this.brokenFrame(level, blockPos, blockState);
        super.m_6810_(blockState, level, blockPos, blockState1, b);
    }

    private void playSound(Level level, BlockPos blockPos, float pitch) {
        level.m_5594_((Player)null, blockPos, SoundEvents.f_12376_, SoundSource.BLOCKS, 1.0f, pitch);
    }

    private void brokenFrame(Level level, BlockPos blockPos, BlockState blockState) {
        if (blockState.m_60713_(DNLBlocks.CHAOS_SPAWNER_DIAMOND_EDGE.get())) {
            this.playSound(level, blockPos, 1.5f);
            level.m_7731_(blockPos, (BlockState)((BlockState)((BlockState)DNLBlocks.CHAOS_SPAWNER_BROKEN_DIAMOND_EDGE.get().m_49966_().m_61124_((Property)FACING, (Comparable)((Direction)blockState.m_61143_((Property)FACING)))).m_61124_(ALL_SIDES, (Comparable)((Object)((AllSides)((Object)blockState.m_61143_(ALL_SIDES)))))).m_61124_((Property)WATERLOGGED, (Comparable)((Boolean)blockState.m_61143_((Property)WATERLOGGED))), 2);
            this.signalToBarrierCenter(level, blockPos, blockState);
        } else if (blockState.m_60713_(DNLBlocks.CHAOS_SPAWNER_EDGE.get())) {
            this.playSound(level, blockPos, 2.0f);
            level.m_7731_(blockPos, (BlockState)((BlockState)((BlockState)DNLBlocks.CHAOS_SPAWNER_BROKEN_EDGE.get().m_49966_().m_61124_((Property)FACING, (Comparable)((Direction)blockState.m_61143_((Property)FACING)))).m_61124_(ALL_SIDES, (Comparable)((Object)((AllSides)((Object)blockState.m_61143_(ALL_SIDES)))))).m_61124_((Property)WATERLOGGED, (Comparable)((Boolean)blockState.m_61143_((Property)WATERLOGGED))), 2);
        }
    }

    public static void fixFrame(Level level, BlockPos blockPos, BlockState blockState) {
        if (blockState.m_60713_(DNLBlocks.CHAOS_SPAWNER_BROKEN_DIAMOND_EDGE.get())) {
            level.m_7731_(blockPos, (BlockState)((BlockState)((BlockState)DNLBlocks.CHAOS_SPAWNER_DIAMOND_EDGE.get().m_49966_().m_61124_((Property)FACING, (Comparable)((Direction)blockState.m_61143_((Property)FACING)))).m_61124_(ALL_SIDES, (Comparable)((Object)((AllSides)((Object)blockState.m_61143_(ALL_SIDES)))))).m_61124_((Property)WATERLOGGED, (Comparable)((Boolean)blockState.m_61143_((Property)WATERLOGGED))), 2);
        } else if (blockState.m_60713_(DNLBlocks.CHAOS_SPAWNER_BROKEN_EDGE.get())) {
            level.m_7731_(blockPos, (BlockState)((BlockState)((BlockState)DNLBlocks.CHAOS_SPAWNER_EDGE.get().m_49966_().m_61124_((Property)FACING, (Comparable)((Direction)blockState.m_61143_((Property)FACING)))).m_61124_(ALL_SIDES, (Comparable)((Object)((AllSides)((Object)blockState.m_61143_(ALL_SIDES)))))).m_61124_((Property)WATERLOGGED, (Comparable)((Boolean)blockState.m_61143_((Property)WATERLOGGED))), 2);
        }
    }

    private void signalToBarrierCenter(Level level, BlockPos blockPos, BlockState blockState) {
        if (((AllSides)((Object)blockState.m_61143_(ALL_SIDES))).equals((Object)AllSides.TOP)) {
            if (((Direction)blockState.m_61143_((Property)FACING)).equals((Object)Direction.NORTH)) {
                ChaosSpawnerBarrierCenterBlock.checkBarrierCondition(level, blockPos.m_6625_(2), Direction.Axis.Z);
                ChaosSpawnerBarrierCenterBlock.checkBarrierCondition(level, blockPos.m_122013_(2), Direction.Axis.Y);
            } else if (((Direction)blockState.m_61143_((Property)FACING)).equals((Object)Direction.EAST)) {
                ChaosSpawnerBarrierCenterBlock.checkBarrierCondition(level, blockPos.m_6625_(2), Direction.Axis.X);
                ChaosSpawnerBarrierCenterBlock.checkBarrierCondition(level, blockPos.m_122030_(2), Direction.Axis.Y);
            } else if (((Direction)blockState.m_61143_((Property)FACING)).equals((Object)Direction.SOUTH)) {
                ChaosSpawnerBarrierCenterBlock.checkBarrierCondition(level, blockPos.m_6625_(2), Direction.Axis.Z);
                ChaosSpawnerBarrierCenterBlock.checkBarrierCondition(level, blockPos.m_122020_(2), Direction.Axis.Y);
            } else if (((Direction)blockState.m_61143_((Property)FACING)).equals((Object)Direction.WEST)) {
                ChaosSpawnerBarrierCenterBlock.checkBarrierCondition(level, blockPos.m_6625_(2), Direction.Axis.X);
                ChaosSpawnerBarrierCenterBlock.checkBarrierCondition(level, blockPos.m_122025_(2), Direction.Axis.Y);
            }
        } else if (((AllSides)((Object)blockState.m_61143_(ALL_SIDES))).equals((Object)AllSides.BOTTOM)) {
            if (((Direction)blockState.m_61143_((Property)FACING)).equals((Object)Direction.NORTH)) {
                ChaosSpawnerBarrierCenterBlock.checkBarrierCondition(level, blockPos.m_6630_(2), Direction.Axis.Z);
                ChaosSpawnerBarrierCenterBlock.checkBarrierCondition(level, blockPos.m_122013_(2), Direction.Axis.Y);
            } else if (((Direction)blockState.m_61143_((Property)FACING)).equals((Object)Direction.EAST)) {
                ChaosSpawnerBarrierCenterBlock.checkBarrierCondition(level, blockPos.m_6630_(2), Direction.Axis.X);
                ChaosSpawnerBarrierCenterBlock.checkBarrierCondition(level, blockPos.m_122030_(2), Direction.Axis.Y);
            } else if (((Direction)blockState.m_61143_((Property)FACING)).equals((Object)Direction.SOUTH)) {
                ChaosSpawnerBarrierCenterBlock.checkBarrierCondition(level, blockPos.m_6630_(2), Direction.Axis.Z);
                ChaosSpawnerBarrierCenterBlock.checkBarrierCondition(level, blockPos.m_122020_(2), Direction.Axis.Y);
            } else if (((Direction)blockState.m_61143_((Property)FACING)).equals((Object)Direction.WEST)) {
                ChaosSpawnerBarrierCenterBlock.checkBarrierCondition(level, blockPos.m_6630_(2), Direction.Axis.X);
                ChaosSpawnerBarrierCenterBlock.checkBarrierCondition(level, blockPos.m_122025_(2), Direction.Axis.Y);
            }
        } else if (((AllSides)((Object)blockState.m_61143_(ALL_SIDES))).equals((Object)AllSides.VERTICAL)) {
            if (((Direction)blockState.m_61143_((Property)FACING)).equals((Object)Direction.NORTH)) {
                ChaosSpawnerBarrierCenterBlock.checkBarrierCondition(level, blockPos.m_122013_(2), Direction.Axis.X);
                ChaosSpawnerBarrierCenterBlock.checkBarrierCondition(level, blockPos.m_122025_(2), Direction.Axis.Z);
            } else if (((Direction)blockState.m_61143_((Property)FACING)).equals((Object)Direction.EAST)) {
                ChaosSpawnerBarrierCenterBlock.checkBarrierCondition(level, blockPos.m_122030_(2), Direction.Axis.Z);
                ChaosSpawnerBarrierCenterBlock.checkBarrierCondition(level, blockPos.m_122013_(2), Direction.Axis.X);
            } else if (((Direction)blockState.m_61143_((Property)FACING)).equals((Object)Direction.SOUTH)) {
                ChaosSpawnerBarrierCenterBlock.checkBarrierCondition(level, blockPos.m_122020_(2), Direction.Axis.X);
                ChaosSpawnerBarrierCenterBlock.checkBarrierCondition(level, blockPos.m_122030_(2), Direction.Axis.Z);
            } else if (((Direction)blockState.m_61143_((Property)FACING)).equals((Object)Direction.WEST)) {
                ChaosSpawnerBarrierCenterBlock.checkBarrierCondition(level, blockPos.m_122025_(2), Direction.Axis.Z);
                ChaosSpawnerBarrierCenterBlock.checkBarrierCondition(level, blockPos.m_122020_(2), Direction.Axis.X);
            }
        }
    }
}

