/*
 * Decompiled with CFR 0.152.
 */
package dev.hexnowloading.dungeonnowloading.block;

import dev.hexnowloading.dungeonnowloading.block.MendingAuraBlock;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class MendingAuraFenceBlock
extends MendingAuraBlock {
    public static final BooleanProperty NORTH = PipeBlock.f_55148_;
    public static final BooleanProperty EAST = PipeBlock.f_55149_;
    public static final BooleanProperty SOUTH = PipeBlock.f_55150_;
    public static final BooleanProperty WEST = PipeBlock.f_55151_;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    protected static final Map<Direction, BooleanProperty> PROPERTY_BY_DIRECTION = (Map)PipeBlock.f_55154_.entrySet().stream().filter(p_52346_ -> ((Direction)p_52346_.getKey()).m_122434_().m_122479_()).collect(Util.m_137448_());
    protected final VoxelShape[] collisionShapeByIndex;
    protected final VoxelShape[] shapeByIndex;
    private final Object2IntMap<BlockState> stateToIndex = new Object2IntOpenHashMap();
    private final VoxelShape[] occlusionByIndex;

    public MendingAuraFenceBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.collisionShapeByIndex = this.makeShapes(2.0f, 2.0f, 24.0f, 0.0f, 24.0f);
        this.shapeByIndex = this.makeShapes(2.0f, 2.0f, 16.0f, 0.0f, 16.0f);
        for (BlockState blockstate : this.f_49792_.m_61056_()) {
            this.getAABBIndex(blockstate);
        }
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)EAST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)SOUTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WEST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        this.occlusionByIndex = this.makeShapes(2.0f, 1.0f, 16.0f, 6.0f, 15.0f);
    }

    protected VoxelShape[] makeShapes(float p_52327_, float p_52328_, float p_52329_, float p_52330_, float p_52331_) {
        float f = 8.0f - p_52327_;
        float f1 = 8.0f + p_52327_;
        float f2 = 8.0f - p_52328_;
        float f3 = 8.0f + p_52328_;
        VoxelShape voxelshape = Block.m_49796_((double)f, (double)0.0, (double)f, (double)f1, (double)p_52329_, (double)f1);
        VoxelShape voxelshape1 = Block.m_49796_((double)f2, (double)p_52330_, (double)0.0, (double)f3, (double)p_52331_, (double)f3);
        VoxelShape voxelshape2 = Block.m_49796_((double)f2, (double)p_52330_, (double)f2, (double)f3, (double)p_52331_, (double)16.0);
        VoxelShape voxelshape3 = Block.m_49796_((double)0.0, (double)p_52330_, (double)f2, (double)f3, (double)p_52331_, (double)f3);
        VoxelShape voxelshape4 = Block.m_49796_((double)f2, (double)p_52330_, (double)f2, (double)16.0, (double)p_52331_, (double)f3);
        VoxelShape voxelshape5 = Shapes.m_83110_((VoxelShape)voxelshape1, (VoxelShape)voxelshape4);
        VoxelShape voxelshape6 = Shapes.m_83110_((VoxelShape)voxelshape2, (VoxelShape)voxelshape3);
        VoxelShape[] avoxelshape = new VoxelShape[]{Shapes.m_83040_(), voxelshape2, voxelshape3, voxelshape6, voxelshape1, Shapes.m_83110_((VoxelShape)voxelshape2, (VoxelShape)voxelshape1), Shapes.m_83110_((VoxelShape)voxelshape3, (VoxelShape)voxelshape1), Shapes.m_83110_((VoxelShape)voxelshape6, (VoxelShape)voxelshape1), voxelshape4, Shapes.m_83110_((VoxelShape)voxelshape2, (VoxelShape)voxelshape4), Shapes.m_83110_((VoxelShape)voxelshape3, (VoxelShape)voxelshape4), Shapes.m_83110_((VoxelShape)voxelshape6, (VoxelShape)voxelshape4), voxelshape5, Shapes.m_83110_((VoxelShape)voxelshape2, (VoxelShape)voxelshape5), Shapes.m_83110_((VoxelShape)voxelshape3, (VoxelShape)voxelshape5), Shapes.m_83110_((VoxelShape)voxelshape6, (VoxelShape)voxelshape5)};
        for (int i = 0; i < 16; ++i) {
            avoxelshape[i] = Shapes.m_83110_((VoxelShape)voxelshape, (VoxelShape)avoxelshape[i]);
        }
        return avoxelshape;
    }

    @Override
    public boolean m_7420_(BlockState p_52348_, BlockGetter p_52349_, BlockPos p_52350_) {
        return (Boolean)p_52348_.m_61143_((Property)WATERLOGGED) == false;
    }

    public VoxelShape m_7952_(BlockState $$0, BlockGetter $$1, BlockPos $$2) {
        return this.occlusionByIndex[this.getAABBIndex($$0)];
    }

    @Override
    public VoxelShape m_5909_(BlockState $$0, BlockGetter $$1, BlockPos $$2, CollisionContext $$3) {
        return this.m_5940_($$0, $$1, $$2, $$3);
    }

    public VoxelShape m_5940_(BlockState p_52352_, BlockGetter p_52353_, BlockPos p_52354_, CollisionContext p_52355_) {
        return this.shapeByIndex[this.getAABBIndex(p_52352_)];
    }

    public VoxelShape m_5939_(BlockState p_52357_, BlockGetter p_52358_, BlockPos p_52359_, CollisionContext p_52360_) {
        return this.collisionShapeByIndex[this.getAABBIndex(p_52357_)];
    }

    public boolean connectsTo(BlockState $$0, boolean $$1, Direction $$2) {
        Block $$3 = $$0.m_60734_();
        boolean $$4 = this.isSameFence($$0);
        boolean $$5 = $$3 instanceof FenceGateBlock && FenceGateBlock.m_53378_((BlockState)$$0, (Direction)$$2);
        return !MendingAuraFenceBlock.m_152463_((BlockState)$$0) && $$1 || $$4 || $$5;
    }

    private boolean isSameFence(BlockState blockState) {
        return blockState.m_204336_(BlockTags.f_13039_) || blockState.m_60734_() instanceof MendingAuraFenceBlock;
    }

    private static int indexFor(Direction p_52344_) {
        return 1 << p_52344_.m_122416_();
    }

    protected int getAABBIndex(BlockState p_52364_) {
        return this.stateToIndex.computeIntIfAbsent((Object)p_52364_, p_52366_ -> {
            int i = 0;
            if (((Boolean)p_52366_.m_61143_((Property)NORTH)).booleanValue()) {
                i |= MendingAuraFenceBlock.indexFor(Direction.NORTH);
            }
            if (((Boolean)p_52366_.m_61143_((Property)EAST)).booleanValue()) {
                i |= MendingAuraFenceBlock.indexFor(Direction.EAST);
            }
            if (((Boolean)p_52366_.m_61143_((Property)SOUTH)).booleanValue()) {
                i |= MendingAuraFenceBlock.indexFor(Direction.SOUTH);
            }
            if (((Boolean)p_52366_.m_61143_((Property)WEST)).booleanValue()) {
                i |= MendingAuraFenceBlock.indexFor(Direction.WEST);
            }
            return i;
        });
    }

    @Override
    public BlockState m_5573_(BlockPlaceContext $$0) {
        Level $$1 = $$0.m_43725_();
        BlockPos $$2 = $$0.m_8083_();
        FluidState $$3 = $$0.m_43725_().m_6425_($$0.m_8083_());
        BlockPos $$4 = $$2.m_122012_();
        BlockPos $$5 = $$2.m_122029_();
        BlockPos $$6 = $$2.m_122019_();
        BlockPos $$7 = $$2.m_122024_();
        BlockState $$8 = $$1.m_8055_($$4);
        BlockState $$9 = $$1.m_8055_($$5);
        BlockState $$10 = $$1.m_8055_($$6);
        BlockState $$11 = $$1.m_8055_($$7);
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)super.m_5573_($$0).m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(this.connectsTo($$8, $$8.m_60783_((BlockGetter)$$1, $$4, Direction.SOUTH), Direction.SOUTH)))).m_61124_((Property)EAST, (Comparable)Boolean.valueOf(this.connectsTo($$9, $$9.m_60783_((BlockGetter)$$1, $$5, Direction.WEST), Direction.WEST)))).m_61124_((Property)SOUTH, (Comparable)Boolean.valueOf(this.connectsTo($$10, $$10.m_60783_((BlockGetter)$$1, $$6, Direction.NORTH), Direction.NORTH)))).m_61124_((Property)WEST, (Comparable)Boolean.valueOf(this.connectsTo($$11, $$11.m_60783_((BlockGetter)$$1, $$7, Direction.EAST), Direction.EAST)))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf($$3.m_76152_() == Fluids.f_76193_));
    }

    public BlockState m_7417_(BlockState $$0, Direction $$1, BlockState $$2, LevelAccessor $$3, BlockPos $$4, BlockPos $$5) {
        if (((Boolean)$$0.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            $$3.m_186469_($$4, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)$$3));
        }
        return $$1.m_122434_().m_122480_() == Direction.Plane.HORIZONTAL ? (BlockState)$$0.m_61124_((Property)PROPERTY_BY_DIRECTION.get($$1), (Comparable)Boolean.valueOf(this.connectsTo($$2, $$2.m_60783_((BlockGetter)$$3, $$5, $$1.m_122424_()), $$1.m_122424_()))) : super.m_7417_($$0, $$1, $$2, $$3, $$4, $$5);
    }

    @Override
    public FluidState m_5888_(BlockState p_52362_) {
        return (Boolean)p_52362_.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(p_52362_);
    }

    public boolean m_7357_(BlockState p_52333_, BlockGetter p_52334_, BlockPos p_52335_, PathComputationType p_52336_) {
        return false;
    }

    public BlockState m_6843_(BlockState p_52341_, Rotation p_52342_) {
        switch (p_52342_) {
            case CLOCKWISE_180: {
                return (BlockState)((BlockState)((BlockState)((BlockState)p_52341_.m_61124_((Property)NORTH, (Comparable)((Boolean)p_52341_.m_61143_((Property)SOUTH)))).m_61124_((Property)EAST, (Comparable)((Boolean)p_52341_.m_61143_((Property)WEST)))).m_61124_((Property)SOUTH, (Comparable)((Boolean)p_52341_.m_61143_((Property)NORTH)))).m_61124_((Property)WEST, (Comparable)((Boolean)p_52341_.m_61143_((Property)EAST)));
            }
            case COUNTERCLOCKWISE_90: {
                return (BlockState)((BlockState)((BlockState)((BlockState)p_52341_.m_61124_((Property)NORTH, (Comparable)((Boolean)p_52341_.m_61143_((Property)EAST)))).m_61124_((Property)EAST, (Comparable)((Boolean)p_52341_.m_61143_((Property)SOUTH)))).m_61124_((Property)SOUTH, (Comparable)((Boolean)p_52341_.m_61143_((Property)WEST)))).m_61124_((Property)WEST, (Comparable)((Boolean)p_52341_.m_61143_((Property)NORTH)));
            }
            case CLOCKWISE_90: {
                return (BlockState)((BlockState)((BlockState)((BlockState)p_52341_.m_61124_((Property)NORTH, (Comparable)((Boolean)p_52341_.m_61143_((Property)WEST)))).m_61124_((Property)EAST, (Comparable)((Boolean)p_52341_.m_61143_((Property)NORTH)))).m_61124_((Property)SOUTH, (Comparable)((Boolean)p_52341_.m_61143_((Property)EAST)))).m_61124_((Property)WEST, (Comparable)((Boolean)p_52341_.m_61143_((Property)SOUTH)));
            }
        }
        return p_52341_;
    }

    public BlockState m_6943_(BlockState p_52338_, Mirror p_52339_) {
        switch (p_52339_) {
            case LEFT_RIGHT: {
                return (BlockState)((BlockState)p_52338_.m_61124_((Property)NORTH, (Comparable)((Boolean)p_52338_.m_61143_((Property)SOUTH)))).m_61124_((Property)SOUTH, (Comparable)((Boolean)p_52338_.m_61143_((Property)NORTH)));
            }
            case FRONT_BACK: {
                return (BlockState)((BlockState)p_52338_.m_61124_((Property)EAST, (Comparable)((Boolean)p_52338_.m_61143_((Property)WEST)))).m_61124_((Property)WEST, (Comparable)((Boolean)p_52338_.m_61143_((Property)EAST)));
            }
        }
        return super.m_6943_(p_52338_, p_52339_);
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> $$0) {
        $$0.m_61104_(new Property[]{NORTH, EAST, WEST, SOUTH, WATERLOGGED});
    }
}

