/*
 * Decompiled with CFR 0.152.
 */
package dev.hexnowloading.dungeonnowloading.block;

import dev.hexnowloading.dungeonnowloading.block.PreserverBlock;
import dev.hexnowloading.dungeonnowloading.block.entity.MendstoneChalkMarkBlockEntity;
import dev.hexnowloading.dungeonnowloading.registry.DNLSounds;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.DustColorTransitionOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class MendstoneChalkMarkBlock
extends PreserverBlock
implements SimpleWaterloggedBlock {
    public static final IntegerProperty OUTLINE = IntegerProperty.m_61631_((String)"outline", (int)0, (int)4);
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    private static final VoxelShape UP_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0);
    private static final VoxelShape DOWN_AABB = Block.m_49796_((double)0.0, (double)15.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape WEST_AABB = Block.m_49796_((double)15.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape EAST_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)16.0);
    private static final VoxelShape NORTH_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)15.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape SOUTH_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)1.0);
    private static final Map<Direction, VoxelShape> SHAPE_BY_DIRECTION = Map.of(Direction.UP, UP_AABB, Direction.DOWN, DOWN_AABB, Direction.WEST, WEST_AABB, Direction.EAST, EAST_AABB, Direction.NORTH, NORTH_AABB, Direction.SOUTH, SOUTH_AABB);

    public MendstoneChalkMarkBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)OUTLINE, (Comparable)Integer.valueOf(0))).m_61124_((Property)LIT, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.FALSE));
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING});
        builder.m_61104_(new Property[]{OUTLINE});
        builder.m_61104_(new Property[]{LIT});
        builder.m_61104_(new Property[]{WATERLOGGED});
    }

    @Override
    @Nullable
    public BlockState m_5573_(BlockPlaceContext blockPlaceContext) {
        Direction direction = blockPlaceContext.m_43719_();
        BlockState blockState = blockPlaceContext.m_43725_().m_8055_(blockPlaceContext.m_8083_().m_121945_(direction.m_122424_()));
        FluidState fluidstate = blockPlaceContext.m_43725_().m_6425_(blockPlaceContext.m_8083_());
        return blockState.m_60713_((Block)this) && blockState.m_61143_((Property)FACING) == direction ? (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)direction.m_122424_())).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.m_205070_(FluidTags.f_13131_) && fluidstate.m_76186_() == 8)) : (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)direction)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.m_205070_(FluidTags.f_13131_) && fluidstate.m_76186_() == 8));
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            worldIn.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)worldIn));
        }
        return stateIn;
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        return switch ((Direction)state.m_61143_((Property)FACING)) {
            case Direction.UP -> UP_AABB;
            case Direction.NORTH -> NORTH_AABB;
            case Direction.EAST -> EAST_AABB;
            case Direction.SOUTH -> SOUTH_AABB;
            case Direction.WEST -> WEST_AABB;
            default -> DOWN_AABB;
        };
    }

    public VoxelShape m_5939_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        return Shapes.m_83040_();
    }

    @Override
    public void setLitPreserverBlock(ServerLevel level, BlockPos pos) {
        BlockEntity be = level.m_7702_(pos);
        if (be instanceof MendstoneChalkMarkBlockEntity) {
            MendstoneChalkMarkBlockEntity mark = (MendstoneChalkMarkBlockEntity)be;
            int newDamage = mark.getDamage() + 1;
            mark.setDamage(newDamage);
            if (newDamage >= 160) {
                level.m_7654_().execute(() -> {
                    level.m_5594_(null, pos, DNLSounds.MENDSTONE_CHALK_MARK_BREAK.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                    level.m_7731_(pos, Blocks.f_50016_.m_49966_(), 3);
                });
                return;
            }
            int outlineStage = newDamage / 32;
            BlockState cur = level.m_8055_(pos);
            int previousOutlineStage = (Integer)cur.m_61143_((Property)OUTLINE);
            if (previousOutlineStage != outlineStage) {
                DustColorTransitionOptions dust2 = new DustColorTransitionOptions(new Vector3f(0.45f, 0.8f, 1.0f), new Vector3f(0.9f, 0.95f, 1.0f), 1.0f);
                level.m_8767_((ParticleOptions)dust2, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, 5, 0.0, 0.5, 0.5, 0.0);
                level.m_5594_(null, pos, DNLSounds.MENDSTONE_CHALK_MARK_CRACK.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            level.m_7731_(pos, (BlockState)((BlockState)cur.m_61124_((Property)LIT, (Comparable)Boolean.valueOf(true))).m_61124_((Property)OUTLINE, (Comparable)Integer.valueOf(outlineStage)), 3);
            level.m_186460_(pos, (Block)this, 20);
            mark.m_6596_();
        }
    }

    @Override
    public void m_213897_(BlockState blockState, ServerLevel serverLevel, BlockPos blockPos, RandomSource randomSource) {
        if (!serverLevel.m_183326_().m_183582_(blockPos, (Object)this)) {
            BlockState cur = serverLevel.m_8055_(blockPos);
            serverLevel.m_7731_(blockPos, (BlockState)cur.m_61124_((Property)LIT, (Comparable)Boolean.valueOf(false)), 3);
        }
    }

    @Override
    @Nullable
    public BlockEntity m_142194_(BlockPos blockPos, BlockState blockState) {
        return new MendstoneChalkMarkBlockEntity(blockPos, blockState);
    }

    @Override
    protected boolean canPlayerDestroy() {
        return true;
    }
}

