/*
 * Decompiled with CFR 0.152.
 */
package dev.hexnowloading.dungeonnowloading.block.entity;

import dev.hexnowloading.dungeonnowloading.block.FairkeeperChestBlock;
import dev.hexnowloading.dungeonnowloading.block.entity.BallistaGolemStatueBlockEntity;
import dev.hexnowloading.dungeonnowloading.block.entity.FairkeeperSpawnerBlockEntity;
import dev.hexnowloading.dungeonnowloading.block.entity.ScuttleStatueBlockEntity;
import dev.hexnowloading.dungeonnowloading.block.property.ChestStates;
import dev.hexnowloading.dungeonnowloading.particle.type.AxisParticleType;
import dev.hexnowloading.dungeonnowloading.platform.Services;
import dev.hexnowloading.dungeonnowloading.registry.DNLBlockEntityTypes;
import dev.hexnowloading.dungeonnowloading.registry.DNLBlocks;
import dev.hexnowloading.dungeonnowloading.registry.DNLParticleTypes;
import dev.hexnowloading.dungeonnowloading.registry.DNLProperties;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;

public class FairkeeperChestBlockEntity
extends RandomizableContainerBlockEntity
implements MenuProvider {
    public static final String LOOT_TABLE_TAG = "LootTable";
    public static final String LOOT_TABLE_SEED_TAG = "LootTableSeed";
    private NonNullList<ItemStack> items = NonNullList.m_122780_((int)27, (Object)ItemStack.f_41583_);
    protected ResourceLocation lootTable;
    protected long lootTableSeed;
    private ResourceLocation combatLootTable;
    private long combatLootTableSeed;
    private List<BlockPos> blockEntityLocationList;
    private BlockPos oldBlockPos;
    private BlockPos lastSpawner;
    private int startUpTick;
    private int actualRegion1X;
    private int actualRegion1Y;
    private int actualRegion1Z;
    private int actualRegion2X;
    private int actualRegion2Y;
    private int actualRegion2Z;
    private int facing;
    private BlockPos maxRegion;
    private BlockPos minRegion;
    private int playerCount;
    private boolean disabled = false;
    private static final double PLAYER_RANGE = 48.0;
    private static final int START_UP_TICK = 60;
    private static final int OPEN_CLOSE_ANIMATION_DURATION = 10;
    private int openCloseAnimationProgress = 0;
    private int prevOpenCloseAnimationProgress = 0;

    public FairkeeperChestBlockEntity(BlockPos pos, BlockState state) {
        super(DNLBlockEntityTypes.FAIRKEEPER_CHEST.get(), pos, state);
    }

    protected void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        if (!this.m_59634_(nbt)) {
            ContainerHelper.m_18973_((CompoundTag)nbt, this.items);
        } else if (this.combatLootTable != null) {
            nbt.m_128359_("CombatLootTable", this.combatLootTable.toString());
            if (this.combatLootTableSeed != 0L) {
                nbt.m_128356_("CombatLootTableSeed", this.combatLootTableSeed);
            }
        }
        if (this.blockEntityLocationList != null) {
            ListTag listTag = new ListTag();
            this.blockEntityLocationList.forEach(blockPos -> listTag.add((Object)this.newIntList(blockPos.m_123341_(), blockPos.m_123342_(), blockPos.m_123343_())));
            nbt.m_128365_("SpawnerLocations", (Tag)listTag);
        }
        if (this.lastSpawner != null) {
            nbt.m_128365_("LastSpawner", (Tag)this.newIntList(this.lastSpawner.m_123341_(), this.lastSpawner.m_123342_(), this.lastSpawner.m_123343_()));
        }
        nbt.m_128405_("Facing", this.facing);
        nbt.m_128365_("OldBlockPos", (Tag)this.newIntList(this.m_58899_().m_123341_(), this.m_58899_().m_123342_(), this.m_58899_().m_123343_()));
        nbt.m_128405_("StartUpTick", this.startUpTick);
        nbt.m_128405_("PlayerCount", this.playerCount);
        nbt.m_128379_("Disabled", this.disabled);
        if (this.maxRegion != null) {
            nbt.m_128365_("MaxRegion", (Tag)this.newIntList(this.maxRegion.m_123341_(), this.maxRegion.m_123342_(), this.maxRegion.m_123343_()));
        }
        if (this.minRegion != null) {
            nbt.m_128365_("MinRegion", (Tag)this.newIntList(this.minRegion.m_123341_(), this.minRegion.m_123342_(), this.minRegion.m_123343_()));
        }
    }

    private ListTag newIntList(int ... ints) {
        ListTag listTag = new ListTag();
        for (int i : ints) {
            listTag.add((Object)IntTag.m_128679_((int)i));
        }
        return listTag;
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.items = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
        if (!this.m_59631_(nbt)) {
            ContainerHelper.m_18980_((CompoundTag)nbt, this.items);
        } else if (nbt.m_128425_("CombatLootTable", 8)) {
            this.combatLootTable = new ResourceLocation(nbt.m_128461_("CombatLootTable"));
            this.combatLootTableSeed = nbt.m_128454_("CombatLootTableSeed");
        }
        if (nbt.m_128425_("SpawnerLocations", 9)) {
            ListTag listTag = nbt.m_128437_("SpawnerLocations", 9);
            if (this.blockEntityLocationList == null) {
                this.blockEntityLocationList = new ArrayList<BlockPos>();
            }
            for (int a = 0; a < listTag.size(); ++a) {
                this.blockEntityLocationList.add(new BlockPos(listTag.m_128763_(0), listTag.m_128763_(1), listTag.m_128763_(2)));
            }
        }
        if (nbt.m_128425_("LastSpawner", 9)) {
            this.lastSpawner = new BlockPos(nbt.m_128437_("LastSpawner", 3).m_128763_(0), nbt.m_128437_("LastSpawner", 3).m_128763_(1), nbt.m_128437_("LastSpawner", 3).m_128763_(2));
        }
        this.facing = nbt.m_128451_("Facing");
        this.startUpTick = nbt.m_128451_("StartUpTick");
        this.playerCount = nbt.m_128451_("PlayerCount");
        this.disabled = nbt.m_128471_("Disabled");
        this.oldBlockPos = new BlockPos(nbt.m_128437_("OldBlockPos", 3).m_128763_(0), nbt.m_128437_("OldBlockPos", 3).m_128763_(1), nbt.m_128437_("OldBlockPos", 3).m_128763_(2));
        if (nbt.m_128425_("MaxRegion", 9)) {
            this.maxRegion = new BlockPos(nbt.m_128437_("MaxRegion", 3).m_128763_(0), nbt.m_128437_("MaxRegion", 3).m_128763_(1), nbt.m_128437_("MaxRegion", 3).m_128763_(2));
        }
        if (nbt.m_128425_("MinRegion", 9)) {
            this.minRegion = new BlockPos(nbt.m_128437_("MinRegion", 3).m_128763_(0), nbt.m_128437_("MinRegion", 3).m_128763_(1), nbt.m_128437_("MinRegion", 3).m_128763_(2));
        }
    }

    public boolean hasSpawnerLocations() {
        if (this.blockEntityLocationList == null) {
            return false;
        }
        return !this.blockEntityLocationList.isEmpty();
    }

    public CompoundTag setCombatLootTable(FairkeeperChestBlockEntity blockEntity) {
        CompoundTag nbt = blockEntity.m_187480_().m_6426_();
        if (nbt.m_128425_("CombatLootTable", 8)) {
            nbt.m_128359_(LOOT_TABLE_TAG, blockEntity.combatLootTable.toString());
            nbt.m_128356_(LOOT_TABLE_SEED_TAG, blockEntity.combatLootTableSeed);
            nbt.m_128473_("CombatLootTable");
            nbt.m_128473_("CombatLootTableSeed");
        }
        return nbt;
    }

    public AABB getBoundaryAABB() {
        return new AABB((double)this.actualRegion1X, (double)this.actualRegion1Y, (double)this.actualRegion1Z, (double)this.actualRegion2X, (double)this.actualRegion2Y, (double)this.actualRegion2Z);
    }

    public int getActualRegion1X() {
        return this.actualRegion1X;
    }

    public boolean hasLastSpawner(Level level, FairkeeperChestBlockEntity blockEntity) {
        if (blockEntity.lastSpawner != null) {
            return level.m_8055_(blockEntity.lastSpawner).m_60713_(DNLBlocks.FAIRKEEEPER_SPAWNER.get());
        }
        return false;
    }

    private void removeLootTable() {
        if (this.lootTable != null) {
            this.lootTable = null;
        }
    }

    public void setDisabled(boolean b) {
        this.disabled = b;
    }

    protected Component m_6820_() {
        return Component.m_237115_((String)"block.dungeonnowloading.fairkeeper_chest");
    }

    protected AbstractContainerMenu m_6555_(int i, Inventory inventory) {
        return ChestMenu.m_39237_((int)i, (Inventory)inventory, (Container)this);
    }

    public int m_6643_() {
        return 27;
    }

    protected NonNullList<ItemStack> m_7086_() {
        return this.items;
    }

    protected void m_6520_(NonNullList<ItemStack> itemStacks) {
        this.items = itemStacks;
    }

    public void m_5856_(Player player) {
        if (!this.f_58859_ && !player.m_5833_()) {
            FairkeeperChestBlock.setFairkeeperChest(this.m_58904_(), this.m_58899_(), ChestStates.OPENING);
            FairkeeperChestBlockEntity.playSound(this.m_58904_(), this.m_58899_(), SoundEvents.f_11749_);
            FairkeeperChestBlockEntity.destroySpawners(this.m_58904_(), this);
        }
    }

    public void m_5785_(Player player) {
        if (!this.f_58859_ && !player.m_5833_()) {
            FairkeeperChestBlock.setFairkeeperChest(this.m_58904_(), this.m_58899_(), ChestStates.CLOSING);
            FairkeeperChestBlockEntity.playSound(this.m_58904_(), this.m_58899_(), SoundEvents.f_11747_);
        }
    }

    public static void playSound(Level level, BlockPos blockPos, SoundEvent soundEvent) {
        level.m_5594_((Player)null, blockPos, soundEvent, SoundSource.BLOCKS, 0.5f, level.f_46441_.m_188501_() * 0.1f + 0.9f);
    }

    public static void setMaxMinRegion(Level level, BlockPos blockPos, FairkeeperChestBlockEntity blockEntity) {
        int xp = 0;
        int xn = 0;
        int yp = 0;
        int yn = 0;
        int zp = 0;
        int zn = 0;
        int i = 0;
        while ((double)i < 48.0) {
            if (level.m_8055_(blockPos.m_7918_(0, i, 0)).m_60713_(Blocks.f_50330_) && yp == 0) {
                yp = i;
            }
            if (level.m_8055_(blockPos.m_7918_(0, 0, i)).m_60713_(Blocks.f_50330_) && zp == 0) {
                zp = i;
            }
            if (level.m_8055_(blockPos.m_7918_(i, 0, 0)).m_60713_(Blocks.f_50330_) && xp == 0) {
                xp = i;
            }
            if (level.m_8055_(blockPos.m_7918_(0, -i, 0)).m_60713_(Blocks.f_50330_) && yn == 0) {
                yn = -i;
            }
            if (level.m_8055_(blockPos.m_7918_(0, 0, -i)).m_60713_(Blocks.f_50330_) && zn == 0) {
                zn = -i;
            }
            if (level.m_8055_(blockPos.m_7918_(-i, 0, 0)).m_60713_(Blocks.f_50330_) && xn == 0) {
                xn = -i;
            }
            ++i;
        }
        blockEntity.maxRegion = new BlockPos(xp, yp, zp);
        blockEntity.minRegion = new BlockPos(xn, yn, zn);
        int tempActualRegion1X = blockPos.m_123341_() + blockEntity.maxRegion.m_123341_();
        int tempActualRegion1Y = blockPos.m_123342_() + blockEntity.maxRegion.m_123342_();
        int tempActualRegion1Z = blockPos.m_123343_() + blockEntity.maxRegion.m_123343_();
        int tempActualRegion2X = blockPos.m_123341_() + blockEntity.minRegion.m_123341_();
        int tempActualRegion2Y = blockPos.m_123342_() + blockEntity.minRegion.m_123342_();
        int tempActualRegion2Z = blockPos.m_123343_() + blockEntity.minRegion.m_123343_();
        blockEntity.actualRegion1X = Math.max(tempActualRegion1X, tempActualRegion2X) + 1;
        blockEntity.actualRegion1Y = Math.max(tempActualRegion1Y, tempActualRegion2Y) + 1;
        blockEntity.actualRegion1Z = Math.max(tempActualRegion1Z, tempActualRegion2Z) + 1;
        blockEntity.actualRegion2X = Math.min(tempActualRegion1X, tempActualRegion2X);
        blockEntity.actualRegion2Y = Math.min(tempActualRegion1Y, tempActualRegion2Y);
        blockEntity.actualRegion2Z = Math.min(tempActualRegion1Z, tempActualRegion2Z);
    }

    private static void rotationalSetRegion(Level level, BlockPos pos, BlockState state, FairkeeperChestBlockEntity blockEntity) {
        BlockPos tempRegion1;
        BlockPos actualMax = new BlockPos(Math.max(blockEntity.maxRegion.m_123341_(), blockEntity.minRegion.m_123341_()) + 1, Math.max(blockEntity.maxRegion.m_123342_(), blockEntity.minRegion.m_123342_()) + 1, Math.max(blockEntity.maxRegion.m_123343_(), blockEntity.minRegion.m_123343_()) + 1);
        BlockPos actualMin = new BlockPos(Math.min(blockEntity.maxRegion.m_123341_(), blockEntity.minRegion.m_123341_()), Math.min(blockEntity.maxRegion.m_123342_(), blockEntity.minRegion.m_123342_()), Math.min(blockEntity.maxRegion.m_123343_(), blockEntity.minRegion.m_123343_()));
        int facingDifference = FairkeeperChestBlock.getFacingInt(level, pos) - blockEntity.facing;
        BlockPos tempRegion2 = switch (facingDifference) {
            default -> {
                tempRegion1 = actualMax;
                yield actualMin;
            }
            case -3, 1 -> {
                tempRegion1 = actualMax.m_7954_(Rotation.CLOCKWISE_90).m_122029_();
                yield actualMin.m_7954_(Rotation.CLOCKWISE_90).m_122029_();
            }
            case -1, 3 -> {
                tempRegion1 = actualMax.m_7954_(Rotation.COUNTERCLOCKWISE_90).m_122019_();
                yield actualMin.m_7954_(Rotation.COUNTERCLOCKWISE_90).m_122019_();
            }
            case -2, 2 -> {
                tempRegion1 = actualMax.m_7954_(Rotation.CLOCKWISE_180).m_122029_().m_122019_();
                yield actualMin.m_7954_(Rotation.CLOCKWISE_180).m_122029_().m_122019_();
            }
        };
        int tempActualRegion1X = pos.m_123341_() + tempRegion1.m_123341_();
        int tempActualRegion1Y = pos.m_123342_() + tempRegion1.m_123342_();
        int tempActualRegion1Z = pos.m_123343_() + tempRegion1.m_123343_();
        int tempActualRegion2X = pos.m_123341_() + tempRegion2.m_123341_();
        int tempActualRegion2Y = pos.m_123342_() + tempRegion2.m_123342_();
        int tempActualRegion2Z = pos.m_123343_() + tempRegion2.m_123343_();
        blockEntity.actualRegion1X = Math.max(tempActualRegion1X, tempActualRegion2X);
        blockEntity.actualRegion1Y = Math.max(tempActualRegion1Y, tempActualRegion2Y);
        blockEntity.actualRegion1Z = Math.max(tempActualRegion1Z, tempActualRegion2Z);
        blockEntity.actualRegion2X = Math.min(tempActualRegion1X, tempActualRegion2X);
        blockEntity.actualRegion2Y = Math.min(tempActualRegion1Y, tempActualRegion2Y);
        blockEntity.actualRegion2Z = Math.min(tempActualRegion1Z, tempActualRegion2Z);
    }

    private static void updateActualRegion(Level level, BlockPos pos, BlockState state, FairkeeperChestBlockEntity blockEntity) {
        if (blockEntity.maxRegion == null) {
            blockEntity.maxRegion = new BlockPos(0, 0, 0);
        }
        if (blockEntity.minRegion == null) {
            blockEntity.minRegion = new BlockPos(0, 0, 0);
        }
        if (blockEntity.oldBlockPos == null || blockEntity.maxRegion.compareTo((Vec3i)blockEntity.minRegion) == 0) {
            FairkeeperChestBlockEntity.setMaxMinRegion(level, pos, blockEntity);
            blockEntity.oldBlockPos = pos;
            blockEntity.facing = FairkeeperChestBlock.getFacingInt(level, pos);
            return;
        }
        if (pos != blockEntity.oldBlockPos) {
            FairkeeperChestBlockEntity.rotationalSetRegion(level, pos, state, blockEntity);
            blockEntity.oldBlockPos = pos;
        }
    }

    private static void triggerSpawners(Level level, BlockPos fairkeeperChestPos, FairkeeperChestBlockEntity blockEntity) {
        blockEntity.startUpTick = 60;
        CompoundTag compoundTag = blockEntity.setCombatLootTable(blockEntity);
        FairkeeperChestBlock.setFairkeeperAlert(level, fairkeeperChestPos, Boolean.TRUE);
        BlockEntity newBlockEntity = level.m_7702_(fairkeeperChestPos);
        newBlockEntity.m_142466_(compoundTag);
        AABB aabb = new AABB((double)blockEntity.actualRegion1X, (double)blockEntity.actualRegion1Y, (double)blockEntity.actualRegion1Z, (double)blockEntity.actualRegion2X, (double)blockEntity.actualRegion2Y, (double)blockEntity.actualRegion2Z);
        List nearbyPlayers = level.m_45976_(Player.class, aabb);
        blockEntity.playerCount = nearbyPlayers.size();
        HashMap map = new HashMap();
        int chunkMinX = SectionPos.m_123171_((int)blockEntity.actualRegion2X);
        int chunkMinZ = SectionPos.m_123171_((int)blockEntity.actualRegion2Z);
        int chunkMaxX = SectionPos.m_123171_((int)blockEntity.actualRegion1X);
        int chunkMaxZ = SectionPos.m_123171_((int)blockEntity.actualRegion1Z);
        int x = 0;
        while (chunkMinX + x <= chunkMaxX) {
            int z = 0;
            while (chunkMinZ + z <= chunkMaxZ) {
                map.putAll(level.m_6325_(chunkMinX + x, chunkMinZ + z).m_62954_());
                ++z;
            }
            ++x;
        }
        Map<BlockPos, BlockEntity> filtered = map.entrySet().stream().filter(e -> {
            ScuttleStatueBlockEntity scuttleStatueBlockEntity;
            Object patt19970$temp;
            FairkeeperSpawnerBlockEntity fairkeeperSpawnerBlockEntity;
            Object patt19793$temp = e.getValue();
            return patt19793$temp instanceof FairkeeperSpawnerBlockEntity && (Boolean)(fairkeeperSpawnerBlockEntity = (FairkeeperSpawnerBlockEntity)((Object)((Object)patt19793$temp))).m_58900_().m_61143_((Property)DNLProperties.FAIRKEEPER_ALERT) == false || (patt19970$temp = e.getValue()) instanceof ScuttleStatueBlockEntity && (scuttleStatueBlockEntity = (ScuttleStatueBlockEntity)((Object)((Object)patt19970$temp))).m_58900_().m_61143_((Property)BlockStateProperties.f_61401_) == DoubleBlockHalf.LOWER || e.getValue() instanceof BallistaGolemStatueBlockEntity;
        }).filter(e -> ((BlockPos)e.getKey()).m_123341_() < blockEntity.actualRegion1X && ((BlockPos)e.getKey()).m_123341_() >= blockEntity.actualRegion2X && ((BlockPos)e.getKey()).m_123342_() < blockEntity.actualRegion1Y && ((BlockPos)e.getKey()).m_123342_() >= blockEntity.actualRegion2Y && ((BlockPos)e.getKey()).m_123343_() < blockEntity.actualRegion1Z && ((BlockPos)e.getKey()).m_123343_() >= blockEntity.actualRegion2Z).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        blockEntity.blockEntityLocationList = new ArrayList<BlockPos>(filtered.keySet());
    }

    private static void destroySpawners(Level level, FairkeeperChestBlockEntity blockEntity) {
        HashMap map = new HashMap();
        int chunkMinX = SectionPos.m_123171_((int)blockEntity.actualRegion2X);
        int chunkMinZ = SectionPos.m_123171_((int)blockEntity.actualRegion2Z);
        int chunkMaxX = SectionPos.m_123171_((int)blockEntity.actualRegion1X);
        int chunkMaxZ = SectionPos.m_123171_((int)blockEntity.actualRegion1Z);
        int x = 0;
        while (chunkMinX + x <= chunkMaxX) {
            int z = 0;
            while (chunkMinZ + z <= chunkMaxZ) {
                map.putAll(level.m_6325_(chunkMinX + x, chunkMinZ + z).m_62954_());
                ++z;
            }
            ++x;
        }
        Map<BlockPos, BlockEntity> filtered = map.entrySet().stream().filter(e -> e.getValue() instanceof FairkeeperSpawnerBlockEntity).filter(e -> ((BlockPos)e.getKey()).m_123341_() < blockEntity.actualRegion1X && ((BlockPos)e.getKey()).m_123341_() >= blockEntity.actualRegion2X && ((BlockPos)e.getKey()).m_123342_() < blockEntity.actualRegion1Y && ((BlockPos)e.getKey()).m_123342_() >= blockEntity.actualRegion2Y && ((BlockPos)e.getKey()).m_123343_() < blockEntity.actualRegion1Z && ((BlockPos)e.getKey()).m_123343_() >= blockEntity.actualRegion2Z).filter(e -> (Boolean)((BlockEntity)e.getValue()).m_58900_().m_61143_((Property)DNLProperties.FAIRKEEPER_ALERT) == false).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        filtered.forEach((blockPosEntry, blockEntityEntry) -> ((FairkeeperSpawnerBlockEntity)((Object)blockEntityEntry)).setDisabled(true));
    }

    public static void clientTick(Level level, BlockPos pos, BlockState state, FairkeeperChestBlockEntity blockEntity) {
        blockEntity.prevOpenCloseAnimationProgress = blockEntity.openCloseAnimationProgress;
        if (state.m_61143_(DNLProperties.CHEST_STATES) == ChestStates.OPENING) {
            if (blockEntity.openCloseAnimationProgress == 10) {
                FairkeeperChestBlock.setFairkeeperChest(level, pos, ChestStates.OPENED);
            } else {
                ++blockEntity.openCloseAnimationProgress;
            }
        } else if (state.m_61143_(DNLProperties.CHEST_STATES) == ChestStates.CLOSING) {
            if (blockEntity.openCloseAnimationProgress == 0) {
                FairkeeperChestBlock.setFairkeeperChest(level, pos, ChestStates.CLOSED);
            } else {
                --blockEntity.openCloseAnimationProgress;
            }
        }
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, FairkeeperChestBlockEntity blockEntity) {
        if (!blockEntity.disabled) {
            if (blockEntity.startUpTick > 0) {
                --blockEntity.startUpTick;
            } else {
                blockEntity.startUpTick = 20;
                if (level.m_45914_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), 48.0)) {
                    FairkeeperChestBlockEntity.updateActualRegion(level, pos, state, blockEntity);
                    AABB aabb = new AABB((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (double)(pos.m_123341_() + 1), (double)(pos.m_123342_() + 1), (double)pos.m_123343_()).m_82400_(48.0);
                    List nearbyPlayers = level.m_45976_(Player.class, aabb);
                    nearbyPlayers.forEach(player -> Services.DATA.addFairkeeperChestPositionList((Player)player, blockEntity.m_58899_()));
                }
                if (((Boolean)state.m_61143_((Property)DNLProperties.FAIRKEEPER_ALERT)).booleanValue()) {
                    if (blockEntity.blockEntityLocationList != null && blockEntity.blockEntityLocationList.size() == 1) {
                        blockEntity.lastSpawner = blockEntity.blockEntityLocationList.get(0);
                    }
                    FairkeeperChestBlockEntity.alertTick(level, pos, state, blockEntity);
                }
            }
            float xy = 1.0f - (float)(blockEntity.actualRegion1X - blockEntity.actualRegion2X) * (float)(blockEntity.actualRegion1Y - blockEntity.actualRegion2Y) / 1024.0f;
            float xz = 1.0f - (float)(blockEntity.actualRegion1X - blockEntity.actualRegion2X) * (float)(blockEntity.actualRegion1Z - blockEntity.actualRegion2Z) / 1024.0f;
            float yz = 1.0f - (float)(blockEntity.actualRegion1Y - blockEntity.actualRegion2Y) * (float)(blockEntity.actualRegion1Z - blockEntity.actualRegion2Z) / 1024.0f;
            double x = (float)blockEntity.actualRegion2X + (float)(blockEntity.actualRegion1X - blockEntity.actualRegion2X) * level.f_46441_.m_188501_();
            double y = (float)blockEntity.actualRegion2Y + (float)(blockEntity.actualRegion1Y - blockEntity.actualRegion2Y) * level.f_46441_.m_188501_();
            double z = (float)blockEntity.actualRegion2Z + (float)(blockEntity.actualRegion1Z - blockEntity.actualRegion2Z) * level.f_46441_.m_188501_();
            float r = level.f_46441_.m_188501_();
            if (r + 0.2f > yz) {
                ((ServerLevel)level).m_8767_((ParticleOptions)new AxisParticleType.AxisParticleData(DNLParticleTypes.FAIRKEEPER_BOUNDARY_PARTICLE.get(), 1, 270.0f), (double)((float)blockEntity.actualRegion1X + (level.f_46441_.m_188501_() - level.f_46441_.m_188501_()) * 0.1f), y, z, 1, 0.0, 0.0, 0.0, 0.0);
                ((ServerLevel)level).m_8767_((ParticleOptions)new AxisParticleType.AxisParticleData(DNLParticleTypes.FAIRKEEPER_BOUNDARY_PARTICLE.get(), 1, 90.0f), (double)((float)blockEntity.actualRegion2X + (level.f_46441_.m_188501_() - level.f_46441_.m_188501_()) * 0.1f), y, z, 1, 0.0, 0.0, 0.0, 0.0);
            }
            if (r + 0.2f > xz) {
                ((ServerLevel)level).m_8767_((ParticleOptions)new AxisParticleType.AxisParticleData(DNLParticleTypes.FAIRKEEPER_BOUNDARY_PARTICLE.get(), 0, 90.0f), x, (double)((float)blockEntity.actualRegion1Y + (level.f_46441_.m_188501_() - level.f_46441_.m_188501_()) * 0.1f), z, 1, 0.0, 0.0, 0.0, 0.0);
                ((ServerLevel)level).m_8767_((ParticleOptions)new AxisParticleType.AxisParticleData(DNLParticleTypes.FAIRKEEPER_BOUNDARY_PARTICLE.get(), 0, 270.0f), x, (double)((float)blockEntity.actualRegion2Y + (level.f_46441_.m_188501_() - level.f_46441_.m_188501_()) * 0.1f), z, 1, 0.0, 0.0, 0.0, 0.0);
            }
            if (r + 0.2f > xy) {
                ((ServerLevel)level).m_8767_((ParticleOptions)new AxisParticleType.AxisParticleData(DNLParticleTypes.FAIRKEEPER_BOUNDARY_PARTICLE.get(), 1, 180.0f), x, y, (double)((float)blockEntity.actualRegion1Z + (level.f_46441_.m_188501_() - level.f_46441_.m_188501_()) * 0.1f), 1, 0.0, 0.0, 0.0, 0.0);
                ((ServerLevel)level).m_8767_((ParticleOptions)new AxisParticleType.AxisParticleData(DNLParticleTypes.FAIRKEEPER_BOUNDARY_PARTICLE.get(), 1, 0.0f), x, y, (double)((float)blockEntity.actualRegion2Z + (level.f_46441_.m_188501_() - level.f_46441_.m_188501_()) * 0.1f), 1, 0.0, 0.0, 0.0, 0.0);
            }
        }
    }

    private static void alertTick(Level level, BlockPos pos, BlockState state, FairkeeperChestBlockEntity blockEntity) {
        if (blockEntity.blockEntityLocationList == null) {
            blockEntity.blockEntityLocationList = new ArrayList<BlockPos>();
            return;
        }
        if (blockEntity.blockEntityLocationList.isEmpty()) {
            return;
        }
        BlockPos spawnerBlockPos = blockEntity.blockEntityLocationList.get(0);
        BlockEntity alertBlockEntity = level.m_7702_(spawnerBlockPos);
        if (alertBlockEntity instanceof FairkeeperSpawnerBlockEntity) {
            FairkeeperSpawnerBlockEntity fairkeeperSpawnerBlockEntity = (FairkeeperSpawnerBlockEntity)alertBlockEntity;
            fairkeeperSpawnerBlockEntity.alert(blockEntity.playerCount == 0 ? 1 : blockEntity.playerCount, spawnerBlockPos, fairkeeperSpawnerBlockEntity);
        }
        if (alertBlockEntity instanceof ScuttleStatueBlockEntity) {
            ScuttleStatueBlockEntity scuttleStatueBlockEntity = (ScuttleStatueBlockEntity)alertBlockEntity;
            scuttleStatueBlockEntity.alert(spawnerBlockPos, scuttleStatueBlockEntity);
        }
        if (alertBlockEntity instanceof BallistaGolemStatueBlockEntity) {
            BallistaGolemStatueBlockEntity ballistaGolemStatueBlockEntity = (BallistaGolemStatueBlockEntity)alertBlockEntity;
            ballistaGolemStatueBlockEntity.alert(spawnerBlockPos, ballistaGolemStatueBlockEntity);
        }
        FairkeeperChestBlockEntity.redstoneBeam(level, pos, spawnerBlockPos);
        blockEntity.blockEntityLocationList.remove(0);
    }

    private static void redstoneBeam(Level level, BlockPos originPos, BlockPos targetPos) {
        double d = targetPos.m_123341_() - originPos.m_123341_();
        double e = targetPos.m_123342_() - originPos.m_123342_();
        double f = targetPos.m_123343_() - originPos.m_123343_();
        double s = Math.sqrt(d * d + e * e + f * f);
        d /= s;
        e /= s;
        f /= s;
        double r = level.f_46441_.m_188500_();
        while (r < s) {
            ((ServerLevel)level).m_8767_((ParticleOptions)DustParticleOptions.f_123656_, (double)originPos.m_123341_() + 0.5 + d * (r += 0.2), (double)originPos.m_123342_() + 0.5 + e * r, (double)originPos.m_123343_() + 0.5 + f * r, 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    public static boolean scanFairkeeperChestPositions(Level level, BlockPos fairkeeperChestPos, BlockPos brokenBlockPos) {
        if ((double)FairkeeperChestBlockEntity.fairkeeperChestToBrokenBlockDistance(fairkeeperChestPos, brokenBlockPos) > 48.0) {
            return false;
        }
        BlockState fairkeeperChestState = level.m_8055_(fairkeeperChestPos);
        if (!fairkeeperChestState.m_60713_(DNLBlocks.FAIRKEEPER_CHEST.get())) {
            return false;
        }
        if (((Boolean)fairkeeperChestState.m_61143_((Property)FairkeeperChestBlock.FAIRKEEPER_ALERT)).booleanValue()) {
            return false;
        }
        BlockEntity blockEntity = level.m_7702_(fairkeeperChestPos);
        if (blockEntity instanceof FairkeeperChestBlockEntity) {
            FairkeeperChestBlockEntity fairkeeperChestBlockEntity = (FairkeeperChestBlockEntity)blockEntity;
            if (fairkeeperChestBlockEntity.disabled) {
                return false;
            }
            if (fairkeeperChestBlockEntity.actualRegion1X > brokenBlockPos.m_123341_() && fairkeeperChestBlockEntity.actualRegion1Y > brokenBlockPos.m_123342_() && fairkeeperChestBlockEntity.actualRegion1Z > brokenBlockPos.m_123343_() && fairkeeperChestBlockEntity.actualRegion2X <= brokenBlockPos.m_123341_() && fairkeeperChestBlockEntity.actualRegion2Y <= brokenBlockPos.m_123342_() && fairkeeperChestBlockEntity.actualRegion2Z <= brokenBlockPos.m_123343_()) {
                fairkeeperChestBlockEntity.removeLootTable();
                FairkeeperChestBlockEntity.redstoneBeam(level, fairkeeperChestPos, brokenBlockPos);
                FairkeeperChestBlockEntity.outlineCauseBlock(level, brokenBlockPos);
                FairkeeperChestBlockEntity.playSound(level, brokenBlockPos, SoundEvents.f_12558_);
                FairkeeperChestBlockEntity.triggerSpawners(level, fairkeeperChestPos, fairkeeperChestBlockEntity);
                return false;
            }
        }
        return true;
    }

    private static void outlineCauseBlock(Level level, BlockPos blockPos) {
        double x = (double)blockPos.m_123341_() + 0.5;
        double y = (double)blockPos.m_123342_() + 0.5;
        double z = (double)blockPos.m_123343_() + 0.5;
        ((ServerLevel)level).m_8767_((ParticleOptions)new AxisParticleType.AxisParticleData(DNLParticleTypes.FAIRKEEPER_BOUNDARY_PARTICLE.get(), 1, 270.0f), (double)((float)blockPos.m_123341_() + 1.1f), y, z, 1, 0.0, 0.0, 0.0, 0.0);
        ((ServerLevel)level).m_8767_((ParticleOptions)new AxisParticleType.AxisParticleData(DNLParticleTypes.FAIRKEEPER_BOUNDARY_PARTICLE.get(), 1, 90.0f), (double)((float)blockPos.m_123341_() - 0.1f), y, z, 1, 0.0, 0.0, 0.0, 0.0);
        ((ServerLevel)level).m_8767_((ParticleOptions)new AxisParticleType.AxisParticleData(DNLParticleTypes.FAIRKEEPER_BOUNDARY_PARTICLE.get(), 0, 90.0f), x, (double)((float)blockPos.m_123342_() + 1.1f), z, 1, 0.0, 0.0, 0.0, 0.0);
        ((ServerLevel)level).m_8767_((ParticleOptions)new AxisParticleType.AxisParticleData(DNLParticleTypes.FAIRKEEPER_BOUNDARY_PARTICLE.get(), 0, 270.0f), x, (double)((float)blockPos.m_123342_() - 0.1f), z, 1, 0.0, 0.0, 0.0, 0.0);
        ((ServerLevel)level).m_8767_((ParticleOptions)new AxisParticleType.AxisParticleData(DNLParticleTypes.FAIRKEEPER_BOUNDARY_PARTICLE.get(), 1, 180.0f), x, y, (double)((float)blockPos.m_123343_() + 1.1f), 1, 0.0, 0.0, 0.0, 0.0);
        ((ServerLevel)level).m_8767_((ParticleOptions)new AxisParticleType.AxisParticleData(DNLParticleTypes.FAIRKEEPER_BOUNDARY_PARTICLE.get(), 1, 0.0f), x, y, (double)((float)blockPos.m_123343_() - 0.1f), 1, 0.0, 0.0, 0.0, 0.0);
    }

    private static float fairkeeperChestToBrokenBlockDistance(BlockPos fairkeeperChestPos, BlockPos brokenBlockPos) {
        float f = fairkeeperChestPos.m_123341_() - brokenBlockPos.m_123341_();
        float g = fairkeeperChestPos.m_123342_() - brokenBlockPos.m_123342_();
        float h = fairkeeperChestPos.m_123343_() - brokenBlockPos.m_123343_();
        return Mth.m_14116_((float)(f * f + g * g + h * h));
    }

    public float getOpenProgress(float partialTicks) {
        return ((float)this.prevOpenCloseAnimationProgress + (float)(this.openCloseAnimationProgress - this.prevOpenCloseAnimationProgress) * partialTicks) / 10.0f;
    }

    public boolean isDisabled(FairkeeperChestBlockEntity blockEntity) {
        return blockEntity.disabled;
    }
}

