/*
 * Decompiled with CFR 0.152.
 */
package dev.hexnowloading.dungeonnowloading.entity.ai;

import dev.hexnowloading.dungeonnowloading.entity.util.WeightedTargetProvider;
import dev.hexnowloading.dungeonnowloading.util.WeightedRandomBag;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.TargetGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.scores.Team;

public class BossTargetSelectorGoal
extends TargetGoal {
    private final Mob mob;
    private final WeightedTargetProvider targetProvider;
    private LivingEntity selectedTarget = null;

    public BossTargetSelectorGoal(Mob mob) {
        super(mob, false);
        WeightedTargetProvider t;
        Mob mob2 = this.mob = mob;
        this.targetProvider = mob2 instanceof WeightedTargetProvider ? (t = (WeightedTargetProvider)mob2) : null;
        this.m_7021_(EnumSet.of(Goal.Flag.TARGET));
    }

    public boolean m_8036_() {
        if (this.mob.m_5448_() == null) {
            this.findTarget();
            return this.selectedTarget != null;
        }
        return false;
    }

    public boolean m_8045_() {
        boolean withinZ;
        LivingEntity livingEntity = this.mob.m_5448_();
        if (livingEntity == null) {
            livingEntity = this.f_26137_;
        }
        if (livingEntity == null) {
            return false;
        }
        if (!this.mob.m_6779_(livingEntity)) {
            return false;
        }
        Team teamMob = this.mob.m_5647_();
        Team teamOther = livingEntity.m_5647_();
        if (teamMob != null && teamOther == teamMob) {
            return false;
        }
        int arenaSize = this.targetProvider.getArenaSize();
        BlockPos arenaCenter = this.targetProvider.getArenaCenter();
        boolean withinX = Math.abs(livingEntity.m_20185_() - (double)arenaCenter.m_123341_() + 0.5) < (double)((float)arenaSize + 0.5f);
        boolean withinY = Math.abs(livingEntity.m_20186_() - (double)arenaCenter.m_123342_() + 0.5) < (double)((float)arenaSize + 0.5f);
        boolean bl = withinZ = Math.abs(livingEntity.m_20189_() - (double)arenaCenter.m_123343_() + 0.5) < (double)((float)arenaSize + 0.5f);
        if (!(withinX && withinY && withinZ)) {
            return false;
        }
        this.mob.m_6710_(livingEntity);
        return true;
    }

    public void m_8056_() {
        if (this.selectedTarget != null) {
            this.mob.m_6710_(this.selectedTarget);
            this.f_26137_ = this.selectedTarget;
            this.selectedTarget = null;
        }
        super.m_8056_();
    }

    public static void changeTarget(WeightedTargetProvider targetProvider) {
        Mob mob = (Mob)targetProvider;
        if (mob.m_5448_() == null) {
            return;
        }
        mob.m_6710_(BossTargetSelectorGoal.weightTargets(targetProvider, mob));
    }

    private void findTarget() {
        this.selectedTarget = BossTargetSelectorGoal.weightTargets(this.targetProvider, this.mob);
    }

    /*
     * WARNING - void declaration
     */
    private static LivingEntity weightTargets(WeightedTargetProvider targetProvider, Mob mob) {
        void var8_12;
        BlockPos arenaCenter = targetProvider.getArenaCenter();
        int range = targetProvider.getArenaSize();
        AABB aabb = new AABB(arenaCenter).m_82400_((double)range);
        HashSet<UUID> seen = new HashSet<UUID>();
        ArrayList<Object> candidates = new ArrayList<Object>();
        for (Player player : mob.m_9236_().m_45976_(Player.class, aabb)) {
            if (!player.m_6084_() || !mob.m_6779_((LivingEntity)player)) continue;
            candidates.add(player);
            seen.add(player.m_20148_());
        }
        for (Map.Entry entry : targetProvider.getAttackers().entrySet()) {
            LivingEntity attacker = (LivingEntity)entry.getValue();
            if (attacker == null || !attacker.m_6084_() || !mob.m_6779_(attacker) || !seen.add((UUID)entry.getKey())) continue;
            candidates.add(attacker);
        }
        targetProvider.getThreatScoreMap().clear();
        WeightedRandomBag<LivingEntity> weightedPool = new WeightedRandomBag<LivingEntity>();
        candidates.sort(Comparator.comparingDouble(arg_0 -> ((Mob)mob).m_20280_(arg_0)));
        boolean bl = false;
        while (var8_12 < candidates.size()) {
            LivingEntity entity = (LivingEntity)candidates.get((int)var8_12);
            double distanceMultiplier = switch (var8_12) {
                case 0 -> 2.0;
                case 1 -> 1.5;
                default -> 1.0;
            };
            double damage = targetProvider.getDamageMap().getOrDefault(entity.m_20148_(), 0.0);
            int damageScore = (int)Math.floor(damage / (double)(mob.m_21233_() * 0.1f));
            int finalScore = (int)Math.floor((double)damageScore * distanceMultiplier + 1.0);
            targetProvider.getThreatScoreMap().put(entity.m_20148_(), Double.valueOf(finalScore));
            weightedPool.addEntry(entity, finalScore);
            ++var8_12;
        }
        LivingEntity livingEntity = (LivingEntity)weightedPool.getRandom();
        if (livingEntity != null) {
            // empty if block
        }
        return livingEntity;
    }
}

