/*
 * Decompiled with CFR 0.152.
 */
package dev.hexnowloading.dungeonnowloading.entity.ai;

import dev.hexnowloading.dungeonnowloading.entity.ai.StoppableGoal;
import dev.hexnowloading.dungeonnowloading.entity.boss.FairkeeperBorosEntity;
import dev.hexnowloading.dungeonnowloading.entity.boss.FairkeeperBorosPartEntity;
import dev.hexnowloading.dungeonnowloading.entity.boss.FairkeeperSerpentCallerEntity;
import dev.hexnowloading.dungeonnowloading.entity.projectile.VertexDomainProjectileEntity;
import dev.hexnowloading.dungeonnowloading.entity.projectile.VertexOrbProjectileEntity;
import java.util.Comparator;
import java.util.EnumSet;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.phys.AABB;

public class FairkeeperBorosEatVertexProjectilesGoal
extends StoppableGoal {
    private final FairkeeperBorosEntity boros;
    private final FairkeeperBorosEntity.FairkeeperBorosState state;
    private final double speed;
    private Entity targetProjectile;
    private static final int ORB_HEAL_AMOUNT = 1;
    private static final int DOMAIN_HEAL_AMOUNT = 5;

    public FairkeeperBorosEatVertexProjectilesGoal(FairkeeperBorosEntity.FairkeeperBorosState state, FairkeeperBorosEntity boros, double speed) {
        this.state = state;
        this.boros = boros;
        this.speed = speed;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean m_8036_() {
        return this.boros.isState(this.state);
    }

    @Override
    public void m_8056_() {
        this.getTargetProjectile();
    }

    public void m_8041_() {
        this.boros.stopAttacking(10);
    }

    public void m_8037_() {
        float consumeRange;
        if (this.targetProjectile == null || !this.targetProjectile.m_6084_()) {
            this.boros.stopAttacking(10);
            return;
        }
        this.boros.m_21566_().m_6849_(this.targetProjectile.m_20185_(), this.boros.m_20186_(), this.targetProjectile.m_20189_(), this.speed);
        float f = consumeRange = this.targetProjectile instanceof VertexDomainProjectileEntity ? 3.0f : 1.5f;
        if (this.boros.m_20270_(this.targetProjectile) < consumeRange) {
            this.absorbProjectile(this.targetProjectile);
        }
    }

    private void absorbProjectile(Entity projectile) {
        float maxHealth = this.boros.m_21233_();
        float healMultiplier = 1.0f;
        if (projectile instanceof VertexDomainProjectileEntity) {
            healMultiplier = 5.0f;
        }
        if (healMultiplier / 5.0f > this.boros.m_217043_().m_188501_()) {
            if (!this.boros.hasArmor()) {
                this.boros.setArmor(true);
                this.boros.setArmorHealth(150.0f);
            } else {
                FairkeeperBorosPartEntity currentPart = (FairkeeperBorosPartEntity)this.boros.getChild();
                if (currentPart != null) {
                    for (int i = 0; i < 14; ++i) {
                        if (!currentPart.hasArmor()) {
                            currentPart.setArmor(true);
                            currentPart.m_5634_(currentPart.m_21233_());
                            break;
                        }
                        if ((currentPart = (FairkeeperBorosPartEntity)currentPart.getChild()) == null) break;
                    }
                }
            }
        }
        this.boros.m_5634_(maxHealth * 0.03f * healMultiplier);
        this.boros.playHealSound(this.boros.m_20185_(), this.boros.m_20186_(), this.boros.m_20189_());
        projectile.m_142687_(Entity.RemovalReason.DISCARDED);
        int i = 0;
        while ((float)i < healMultiplier) {
            RandomSource randomSource = this.boros.m_217043_();
            double offsetX = randomSource.m_188500_() - 0.5;
            double offsetY = randomSource.m_188500_() - 0.5;
            double offsetZ = randomSource.m_188500_() - 0.5;
            ((ServerLevel)this.boros.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123750_, this.boros.m_20185_() + offsetX, this.boros.m_20186_() + 3.0 + offsetY, this.boros.m_20189_() + offsetZ, 1, 0.0, 0.0, 0.0, 0.0);
            ++i;
        }
        this.getTargetProjectile();
    }

    private void getTargetProjectile() {
        FairkeeperSerpentCallerEntity caller = this.boros.getCaller();
        if (caller == null) {
            this.stopGoal();
            return;
        }
        int halfSize = caller.getArenaSize();
        AABB arenaAABB = new AABB(caller.m_20185_() - (double)halfSize, caller.m_20186_() - (double)halfSize, caller.m_20189_() - (double)halfSize, caller.m_20185_() + (double)halfSize, caller.m_20186_() + (double)halfSize, caller.m_20189_() + (double)halfSize);
        this.targetProjectile = this.boros.m_9236_().m_6249_((Entity)null, arenaAABB, entity -> {
            VertexDomainProjectileEntity vertexDomain;
            VertexOrbProjectileEntity vertexOrb;
            return entity instanceof VertexOrbProjectileEntity && (vertexOrb = (VertexOrbProjectileEntity)((Object)entity)).getLife() > 0 && (float)vertexOrb.getLife() < 150.0f || entity instanceof VertexDomainProjectileEntity && (vertexDomain = (VertexDomainProjectileEntity)((Object)entity)).getLife() > 0 && (float)vertexDomain.getLife() < 600.0f;
        }).stream().filter(entity -> entity.m_20186_() < this.boros.m_20186_() + 3.0).min(Comparator.comparingDouble(entity -> entity.m_20280_((Entity)this.boros))).orElse(null);
        if (this.targetProjectile == null || !this.targetProjectile.m_6084_()) {
            this.stopGoal();
        }
    }
}

