/*
 * Decompiled with CFR 0.152.
 */
package dev.hexnowloading.dungeonnowloading.entity.ai;

import dev.hexnowloading.dungeonnowloading.entity.boss.FairkeeperOurosEntity;
import dev.hexnowloading.dungeonnowloading.entity.boss.FairkeeperSerpentCallerEntity;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.phys.Vec3;

public class FairkeeperOurosAwakenGoal
extends Goal {
    private final FairkeeperOurosEntity ouros;
    private Vec3 initialTarget;
    private Vec3 finalTarget;
    private boolean movingHorizontally;
    private static final double THRESHOLD = 1.0;

    public FairkeeperOurosAwakenGoal(FairkeeperOurosEntity ouros) {
        this.ouros = ouros;
        this.movingHorizontally = false;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.JUMP, Goal.Flag.TARGET));
    }

    public boolean m_8036_() {
        return this.ouros.isState(FairkeeperOurosEntity.FairkeeperOurosState.AWAKENING) && this.ouros.getCaller() != null;
    }

    public void m_8056_() {
        FairkeeperSerpentCallerEntity caller = this.ouros.getCaller();
        int verticalOffset = caller.getVerticalOffset();
        int horizontalOffset = caller.getHorizontalOffset();
        BlockPos callerPos = caller.m_20183_();
        Direction direction = caller.m_6350_();
        this.initialTarget = new BlockPos((Vec3i)callerPos.m_5484_(direction.m_122427_(), horizontalOffset).m_6630_(verticalOffset)).m_252807_().m_82520_(0.0, 0.5, 0.0);
        this.finalTarget = new BlockPos((Vec3i)callerPos.m_5484_(direction.m_122428_(), horizontalOffset).m_6630_(verticalOffset)).m_252807_().m_82520_(0.0, 0.5, 0.0);
        this.ouros.setAwakenEndPos(this.initialTarget);
        this.ouros.playMouthOpen();
        this.ouros.f_19794_ = true;
    }

    public void m_8037_() {
        if (!this.movingHorizontally) {
            double deltaY = this.ouros.m_20191_().f_82292_ - this.initialTarget.f_82480_;
            if (deltaY * deltaY < 25.0) {
                if (this.ouros.f_19794_) {
                    this.ouros.f_19794_ = false;
                }
                this.ouros.m_246865_(this.ouros.m_20154_().m_82490_((double)0.05f));
            }
            if (this.ouros.onCieling()) {
                this.movingHorizontally = true;
                this.ouros.setCanDestroyBlocks(true);
            }
        } else {
            this.ouros.m_21566_().m_6849_(this.finalTarget.f_82479_, this.ouros.m_20191_().f_82292_, this.finalTarget.f_82481_, 1.0);
            this.lookTowardTarget();
            double deltaX = this.ouros.m_20185_() - this.finalTarget.f_82479_;
            double deltaZ = this.ouros.m_20189_() - this.finalTarget.f_82481_;
            if (deltaX * deltaX + deltaZ * deltaZ < 1.0) {
                this.ouros.playMouthClose();
                this.ouros.stopAttacking(20);
            }
        }
    }

    private void lookTowardTarget() {
        double directionX = this.finalTarget.f_82479_ - this.ouros.m_20185_();
        double directionZ = this.finalTarget.f_82481_ - this.ouros.m_20189_();
        double yaw = Math.toDegrees(Math.atan2(directionZ, directionX)) - 90.0;
        this.ouros.m_146922_((float)yaw);
        this.ouros.f_20883_ = (float)yaw;
    }

    public boolean m_183429_() {
        return true;
    }
}

