/*
 * Decompiled with CFR 0.152.
 */
package dev.hexnowloading.dungeonnowloading.entity.boss;

import com.mojang.logging.LogUtils;
import dev.hexnowloading.dungeonnowloading.entity.ai.BossTargetSelectorGoal;
import dev.hexnowloading.dungeonnowloading.entity.ai.FairkeeperBorosAwakenGoal;
import dev.hexnowloading.dungeonnowloading.entity.ai.FairkeeperBorosCircleAndShootArrowGoal;
import dev.hexnowloading.dungeonnowloading.entity.ai.FairkeeperBorosCircleAroundPlayerGoal;
import dev.hexnowloading.dungeonnowloading.entity.ai.FairkeeperBorosEatVertexProjectilesGoal;
import dev.hexnowloading.dungeonnowloading.entity.ai.FairkeeperBorosFlameThrowerGoal;
import dev.hexnowloading.dungeonnowloading.entity.ai.FairkeeperBorosPursueAndShootArrowGoal;
import dev.hexnowloading.dungeonnowloading.entity.ai.FairkeeperBorosShootArrowAboveGoal;
import dev.hexnowloading.dungeonnowloading.entity.ai.FairkeeperBorosShootArrowGoal;
import dev.hexnowloading.dungeonnowloading.entity.ai.FairkeeperBorosTackleGoal;
import dev.hexnowloading.dungeonnowloading.entity.boss.FairkeeperBorosPartEntity;
import dev.hexnowloading.dungeonnowloading.entity.boss.FairkeeperSerpentCallerEntity;
import dev.hexnowloading.dungeonnowloading.entity.boss.FairkeeperSerpentEntity;
import dev.hexnowloading.dungeonnowloading.entity.projectile.VertexDomainProjectileEntity;
import dev.hexnowloading.dungeonnowloading.entity.projectile.VertexOrbProjectileEntity;
import dev.hexnowloading.dungeonnowloading.entity.util.AnimationChainer;
import dev.hexnowloading.dungeonnowloading.entity.util.Boss;
import dev.hexnowloading.dungeonnowloading.entity.util.EntityStates;
import dev.hexnowloading.dungeonnowloading.entity.util.SlumberingEntity;
import dev.hexnowloading.dungeonnowloading.entity.util.WeightedTargetProvider;
import dev.hexnowloading.dungeonnowloading.network.packets.S2CStartTickingSoundPacket;
import dev.hexnowloading.dungeonnowloading.network.packets.S2CStopTickingSoundPacket;
import dev.hexnowloading.dungeonnowloading.platform.Services;
import dev.hexnowloading.dungeonnowloading.registry.DNLEntityTypes;
import dev.hexnowloading.dungeonnowloading.registry.DNLMobEffects;
import dev.hexnowloading.dungeonnowloading.registry.DNLSounds;
import dev.hexnowloading.dungeonnowloading.registry.DNLTags;
import dev.hexnowloading.dungeonnowloading.util.DNLLevelUtil;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.BossEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class FairkeeperBorosEntity
extends Monster
implements Boss,
Enemy,
SlumberingEntity,
FairkeeperSerpentEntity,
WeightedTargetProvider {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final EntityDataAccessor<FairkeeperBorosState> STATE = SynchedEntityData.m_135353_(FairkeeperBorosEntity.class, EntityStates.FAIRKEEPER_BOROS_STATE);
    private static final EntityDataAccessor<FairkeeperBorosAnimationState> ANIMATION_STATE = SynchedEntityData.m_135353_(FairkeeperBorosEntity.class, EntityStates.FAIRKEEPER_BOROS_ANIMATION_STATE);
    private static final EntityDataAccessor<Optional<UUID>> CHILD_UUID = SynchedEntityData.m_135353_(FairkeeperBorosEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private static final EntityDataAccessor<Boolean> HAS_ARMOR = SynchedEntityData.m_135353_(FairkeeperBorosEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public final AnimationState idleAnimationState = new AnimationState();
    public final AnimationState pursueOpenMouthAnimationState = new AnimationState();
    public final AnimationState pursueOpenedMouthAnimationState = new AnimationState();
    public final AnimationState pursueCloseMouthAnimationState = new AnimationState();
    private final Deque<Vec3> positionHistory = new LinkedList<Vec3>();
    private Set<UUID> partList;
    private final Map<UUID, Double> damageMap = new HashMap<UUID, Double>();
    private final Map<UUID, LivingEntity> attackers = new HashMap<UUID, LivingEntity>();
    private final Map<UUID, Double> threatScores = new HashMap<UUID, Double>();
    private Vec3 awakenEndPos;
    private FairkeeperSerpentCallerEntity fairkeeperSerpentCaller;
    private UUID callerUUID;
    private int attackTick;
    private int destructionTick;
    private int stuckTick;
    private int slitheringSoundTick;
    private int partIndex;
    private float previousTilt = 0.0f;
    private float armorHealth;
    private boolean targetRandomPlayer;
    private boolean damageFromOtherSegment;
    private boolean canDestroyBlocks;
    private boolean changeTarget;
    private DamageSource killedDamageSource;
    private AnimationChainer<FairkeeperBorosAnimationState> animationChainer = new AnimationChainer();
    private final ServerBossEvent bossEvent;
    public static final int SEGMENT_COUNT = 14;
    public static int SEGMENT_DELAY_STEP = 13;
    public static final float SHOOT_ARROW_HEIGHT = 0.3f;
    private int mouthOpenAnimationTimeOut;
    private static final int MOUTH_OPEN_ANIMATION_DURATION = 19;
    private static final int STUCK_THRESHOLD = 100;
    private static final int SLITHERING_SOUND_INTERVAL = 140;

    public FairkeeperBorosEntity(EntityType<? extends Monster> entityType, Level level) {
        super(entityType, level);
        this.m_274367_(1.0f);
        this.m_21530_();
        this.setArmor(true);
        this.setArmorHealth(75.0f);
        this.f_21364_ = 0;
        this.bossEvent = (ServerBossEvent)new ServerBossEvent(this.m_5446_(), BossEvent.BossBarColor.PURPLE, BossEvent.BossBarOverlay.PROGRESS).m_7003_(true);
    }

    public FairkeeperBorosEntity(Level level, FairkeeperSerpentCallerEntity fairkeeperSerpentCaller) {
        this(DNLEntityTypes.FAIRKEEPER_BOROS.get(), level);
        this.fairkeeperSerpentCaller = fairkeeperSerpentCaller;
        this.callerUUID = this.fairkeeperSerpentCaller.m_20148_();
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 500.0).m_22268_(Attributes.f_22281_, 20.0).m_22268_(Attributes.f_22282_, 1.5).m_22268_(Attributes.f_22279_, 0.4).m_22268_(Attributes.f_22277_, 30.0).m_22268_(Attributes.f_22278_, 1.0);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FairkeeperBorosAwakenGoal(this));
        this.f_21345_.m_25352_(3, (Goal)new FairkeeperBorosTackleGoal(FairkeeperBorosState.TACKLE_FAST, this, 1.5, 10.0, 0.7f));
        this.f_21345_.m_25352_(3, (Goal)new FairkeeperBorosTackleGoal(FairkeeperBorosState.FLAME_TACKLE, this, 1.3, 6.0, 0.5));
        this.f_21345_.m_25352_(3, (Goal)new FairkeeperBorosFlameThrowerGoal(FairkeeperBorosState.FLAME_TACKLE, this, 40));
        this.f_21345_.m_25352_(3, (Goal)new FairkeeperBorosTackleGoal(FairkeeperBorosState.TACKLE, this, 1.3, 6.0, 0.5));
        this.f_21345_.m_25352_(3, (Goal)new FairkeeperBorosShootArrowGoal(FairkeeperBorosState.SHOOT_ARROW_LINE, this, 1.5, FairkeeperBorosShootArrowGoal.PATTERN_LINE));
        this.f_21345_.m_25352_(3, (Goal)new FairkeeperBorosShootArrowGoal(FairkeeperBorosState.SHOOT_ARROW_LINE_FAST, this, 1.7f, FairkeeperBorosShootArrowGoal.PATTERN_LINE_FAST));
        this.f_21345_.m_25352_(3, (Goal)new FairkeeperBorosCircleAndShootArrowGoal(FairkeeperBorosState.SHOOT_ARROW_SMALL_CIRCLE, this, 1.7f, FairkeeperBorosCircleAndShootArrowGoal.PATTERN_SMALL_CIRLCE));
        this.f_21345_.m_25352_(3, (Goal)new FairkeeperBorosCircleAndShootArrowGoal(FairkeeperBorosState.SHOOT_ARROW_LARGE_CIRCLE, this, 1.7f, FairkeeperBorosCircleAndShootArrowGoal.PATTERN_LARGE_CIRCLE));
        this.f_21345_.m_25352_(3, (Goal)new FairkeeperBorosPursueAndShootArrowGoal(FairkeeperBorosState.PURSUE_AND_SHOOT_TRIPLE_ARROW, this, 1.3f, 3.0, 30, FairkeeperBorosPursueAndShootArrowGoal.PATTERN_TRIPLE));
        this.f_21345_.m_25352_(3, (Goal)new FairkeeperBorosPursueAndShootArrowGoal(FairkeeperBorosState.PURSUE_AND_SHOOT_SINGLE_ARROW, this, 1.3f, 5.0, 30, FairkeeperBorosPursueAndShootArrowGoal.PATTERN_SINGLE));
        this.f_21345_.m_25352_(3, (Goal)new FairkeeperBorosShootArrowAboveGoal(FairkeeperBorosState.SHOOT_ARROW_ABOVE, this, 1.5, FairkeeperBorosShootArrowAboveGoal.PATTERN_PLAYER_LARGE_CIRCLE));
        this.f_21345_.m_25352_(3, (Goal)new FairkeeperBorosFlameThrowerGoal(FairkeeperBorosState.DESPERATE, this, 40));
        this.f_21345_.m_25352_(3, (Goal)new FairkeeperBorosPursueAndShootArrowGoal(FairkeeperBorosState.DESPERATE, this, 1.5, 2.0, 30, FairkeeperBorosPursueAndShootArrowGoal.PATTERN_DESPERATE));
        this.f_21345_.m_25352_(3, (Goal)new FairkeeperBorosEatVertexProjectilesGoal(FairkeeperBorosState.EAT_VERTEX_PROJECTILES, this, 1.5));
        this.f_21345_.m_25352_(4, (Goal)new FairkeeperBorosCircleAroundPlayerGoal(FairkeeperBorosState.IDLE, this, 20.0, 1.5, true, true));
        this.f_21345_.m_25352_(5, (Goal)new FairkeeperBorosCircleAroundPlayerGoal(FairkeeperBorosState.IDLE, this, 20.0, 1.5, true, false));
        this.f_21346_.m_25352_(2, (Goal)new BossTargetSelectorGoal((Mob)this));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(CHILD_UUID, Optional.empty());
        this.f_19804_.m_135372_(STATE, (Object)FairkeeperBorosState.IDLE);
        this.f_19804_.m_135372_(ANIMATION_STATE, (Object)FairkeeperBorosAnimationState.IDLE);
        this.f_19804_.m_135372_(HAS_ARMOR, (Object)true);
    }

    public void m_7380_(CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        if (this.getChildId() != null) {
            compoundTag.m_128362_("ChildUUID", this.getChildId());
        }
        if (this.getCallerId() != null) {
            compoundTag.m_128362_("CallerUUID", this.getCallerId());
        }
        compoundTag.m_128379_("CanDestroyBlocks", this.canDestroyBlocks);
        compoundTag.m_128379_("Awakened", !this.isState(FairkeeperBorosState.AWAKENING));
        compoundTag.m_128379_("Armor", this.hasArmor());
    }

    public void m_7378_(CompoundTag compoundTag) {
        super.m_7378_(compoundTag);
        if (this.m_8077_()) {
            this.bossEvent.m_6456_(this.m_5446_());
        }
        if (compoundTag.m_128403_("ChildUUID")) {
            this.setChildId(compoundTag.m_128342_("ChildUUID"));
        }
        if (compoundTag.m_128403_("CallerUUID")) {
            this.setCallerId(compoundTag.m_128342_("CallerUUID"));
        }
        this.setCanDestroyBlocks(compoundTag.m_128471_("CanDestroyBlocks"));
        this.setState(compoundTag.m_128471_("Awakened") ? FairkeeperBorosState.IDLE : FairkeeperBorosState.AWAKENING);
        this.setArmor(compoundTag.m_128471_("Armor"));
    }

    public void m_6593_(@Nullable Component component) {
        super.m_6593_(component);
        this.bossEvent.m_6456_(this.m_5446_());
    }

    public void m_6457_(ServerPlayer serverPlayer) {
        super.m_6457_(serverPlayer);
        this.bossEvent.m_6543_(serverPlayer);
        if (this.isSlumbering()) {
            this.disableBossBar();
        }
    }

    public void m_6452_(ServerPlayer serverPlayer) {
        super.m_6452_(serverPlayer);
        this.bossEvent.m_6539_(serverPlayer);
    }

    public void m_8119_() {
        super.m_8119_();
        this.animationControl();
    }

    private void animationControl() {
        if (this.m_9236_().f_46443_) {
            return;
        }
        this.animationChainer.tick(this::transitionTo);
    }

    public void playMouthOpenAndClose() {
        this.animationChainer.reset();
        this.animationChainer.enqueue(AnimationChainer.AnimationStep.of(FairkeeperBorosAnimationState.MOUTH_OPEN, 0.9167f, () -> this.playMouthOpenSound(this.m_20185_(), this.m_20186_(), this.m_20189_()), null));
        this.animationChainer.enqueue(AnimationChainer.AnimationStep.of(FairkeeperBorosAnimationState.MOUTH_CLOSE, 0.7083f, () -> this.playMouthCloseSound(this.m_20185_(), this.m_20186_(), this.m_20189_()), null));
        this.animationChainer.enqueue(AnimationChainer.AnimationStep.looping(FairkeeperBorosAnimationState.IDLE, 0.0f));
    }

    public void playMouthOpen() {
        this.animationChainer.reset();
        this.animationChainer.enqueue(AnimationChainer.AnimationStep.of(FairkeeperBorosAnimationState.MOUTH_OPEN, 0.9167f, () -> this.playMouthOpenSound(this.m_20185_(), this.m_20186_(), this.m_20189_()), null));
        this.animationChainer.enqueue(AnimationChainer.AnimationStep.looping(FairkeeperBorosAnimationState.MOUTH_OPENED, 0.1667f));
    }

    public void playMouthOpenForShootingArrow() {
        this.animationChainer.reset();
        this.animationChainer.enqueue(AnimationChainer.AnimationStep.of(FairkeeperBorosAnimationState.MOUTH_OPEN, 1.75f, () -> this.playMouthOpenSound(this.m_20185_(), this.m_20186_(), this.m_20189_()), () -> this.playArrowSound(this.m_20185_(), this.m_20186_(), this.m_20189_(), 3.0f)));
    }

    public void playMouthClose() {
        this.animationChainer.reset();
        this.animationChainer.enqueue(AnimationChainer.AnimationStep.of(FairkeeperBorosAnimationState.MOUTH_CLOSE, 0.7083f, () -> this.playMouthCloseSound(this.m_20185_(), this.m_20186_(), this.m_20189_()), null));
        this.animationChainer.enqueue(AnimationChainer.AnimationStep.looping(FairkeeperBorosAnimationState.IDLE, 0.0f));
    }

    private void playDeathAnimation() {
        this.animationChainer.reset();
        this.animationChainer.enqueue(AnimationChainer.AnimationStep.looping(FairkeeperBorosAnimationState.MOUTH_OPENED, 0.0f));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void segmentControl() {
        if (!this.m_9236_().f_46443_) {
            int i;
            Entity child = this.getChild();
            if (this.positionHistory.isEmpty()) {
                Vec3 currentPos = this.m_20182_();
                int requiredHistorySize = 15 * SEGMENT_DELAY_STEP;
                for (i = 0; i < requiredHistorySize; ++i) {
                    this.positionHistory.addLast(currentPos);
                }
            }
            if (child == null && !this.m_21224_()) {
                Monster partParent = this;
                int segments = 14;
                for (i = 0; i < segments; ++i) {
                    FairkeeperBorosPartEntity bodyPartParent;
                    FairkeeperBorosPartEntity part = new FairkeeperBorosPartEntity(DNLEntityTypes.FAIRKEEPER_BOROS_PART.get(), (LivingEntity)partParent, (LivingEntity)this, i);
                    if (partParent == this) {
                        this.setChildId(part.m_20148_());
                    } else if (partParent instanceof FairkeeperBorosPartEntity && !(bodyPartParent = (FairkeeperBorosPartEntity)partParent).isTail()) {
                        bodyPartParent.setChild((Entity)part);
                    }
                    part.m_6034_(partParent.m_20185_(), partParent.m_20186_(), partParent.m_20189_());
                    part.m_146922_(partParent.m_146908_());
                    part.f_20883_ = partParent.m_146908_();
                    part.f_20885_ = partParent.m_146908_();
                    part.setRotatable(false);
                    partParent = part;
                    if (i == segments - 1) {
                        part.setTail(true);
                    }
                    this.m_9236_().m_7967_((Entity)part);
                }
            }
            if (this.m_20184_().m_82556_() > 0.01) {
                Deque<Vec3> deque = this.positionHistory;
                synchronized (deque) {
                    this.positionHistory.addFirst(new Vec3(this.m_20185_(), this.m_20186_(), this.m_20189_()));
                    int maxHistorySize = 15 * SEGMENT_DELAY_STEP;
                    if (this.positionHistory.size() > maxHistorySize) {
                        this.positionHistory.pollLast();
                    }
                }
            }
            if (!this.m_20096_() && this.m_20184_().f_82480_ < 0.0) {
                this.m_20256_(this.m_20184_().m_82542_(1.0, 0.8, 1.0));
            }
            if (!this.isState(FairkeeperBorosState.AWAKENING)) {
                this.lookTowardTarget();
            }
        }
    }

    public Vec3 getSegmentTargetPosition(int segmentIndex) {
        double segmentSpacing = 4.0;
        double targetDistance = (double)segmentIndex * segmentSpacing;
        ArrayList<Vec3> history = new ArrayList<Vec3>(this.positionHistory);
        if (history.size() < 2) {
            return this.m_20182_();
        }
        Vec3 current = (Vec3)history.get(0);
        double accumulated = 0.0;
        for (int i = 1; i < history.size(); ++i) {
            Vec3 next = (Vec3)history.get(i);
            double dist = current.m_82554_(next);
            if (accumulated + dist >= targetDistance) {
                double remaining = targetDistance - accumulated;
                double t = remaining / dist;
                return current.m_165921_(next, t);
            }
            accumulated += dist;
            current = next;
        }
        return (Vec3)history.get(history.size() - 1);
    }

    private void lookTowardTarget() {
        double directionX = this.m_21566_().m_25000_() - this.m_20185_();
        double directionZ = this.m_21566_().m_25002_() - this.m_20189_();
        double yaw = Math.toDegrees(Math.atan2(directionZ, directionX)) - 90.0;
        this.m_146922_((float)yaw);
        this.f_20883_ = (float)yaw;
    }

    protected void m_8024_() {
        if (this.isState(FairkeeperBorosState.AWAKENING)) {
            this.enableBossBar();
        }
        this.segmentControl();
        this.slitheringSoundControl();
        this.findCaller();
        this.performContactDamage();
        this.abilityCooldown();
        this.stuckTracker();
        this.blockDestructionTick();
        super.m_8024_();
        this.bossEvent.m_142711_(this.m_21223_() / this.m_21233_());
    }

    private void slitheringSoundControl() {
        if (this.slitheringSoundTick-- <= 0) {
            this.playSlitheringSound();
            this.slitheringSoundTick = 140;
        }
    }

    private void findCaller() {
        if (this.fairkeeperSerpentCaller == null) {
            this.fairkeeperSerpentCaller = (FairkeeperSerpentCallerEntity)((ServerLevel)this.m_9236_()).m_8791_(this.getCallerId());
        }
    }

    private void stuckTracker() {
        boolean isStuck;
        Vec3 motion = this.m_20184_();
        boolean bl = isStuck = motion.m_82556_() < 1.0E-6;
        if (isStuck) {
            ++this.stuckTick;
        }
        if (this.stuckTick > 0 && !isStuck) {
            this.stuckTick = 0;
        }
    }

    private void performContactDamage() {
        this.m_9236_().m_6249_((Entity)this, this.m_20191_(), this::canPerformContactDamageTo).forEach(entity -> {
            entity.m_7334_((Entity)this);
            entity.m_6469_(entity.m_9236_().m_269111_().m_269333_((LivingEntity)this), this.getContactDamage());
        });
    }

    private float getContactDamage() {
        return (float)(this.m_21133_(Attributes.f_22281_) * (double)(this.isState(FairkeeperBorosState.TACKLE) ? 1.5f : 0.5f));
    }

    private boolean canPerformContactDamageTo(Entity entity) {
        if (entity instanceof FairkeeperBorosPartEntity) {
            FairkeeperBorosPartEntity part = (FairkeeperBorosPartEntity)entity;
            return !this.m_20148_().equals(part.getHeadId());
        }
        return !(entity instanceof VertexOrbProjectileEntity) && !(entity instanceof VertexDomainProjectileEntity);
    }

    private void blockDestructionTick() {
        if (!this.canDestroyBlocks) {
            return;
        }
        int DESTRUCTION_RANGE = 4;
        if (this.m_20184_().m_82556_() > 0.01) {
            return;
        }
        if (this.destructionTick-- > 0) {
            return;
        }
        this.destructionTick = 2;
        this.destroyContactBlocks(-DESTRUCTION_RANGE, DESTRUCTION_RANGE, 0, 4, -DESTRUCTION_RANGE, DESTRUCTION_RANGE);
    }

    private void destroyContactBlocks(int minX, int maxX, int minY, int maxY, int minZ, int maxZ) {
        boolean blockBroken = false;
        for (int ix = minX; ix <= maxX; ++ix) {
            for (int iz = minZ; iz <= maxZ; ++iz) {
                for (int iy = minY; iy <= maxY; ++iy) {
                    int dx = this.m_146903_() + ix;
                    int dy = this.m_146904_() + iy;
                    int dz = this.m_146907_() + iz;
                    BlockPos blockPos = new BlockPos(dx, dy, dz);
                    BlockState blockState = this.m_9236_().m_8055_(blockPos);
                    if (blockState.m_60795_() || blockState.m_204336_(BlockTags.f_13070_) || blockState.m_204336_(DNLTags.TORCH_BLOCKS)) continue;
                    blockBroken = DNLLevelUtil.destroyBlockMulti(this.m_9236_(), blockPos, false, (Entity)this, 3);
                }
            }
        }
        if (blockBroken) {
            this.m_216990_(SoundEvents.f_12442_);
        }
    }

    private void abilityCooldown() {
        if (this.fairkeeperSerpentCaller == null) {
            return;
        }
        if (!this.isState(FairkeeperBorosState.IDLE)) {
            return;
        }
        if (this.attackTick > 0) {
            --this.attackTick;
            return;
        }
        if (this.getCaller() != null) {
            this.getCaller().setBorosWaitingForCommand(true);
        }
    }

    public void stopAttacking(int cooldown) {
        this.setState(FairkeeperBorosState.IDLE);
        this.setAttackTick(cooldown);
    }

    public boolean m_6469_(DamageSource damageSource, float amount) {
        LivingEntity livingEntity;
        Entity entity;
        if (damageSource.m_7639_() instanceof FairkeeperSerpentEntity) {
            Entity entity2 = damageSource.m_7640_();
            if (entity2 instanceof AbstractArrow) {
                AbstractArrow arrow = (AbstractArrow)entity2;
                arrow.m_142687_(Entity.RemovalReason.DISCARDED);
            }
            return false;
        }
        if (!this.isDamageFromOtherSegment() && this.hasArmor() && (this.getAnimationState().equals((Object)FairkeeperBorosAnimationState.MOUTH_OPEN) || this.getAnimationState().equals((Object)FairkeeperBorosAnimationState.MOUTH_OPENED) || this.getAnimationState().equals((Object)FairkeeperBorosAnimationState.MOUTH_CLOSE))) {
            this.playHurtSound(this.m_20185_(), this.m_20186_(), this.m_20189_());
            return this.hurtAndTrackAttackers(damageSource, amount);
        }
        if (this.isDamageFromOtherSegment()) {
            this.setDamageFromOtherSegment(false);
            this.playHurtSound(this.m_20185_(), this.m_20186_(), this.m_20189_());
            return this.hurtAndTrackAttackers(damageSource, amount);
        }
        if (!this.hasArmor() || damageSource.m_19390_() || damageSource.m_269533_(DNLTags.FAIRKEEPER_BOROS_BYPASS_ARMOR)) {
            this.playHurtSound(this.m_20185_(), this.m_20186_(), this.m_20189_());
            return this.hurtAndTrackAttackers(damageSource, amount);
        }
        if (damageSource.m_269533_(DNLTags.FAIRKEEPER_BOROS_ARMOR_HURTABLE) || (entity = damageSource.m_7640_()) instanceof LivingEntity && (livingEntity = (LivingEntity)entity).m_21205_().m_41720_() instanceof PickaxeItem) {
            float nonKillableDamage;
            boolean penetratesArmor = this.getArmorHealth() - amount <= 0.0f;
            float f = nonKillableDamage = penetratesArmor ? 0.0f : amount;
            if (penetratesArmor) {
                this.setArmor(false);
                Level level = this.m_9236_();
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123813_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 1, 0.0, 0.0, 0.0, 0.0);
                }
                this.m_9236_().m_5594_(null, this.m_20183_(), SoundEvents.f_11913_, SoundSource.HOSTILE, 1.0f, 1.0f);
                return this.hurtAndTrackAttackers(damageSource, 0.0f);
            }
            this.m_9236_().m_5594_(null, this.m_20183_(), DNLSounds.FAIRKEEPER_BOROS_ARMOR_BREAK.get(), SoundSource.HOSTILE, 1.0f, 1.0f);
            this.setArmorHealth(this.getArmorHealth() - nonKillableDamage);
            return this.hurtAndTrackAttackers(damageSource, 0.0f);
        }
        if (damageSource.m_276093_(DamageTypes.f_268631_) || damageSource.m_276093_(DamageTypes.f_268468_)) {
            return false;
        }
        this.m_9236_().m_5594_(null, this.m_20183_(), DNLSounds.FAIRKEEPER_BOROS_ARMOR_HIT.get(), SoundSource.HOSTILE, 1.0f, 1.0f);
        return false;
    }

    private boolean hurtAndTrackAttackers(DamageSource source, float amount) {
        boolean result = super.m_6469_(source, amount);
        Entity attacker = source.m_7639_();
        if (attacker instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)attacker;
            this.recordDamage(livingEntity, amount);
        }
        return result;
    }

    protected void m_6153_() {
        ++this.f_20919_;
        if (this.m_9236_().f_46443_) {
            return;
        }
        if (this.f_20919_ == 1) {
            this.partIndex = 0;
            this.playDeathAnimation();
            this.stopSlitheringSound();
            this.playDeathSound(this.m_20185_(), this.m_20186_(), this.m_20189_());
            this.stopFlameShootingSound();
            for (int i = 0; i <= 13; ++i) {
                FairkeeperBorosPartEntity part = this.getPart(i);
                if (part == null) continue;
                part.m_21153_(0.0f);
            }
        }
        if (this.f_20919_ % 10 == 0) {
            if (this.partIndex <= 13) {
                FairkeeperBorosPartEntity part = this.getPart(13 - this.partIndex);
                if (part != null) {
                    this.m_9236_().m_5594_(null, part.m_20183_(), SoundEvents.f_11913_, SoundSource.BLOCKS, 4.0f, (1.0f + (this.m_9236_().f_46441_.m_188501_() - this.m_9236_().f_46441_.m_188501_()) * 0.2f) * 0.7f);
                    ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123813_, part.m_20185_(), part.m_20186_(), part.m_20189_(), 1, 0.0, 0.0, 0.0, 1.0);
                    part.m_142687_(Entity.RemovalReason.KILLED);
                }
            } else {
                FairkeeperSerpentCallerEntity caller = this.getCaller();
                if (caller != null) {
                    caller.defeatedBoros();
                }
                this.m_9236_().m_5594_(null, this.m_20183_(), SoundEvents.f_11913_, SoundSource.BLOCKS, 4.0f, (1.0f + (this.m_9236_().f_46441_.m_188501_() - this.m_9236_().f_46441_.m_188501_()) * 0.2f) * 0.7f);
                ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123813_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 1, 0.0, 0.0, 0.0, 1.0);
                this.m_9236_().m_7605_((Entity)this, (byte)60);
                this.m_142687_(Entity.RemovalReason.KILLED);
            }
            ++this.partIndex;
        }
    }

    private FairkeeperBorosPartEntity getPart(int index) {
        FairkeeperBorosPartEntity part = (FairkeeperBorosPartEntity)this.getChild();
        if (part == null) {
            return null;
        }
        for (int i = 0; i < index; ++i) {
            if ((part = (FairkeeperBorosPartEntity)part.getChild()) != null) continue;
            return null;
        }
        return part;
    }

    public void m_6667_(DamageSource damageSource) {
        FairkeeperSerpentCallerEntity caller = this.getCaller();
        if (caller != null) {
            caller.dyingBoros();
            caller.setLastDamageSource(damageSource);
            if (caller.isOurosDefeated()) {
                caller.stopAllBossMusic();
            }
        }
        super.m_6667_(damageSource);
    }

    public boolean m_7301_(MobEffectInstance mobEffectInstance) {
        MobEffect effect = mobEffectInstance.m_19544_();
        if (effect == MobEffects.f_19614_ || effect == DNLMobEffects.VERTEX_TRANSMISSION.get()) {
            return false;
        }
        return super.m_7301_(mobEffectInstance);
    }

    public void m_7350_(EntityDataAccessor<?> entityDataAccessor) {
        if (ANIMATION_STATE.equals(entityDataAccessor)) {
            FairkeeperBorosAnimationState animationState = this.getAnimationState();
            this.resetAnimations();
            switch (animationState) {
                case IDLE: {
                    this.idleAnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case MOUTH_OPEN: 
                case MOUTH_OPEN_WITHOUT_OPENED: {
                    this.pursueOpenMouthAnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case MOUTH_OPENED: {
                    this.pursueOpenedMouthAnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case MOUTH_CLOSE: {
                    this.pursueCloseMouthAnimationState.m_216982_(this.f_19797_);
                }
            }
        }
        super.m_7350_(entityDataAccessor);
    }

    private void resetAnimations() {
        this.idleAnimationState.m_216973_();
        this.pursueOpenMouthAnimationState.m_216973_();
        this.pursueOpenedMouthAnimationState.m_216973_();
        this.pursueCloseMouthAnimationState.m_216973_();
    }

    public FairkeeperBorosEntity transitionTo(FairkeeperBorosAnimationState state) {
        switch (state) {
            case IDLE: {
                this.setAnimationState(FairkeeperBorosAnimationState.IDLE);
                break;
            }
            case MOUTH_OPEN: {
                this.setAnimationState(FairkeeperBorosAnimationState.MOUTH_OPEN);
                break;
            }
            case MOUTH_OPENED: {
                this.setAnimationState(FairkeeperBorosAnimationState.MOUTH_OPENED);
                break;
            }
            case MOUTH_CLOSE: {
                this.setAnimationState(FairkeeperBorosAnimationState.MOUTH_CLOSE);
                break;
            }
            case MOUTH_OPEN_WITHOUT_OPENED: {
                this.setAnimationState(FairkeeperBorosAnimationState.MOUTH_OPEN_WITHOUT_OPENED);
            }
        }
        return this;
    }

    @Override
    public BlockPos resetRegionCenter() {
        return this.getCaller().m_20183_();
    }

    @Override
    public boolean resetCondition() {
        return false;
    }

    @Override
    public void resetBoss() {
        this.m_142687_(Entity.RemovalReason.DISCARDED);
    }

    public boolean m_7337_(Entity entity) {
        return !(entity instanceof VertexDomainProjectileEntity) && super.m_7337_(entity);
    }

    public void m_7334_(Entity entity) {
    }

    public boolean m_6094_() {
        return false;
    }

    public boolean m_6063_() {
        return false;
    }

    protected boolean m_20073_() {
        return false;
    }

    public boolean m_5830_() {
        return false;
    }

    protected void m_7840_(double $$0, boolean $$1, BlockState $$2, BlockPos $$3) {
    }

    protected int m_5639_(float $$0, float $$1) {
        return 0;
    }

    public boolean m_142535_(float v, float v1, DamageSource damageSource) {
        return false;
    }

    public void playSlitheringSound() {
        float radius = 32.0f;
        AABB detectionBox = this.m_20191_().m_82400_((double)radius);
        List nearbyPlayers = this.m_9236_().m_45976_(ServerPlayer.class, detectionBox);
        for (ServerPlayer player : nearbyPlayers) {
            Services.NETWORK.sendToPlayer(new S2CStartTickingSoundPacket(this.m_19879_(), DNLSounds.FAIRKEEPER_BOROS_SLITHER.get().m_11660_(), SoundSource.HOSTILE, 3.0f, 1.0f, false, 16.0f, 0.0f), player);
        }
    }

    public void stopSlitheringSound() {
        float radius = 32.0f;
        AABB detectionBox = this.m_20191_().m_82400_((double)radius);
        List nearbyPlayers = this.m_9236_().m_45976_(ServerPlayer.class, detectionBox);
        for (ServerPlayer player : nearbyPlayers) {
            Services.NETWORK.sendToPlayer(new S2CStopTickingSoundPacket(this.m_19879_(), DNLSounds.FAIRKEEPER_BOROS_SLITHER.get().m_11660_(), 20, false), player);
        }
    }

    public void playFlameShootingSound() {
        float radius = 32.0f;
        AABB detectionBox = this.m_20191_().m_82400_((double)radius);
        List nearbyPlayers = this.m_9236_().m_45976_(ServerPlayer.class, detectionBox);
        for (ServerPlayer player : nearbyPlayers) {
            Services.NETWORK.sendToPlayer(new S2CStartTickingSoundPacket(this.m_19879_(), DNLSounds.FAIRKEEPER_BOROS_FIRE_ATTACK.get().m_11660_(), SoundSource.HOSTILE, 3.0f, 1.0f, false, 32.0f, 0.0f), player);
        }
    }

    public void stopFlameShootingSound() {
        float radius = 32.0f;
        AABB detectionBox = this.m_20191_().m_82400_((double)radius);
        List nearbyPlayers = this.m_9236_().m_45976_(ServerPlayer.class, detectionBox);
        for (ServerPlayer player : nearbyPlayers) {
            Services.NETWORK.sendToPlayer(new S2CStopTickingSoundPacket(this.m_19879_(), DNLSounds.FAIRKEEPER_BOROS_FIRE_ATTACK.get().m_11660_(), 20, true), player);
        }
    }

    public void playMouthOpenSound(double x, double y, double z) {
        this.m_9236_().m_6263_(null, x, y, z, DNLSounds.FAIRKEEPER_MOUTH_OPEN.get(), this.m_5720_(), 3.0f, 1.0f);
    }

    public void playMouthCloseSound(double x, double y, double z) {
        this.m_9236_().m_6263_(null, x, y, z, DNLSounds.FAIRKEEPER_MOUTH_CLOSE.get(), this.m_5720_(), 3.0f, 1.0f);
    }

    public void playBeamSound(double x, double y, double z, float volume) {
        this.m_9236_().m_6263_(null, x, y, z, DNLSounds.FAIRKEEPER_BOROS_ARROW_WARNING.get(), this.m_5720_(), volume, 1.0f);
    }

    public void playArrowSound(double x, double y, double z, float volume) {
        this.m_9236_().m_6263_(null, x, y, z, DNLSounds.FAIRKEEPER_BOROS_ARROW_SHOOT.get(), this.m_5720_(), volume, 1.0f);
    }

    public void playHealSound(double x, double y, double z) {
        this.m_9236_().m_6263_(null, x, y, z, DNLSounds.FAIRKEEPER_BOROS_HEAL.get(), this.m_5720_(), 3.0f, 1.0f);
    }

    public void playDeathSound(double x, double y, double z) {
        this.m_9236_().m_6263_(null, x, y, z, DNLSounds.FAIRKEEPER_BOROS_DEATH.get(), this.m_5720_(), 3.0f, 1.0f);
    }

    public void playHurtSound(double x, double y, double z) {
        this.m_9236_().m_6263_(null, x, y, z, DNLSounds.FAIRKEEPER_BOROS_HURT.get(), this.m_5720_(), 3.0f, 1.0f);
    }

    public Entity getChild() {
        UUID id = this.getChildId();
        if (id != null && !this.m_9236_().f_46443_) {
            return ((ServerLevel)this.m_9236_()).m_8791_(id);
        }
        return null;
    }

    public FairkeeperSerpentCallerEntity getCaller() {
        return this.fairkeeperSerpentCaller;
    }

    @Override
    public BlockPos getArenaCenter() {
        FairkeeperSerpentCallerEntity entity = this.getCaller();
        return ((Entity)Objects.requireNonNullElse(entity, this)).m_20183_();
    }

    @Override
    public int getArenaSize() {
        FairkeeperSerpentCallerEntity entity = this.getCaller();
        if (entity != null) {
            return entity.getArenaSize();
        }
        return (int)this.getFollowDistance();
    }

    public boolean isStuck() {
        return this.m_20184_().m_82556_() < (double)0.01f;
    }

    public void enableBossBar() {
        this.bossEvent.m_8321_(true);
    }

    public void disableBossBar() {
        this.bossEvent.m_8321_(false);
    }

    public int getAttackTick() {
        return this.attackTick;
    }

    public void setAttackTick(int i) {
        this.attackTick = i;
    }

    public double getAttackDamage() {
        return this.m_21133_(Attributes.f_22281_);
    }

    public double getFollowDistance() {
        return this.m_21133_(Attributes.f_22277_);
    }

    public void setState(FairkeeperBorosState fairkeeperState) {
        this.f_19804_.m_135381_(STATE, (Object)fairkeeperState);
    }

    public FairkeeperBorosState getState() {
        return (FairkeeperBorosState)((Object)this.f_19804_.m_135370_(STATE));
    }

    public void setAnimationState(FairkeeperBorosAnimationState animationState) {
        this.f_19804_.m_135381_(ANIMATION_STATE, (Object)animationState);
    }

    public FairkeeperBorosAnimationState getAnimationState() {
        return (FairkeeperBorosAnimationState)((Object)this.f_19804_.m_135370_(ANIMATION_STATE));
    }

    public boolean isState(FairkeeperBorosState fairkeeperState) {
        return this.getState().equals((Object)fairkeeperState);
    }

    public UUID getChildId() {
        return ((Optional)this.f_19804_.m_135370_(CHILD_UUID)).orElse(null);
    }

    public void setChildId(@Nullable UUID uniqueId) {
        this.f_19804_.m_135381_(CHILD_UUID, Optional.ofNullable(uniqueId));
    }

    public UUID getCallerId() {
        return this.callerUUID;
    }

    public void setCallerId(@Nullable UUID uniqueId) {
        this.callerUUID = uniqueId;
    }

    public Queue<Vec3> getPositionHistory() {
        return this.positionHistory;
    }

    public float getPreviousTilt() {
        return this.previousTilt;
    }

    public void setPreviousTilt(float tilt) {
        this.previousTilt = tilt;
    }

    public Vec3 getAwakenEndPos() {
        return this.awakenEndPos;
    }

    public void setAwakenEndPos(Vec3 blockPos) {
        this.awakenEndPos = blockPos;
    }

    public boolean hasArmor() {
        return (Boolean)this.f_19804_.m_135370_(HAS_ARMOR);
    }

    public void setArmor(boolean b) {
        this.f_19804_.m_135381_(HAS_ARMOR, (Object)b);
    }

    public float getArmorHealth() {
        return this.armorHealth;
    }

    public void setArmorHealth(float f) {
        this.armorHealth = f;
    }

    public void setDamageFromOtherSegment(boolean b) {
        this.damageFromOtherSegment = b;
    }

    public boolean isDamageFromOtherSegment() {
        return this.damageFromOtherSegment;
    }

    public void setCanDestroyBlocks(boolean b) {
        this.canDestroyBlocks = b;
    }

    public boolean canDestroyBlocks() {
        return this.canDestroyBlocks;
    }

    @Override
    public boolean isStationary() {
        return false;
    }

    @Override
    public boolean isSlumbering() {
        return false;
    }

    @Override
    public Map<UUID, Double> getDamageMap() {
        return this.damageMap;
    }

    @Override
    public Map<UUID, LivingEntity> getAttackers() {
        return this.attackers;
    }

    @Override
    public Map<UUID, Double> getThreatScoreMap() {
        return this.threatScores;
    }

    public static enum FairkeeperBorosState {
        AWAKENING,
        IDLE,
        TACKLE,
        TACKLE_FAST,
        PURSUE_RANDOM,
        FLAME_TACKLE,
        SHOOT_ARROW_RANDOM,
        SHOOT_ARROW_LINE,
        SHOOT_ARROW_LINE_FAST,
        SHOOT_ARROW_SLITHER,
        SHOOT_ARROW_SMALL_CIRCLE,
        SHOOT_ARROW_LARGE_CIRCLE,
        SHOOT_ARROW_PLAYER_LARGE_CRICLE,
        PURSUE_AND_SHOOT_TRIPLE_ARROW,
        PURSUE_AND_SHOOT_SINGLE_ARROW,
        SHOOT_ARROW_ABOVE,
        EAT_VERTEX_PROJECTILES,
        EXHAUSTED,
        DESPERATE,
        DYING;

    }

    public static enum FairkeeperBorosAnimationState {
        IDLE,
        MOUTH_OPEN_WITHOUT_OPENED,
        MOUTH_OPEN,
        MOUTH_OPENED,
        MOUTH_CLOSE;

    }
}

