/*
 * Decompiled with CFR 0.152.
 */
package dev.hexnowloading.dungeonnowloading.entity.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import dev.hexnowloading.dungeonnowloading.entity.monster.HollowEntity;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class HollowModel<T extends HollowEntity>
extends HierarchicalModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(new ResourceLocation("dungeonnowloading", "hollow"), "main");
    private final ModelPart right_hand;
    private final ModelPart left_hand;
    private final ModelPart head;
    private final ModelPart root;

    public HollowModel(ModelPart root) {
        this.root = root;
        this.right_hand = root.m_171324_("right_hand");
        this.left_hand = root.m_171324_("left_hand");
        this.head = root.m_171324_("head");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition right_hand = partdefinition.m_171599_("right_hand", CubeListBuilder.m_171558_().m_171514_(40, 10).m_171488_(-10.0f, -10.0f, -5.0f, 3.0f, 4.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)4.0f, (float)24.0f, (float)-4.0f));
        PartDefinition left_hand = partdefinition.m_171599_("left_hand", CubeListBuilder.m_171558_().m_171514_(40, 0).m_171488_(-1.0f, -12.0f, -6.0f, 4.0f, 5.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)4.0f, (float)24.0f, (float)-4.0f));
        PartDefinition head = partdefinition.m_171599_("head", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)4.0f, (float)24.0f, (float)-4.0f));
        PartDefinition cube_r1 = head.m_171599_("cube_r1", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-5.0f, -6.5f, -5.0f, 10.0f, 13.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-4.0f, (float)-8.5f, (float)4.0f, (float)0.0f, (float)1.5708f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void setupAnim(HollowEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.m_142109_().m_171331_().forEach(ModelPart::m_233569_);
        this.animateIdlePose(entity, ageInTicks);
    }

    private void animateIdlePose(HollowEntity entity, float ageInTicks) {
        float f = entity.IsCharging() ? ageInTicks * 0.5f : ageInTicks * 0.1f;
        float f1 = Mth.m_14031_((float)f);
        float f2 = Mth.m_14089_((float)f);
        float f3 = Mth.m_14089_((float)(f + 1.5707964f));
        this.head.f_104201_ += 2.0f * f1;
        this.left_hand.f_104201_ += 2.0f * f2;
        this.right_hand.f_104201_ += 2.0f * f3;
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.right_hand.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.left_hand.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.head.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }

    public ModelPart m_142109_() {
        return this.root;
    }
}

