/*
 * Decompiled with CFR 0.152.
 */
package dev.hexnowloading.dungeonnowloading.entity.projectile;

import dev.hexnowloading.dungeonnowloading.entity.util.ProjectileUtils;
import dev.hexnowloading.dungeonnowloading.particle.type.ScalableParticleType;
import dev.hexnowloading.dungeonnowloading.registry.DNLEntityTypes;
import dev.hexnowloading.dungeonnowloading.registry.DNLParticleTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;

public class FlameProjectileEntity
extends ThrowableItemProjectile {
    private static final EntityDataAccessor<Float> DAMAGE = SynchedEntityData.m_135353_(FlameProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Boolean> SOUL = SynchedEntityData.m_135353_(FlameProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);

    public FlameProjectileEntity(EntityType entityType, Level level) {
        super(entityType, level);
    }

    public FlameProjectileEntity(LivingEntity owner, Level level) {
        super(DNLEntityTypes.FLAME_PROJECTILE.get(), owner, level);
        this.setDamage(0.0f);
        this.setSoul(false);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DAMAGE, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(SOUL, (Object)false);
    }

    public void m_8119_() {
        ProjectileUtils.checkAndUnloadProjectile((Entity)this);
        super.m_8119_();
        float progress = (float)this.f_19797_ / 60.0f;
        float scale = 0.4f + 1.6f * progress;
        ScalableParticleType.ScalableParticleData particleData = this.m_19749_() instanceof Player ? (this.getSoul() ? new ScalableParticleType.ScalableParticleData(DNLParticleTypes.LARGE_SOUL_FLAME_PARTICLE.get(), scale) : new ScalableParticleType.ScalableParticleData(DNLParticleTypes.LARGE_FLAME_PARTICLE.get(), scale)) : new ScalableParticleType.ScalableParticleData(DNLParticleTypes.LARGE_FLAME_PARTICLE.get(), 1.0f);
        this.m_9236_().m_6485_((ParticleOptions)particleData, true, this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.0, 0.0);
        if (this.f_19797_ > 60) {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
    }

    public void m_7822_(byte b) {
        if (b == 3) {
            for (int i = 0; i < 8; ++i) {
                ScalableParticleType.ScalableParticleData particleData = new ScalableParticleType.ScalableParticleData(DNLParticleTypes.LARGE_FLAME_PARTICLE.get(), 1.0f);
                this.m_9236_().m_6485_((ParticleOptions)particleData, true, this.m_20185_(), this.m_20186_(), this.m_20189_(), ((double)this.f_19796_.m_188501_() - 0.5) * 0.08, ((double)this.f_19796_.m_188501_() - 0.5) * 0.08, ((double)this.f_19796_.m_188501_() - 0.5) * 0.08);
            }
        }
    }

    protected void m_5790_(EntityHitResult entityHitResult) {
        super.m_5790_(entityHitResult);
        if (this.m_9236_().f_46443_) {
            return;
        }
        Entity target = entityHitResult.m_82443_();
        Entity owner = this.m_19749_();
        if (target instanceof Arrow) {
            Arrow arrow = (Arrow)target;
            arrow.m_146870_();
            return;
        }
        if (owner instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)owner;
            double damageAmount = livingEntity.m_21133_(Attributes.f_22281_);
            target.m_20254_(5);
            if (!(target instanceof LivingEntity)) {
                return;
            }
            LivingEntity targetLivingEntity = (LivingEntity)target;
            if (targetLivingEntity.m_5825_()) {
                return;
            }
            if (targetLivingEntity.m_21023_(MobEffects.f_19607_)) {
                return;
            }
            if (this.getDamage() > 0.0f && target.m_6469_(this.m_269291_().m_269299_((Entity)this, livingEntity), this.getDamage()) && target.m_6084_()) {
                this.m_19970_(livingEntity, target);
                return;
            }
            if (target.m_6469_(this.m_269291_().m_269299_((Entity)this, livingEntity), (float)damageAmount) && target.m_6084_()) {
                this.m_19970_(livingEntity, target);
            }
        }
    }

    protected void m_8060_(BlockHitResult blockHitResult) {
        super.m_8060_(blockHitResult);
        if (this.m_9236_().f_46443_) {
            return;
        }
        if (this.getSoul()) {
            return;
        }
        Entity owner = this.m_19749_();
        if (!(owner instanceof LivingEntity) || this.m_9236_().m_46469_().m_46207_(GameRules.f_46132_)) {
            BlockPos blockPos = blockHitResult.m_82425_().m_121945_(blockHitResult.m_82434_());
            if (this.m_9236_().m_46859_(blockPos)) {
                this.m_9236_().m_46597_(blockPos, BaseFireBlock.m_49245_((BlockGetter)this.m_9236_(), (BlockPos)blockPos));
            }
        }
    }

    protected void m_6532_(HitResult hitResult) {
        super.m_6532_(hitResult);
        if (!this.m_9236_().f_46443_) {
            this.m_146870_();
        }
    }

    protected Item m_7881_() {
        return Items.f_41852_;
    }

    protected float m_7139_() {
        return 0.0f;
    }

    public boolean m_6060_() {
        return false;
    }

    public void setDamage(float f) {
        this.f_19804_.m_135381_(DAMAGE, (Object)Float.valueOf(f));
    }

    public float getDamage() {
        return ((Float)this.f_19804_.m_135370_(DAMAGE)).floatValue();
    }

    public void setSoul(boolean b) {
        this.f_19804_.m_135381_(SOUL, (Object)b);
    }

    public boolean getSoul() {
        return (Boolean)this.f_19804_.m_135370_(SOUL);
    }
}

