/*
 * Decompiled with CFR 0.152.
 */
package dev.hexnowloading.dungeonnowloading.entity.util;

public class ExhaustionTracker {
    private float exhaustion = 0.0f;
    private float maxExhaustion;

    public ExhaustionTracker(float maxExhaustion) {
        this.maxExhaustion = maxExhaustion;
    }

    public void addExhaustion(float amount) {
        this.exhaustion += amount;
        this.exhaustion = Math.min(this.exhaustion, this.maxExhaustion);
    }

    public void reduceExhaustion(float amount) {
        this.exhaustion = Math.max(0.0f, this.exhaustion - amount);
    }

    public void resetExhaustion() {
        this.exhaustion = 0.0f;
    }

    public float getExhaustion() {
        return this.exhaustion;
    }

    public float getMaxExhaustion() {
        return this.maxExhaustion;
    }

    public float getExhaustionPercent() {
        return this.exhaustion / this.maxExhaustion;
    }

    public boolean isExhausted() {
        return this.exhaustion >= this.maxExhaustion;
    }

    public void setMaxExhaustion(float maxExhaustion) {
        this.maxExhaustion = maxExhaustion;
    }
}

