/*
 * Decompiled with CFR 0.152.
 */
package dev.hexnowloading.dungeonnowloading.item;

import dev.hexnowloading.dungeonnowloading.block.MendstoneChalkMarkBlock;
import dev.hexnowloading.dungeonnowloading.block.entity.MendstoneChalkMarkBlockEntity;
import dev.hexnowloading.dungeonnowloading.registry.DNLSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.DustColorTransitionOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.SupportType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import org.joml.Vector3f;

public class MendstoneChalkItem
extends Item {
    private final Block markBlock;

    public MendstoneChalkItem(Item.Properties properties, Block markBlock) {
        super(properties);
        this.markBlock = markBlock;
    }

    public InteractionResult m_6225_(UseOnContext ctx) {
        BlockState state;
        Level level = ctx.m_43725_();
        BlockPos clickedPos = ctx.m_8083_();
        BlockState clickedState = level.m_8055_(clickedPos);
        ItemStack stack = ctx.m_43722_();
        Player player = ctx.m_43723_();
        if (clickedState.m_60713_(this.markBlock)) {
            BlockEntity be;
            if (!level.f_46443_ && (be = level.m_7702_(clickedPos)) instanceof MendstoneChalkMarkBlockEntity) {
                MendstoneChalkMarkBlockEntity markBe = (MendstoneChalkMarkBlockEntity)be;
                int oldDamage = markBe.getDamage();
                if (oldDamage > 0) {
                    int newDamage = Math.max(0, oldDamage - 32);
                    markBe.setDamage(newDamage);
                    int newOutline = newDamage / 32;
                    BlockState newState = (BlockState)((BlockState)clickedState.m_61124_((Property)MendstoneChalkMarkBlock.OUTLINE, (Comparable)Integer.valueOf(newOutline))).m_61124_((Property)MendstoneChalkMarkBlock.LIT, (Comparable)Boolean.valueOf(true));
                    level.m_7731_(clickedPos, newState, 3);
                    level.m_186460_(clickedPos, (Block)((MendstoneChalkMarkBlock)this.markBlock), 20);
                    markBe.m_6596_();
                    if (level instanceof ServerLevel) {
                        ServerLevel sl = (ServerLevel)level;
                        DustColorTransitionOptions dust = new DustColorTransitionOptions(new Vector3f(0.45f, 0.8f, 1.0f), new Vector3f(0.9f, 0.95f, 1.0f), 1.0f);
                        sl.m_8767_((ParticleOptions)dust, (double)clickedPos.m_123341_() + 0.5, (double)clickedPos.m_123342_() + 0.5, (double)clickedPos.m_123343_() + 0.5, 6, 0.5, 0.5, 0.5, 0.0);
                        level.m_5594_(null, clickedPos, DNLSounds.MENDING_AURA_POP.get(), SoundSource.BLOCKS, 0.6f, 1.2f);
                    }
                    if (player instanceof ServerPlayer) {
                        ServerPlayer sp = (ServerPlayer)player;
                        sp.m_36246_(Stats.f_12982_.m_12902_((Object)this));
                    }
                    if (player != null && !player.m_150110_().f_35937_) {
                        if (stack.m_41763_()) {
                            stack.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(ctx.m_43724_()));
                        } else {
                            stack.m_41774_(1);
                        }
                    }
                } else {
                    return InteractionResult.FAIL;
                }
            }
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        BlockPlaceContext placeCtx = new BlockPlaceContext(ctx);
        BlockPos placePos = placeCtx.m_8083_();
        if (level.m_8055_(placePos).m_60713_(this.markBlock)) {
            return InteractionResult.FAIL;
        }
        if (!level.m_8055_(placePos).m_60629_(placeCtx)) {
            return InteractionResult.FAIL;
        }
        Direction[] candidates = placeCtx.m_6232_();
        Direction clickedFace = placeCtx.m_43719_();
        if (candidates.length == 0 || candidates[0] != clickedFace) {
            Direction[] withFirst = new Direction[candidates.length + 1];
            withFirst[0] = clickedFace;
            System.arraycopy(candidates, 0, withFirst, 1, candidates.length);
            candidates = withFirst;
        }
        Direction chosen = null;
        for (Direction dir : candidates) {
            BlockPos supportPos = placePos.m_121945_(dir.m_122424_());
            BlockState support = level.m_8055_(supportPos);
            if (!support.m_60659_((BlockGetter)level, supportPos, dir, SupportType.FULL)) continue;
            chosen = dir;
            break;
        }
        if (chosen == null) {
            return InteractionResult.FAIL;
        }
        boolean creative = player != null && player.m_150110_().f_35937_;
        int consume = 0;
        int startDamage = 0;
        if (!creative) {
            if (!stack.m_41763_()) {
                if (stack.m_41613_() <= 0) {
                    return InteractionResult.FAIL;
                }
                consume = 1;
            } else {
                int cur;
                int max = stack.m_41776_();
                int remaining = Math.max(0, max - (cur = stack.m_41773_()));
                if (remaining <= 0) {
                    return InteractionResult.FAIL;
                }
                if (remaining >= 5) {
                    consume = 5;
                    startDamage = 0;
                } else {
                    int deficit = 5 - remaining;
                    startDamage = deficit * 32;
                    consume = remaining;
                }
            }
        }
        if ((state = this.markBlock.m_5573_(placeCtx)) == null) {
            state = this.markBlock.m_49966_();
        }
        state = (BlockState)((BlockState)state.m_61124_((Property)MendstoneChalkMarkBlock.FACING, (Comparable)chosen)).m_61124_((Property)MendstoneChalkMarkBlock.OUTLINE, (Comparable)Integer.valueOf(startDamage / 32));
        if (!level.f_46443_) {
            if (!level.m_7731_(placePos, state, 3)) {
                return InteractionResult.FAIL;
            }
            BlockEntity be = level.m_7702_(placePos);
            if (be instanceof MendstoneChalkMarkBlockEntity) {
                MendstoneChalkMarkBlockEntity markBe = (MendstoneChalkMarkBlockEntity)be;
                markBe.setDamage(startDamage);
                markBe.m_6596_();
            }
            SoundType st = state.m_60827_();
            level.m_5594_(null, placePos, DNLSounds.MENDSTONE_CHALK_DRAW.get(), SoundSource.BLOCKS, (st.m_56773_() + 1.0f) / 2.0f, st.m_56774_() * 0.8f);
            level.m_142346_((Entity)player, GameEvent.f_157797_, placePos);
            if (player instanceof ServerPlayer) {
                ServerPlayer sp = (ServerPlayer)player;
                sp.m_36246_(Stats.f_12982_.m_12902_((Object)this));
            }
            if (!creative) {
                if (stack.m_41763_()) {
                    stack.m_41622_(consume, (LivingEntity)player, p -> p.m_21190_(ctx.m_43724_()));
                } else {
                    stack.m_41774_(1);
                }
            }
        }
        return InteractionResult.m_19078_((boolean)level.f_46443_);
    }

    public boolean m_6832_(ItemStack $$0, ItemStack $$1) {
        return false;
    }

    public boolean m_8120_(ItemStack stack) {
        return false;
    }

    public int m_6473_() {
        return 0;
    }
}

