/*
 * Decompiled with CFR 0.152.
 */
package dev.hexnowloading.dungeonnowloading.item.client;

import dev.hexnowloading.dungeonnowloading.item.DNLAnimatedItem;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class ItemAnimationState {
    private static final String ANIMATIONS_TAG = "Animations";

    public static void start(ItemStack stack, String animationName, long gameTime, long duration, boolean loop, boolean resetAnimations) {
        ItemAnimationState.ensureUUID(stack);
        if (resetAnimations) {
            ItemAnimationState.stopAll(stack);
        }
        CompoundTag tag = stack.m_41784_();
        CompoundTag animationsTag = tag.m_128469_(ANIMATIONS_TAG);
        CompoundTag animTag = new CompoundTag();
        animTag.m_128356_("StartTime", gameTime);
        animTag.m_128356_("Duration", duration);
        animTag.m_128379_("Looping", loop);
        animationsTag.m_128365_(animationName, (Tag)animTag);
        tag.m_128365_(ANIMATIONS_TAG, (Tag)animationsTag);
    }

    public static void startIfStopped(ItemStack stack, String animationName, long gameTime, long duration, boolean loop, boolean resetAnimations) {
        if (!ItemAnimationState.isAnimating(stack, animationName, gameTime)) {
            ItemAnimationState.start(stack, animationName, gameTime, duration, loop, resetAnimations);
        }
    }

    public static float getProgress(ItemStack stack, String animationName, long gameTime, float partialTicks) {
        if (!stack.m_41782_()) {
            return 0.0f;
        }
        CompoundTag animationsTag = stack.m_41783_().m_128469_(ANIMATIONS_TAG);
        if (!animationsTag.m_128441_(animationName)) {
            return 0.0f;
        }
        CompoundTag animTag = animationsTag.m_128469_(animationName);
        long startTime = animTag.m_128454_("StartTime");
        long duration = animTag.m_128454_("Duration");
        if (duration <= 0L) {
            return 0.0f;
        }
        float progress = ((float)gameTime + partialTicks - (float)startTime) / (float)duration;
        return Math.min(progress, 1.0f);
    }

    public static String getCurrentAnimation(ItemStack stack, long gameTime) {
        if (!stack.m_41782_()) {
            return null;
        }
        CompoundTag animationsTag = stack.m_41783_().m_128469_(ANIMATIONS_TAG);
        for (String key : animationsTag.m_128431_()) {
            CompoundTag animTag = animationsTag.m_128469_(key);
            long startTime = animTag.m_128454_("StartTime");
            long duration = animTag.m_128454_("Duration");
            boolean looping = animTag.m_128471_("Looping");
            if (!looping && gameTime - startTime >= duration) continue;
            return key;
        }
        return null;
    }

    public static boolean isAnimating(ItemStack stack, String animationName, long gameTime) {
        if (!stack.m_41782_()) {
            return false;
        }
        CompoundTag animationsTag = stack.m_41783_().m_128469_(ANIMATIONS_TAG);
        if (!animationsTag.m_128441_(animationName)) {
            return false;
        }
        CompoundTag animTag = animationsTag.m_128469_(animationName);
        long startTime = animTag.m_128454_("StartTime");
        long duration = animTag.m_128454_("Duration");
        boolean looping = animTag.m_128471_("Looping");
        return looping || gameTime - startTime < duration;
    }

    public static boolean isAnimatingOrHanging(ItemStack stack, String animationName, long gameTime) {
        if (!stack.m_41782_()) {
            return false;
        }
        CompoundTag animationsTag = stack.m_41783_().m_128469_(ANIMATIONS_TAG);
        if (!animationsTag.m_128441_(animationName)) {
            return false;
        }
        CompoundTag animTag = animationsTag.m_128469_(animationName);
        long startTime = animTag.m_128454_("StartTime");
        long duration = animTag.m_128454_("Duration");
        boolean looping = animTag.m_128471_("Looping");
        return looping || gameTime - startTime < duration || !looping && gameTime - startTime >= duration;
    }

    public static boolean isAnimationHanging(ItemStack stack, String animationName, long gameTime) {
        if (!stack.m_41782_()) {
            return false;
        }
        CompoundTag animationsTag = stack.m_41783_().m_128469_(ANIMATIONS_TAG);
        if (!animationsTag.m_128441_(animationName)) {
            return false;
        }
        CompoundTag animTag = animationsTag.m_128469_(animationName);
        long startTime = animTag.m_128454_("StartTime");
        long duration = animTag.m_128454_("Duration");
        boolean looping = animTag.m_128471_("Looping");
        return !looping && gameTime - startTime >= duration;
    }

    public static void stopAll(ItemStack itemStack) {
        if (!itemStack.m_41782_()) {
            return;
        }
        CompoundTag tag = itemStack.m_41783_();
        if (tag.m_128441_(ANIMATIONS_TAG)) {
            tag.m_128473_(ANIMATIONS_TAG);
        }
    }

    private static void ensureUUID(ItemStack itemStack) {
        Item item = itemStack.m_41720_();
        if (item instanceof DNLAnimatedItem) {
            DNLAnimatedItem dnlAnimatedItem = (DNLAnimatedItem)item;
            dnlAnimatedItem.ensureItemUUID(itemStack);
        }
    }
}

