/*
 * Decompiled with CFR 0.152.
 */
package dev.hexnowloading.dungeonnowloading.item.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import dev.hexnowloading.dungeonnowloading.item.ScorcherItem;
import dev.hexnowloading.dungeonnowloading.item.client.ItemAnimationState;
import dev.hexnowloading.dungeonnowloading.item.client.animation.ScorcherAnimation;
import dev.hexnowloading.dungeonnowloading.item.client.model.ScorcherModel;
import dev.hexnowloading.dungeonnowloading.network.ClientUtil;
import dev.hexnowloading.dungeonnowloading.registry.DNLItems;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;

public class ScorcherRenderer
extends BlockEntityWithoutLevelRenderer {
    private static final ResourceLocation TEXTURE_EMISSIVE_FLAME = new ResourceLocation("dungeonnowloading", "textures/item/scorcher/scorcher_emissive_flame.png");
    private static final ResourceLocation TEXTURE_EMISSIVE_SOUL_FLAME = new ResourceLocation("dungeonnowloading", "textures/item/scorcher/scorcher_emissive_soul_flame.png");
    private static final ResourceLocation TEXTURE_EMISSIVE_HEAT = new ResourceLocation("dungeonnowloading", "textures/item/scorcher/scorcher_emissive_heat.png");
    private static final RenderType RENDER_TYPE_EMISSIVE_FLAME = RenderType.m_110473_((ResourceLocation)TEXTURE_EMISSIVE_FLAME);
    private static final RenderType RENDER_TYPE_EMISSIVE_SOUL_FLAME = RenderType.m_110473_((ResourceLocation)TEXTURE_EMISSIVE_SOUL_FLAME);
    private static final RenderType RENDER_TYPE_EMISSIVE_HEAT = RenderType.m_110473_((ResourceLocation)TEXTURE_EMISSIVE_HEAT);
    private ScorcherModel model;

    public ScorcherRenderer() {
        super(ClientUtil.getClient().m_167982_(), ClientUtil.getClient().m_167973_());
    }

    public void m_108829_(ItemStack itemStack, ItemDisplayContext itemDisplayContext, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        Item item;
        poseStack.m_85836_();
        if (this.model == null) {
            this.model = new ScorcherModel(ClientUtil.getClient().m_167973_().m_171103_(ScorcherModel.LAYER_LOCATION));
        }
        poseStack.m_85837_(0.5, 1.5, 0.5);
        poseStack.m_85837_(0.0, 0.0, 0.0);
        poseStack.m_85841_(-1.0f, -1.0f, 1.0f);
        float flameAlpha = 0.0f;
        float heatAlpha = 0.0f;
        VertexConsumer vertexConsumer = bufferSource.m_6299_(this.model.m_103119_(ScorcherModel.TEXTURE));
        if (itemStack.m_150930_(DNLItems.SOUL_SCORCHER.get())) {
            vertexConsumer = bufferSource.m_6299_(this.model.m_103119_(ScorcherModel.TEXTURE_SOUL));
        }
        if ((item = itemStack.m_41720_()) instanceof ScorcherItem) {
            ScorcherItem scorcherItem = (ScorcherItem)item;
            Player player = ClientUtil.getClientPlayer();
            if (player == null) {
                return;
            }
            this.animateOutsideInventory(player, itemStack, itemDisplayContext);
            this.model.setUpAnim(scorcherItem, player, itemStack, this.getPartialTick());
            flameAlpha = this.getFlameAlpha(player, itemStack);
            heatAlpha = this.getHeat(player, itemStack);
        }
        this.model.m_7695_(poseStack, vertexConsumer, packedLight, packedOverlay, 1.0f, 1.0f, 1.0f, 1.0f);
        if (flameAlpha > 0.0f) {
            VertexConsumer emissiveFlame = bufferSource.m_6299_(RENDER_TYPE_EMISSIVE_FLAME);
            if (itemStack.m_150930_(DNLItems.SOUL_SCORCHER.get())) {
                emissiveFlame = bufferSource.m_6299_(RENDER_TYPE_EMISSIVE_SOUL_FLAME);
            }
            this.model.m_7695_(poseStack, emissiveFlame, 0xF000F0, packedOverlay, 1.0f, 1.0f, 1.0f, flameAlpha);
        }
        if (heatAlpha > 0.0f) {
            VertexConsumer emissiveHeat = bufferSource.m_6299_(RENDER_TYPE_EMISSIVE_HEAT);
            this.model.m_7695_(poseStack, emissiveHeat, 0xF000F0, packedOverlay, 1.0f, 1.0f, 1.0f, heatAlpha);
        }
        poseStack.m_85849_();
    }

    private boolean onlyRenderInHands(ItemDisplayContext itemDisplayContext) {
        return itemDisplayContext == ItemDisplayContext.FIRST_PERSON_LEFT_HAND || itemDisplayContext == ItemDisplayContext.FIRST_PERSON_RIGHT_HAND || itemDisplayContext == ItemDisplayContext.THIRD_PERSON_LEFT_HAND || itemDisplayContext == ItemDisplayContext.THIRD_PERSON_RIGHT_HAND;
    }

    private void animateOutsideInventory(Player player, ItemStack stack, ItemDisplayContext itemDisplayContext) {
        long currentGameTime;
        long storedGameTime = ScorcherItem.getTimeStamp(stack);
        if (storedGameTime == (currentGameTime = player.m_9236_().m_46467_())) {
            return;
        }
        if (itemDisplayContext != ItemDisplayContext.GROUND) {
            return;
        }
        if (!ItemAnimationState.isAnimating(stack, ScorcherItem.ScorcherAnimationState.SCORCHER_OVERHEAT.getName(), currentGameTime)) {
            if (ItemAnimationState.isAnimating(stack, ScorcherItem.ScorcherAnimationState.SCORCHER_SHOOT.getName(), currentGameTime)) {
                ItemAnimationState.start(stack, ScorcherItem.ScorcherAnimationState.SCORCHER_STOP.getName(), currentGameTime, (long)(ScorcherAnimation.SCORCHER_STOP.f_232255_() * 20.0f), false, true);
            } else if (!ItemAnimationState.isAnimating(stack, ScorcherItem.ScorcherAnimationState.SCORCHER_STOP.getName(), currentGameTime)) {
                ItemAnimationState.stopAll(stack);
            }
        }
    }

    private float getHeat(Player player, ItemStack itemStack) {
        long storedGameTime = ScorcherItem.getTimeStamp(itemStack);
        long currentGameTime = player.m_9236_().m_46467_();
        float heatLevel = ScorcherItem.getHeatLevel(itemStack);
        if (storedGameTime == currentGameTime) {
            return Math.min(heatLevel, 1.0f);
        }
        long timeElapsed = currentGameTime - storedGameTime;
        float heatDecayPerTick = 0.008333334f;
        float newHeatLevel = Math.max(0.0f, heatLevel - (float)timeElapsed * heatDecayPerTick);
        return Math.min(newHeatLevel, 1.0f);
    }

    private float getFlameAlpha(Player player, ItemStack itemStack) {
        long gameTime = player.m_9236_().m_46467_();
        float partialTick = this.getPartialTick();
        if (ItemAnimationState.isAnimatingOrHanging(itemStack, ScorcherItem.ScorcherAnimationState.SCORCHER_ACTIVATED.getName(), gameTime)) {
            return Math.min(ItemAnimationState.getProgress(itemStack, ScorcherItem.ScorcherAnimationState.SCORCHER_ACTIVATED.getName(), gameTime, this.getPartialTick()), 1.0f);
        }
        if (ItemAnimationState.isAnimatingOrHanging(itemStack, ScorcherItem.ScorcherAnimationState.SCORCHER_STOP.getName(), gameTime)) {
            return 1.0f - ItemAnimationState.getProgress(itemStack, ScorcherItem.ScorcherAnimationState.SCORCHER_STOP.getName(), gameTime, this.getPartialTick());
        }
        if (ItemAnimationState.isAnimatingOrHanging(itemStack, ScorcherItem.ScorcherAnimationState.SCORCHER_SHOOT.getName(), gameTime)) {
            return 1.0f;
        }
        if (ItemAnimationState.isAnimating(itemStack, ScorcherItem.ScorcherAnimationState.SCORCHER_OVERHEAT.getName(), gameTime)) {
            float totalOverheatDuration = 160.0f;
            float fadeStartTime = 135.0f;
            float progress = ItemAnimationState.getProgress(itemStack, ScorcherItem.ScorcherAnimationState.SCORCHER_OVERHEAT.getName(), gameTime, partialTick);
            float totalTicksElapsed = progress * totalOverheatDuration;
            if (totalTicksElapsed < fadeStartTime) {
                return 1.0f;
            }
            float fadeProgress = (totalTicksElapsed - fadeStartTime) / (totalOverheatDuration - fadeStartTime);
            return Math.max(0.0f, 1.0f - fadeProgress);
        }
        return 0.0f;
    }

    private float getPartialTick() {
        return ClientUtil.getClientLevel() != null ? ClientUtil.getClient().m_91296_() : 0.0f;
    }

    public static ScorcherRenderer getInstance() {
        return new ScorcherRenderer();
    }
}

