/*
 * Decompiled with CFR 0.152.
 */
package dev.hexnowloading.dungeonnowloading.mixin.items;

import dev.hexnowloading.dungeonnowloading.item.ScrapItem;
import dev.hexnowloading.dungeonnowloading.registry.DNLEnchantments;
import java.util.function.Consumer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ItemStack.class})
public abstract class ItemStackBreakProtectionMixin {
    @Inject(method={"hurtAndBreak"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/item/ItemStack;shrink(I)V")}, cancellable=true)
    private void dnl$convertToScrapOnBreak(int amount, LivingEntity entity, Consumer<LivingEntity> onBroken, CallbackInfo ci) {
        ItemStack self = (ItemStack)this;
        if (!self.m_41763_()) {
            return;
        }
        if (EnchantmentHelper.m_44843_((Enchantment)DNLEnchantments.BREAK_PROTECTION.get(), (ItemStack)self) <= 0) {
            return;
        }
        if (entity != null && onBroken != null) {
            onBroken.accept(entity);
        }
        ItemStack scrap = ScrapItem.ofOriginal(self.m_41777_());
        boolean replaced = false;
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (player.m_21205_() == self) {
                player.m_21008_(InteractionHand.MAIN_HAND, scrap);
                replaced = true;
            } else if (player.m_21206_() == self) {
                player.m_21008_(InteractionHand.OFF_HAND, scrap);
                replaced = true;
            } else {
                for (EquipmentSlot slot : EquipmentSlot.values()) {
                    if (player.m_6844_(slot) != self) continue;
                    player.m_8061_(slot, scrap);
                    replaced = true;
                    break;
                }
            }
            if (!replaced && !player.m_150109_().m_36054_(scrap)) {
                player.m_36176_(scrap, false);
            }
        } else if (entity != null) {
            entity.m_19983_(scrap);
        }
        self.m_41764_(0);
        ci.cancel();
    }
}

