/*
 * Decompiled with CFR 0.152.
 */
package dev.hexnowloading.dungeonnowloading.network.packets;

import dev.hexnowloading.dungeonnowloading.network.ClientUtil;
import dev.hexnowloading.dungeonnowloading.network.DNLPacket;
import dev.hexnowloading.dungeonnowloading.sound.DNLClientSoundHandler;
import dev.hexnowloading.dungeonnowloading.sound.TickingSoundTarget;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;

public class S2CStopTickingSoundPacket
implements DNLPacket {
    private final int entityId;
    private final ResourceLocation soundId;
    private final TickingSoundTarget target;
    private final int tagId;
    private final int fadeTicks;
    private final boolean shouldStop;

    public S2CStopTickingSoundPacket(int entityId, ResourceLocation soundId, int fadeTicks, boolean shouldStop) {
        this(entityId, soundId, TickingSoundTarget.OLDEST, -1, fadeTicks, shouldStop);
    }

    public S2CStopTickingSoundPacket(int entityId, ResourceLocation soundId, TickingSoundTarget target, int fadeTicks, boolean shouldStop) {
        this(entityId, soundId, target, -1, fadeTicks, shouldStop);
    }

    public S2CStopTickingSoundPacket(int entityId, ResourceLocation soundId, int tagId, int fadeTicks, boolean shouldStop) {
        this(entityId, soundId, TickingSoundTarget.SPECIFIC, tagId, fadeTicks, shouldStop);
    }

    public S2CStopTickingSoundPacket(int entityId, ResourceLocation soundId, TickingSoundTarget target, int tagId, int fadeTicks, boolean shouldStop) {
        this.entityId = entityId;
        this.soundId = soundId;
        this.target = target;
        this.tagId = tagId;
        this.fadeTicks = fadeTicks;
        this.shouldStop = shouldStop;
    }

    public S2CStopTickingSoundPacket(FriendlyByteBuf buf) {
        this.entityId = buf.m_130242_();
        this.soundId = buf.m_130281_();
        this.target = (TickingSoundTarget)buf.m_130066_(TickingSoundTarget.class);
        this.tagId = buf.m_130242_();
        this.fadeTicks = buf.m_130242_();
        this.shouldStop = buf.readBoolean();
    }

    @Override
    public void encode(FriendlyByteBuf buf) {
        buf.m_130130_(this.entityId);
        buf.m_130085_(this.soundId);
        buf.m_130068_((Enum)this.target);
        buf.m_130130_(this.tagId);
        buf.m_130130_(this.fadeTicks);
        buf.writeBoolean(this.shouldStop);
    }

    public static S2CStopTickingSoundPacket decode(FriendlyByteBuf buf) {
        return new S2CStopTickingSoundPacket(buf);
    }

    @Override
    public void handle(@Nullable ServerPlayer sender) {
        if (sender != null) {
            return;
        }
        if (ClientUtil.onClient()) {
            DNLClientSoundHandler.fadeOutTickingSound(this.soundId, this.entityId, this.target, this.tagId, this.fadeTicks, this.shouldStop);
        }
    }
}

