/*
 * Decompiled with CFR 0.152.
 */
package dev.hexnowloading.dungeonnowloading.particle.type;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Locale;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;

public class ScalableAxisParticleType
extends ParticleType<ScalableAxisParticleData> {
    public static final Codec<ScalableAxisParticleData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("particle_type").forGetter(data -> BuiltInRegistries.f_257034_.m_7981_(data.particleType).toString()), (App)Codec.INT.fieldOf("axis").forGetter(data -> data.axis), (App)Codec.FLOAT.fieldOf("degree").forGetter(data -> Float.valueOf(data.degree)), (App)Codec.FLOAT.fieldOf("scale").forGetter(data -> Float.valueOf(data.scale))).apply((Applicative)instance, (type, axis, degree, scale) -> new ScalableAxisParticleData((ParticleType<ScalableAxisParticleData>)((ParticleType)BuiltInRegistries.f_257034_.m_7745_(new ResourceLocation(type))), (int)axis, degree.floatValue(), scale.floatValue())));

    public ScalableAxisParticleType(boolean alwaysShow) {
        super(alwaysShow, ScalableAxisParticleData.DESERIALIZER);
    }

    public Codec<ScalableAxisParticleData> m_7652_() {
        return CODEC;
    }

    public static class ScalableAxisParticleData
    implements ParticleOptions {
        public static final ParticleOptions.Deserializer<ScalableAxisParticleData> DESERIALIZER = new ParticleOptions.Deserializer<ScalableAxisParticleData>(){

            public ScalableAxisParticleData fromCommand(ParticleType<ScalableAxisParticleData> particleType, StringReader reader) throws CommandSyntaxException {
                reader.expect(' ');
                int axis = reader.readInt();
                reader.expect(' ');
                float degree = reader.readFloat();
                reader.expect(' ');
                float scale = reader.readFloat();
                return new ScalableAxisParticleData(particleType, axis, degree, scale);
            }

            public ScalableAxisParticleData fromNetwork(ParticleType<ScalableAxisParticleData> particleType, FriendlyByteBuf buffer) {
                return new ScalableAxisParticleData(particleType, buffer.readInt(), buffer.readFloat(), buffer.readFloat());
            }
        };
        private final ParticleType<ScalableAxisParticleData> particleType;
        private final int axis;
        private final float degree;
        private final float scale;

        public ScalableAxisParticleData(ParticleType<ScalableAxisParticleData> particleType, int axis, float degree, float scale) {
            this.particleType = particleType;
            this.axis = axis;
            this.degree = degree;
            this.scale = scale;
        }

        public String m_5942_() {
            return String.format(Locale.ROOT, "%s", BuiltInRegistries.f_257034_.m_7981_(this.m_6012_()));
        }

        public void m_7711_(FriendlyByteBuf buffer) {
            buffer.writeInt(this.axis);
            buffer.writeFloat(this.degree);
            buffer.writeFloat(this.scale);
        }

        public ParticleType<?> m_6012_() {
            return this.particleType;
        }

        public int getAxis() {
            return this.axis;
        }

        public float getDegree() {
            return this.degree;
        }

        public float getScale() {
            return this.scale;
        }
    }
}

