/*
 * Decompiled with CFR 0.152.
 */
package dev.hexnowloading.dungeonnowloading.particle.type;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Locale;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;

public class ScalableParticleType
extends ParticleType<ScalableParticleData> {
    public static final Codec<ScalableParticleData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("particle_type").forGetter(data -> BuiltInRegistries.f_257034_.m_7981_(data.particleType).toString()), (App)Codec.FLOAT.fieldOf("scale").forGetter(data -> Float.valueOf(data.scale))).apply((Applicative)instance, (type, scale) -> new ScalableParticleData((ParticleType<ScalableParticleData>)((ParticleType)BuiltInRegistries.f_257034_.m_7745_(new ResourceLocation(type))), scale.floatValue())));

    public ScalableParticleType(boolean alwaysShow) {
        super(alwaysShow, ScalableParticleData.DESERIALIZER);
    }

    public Codec<ScalableParticleData> m_7652_() {
        return CODEC;
    }

    public static class ScalableParticleData
    implements ParticleOptions {
        public static final ParticleOptions.Deserializer<ScalableParticleData> DESERIALIZER = new ParticleOptions.Deserializer<ScalableParticleData>(){

            public ScalableParticleData fromCommand(ParticleType<ScalableParticleData> particleType, StringReader reader) throws CommandSyntaxException {
                reader.expect(' ');
                float scale = reader.readFloat();
                return new ScalableParticleData(particleType, scale);
            }

            public ScalableParticleData fromNetwork(ParticleType<ScalableParticleData> particleType, FriendlyByteBuf buffer) {
                return new ScalableParticleData(particleType, buffer.readFloat());
            }
        };
        private final ParticleType<ScalableParticleData> particleType;
        private final float scale;

        public ScalableParticleData(ParticleType<ScalableParticleData> particleType, float scale) {
            this.particleType = particleType;
            this.scale = scale;
        }

        public String m_5942_() {
            return String.format(Locale.ROOT, "%s", BuiltInRegistries.f_257034_.m_7981_(this.m_6012_()));
        }

        public void m_7711_(FriendlyByteBuf buffer) {
            buffer.writeFloat(this.scale);
        }

        public ParticleType<?> m_6012_() {
            return this.particleType;
        }

        public float getScale() {
            return this.scale;
        }
    }
}

