/*
 * Decompiled with CFR 0.152.
 */
package dev.hexnowloading.dungeonnowloading.platform;

import dev.hexnowloading.dungeonnowloading.platform.services.RegistryHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.SoundType;
import net.minecraftforge.common.util.ForgeSoundType;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryObject;

public class ForgeCommonRegistryHelper
implements RegistryHelper {
    public static final DeferredRegister<CreativeModeTab> TAB_REGISTRY = DeferredRegister.create((ResourceKey)Registries.f_279569_, (String)"dungeonnowloading");
    private static final RegistryMap registryMap = new RegistryMap();
    public static final List<SimpleJsonResourceReloadListener> dataLoaders = new ArrayList<SimpleJsonResourceReloadListener>();

    @Override
    public <T> Supplier<T> register(Registry<? super T> registry, String name, Supplier<T> entry) {
        return registryMap.register(registry, name, entry);
    }

    @Override
    public void register(ResourceLocation id, SimpleJsonResourceReloadListener loader) {
        dataLoaders.add(loader);
    }

    @Override
    public SoundType getSoundType(float volume, float pitch, Supplier<SoundEvent> breakSound, Supplier<SoundEvent> stepSound, Supplier<SoundEvent> placeSound, Supplier<SoundEvent> hitSound, Supplier<SoundEvent> fallSound) {
        return new ForgeSoundType(volume, pitch, breakSound, stepSound, placeSound, hitSound, fallSound);
    }

    @Override
    public Supplier<CreativeModeTab> registerCreativeTab(String name, Supplier<ItemStack> iconSupplier, CreativeModeTab.DisplayItemsGenerator itemGenerator) {
        return TAB_REGISTRY.register(name, () -> CreativeModeTab.builder().m_257941_((Component)Component.m_237115_((String)("tab.dungeonnowloading." + name))).m_257737_(iconSupplier).m_257501_(itemGenerator).m_257652_());
    }

    public static RegistryMap getRegistryMap() {
        return registryMap;
    }

    public static class RegistryMap {
        private final Map<ResourceLocation, DeferredRegister<?>> registries = new HashMap();

        private <T> RegistryObject<T> register(Registry<? super T> registry, String name, Supplier<T> entry) {
            DeferredRegister<? super T> reg = this.getDeferred(registry);
            return reg != null ? reg.register(name, entry) : null;
        }

        public <T> DeferredRegister<T> getDeferred(Registry<? super T> registry) {
            return this.registries.computeIfAbsent(registry.m_123023_().m_135782_(), key -> {
                DeferredRegister defReg = DeferredRegister.create((ResourceLocation)registry.m_123023_().m_135782_(), (String)"dungeonnowloading");
                defReg.register(FMLJavaModLoadingContext.get().getModEventBus());
                return defReg;
            });
        }
    }
}

