/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.mods;

import com.mojang.blaze3d.platform.InputConstants;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.dimension.DimensionType;
import xaero.common.IXaeroMinimap;
import xaero.common.XaeroMinimapSession;
import xaero.common.core.XaeroMinimapCore;
import xaero.common.effect.Effects;
import xaero.common.gui.GuiAddWaypoint;
import xaero.common.gui.GuiWaypoints;
import xaero.common.gui.GuiWorldTpCommand;
import xaero.common.minimap.highlight.DimensionHighlighterHandler;
import xaero.common.minimap.render.radar.element.RadarRenderer;
import xaero.common.minimap.waypoints.WaypointSet;
import xaero.common.minimap.waypoints.WaypointWorld;
import xaero.common.minimap.waypoints.WaypointWorldRootContainer;
import xaero.common.minimap.waypoints.WaypointsManager;
import xaero.common.misc.Misc;
import xaero.common.mods.SupportXaeroWorldmap;
import xaero.common.settings.ModSettings;
import xaero.map.WorldMap;
import xaero.map.element.HoveredMapElementHolder;
import xaero.map.gui.GuiMap;
import xaero.map.misc.KeySortableByOther;
import xaero.map.mods.gui.Waypoint;
import xaero.map.mods.gui.WaypointMenuRenderContext;
import xaero.map.mods.gui.WaypointMenuRenderProvider;
import xaero.map.mods.gui.WaypointMenuRenderer;
import xaero.map.mods.gui.WaypointRenderer;
import xaero.map.mods.minimap.element.RadarRendererWrapperHelper;
import xaero.map.mods.minimap.tracker.system.MinimapSyncedPlayerTrackerSystem;
import xaero.map.radar.tracker.system.IPlayerTrackerSystem;
import xaero.map.world.MapDimension;
import xaero.map.world.MapWorld;

public class SupportXaeroMinimap {
    IXaeroMinimap modMain;
    public int compatibilityVersion;
    private boolean deathpoints = true;
    private boolean refreshWaypoints = true;
    private WaypointWorld waypointWorld;
    private WaypointWorld mapWaypointWorld;
    private ResourceKey<Level> mapDimId;
    private double dimDiv;
    private WaypointSet waypointSet;
    private boolean allSets;
    private ArrayList<Waypoint> waypoints;
    private ArrayList<Waypoint> waypointsSorted;
    private WaypointMenuRenderer waypointMenuRenderer;
    private final WaypointRenderer waypointRenderer;
    private IPlayerTrackerSystem<?> minimapSyncedPlayerTrackerSystem;
    private WaypointWorld mouseBlockWaypointWorld;
    private WaypointWorld rightClickWaypointWorld;

    public SupportXaeroMinimap() {
        try {
            Class<?> mmClassTest = Class.forName("xaero.pvp.BetterPVP");
            this.modMain = XaeroMinimapCore.modMain;
            WorldMap.LOGGER.info("Xaero's WorldMap Mod: Better PVP found!");
        }
        catch (ClassNotFoundException e) {
            try {
                Class<?> mmClassTest = Class.forName("xaero.minimap.XaeroMinimap");
                this.modMain = XaeroMinimapCore.modMain;
                WorldMap.LOGGER.info("Xaero's WorldMap Mod: Xaero's minimap found!");
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (this.modMain != null) {
            try {
                this.compatibilityVersion = SupportXaeroWorldmap.WORLDMAP_COMPATIBILITY_VERSION;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            if (this.compatibilityVersion < 3) {
                throw new RuntimeException("Xaero's Minimap 20.23.0 or newer required!");
            }
        }
        this.waypointRenderer = WaypointRenderer.Builder.begin().setMinimap(this).setSymbolCreator(WorldMap.waypointSymbolCreator).build();
    }

    public void register() {
        if (this.hasTrackedPlayerSystemSupport()) {
            WorldMap.playerTrackerSystemManager.register("minimap_synced", this.getMinimapSyncedPlayerTrackerSystem());
        }
    }

    public ArrayList<Waypoint> convertWaypoints(double dimDiv) {
        if (this.waypointSet == null) {
            return null;
        }
        ArrayList<Waypoint> result = new ArrayList<Waypoint>();
        if (!this.allSets) {
            this.convertSet(this.waypointSet, result, dimDiv);
        } else {
            HashMap sets = this.waypointWorld.getSets();
            for (WaypointSet set : sets.values()) {
                this.convertSet(set, result, dimDiv);
            }
        }
        this.deathpoints = this.modMain.getSettings().getDeathpoints();
        return result;
    }

    private void convertSet(WaypointSet set, ArrayList<Waypoint> result, double dimDiv) {
        ArrayList list = set.getList();
        String setName = set.getName();
        boolean showingDisabled = WorldMap.settings.showDisabledWaypoints;
        for (int i = 0; i < list.size(); ++i) {
            xaero.common.minimap.waypoints.Waypoint w = (xaero.common.minimap.waypoints.Waypoint)list.get(i);
            if (!showingDisabled && w.isDisabled()) continue;
            result.add(this.convertWaypoint(w, true, setName, dimDiv));
        }
    }

    public Waypoint convertWaypoint(xaero.common.minimap.waypoints.Waypoint w, boolean editable, String setName, double dimDiv) {
        int waypointType = w.getWaypointType();
        Waypoint converted = new Waypoint(w, w.getX(), w.getY(), w.getZ(), w.getName(), w.getSymbol(), ModSettings.COLORS[w.getColor()], waypointType, editable, setName, w.isYIncluded(), dimDiv);
        converted.setDisabled(w.isDisabled());
        converted.setYaw(w.getYaw());
        converted.setRotation(w.isRotation());
        converted.setTemporary(w.isTemporary());
        converted.setGlobal(w.isGlobal());
        return converted;
    }

    public void openWaypoint(GuiMap parent, Waypoint waypoint) {
        if (!waypoint.isEditable()) {
            return;
        }
        XaeroMinimapSession minimapSession = XaeroMinimapSession.getCurrentSession();
        GuiAddWaypoint addScreen = new GuiAddWaypoint(this.modMain, minimapSession.getWaypointsManager(), (Screen)parent, (Screen)parent, (xaero.common.minimap.waypoints.Waypoint)waypoint.getOriginal(), this.waypointWorld.getContainer().getRootContainer().getKey(), this.waypointWorld, waypoint.getSetName());
        Minecraft.m_91087_().m_91152_((Screen)addScreen);
    }

    public void createWaypoint(GuiMap parent, int x, int y, int z, double coordDimensionScale, boolean rightClick) {
        GuiAddWaypoint addScreen;
        WaypointWorld coordSourceWaypointWorld;
        if (this.waypointWorld == null) {
            return;
        }
        XaeroMinimapSession minimapSession = XaeroMinimapSession.getCurrentSession();
        WaypointsManager waypointsManager = minimapSession.getWaypointsManager();
        WaypointWorld waypointWorld = coordSourceWaypointWorld = rightClick ? this.rightClickWaypointWorld : this.mouseBlockWaypointWorld;
        if (this.hasDimSwitchSupport()) {
            addScreen = new GuiAddWaypoint(this.modMain, minimapSession.getWaypointsManager(), (Screen)parent, (Screen)parent, null, this.waypointWorld.getContainer().getRootContainer().getKey(), this.waypointWorld, this.waypointWorld.getCurrent(), true, x, y, z, coordDimensionScale, coordSourceWaypointWorld);
        } else {
            int legacyX = x;
            int legacyY = y;
            int legacyZ = z;
            if (coordDimensionScale != Minecraft.m_91087_().f_91073_.m_6042_().f_63859_()) {
                double legacyDimDiv = Minecraft.m_91087_().f_91073_.m_6042_().f_63859_() / coordDimensionScale;
                legacyX = (int)Math.floor((double)legacyX / legacyDimDiv);
                legacyZ = (int)Math.floor((double)legacyZ / legacyDimDiv);
            }
            if (coordSourceWaypointWorld != this.waypointWorld) {
                legacyY = Short.MAX_VALUE;
            }
            addScreen = new GuiAddWaypoint(this.modMain, minimapSession.getWaypointsManager(), (Screen)parent, (Screen)parent, null, this.waypointWorld.getContainer().getRootContainer().getKey(), this.waypointWorld, this.waypointWorld.getCurrent(), true, legacyX, legacyY, legacyZ);
        }
        Minecraft.m_91087_().m_91152_((Screen)addScreen);
    }

    public void createTempWaypoint(int x, int y, int z, double mapDimensionScale, boolean rightClick) {
        WaypointWorld coordSourceWaypointWorld;
        if (this.waypointWorld == null) {
            return;
        }
        XaeroMinimapSession minimapSession = XaeroMinimapSession.getCurrentSession();
        WaypointsManager waypointsManager = minimapSession.getWaypointsManager();
        WaypointWorld waypointWorld = coordSourceWaypointWorld = rightClick ? this.rightClickWaypointWorld : this.mouseBlockWaypointWorld;
        if (this.hasDimSwitchSupport()) {
            waypointsManager.createTemporaryWaypoints(this.waypointWorld, x, y, z, y != Short.MAX_VALUE && coordSourceWaypointWorld == this.waypointWorld, mapDimensionScale);
        } else {
            int legacyX = x;
            int legacyY = y;
            int legacyZ = z;
            if (mapDimensionScale != Minecraft.m_91087_().f_91073_.m_6042_().f_63859_()) {
                double legacyDimDiv = Minecraft.m_91087_().f_91073_.m_6042_().f_63859_() / mapDimensionScale;
                legacyX = (int)Math.floor((double)legacyX / legacyDimDiv);
                legacyZ = (int)Math.floor((double)legacyZ / legacyDimDiv);
            }
            if (coordSourceWaypointWorld != this.waypointWorld) {
                legacyY = Short.MAX_VALUE;
            }
            if (legacyY == Short.MAX_VALUE) {
                waypointsManager.createTemporaryWaypoints(this.waypointWorld, legacyX, legacyY, legacyZ, false);
            } else {
                waypointsManager.createTemporaryWaypoints(this.waypointWorld, legacyX, legacyY, legacyZ);
            }
        }
        this.requestWaypointsRefresh();
    }

    public boolean canTeleport(WaypointWorld world) {
        XaeroMinimapSession minimapSession = XaeroMinimapSession.getCurrentSession();
        WaypointsManager waypointsManager = minimapSession.getWaypointsManager();
        return world != null && waypointsManager.canTeleport(waypointsManager.isWorldTeleportable(world), world);
    }

    public void teleportToWaypoint(Screen screen, Waypoint w) {
        this.teleportToWaypoint(screen, w, this.waypointWorld);
    }

    public void teleportToWaypoint(Screen screen, Waypoint w, WaypointWorld world) {
        if (world == null) {
            return;
        }
        XaeroMinimapSession minimapSession = XaeroMinimapSession.getCurrentSession();
        WaypointsManager waypointsManager = minimapSession.getWaypointsManager();
        waypointsManager.teleportToWaypoint((xaero.common.minimap.waypoints.Waypoint)w.getOriginal(), world, screen);
    }

    public void disableWaypoint(Waypoint waypoint) {
        ((xaero.common.minimap.waypoints.Waypoint)waypoint.getOriginal()).setDisabled(!((xaero.common.minimap.waypoints.Waypoint)waypoint.getOriginal()).isDisabled());
        try {
            this.modMain.getSettings().saveWaypoints(this.waypointWorld);
        }
        catch (IOException e) {
            WorldMap.LOGGER.error("suppressed exception", (Throwable)e);
        }
        waypoint.setDisabled(((xaero.common.minimap.waypoints.Waypoint)waypoint.getOriginal()).isDisabled());
        waypoint.setTemporary(((xaero.common.minimap.waypoints.Waypoint)waypoint.getOriginal()).isTemporary());
    }

    public void deleteWaypoint(Waypoint waypoint) {
        if (!this.allSets) {
            this.waypointSet.getList().remove((xaero.common.minimap.waypoints.Waypoint)waypoint.getOriginal());
        } else {
            WaypointSet set;
            HashMap sets = this.waypointWorld.getSets();
            Iterator iterator = sets.values().iterator();
            while (iterator.hasNext() && !(set = (WaypointSet)iterator.next()).getList().remove((xaero.common.minimap.waypoints.Waypoint)waypoint.getOriginal())) {
            }
        }
        try {
            this.modMain.getSettings().saveWaypoints(this.waypointWorld);
        }
        catch (IOException e) {
            WorldMap.LOGGER.error("suppressed exception", (Throwable)e);
        }
        this.waypoints.remove(waypoint);
        this.waypointsSorted.remove(waypoint);
        this.waypointMenuRenderer.updateFilteredList();
    }

    public void checkWaypoints(boolean multiplayer, ResourceKey<Level> dimId, String multiworldId, int width, int height, GuiMap screen, MapWorld mapWorld, Registry<DimensionType> dimensionTypes) {
        WaypointSet checkingSet;
        XaeroMinimapSession minimapSession = XaeroMinimapSession.getCurrentSession();
        WaypointsManager waypointsManager = minimapSession.getWaypointsManager();
        String containerId = waypointsManager.getAutoRootContainerID() + "/" + waypointsManager.getDimensionDirectoryName(dimId);
        String mapBasedMW = !multiplayer ? "waypoints" : multiworldId;
        this.mapWaypointWorld = waypointsManager.getWorld(containerId, mapBasedMW);
        WaypointWorld checkingWaypointWorld = WorldMap.settings.onlyCurrentMapWaypoints ? this.mapWaypointWorld : waypointsManager.getCurrentWorld();
        Minecraft mc = Minecraft.m_91087_();
        if (xaero.map.misc.Misc.hasEffect((Player)mc.f_91074_, Effects.NO_WAYPOINTS) || xaero.map.misc.Misc.hasEffect((Player)mc.f_91074_, Effects.NO_WAYPOINTS_HARMFUL)) {
            checkingWaypointWorld = null;
        }
        boolean shouldRefresh = this.refreshWaypoints;
        if (dimId != this.mapDimId) {
            shouldRefresh = true;
            this.mapDimId = dimId;
        }
        if (checkingWaypointWorld != this.waypointWorld) {
            this.waypointWorld = checkingWaypointWorld;
            screen.closeRightClick();
            if (screen.waypointMenu) {
                screen.m_6575_(Minecraft.m_91087_(), width, height);
            }
            shouldRefresh = true;
        }
        WaypointSet waypointSet = checkingSet = checkingWaypointWorld == null ? null : checkingWaypointWorld.getCurrentSet();
        if (checkingSet != this.waypointSet) {
            this.waypointSet = checkingSet;
            shouldRefresh = true;
        }
        if (this.allSets != this.modMain.getSettings().renderAllSets) {
            this.allSets = this.modMain.getSettings().renderAllSets;
            shouldRefresh = true;
        }
        if (shouldRefresh) {
            this.dimDiv = this.waypointWorld == null ? 1.0 : this.getDimensionDivision(mapWorld, dimensionTypes, waypointsManager, this.waypointWorld.getContainer().getKey(), dimId);
            this.waypoints = this.convertWaypoints(this.dimDiv);
            if (this.waypoints != null) {
                Collections.sort(this.waypoints);
                this.waypointsSorted = new ArrayList();
                ArrayList<KeySortableByOther<Waypoint>> sortingList = new ArrayList<KeySortableByOther<Waypoint>>();
                for (Waypoint waypoint : this.waypoints) {
                    sortingList.add(new KeySortableByOther<Waypoint>(waypoint, new Comparable[]{waypoint.getComparisonName(), waypoint.getName()}));
                }
                Collections.sort(sortingList);
                for (KeySortableByOther keySortableByOther : sortingList) {
                    this.waypointsSorted.add((Waypoint)keySortableByOther.getKey());
                }
            } else {
                this.waypointsSorted = null;
            }
            this.waypointMenuRenderer.updateFilteredList();
        }
        this.refreshWaypoints = false;
    }

    private double getDimensionDivision(MapWorld mapWorld, Registry<DimensionType> dimensionTypes, WaypointsManager waypointsManager, String worldContainerID, ResourceKey<Level> mapDimId) {
        if (worldContainerID == null || Minecraft.m_91087_().f_91073_ == null) {
            return 1.0;
        }
        String dimPart = worldContainerID.substring(worldContainerID.lastIndexOf(47) + 1);
        ResourceKey waypointDimId = waypointsManager.getDimensionKeyForDirectoryName(dimPart);
        MapDimension waypointMapDimension = mapWorld.getDimension((ResourceKey<Level>)waypointDimId);
        MapDimension mapDimension = mapWorld.getDimension(mapDimId);
        DimensionType waypointDimType = MapDimension.getDimensionType(waypointMapDimension, (ResourceKey<Level>)waypointDimId, dimensionTypes);
        DimensionType mapDimType = MapDimension.getDimensionType(mapDimension, mapDimId, dimensionTypes);
        double waypointDimScale = waypointDimType == null ? 1.0 : waypointDimType.f_63859_();
        double mapDimScale = mapDimType == null ? 1.0 : mapDimType.f_63859_();
        return mapDimScale / waypointDimScale;
    }

    public HoveredMapElementHolder<?, ?> renderWaypointsMenu(GuiGraphics guiGraphics, GuiMap gui, double scale, int width, int height, int mouseX, int mouseY, boolean leftMousePressed, boolean leftMouseClicked, HoveredMapElementHolder<?, ?> hovered, Minecraft mc) {
        return this.waypointMenuRenderer.renderMenu(guiGraphics, gui, scale, width, height, mouseX, mouseY, leftMousePressed, leftMouseClicked, hovered, mc);
    }

    public void requestWaypointsRefresh() {
        this.refreshWaypoints = true;
    }

    public KeyMapping getWaypointKeyBinding() {
        return ModSettings.newWaypoint;
    }

    public KeyMapping getTempWaypointKeyBinding() {
        return ModSettings.keyInstantWaypoint;
    }

    public KeyMapping getTempWaypointsMenuKeyBinding() {
        return ModSettings.keyWaypoints;
    }

    public void onMapKeyPressed(InputConstants.Type type, int code, GuiMap screen) {
        KeyMapping listPlayerAlternative;
        KeyMapping minimapSettingsKB;
        KeyMapping kb = null;
        if (xaero.map.misc.Misc.inputMatchesKeyBinding(type, code, this.getToggleRadarKey(), 0)) {
            screen.onRadarButton(screen.getRadarButton());
        }
        if (xaero.map.misc.Misc.inputMatchesKeyBinding(type, code, ModSettings.keyToggleMapWaypoints, 0)) {
            this.getWaypointMenuRenderer().onRenderWaypointsButton(screen, screen.f_96543_, screen.f_96544_);
        }
        if (xaero.map.misc.Misc.inputMatchesKeyBinding(type, code, ModSettings.keyReverseEntityRadar, 0)) {
            ModSettings.keyReverseEntityRadar.m_7249_(true);
        }
        if (xaero.map.misc.Misc.inputMatchesKeyBinding(type, code, ModSettings.keySwitchSet, 0)) {
            kb = ModSettings.keySwitchSet;
        }
        if (xaero.map.misc.Misc.inputMatchesKeyBinding(type, code, ModSettings.keyAllSets, 0)) {
            kb = ModSettings.keyAllSets;
        }
        if (xaero.map.misc.Misc.inputMatchesKeyBinding(type, code, ModSettings.keyWaypoints, 0)) {
            kb = ModSettings.keyWaypoints;
        }
        if (xaero.map.misc.Misc.inputMatchesKeyBinding(type, code, minimapSettingsKB = (KeyMapping)this.modMain.getSettingsKey(), 0)) {
            kb = minimapSettingsKB;
        }
        if ((listPlayerAlternative = this.getMinimapListPlayersAlternative()) != null && xaero.map.misc.Misc.inputMatchesKeyBinding(type, code, listPlayerAlternative, 0)) {
            listPlayerAlternative.m_7249_(true);
        }
        Minecraft mc = Minecraft.m_91087_();
        if (kb != null) {
            if (kb == ModSettings.keyWaypoints) {
                this.openWaypointsMenu(mc, screen);
                return;
            }
            if (minimapSettingsKB != null && kb == minimapSettingsKB) {
                this.openSettingsScreen(mc, screen, screen);
                return;
            }
            this.handleMinimapKeyBinding(kb, screen);
        }
    }

    public boolean onMapKeyReleased(InputConstants.Type type, int code, GuiMap screen) {
        KeyMapping listPlayerAlternative;
        boolean result = false;
        if (xaero.map.misc.Misc.inputMatchesKeyBinding(type, code, ModSettings.keyReverseEntityRadar, 0)) {
            ModSettings.keyReverseEntityRadar.m_7249_(false);
            result = true;
        }
        if ((listPlayerAlternative = this.getMinimapListPlayersAlternative()) != null && xaero.map.misc.Misc.inputMatchesKeyBinding(type, code, listPlayerAlternative, 0)) {
            listPlayerAlternative.m_7249_(false);
            result = true;
        }
        return result;
    }

    public void handleMinimapKeyBinding(KeyMapping kb, GuiMap screen) {
        XaeroMinimapSession minimapSession = XaeroMinimapSession.getCurrentSession();
        minimapSession.getControls().keyDown(kb, false, false);
        if ((kb == ModSettings.keySwitchSet || kb == ModSettings.keyAllSets) && screen.waypointMenu) {
            screen.m_6575_(Minecraft.m_91087_(), screen.f_96543_, screen.f_96544_);
        }
    }

    public void drawSetChange(GuiGraphics guiGraphics) {
        XaeroMinimapSession minimapSession = XaeroMinimapSession.getCurrentSession();
        this.modMain.getInterfaces().getMinimapInterface().getWaypointsGuiRenderer().drawSetChange(minimapSession.getWaypointsManager(), guiGraphics, Minecraft.m_91087_().m_91268_());
    }

    public float getMinimapBrightnessOldCompatibility() {
        return this.modMain.getSupportMods().worldmapSupport.getMinimapBrightness();
    }

    public Screen openSettingsScreen(Minecraft mc, Screen current, Screen escape) {
        this.modMain.getGuiHelper().openMinimapSettingsFromScreen(current, escape);
        return Minecraft.m_91087_().f_91080_;
    }

    public String getControlsTooltip() {
        return I18n.m_118938_((String)"gui.xaero_box_controls_minimap", (Object[])new Object[]{xaero.map.misc.Misc.getKeyName(ModSettings.newWaypoint), xaero.map.misc.Misc.getKeyName(ModSettings.keyInstantWaypoint), xaero.map.misc.Misc.getKeyName(ModSettings.keySwitchSet), xaero.map.misc.Misc.getKeyName(ModSettings.keyAllSets), xaero.map.misc.Misc.getKeyName(ModSettings.keyWaypoints)});
    }

    public void onMapMouseRelease(double par1, double par2, int par3) {
        this.waypointMenuRenderer.onMapMouseRelease(par1, par2, par3);
    }

    public void onMapConstruct() {
        this.waypointMenuRenderer = new WaypointMenuRenderer(new WaypointMenuRenderContext(), new WaypointMenuRenderProvider(this), this.waypointRenderer);
    }

    public void onMapInit(GuiMap mapScreen, Minecraft mc, int width, int height) {
        this.waypointMenuRenderer.onMapInit(mapScreen, mc, width, height, this.waypointWorld, this.modMain, XaeroMinimapSession.getCurrentSession());
    }

    public ArrayList<Waypoint> getWaypointsSorted() {
        return this.waypointsSorted;
    }

    public boolean waypointExists(Waypoint w) {
        return this.waypoints != null && this.waypoints.contains(w);
    }

    public void toggleTemporaryWaypoint(Waypoint waypoint) {
        ((xaero.common.minimap.waypoints.Waypoint)waypoint.getOriginal()).setTemporary(!((xaero.common.minimap.waypoints.Waypoint)waypoint.getOriginal()).isTemporary());
        try {
            this.modMain.getSettings().saveWaypoints(this.waypointWorld);
        }
        catch (IOException e) {
            WorldMap.LOGGER.error("suppressed exception", (Throwable)e);
        }
        waypoint.setDisabled(((xaero.common.minimap.waypoints.Waypoint)waypoint.getOriginal()).isDisabled());
        waypoint.setTemporary(((xaero.common.minimap.waypoints.Waypoint)waypoint.getOriginal()).isTemporary());
    }

    public void openWaypointsMenu(Minecraft mc, GuiMap screen) {
        XaeroMinimapSession minimapSession = XaeroMinimapSession.getCurrentSession();
        mc.m_91152_((Screen)new GuiWaypoints(this.modMain, minimapSession, (Screen)screen, (Screen)screen));
    }

    public boolean screenShouldSkipWorldRender(Screen currentScreen) {
        return Misc.screenShouldSkipWorldRender((IXaeroMinimap)this.modMain, (Screen)currentScreen, (boolean)false);
    }

    public boolean hidingWaypointCoordinates() {
        return this.modMain.getSettings().hideWaypointCoordinates;
    }

    public void shareWaypoint(Waypoint waypoint, GuiMap screen, WaypointWorld world) {
        XaeroMinimapSession minimapSession = XaeroMinimapSession.getCurrentSession();
        minimapSession.getWaypointSharing().shareWaypoint((Screen)screen, (xaero.common.minimap.waypoints.Waypoint)waypoint.getOriginal(), world);
    }

    public void shareLocation(GuiMap guiMap, int rightClickX, int rightClickY, int rightClickZ) {
        int wpColor = (int)((double)ModSettings.COLORS.length * Math.random());
        xaero.common.minimap.waypoints.Waypoint minimapLocationWaypoint = new xaero.common.minimap.waypoints.Waypoint(rightClickX, rightClickY == Short.MAX_VALUE ? 0 : rightClickY, rightClickZ, "Shared Location", "S", wpColor, 0, false, rightClickY != Short.MAX_VALUE);
        Waypoint locationWaypoint = this.convertWaypoint(minimapLocationWaypoint, false, "", 1.0);
        this.shareWaypoint(locationWaypoint, guiMap, this.rightClickWaypointWorld);
    }

    public WaypointWorld getMapWaypointWorld() {
        return this.mapWaypointWorld;
    }

    public WaypointWorld getWaypointWorld() {
        return this.waypointWorld;
    }

    public double getDimDiv() {
        return this.dimDiv;
    }

    public int getArrowColorIndex() {
        return this.modMain.getSettings().arrowColour;
    }

    public float[] getArrowColor() {
        block3: {
            block2: {
                if (this.modMain.getSettings().arrowColour < 0) break block2;
                int n = this.modMain.getSettings().arrowColour;
                this.modMain.getSettings();
                if (n < ModSettings.arrowColours.length) break block3;
            }
            return null;
        }
        this.modMain.getSettings();
        return ModSettings.arrowColours[this.modMain.getSettings().arrowColour];
    }

    public String getSubWorldNameToRender() {
        if (WorldMap.settings.onlyCurrentMapWaypoints || this.waypointWorld == null) {
            return null;
        }
        if (this.waypointWorld != this.mapWaypointWorld) {
            return I18n.m_118938_((String)"gui.xaero_wm_using_custom_subworld", (Object[])new Object[]{this.waypointWorld.getContainer().getSubName()});
        }
        return null;
    }

    public void registerMinimapHighlighters(Object highlighterRegistry) {
    }

    public ArrayList<Waypoint> getWaypoints() {
        return this.waypoints;
    }

    public boolean getDeathpoints() {
        return this.deathpoints;
    }

    public WaypointRenderer getWaypointRenderer() {
        return this.waypointRenderer;
    }

    public WaypointMenuRenderer getWaypointMenuRenderer() {
        return this.waypointMenuRenderer;
    }

    public void onClearHighlightHash(int regionX, int regionZ) {
        DimensionHighlighterHandler highlightHandler;
        XaeroMinimapSession minimapSession = XaeroMinimapSession.getCurrentSession();
        if (minimapSession != null && (highlightHandler = minimapSession.getMinimapProcessor().getMinimapWriter().getDimensionHighlightHandler()) != null) {
            highlightHandler.requestRefresh(regionX, regionZ);
        }
    }

    public void createRadarRendererWrapper(Object radarRenderer) {
        new RadarRendererWrapperHelper().createWrapper(this.modMain, (RadarRenderer)radarRenderer);
    }

    public KeyMapping getToggleRadarKey() {
        return ModSettings.keyToggleRadar;
    }

    public void onClearHighlightHashes() {
        DimensionHighlighterHandler highlightHandler;
        XaeroMinimapSession minimapSession = XaeroMinimapSession.getCurrentSession();
        if (minimapSession != null && (highlightHandler = minimapSession.getMinimapProcessor().getMinimapWriter().getDimensionHighlightHandler()) != null) {
            highlightHandler.requestRefresh();
        }
    }

    public KeyMapping getToggleAllyPlayersKey() {
        if (this.hasTrackedPlayerSystemSupport()) {
            return ModSettings.keyToggleTrackedPlayers;
        }
        return ModSettings.keyTogglePacPlayers;
    }

    public KeyMapping getToggleClaimsKey() {
        return ModSettings.keyTogglePacChunkClaims;
    }

    public void onSessionFinalized() {
        this.waypointWorld = null;
        this.mapWaypointWorld = null;
    }

    public void openWaypointWorldTeleportCommandScreen(Screen parent, Screen escape) {
        String containerId;
        XaeroMinimapSession minimapSession = XaeroMinimapSession.getCurrentSession();
        if (minimapSession == null) {
            return;
        }
        WaypointsManager waypointsManager = minimapSession.getWaypointsManager();
        WaypointWorldRootContainer container = waypointsManager.getWorldContainerNullable(containerId = waypointsManager.getAutoRootContainerID()).getRootContainer();
        if (container != null) {
            Minecraft.m_91087_().m_91152_((Screen)new GuiWorldTpCommand(this.modMain, parent, escape, container));
        }
    }

    public KeyMapping getMinimapListPlayersAlternative() {
        return ModSettings.keyAlternativeListPlayers;
    }

    public int getCaveStart(int defaultWorldMapStart, boolean isMapScreen) {
        if (!this.modMain.getSettings().getMinimap() || this.isFairPlay()) {
            return defaultWorldMapStart;
        }
        if (xaero.map.misc.Misc.hasEffect(Effects.NO_CAVE_MAPS) || xaero.map.misc.Misc.hasEffect(Effects.NO_CAVE_MAPS_HARMFUL) || this.compatibilityVersion >= 19 && this.modMain.getSettings().caveMapsDisabled()) {
            return isMapScreen ? defaultWorldMapStart : Integer.MAX_VALUE;
        }
        int usedCaving = this.getUsedCaving();
        if (usedCaving == Integer.MAX_VALUE) {
            return WorldMap.settings.caveModeStart;
        }
        return usedCaving;
    }

    public int getUsedCaving() {
        XaeroMinimapSession minimapSession = XaeroMinimapSession.getCurrentSession();
        if (minimapSession != null) {
            return minimapSession.getMinimapProcessor().getMinimapWriter().getLoadedCaving();
        }
        return Integer.MAX_VALUE;
    }

    public boolean isFairPlay() {
        return this.modMain.isFairPlay();
    }

    public boolean hasTrackedPlayerSystemSupport() {
        return this.compatibilityVersion >= 17;
    }

    public IPlayerTrackerSystem<?> getMinimapSyncedPlayerTrackerSystem() {
        if (this.minimapSyncedPlayerTrackerSystem == null) {
            this.minimapSyncedPlayerTrackerSystem = new MinimapSyncedPlayerTrackerSystem(this);
        }
        return this.minimapSyncedPlayerTrackerSystem;
    }

    public boolean hasDimSwitchSupport() {
        return this.compatibilityVersion >= 20;
    }

    public void onBlockHover() {
        this.mouseBlockWaypointWorld = this.mapWaypointWorld;
    }

    public void onRightClick() {
        this.rightClickWaypointWorld = this.mouseBlockWaypointWorld;
    }
}

