/*
 * Decompiled with CFR 0.152.
 */
package sfiomn.legendarycreatures.entities.goals;

import java.util.EnumSet;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import sfiomn.legendarycreatures.entities.AnimatedCreatureEntity;
import sfiomn.legendarycreatures.entities.goals.MoveToTargetGoal;

public class BaseMeleeAttackGoal
extends MoveToTargetGoal {
    private final int attackDuration;
    private final int actionPoint;
    private final int attackCoolDown;
    private int attackAnimationTick;
    private long lastUseTime;
    private int ticksUntilNextAttack;

    public BaseMeleeAttackGoal(AnimatedCreatureEntity mob, int attackDuration, int hurtTick, int attackCoolDown, double speedModifier, boolean followingEvenIfNotSeen) {
        super(mob, speedModifier, followingEvenIfNotSeen);
        this.attackDuration = (int)Math.ceil((double)attackDuration / 2.0);
        this.actionPoint = hurtTick / 2;
        this.attackCoolDown = (int)Math.ceil((double)attackCoolDown / 2.0);
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_6767_() {
        return false;
    }

    public boolean isAttacking() {
        return this.mob.getAttackAnimation() == 1;
    }

    @Override
    public boolean m_8036_() {
        long time = this.mob.m_9236_().m_46467_();
        if (time - this.lastUseTime < 20L || this.isAttacking()) {
            return false;
        }
        return super.m_8036_();
    }

    @Override
    public boolean m_8045_() {
        return super.m_8045_();
    }

    @Override
    public void m_8056_() {
        super.m_8056_();
        this.mob.m_21561_(true);
        this.attackAnimationTick = 0;
        this.ticksUntilNextAttack = 0;
    }

    @Override
    public void m_8041_() {
        super.m_8041_();
        this.lastUseTime = this.mob.m_9236_().m_46467_();
        if (this.isAttacking()) {
            this.stopAttack();
        }
        this.mob.m_21561_(false);
    }

    @Override
    public void m_8037_() {
        LivingEntity target;
        if (this.attackAnimationTick > 0) {
            --this.attackAnimationTick;
        }
        if (this.ticksUntilNextAttack > 0) {
            --this.ticksUntilNextAttack;
        }
        if ((target = this.mob.m_5448_()) != null) {
            double distToTargetSqr = this.mob.m_20280_((Entity)target);
            super.m_8037_();
            if (this.ticksUntilNextAttack == 0 && this.getAttackReachSqr(target) >= distToTargetSqr && !this.isAttacking()) {
                this.mob.m_7618_(EntityAnchorArgument.Anchor.EYES, target.m_20182_());
                this.startAttack();
            }
            if (this.attackAnimationTick == 0 && this.isAttacking()) {
                this.stopAttack();
            }
            if (this.isActionPoint()) {
                this.executeAttack(target);
            }
        }
    }

    protected void startAttack() {
        this.mob.setAttackAnimation(1);
        this.attackAnimationTick = this.attackDuration;
    }

    protected void stopAttack() {
        this.mob.setAttackAnimation(0);
        this.ticksUntilNextAttack = this.attackCoolDown;
    }

    protected boolean executeAttack(LivingEntity target) {
        return this.mob.m_7327_((Entity)target);
    }

    protected boolean isActionPoint() {
        return this.attackAnimationTick == this.attackDuration - this.actionPoint;
    }

    @Override
    protected double getAttackReachSqr(LivingEntity entity) {
        return this.mob.m_20205_() * 2.0f * this.mob.m_20205_() * 2.0f + entity.m_20205_();
    }
}

