/*
 * Decompiled with CFR 0.152.
 */
package sfiomn.legendarycreatures.entities.goals;

import java.util.EnumSet;
import java.util.UUID;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.phys.Vec3;
import sfiomn.legendarycreatures.api.ModDamageTypes;
import sfiomn.legendarycreatures.entities.AnimatedCreatureEntity;
import sfiomn.legendarycreatures.entities.goals.MoveToTargetGoal;
import sfiomn.legendarycreatures.registry.EffectRegistry;
import sfiomn.legendarycreatures.util.DamageSourceUtil;

public class RootMeleeAttackGoal
extends MoveToTargetGoal {
    protected static final UUID KNOCKBACK_RESISTANCE_UUID = UUID.fromString("e20745c1-e432-40f2-b930-d08f1ef67508");
    private final AttributeModifier maxKnockBackResistance = new AttributeModifier(KNOCKBACK_RESISTANCE_UUID, "legendarycreatures.rootAttack.knockbackResistance", 1000.0, AttributeModifier.Operation.ADDITION);
    private AttributeInstance mobKnockBackResAttribute;
    private final int baseAttackDuration;
    private final int baseActionPoint;
    private boolean baseAttackDone;
    private final int rootAttackDuration;
    private final float damageEvery1s;
    private final int goalCoolDown;
    private final double stopAttackMobHealthPercent;
    private float mobHealth;
    private boolean shouldStopAttack;
    private int baseAttackAnimationTick;
    private int rootAttackAnimationTick;
    private int rootTick;
    private long lastUseTime;
    private LivingEntity rootTarget;

    public RootMeleeAttackGoal(AnimatedCreatureEntity mob, int baseAttackDuration, int baseActionPoint, int rootAttackDuration, float damageEvery1s, double stopAttackMobHealthPercent, double speedModifier, int goalCoolDown) {
        super(mob, speedModifier, true);
        this.baseAttackDuration = (int)Math.ceil((double)baseAttackDuration / 2.0);
        this.baseActionPoint = baseActionPoint / 2;
        this.rootAttackDuration = (int)Math.ceil((double)rootAttackDuration / 2.0);
        this.damageEvery1s = damageEvery1s;
        this.goalCoolDown = goalCoolDown;
        this.stopAttackMobHealthPercent = stopAttackMobHealthPercent;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_6767_() {
        return false;
    }

    public boolean isAttacking() {
        return this.mob.getAttackAnimation() == 4 || this.mob.getAttackAnimation() == 1;
    }

    @Override
    public boolean m_8036_() {
        long time = this.mob.m_9236_().m_46467_();
        if (time - this.lastUseTime < (long)this.goalCoolDown) {
            return false;
        }
        return super.m_8036_();
    }

    @Override
    public boolean m_8045_() {
        if (super.m_8045_()) {
            if ((double)((this.mobHealth - this.mob.m_21223_()) / this.mob.m_21233_()) > this.stopAttackMobHealthPercent) {
                return false;
            }
            return !this.shouldStopAttack;
        }
        return false;
    }

    @Override
    public void m_8056_() {
        super.m_8056_();
        this.mob.m_21561_(true);
        this.baseAttackAnimationTick = 0;
        this.rootAttackAnimationTick = 0;
        this.mobHealth = this.mob.m_21223_();
        this.shouldStopAttack = false;
        this.baseAttackDone = false;
        this.rootTick = 0;
        this.mobKnockBackResAttribute = this.mob.m_21051_(Attributes.f_22278_);
    }

    @Override
    public void m_8041_() {
        super.m_8041_();
        this.lastUseTime = this.mob.m_9236_().m_46467_();
        this.stopAttack();
        if (this.rootTarget != null) {
            this.removeRootEffect(this.rootTarget);
        }
        this.mob.m_21561_(false);
    }

    @Override
    public void m_8037_() {
        LivingEntity target;
        if (this.baseAttackAnimationTick > 0) {
            --this.baseAttackAnimationTick;
        }
        if (this.rootAttackAnimationTick > 0) {
            --this.rootAttackAnimationTick;
        }
        if ((target = this.mob.m_5448_()) != null) {
            this.mob.m_21563_().m_24964_(target.m_20182_());
            if (this.rootAttackAnimationTick <= 0) {
                super.m_8037_();
            }
            double distToTargetSqr = this.mob.m_20280_((Entity)target);
            if (this.getAttackReachSqr(target) >= distToTargetSqr && !this.isAttacking()) {
                this.mob.m_7618_(EntityAnchorArgument.Anchor.EYES, target.m_20182_());
                this.startBaseAttack();
            }
            if (this.baseAttackDone && this.rootAttackAnimationTick == 0) {
                this.mob.m_7618_(EntityAnchorArgument.Anchor.EYES, target.m_20182_());
                this.startRootAttack();
            }
            if (this.mob.getAttackAnimation() == 1 && this.getBaseActionPoint()) {
                this.executeBaseAttack(target);
            }
            if (this.mob.getAttackAnimation() == 4 && this.rootTick-- <= 0) {
                this.rootTick = 10;
                this.executeRootAttack(target);
            }
            if (this.baseAttackDone && this.getAttackReachSqr(target) * 1.5 < distToTargetSqr) {
                this.shouldStopAttack = true;
            }
        }
    }

    protected void startBaseAttack() {
        this.mob.setAttackAnimation(1);
        this.baseAttackAnimationTick = this.baseAttackDuration;
    }

    protected void startRootAttack() {
        this.mob.setAttackAnimation(4);
        this.rootAttackAnimationTick = this.rootAttackDuration;
    }

    protected void stopAttack() {
        this.mob.setAttackAnimation(0);
    }

    protected void executeBaseAttack(LivingEntity target) {
        if (target != null) {
            if (!this.isDamageSourceBlocked(target)) {
                this.addRootEffect(target);
                target.m_6469_(DamageSourceUtil.getDamageSource(this.mob.m_9236_(), ModDamageTypes.ROOT_ATTACK), this.damageEvery1s);
                this.rootTarget = target;
                this.rootTick = 10;
                this.baseAttackDone = true;
            } else {
                target.m_6469_(this.mob.m_269291_().m_269333_((LivingEntity)this.mob), this.damageEvery1s);
                this.shouldStopAttack = true;
            }
        }
    }

    protected void executeRootAttack(LivingEntity target) {
        this.addRootEffect(target);
        target.m_6469_(DamageSourceUtil.getDamageSource(this.mob.m_9236_(), ModDamageTypes.ROOT_ATTACK), this.damageEvery1s);
    }

    protected void addRootEffect(LivingEntity target) {
        target.m_7292_(new MobEffectInstance((MobEffect)EffectRegistry.ROOT.get(), 40, 0, false, true));
        if (this.mobKnockBackResAttribute != null && !this.mobKnockBackResAttribute.m_22109_(this.maxKnockBackResistance)) {
            this.mobKnockBackResAttribute.m_22118_(this.maxKnockBackResistance);
        }
    }

    protected void removeRootEffect(LivingEntity target) {
        if (target.m_21023_((MobEffect)EffectRegistry.ROOT.get())) {
            target.m_21195_((MobEffect)EffectRegistry.ROOT.get());
        }
        if (this.mobKnockBackResAttribute != null && this.mobKnockBackResAttribute.m_22109_(this.maxKnockBackResistance)) {
            this.mobKnockBackResAttribute.m_22130_(this.maxKnockBackResistance);
        }
    }

    protected boolean getBaseActionPoint() {
        return this.baseAttackDuration - this.baseActionPoint == this.baseAttackAnimationTick;
    }

    @Override
    protected double getAttackReachSqr(LivingEntity entity) {
        return this.mob.m_20205_() * 2.0f * this.mob.m_20205_() * 2.0f + entity.m_20205_();
    }

    protected boolean isDamageSourceBlocked(LivingEntity target) {
        if (target.m_21254_()) {
            Vec3 vector3d2 = this.mob.m_20182_();
            Vec3 vector3d = target.m_20252_(1.0f);
            Vec3 vector3d1 = vector3d2.m_82505_(target.m_20182_()).m_82541_();
            vector3d1 = new Vec3(vector3d1.f_82479_, 0.0, vector3d1.f_82481_);
            return vector3d1.m_82526_(vector3d) < 0.0;
        }
        return false;
    }
}

