/*
 * Decompiled with CFR 0.152.
 */
package sfiomn.legendarycreatures.events;

import com.realgecko.xpfromharvest.ModConfig;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.tags.IReverseTag;
import sfiomn.legendarycreatures.LegendaryCreatures;
import sfiomn.legendarycreatures.api.entities.MobEntityEnum;
import sfiomn.legendarycreatures.config.BlackLists;
import sfiomn.legendarycreatures.config.json.JsonChanceSpawn;
import sfiomn.legendarycreatures.config.json.JsonConfig;
import sfiomn.legendarycreatures.entities.AnimatedCreatureEntity;
import sfiomn.legendarycreatures.items.StrawHatItem;
import sfiomn.legendarycreatures.util.DamageSourceUtil;
import sfiomn.legendarycreatures.util.WorldUtil;

@Mod.EventBusSubscriber(modid="legendarycreatures", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ForgeEvents {
    @SubscribeEvent
    public static void onBlockBreak(BlockEvent.BreakEvent event) {
        if (event.getPlayer().m_7500_() || event.getPlayer().m_5833_() || !event.getState().m_60734_().canHarvestBlock(event.getState(), (BlockGetter)event.getLevel(), event.getPos(), event.getPlayer())) {
            return;
        }
        ForgeEvents.handleBreakBlock(event.getLevel(), event.getState(), event.getPos(), event.getPlayer());
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onBlockRightClick(PlayerInteractEvent.RightClickBlock event) {
        if (event.getEntity().m_7500_() || event.getEntity().m_5833_()) {
            return;
        }
        if (LegendaryCreatures.xpFromHarvestLoaded && ((Boolean)ModConfig.simpleHarvest.get()).booleanValue()) {
            if (event.getEntity() == null || event.getLevel().m_5776_()) {
                return;
            }
            Level level = event.getLevel();
            BlockPos pos = event.getPos();
            BlockState state = level.m_8055_(pos);
            if (((List)ModConfig.crops.get()).contains(state.toString())) {
                ForgeEvents.handleBreakBlock((LevelAccessor)level, state, pos, event.getEntity());
            }
        }
    }

    @SubscribeEvent
    public static void onEntityKilled(LivingDeathEvent event) {
        Entity entity = event.getSource().m_7639_();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            ResourceLocation killedEntityName = ForgeRegistries.ENTITY_TYPES.getKey((Object)event.getEntity().m_6095_());
            Optional entityTypeTagsOptional = Objects.requireNonNull(ForgeRegistries.ENTITY_TYPES.tags()).getReverseTag((Object)event.getEntity().m_6095_());
            IReverseTag entityTypeTags = null;
            if (entityTypeTagsOptional.isPresent()) {
                entityTypeTags = (IReverseTag)entityTypeTagsOptional.get();
            }
            if (player.m_7500_() || player.m_5833_() || killedEntityName == null) {
                return;
            }
            for (MobEntityEnum mobEntityEnum : MobEntityEnum.values()) {
                String mobId = mobEntityEnum.mobId;
                BlackLists blackLists = JsonConfig.mobIdSpawnList.get((Object)mobId).blackLists;
                Map<String, JsonChanceSpawn> killingEntityNameSpawns = JsonConfig.mobIdSpawnList.get((Object)mobId).killingEntityNameSpawns;
                Map<TagKey<EntityType<?>>, JsonChanceSpawn> killingEntityTagSpawns = JsonConfig.mobIdSpawnList.get((Object)mobId).killingEntityTypeTagSpawns;
                boolean cancelSpawn = false;
                if (blackLists.killingEntityNames.contains(killedEntityName.toString())) {
                    cancelSpawn = true;
                } else if (entityTypeTags != null) {
                    for (TagKey<EntityType<?>> blackListedEntityTypeTag : blackLists.killingEntityTypeTags) {
                        if (!entityTypeTags.containsTag(blackListedEntityTypeTag)) continue;
                        cancelSpawn = true;
                    }
                }
                if (cancelSpawn) continue;
                if (killingEntityNameSpawns.containsKey(killedEntityName.toString())) {
                    if (!ForgeEvents.spawnEntity((LevelAccessor)event.getEntity().m_20193_(), event.getEntity().m_20182_(), mobEntityEnum, killingEntityNameSpawns.get((Object)killedEntityName.toString()).chance)) continue;
                    return;
                }
                if (entityTypeTags == null) continue;
                boolean tagFound = false;
                for (TagKey<EntityType<?>> spawnKillingEntityTypeTag : killingEntityTagSpawns.keySet()) {
                    if (!entityTypeTags.containsTag(spawnKillingEntityTypeTag)) continue;
                    tagFound = true;
                    if (!ForgeEvents.spawnEntity((LevelAccessor)event.getEntity().m_20193_(), event.getEntity().m_20182_(), mobEntityEnum, killingEntityTagSpawns.get(spawnKillingEntityTypeTag).chance)) continue;
                    return;
                }
                if (tagFound || !killingEntityNameSpawns.containsKey("default") || !ForgeEvents.spawnEntity((LevelAccessor)event.getEntity().m_20193_(), event.getEntity().m_20182_(), mobEntityEnum, killingEntityNameSpawns.get((Object)"default").chance)) continue;
                return;
            }
        }
    }

    private static void handleBreakBlock(LevelAccessor level, BlockState state, BlockPos pos, Player player) {
        ResourceLocation blockRegistryName = ForgeRegistries.BLOCKS.getKey((Object)state.m_60734_());
        if (blockRegistryName == null) {
            return;
        }
        Vec3 spawnPos = new Vec3((double)pos.m_123341_() + 0.5, (double)pos.m_123342_(), (double)pos.m_123343_() + 0.5);
        Optional blockTagsOptional = Objects.requireNonNull(ForgeRegistries.BLOCKS.tags()).getReverseTag((Object)state.m_60734_());
        IReverseTag blockTags = null;
        if (blockTagsOptional.isPresent()) {
            blockTags = (IReverseTag)blockTagsOptional.get();
        }
        boolean isStrawHatWorn = player.m_6844_(EquipmentSlot.HEAD).m_41720_() instanceof StrawHatItem;
        for (MobEntityEnum mobEntityEnum : MobEntityEnum.values()) {
            String mobId = mobEntityEnum.mobId;
            String blockName = blockRegistryName.toString();
            BlackLists blackLists = JsonConfig.mobIdSpawnList.get((Object)mobId).blackLists;
            Map<String, JsonChanceSpawn> breakingBlockNameSpawns = JsonConfig.mobIdSpawnList.get((Object)mobId).breakingBlockNameSpawns;
            Map<TagKey<Block>, JsonChanceSpawn> breakingBlockTagSpawns = JsonConfig.mobIdSpawnList.get((Object)mobId).breakingBlockTagSpawns;
            boolean cancelSpawn = false;
            if (blackLists.breakingBlockNames.contains(blockName)) {
                cancelSpawn = true;
            } else if (blockTags != null) {
                for (TagKey<Block> blackListedBlockTag : blackLists.breakingBlockTags) {
                    if (!blockTags.containsTag(blackListedBlockTag)) continue;
                    cancelSpawn = true;
                }
            }
            if (cancelSpawn) continue;
            double spawnChance = 0.0;
            if (breakingBlockNameSpawns.containsKey(blockRegistryName.toString())) {
                spawnChance = breakingBlockNameSpawns.get((Object)blockRegistryName.toString()).chance;
            }
            if (spawnChance <= 0.0 && breakingBlockNameSpawns.containsKey("default")) {
                spawnChance = breakingBlockNameSpawns.get((Object)"default").chance;
            }
            if (spawnChance <= 0.0 && blockTags != null) {
                for (TagKey<Block> spawnBlockTag : breakingBlockTagSpawns.keySet()) {
                    if (!blockTags.containsTag(spawnBlockTag)) continue;
                    spawnChance = breakingBlockTagSpawns.get(spawnBlockTag).chance;
                }
            }
            if (!(spawnChance > 0.0)) continue;
            if (mobEntityEnum == MobEntityEnum.SCARECROW && isStrawHatWorn) {
                if (!(level instanceof Level)) continue;
                player.m_150109_().m_150072_(DamageSourceUtil.getDamageSource((Level)level, (ResourceKey<DamageType>)DamageTypes.f_268433_), 1.0f, Inventory.f_150069_);
                continue;
            }
            if (!ForgeEvents.spawnEntity(level, spawnPos, mobEntityEnum, spawnChance)) continue;
            return;
        }
    }

    private static boolean spawnEntity(LevelAccessor level, Vec3 pos, MobEntityEnum mobEntityEnum, double chance) {
        Entity entityToSpawn;
        EntityType entityType;
        RandomSource rand = level.m_213780_();
        if ((double)rand.m_188501_() < chance && (entityType = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(new ResourceLocation("legendarycreatures", mobEntityEnum.mobId))) != null && (entityToSpawn = entityType.m_20615_((Level)level)) != null) {
            if (entityToSpawn instanceof AnimatedCreatureEntity) {
                AnimatedCreatureEntity animEntity = (AnimatedCreatureEntity)entityToSpawn;
                animEntity.setSpawnEffect(true);
            }
            WorldUtil.spawnEntity(entityToSpawn, level, pos);
            return true;
        }
        return false;
    }
}

