/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.library.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.subtypes.UidContext;
import mezz.jei.api.recipe.vanilla.IJeiBrewingRecipe;
import mezz.jei.api.recipe.vanilla.IVanillaRecipeFactory;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.common.platform.IPlatformIngredientHelper;
import mezz.jei.common.platform.IPlatformRegistry;
import mezz.jei.common.platform.Services;
import mezz.jei.common.util.ErrorUtil;
import mezz.jei.library.ingredients.IngredientSet;
import mezz.jei.library.util.ResourceLocationUtil;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionBrewing;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BrewingRecipeMakerCommon {
    private static final Logger LOGGER = LogManager.getLogger();

    public static Set<IJeiBrewingRecipe> getVanillaBrewingRecipes(IVanillaRecipeFactory recipeFactory, IIngredientManager ingredientManager) {
        boolean foundNewPotions;
        HashSet<IJeiBrewingRecipe> recipes = new HashSet<IJeiBrewingRecipe>();
        IPlatformRegistry<Potion> potionRegistry = Services.PLATFORM.getRegistry(Registries.f_256973_);
        IIngredientHelper<ItemStack> itemStackHelper = ingredientManager.getIngredientHelper(VanillaTypes.ITEM_STACK);
        IngredientSet<ItemStack> knownPotions = BrewingRecipeMakerCommon.getBaseKnownPotions(ingredientManager, potionRegistry);
        IngredientSet potionReagents = ingredientManager.getAllItemStacks().stream().filter(BrewingRecipeMakerCommon::isIngredient).collect(Collectors.toCollection(() -> new IngredientSet(itemStackHelper, UidContext.Ingredient)));
        do {
            List<ItemStack> newPotions;
            foundNewPotions = !(newPotions = BrewingRecipeMakerCommon.getNewPotions(recipeFactory, itemStackHelper, knownPotions, potionReagents, recipes)).isEmpty();
            knownPotions.addAll(newPotions);
        } while (foundNewPotions);
        return recipes;
    }

    private static boolean isIngredient(ItemStack itemStack) {
        try {
            return PotionBrewing.m_43506_((ItemStack)itemStack);
        }
        catch (LinkageError | RuntimeException e) {
            String itemStackInfo = ErrorUtil.getItemStackInfo(itemStack);
            LOGGER.error("Failed to check if item is a potion reagent {}.", (Object)itemStackInfo, (Object)e);
            return false;
        }
    }

    private static IngredientSet<ItemStack> getBaseKnownPotions(IIngredientManager ingredientManager, IPlatformRegistry<Potion> potionRegistry) {
        IPlatformIngredientHelper ingredientHelper = Services.PLATFORM.getIngredientHelper();
        IIngredientHelper itemStackHelper = ingredientManager.getIngredientHelper(VanillaTypes.ITEM_STACK);
        IngredientSet potionContainers = ingredientHelper.getPotionContainers().stream().flatMap(potionItem -> Arrays.stream(potionItem.m_43908_())).collect(Collectors.toCollection(() -> new IngredientSet(itemStackHelper, UidContext.Ingredient)));
        IngredientSet<ItemStack> knownPotions = new IngredientSet<ItemStack>(itemStackHelper, UidContext.Ingredient);
        knownPotions.addAll(potionContainers);
        potionRegistry.getValues().filter(potion -> potion != Potions.f_43598_).forEach(potion -> {
            for (ItemStack potionContainer : potionContainers) {
                ItemStack result = PotionUtils.m_43549_((ItemStack)potionContainer.m_41777_(), (Potion)potion);
                knownPotions.add(result);
            }
        });
        return knownPotions;
    }

    private static List<ItemStack> getNewPotions(IVanillaRecipeFactory recipeFactory, IIngredientHelper<ItemStack> itemStackHelper, Collection<ItemStack> knownPotions, Collection<ItemStack> potionReagents, Collection<IJeiBrewingRecipe> recipes) {
        ArrayList<ItemStack> newPotions = new ArrayList<ItemStack>();
        for (ItemStack potionInput : knownPotions) {
            String inputId = itemStackHelper.getUniqueId(potionInput, UidContext.Recipe);
            String inputPathId = ResourceLocationUtil.sanitizePath(inputId);
            for (ItemStack potionReagent : potionReagents) {
                String outputId;
                Potion potionOutputType;
                ItemStack potionOutput = BrewingRecipeMakerCommon.getOutput(potionInput.m_41777_(), potionReagent);
                if (potionOutput.m_41619_() || potionInput.m_41720_() instanceof PotionItem && potionOutput.m_41720_() instanceof PotionItem && (potionOutputType = PotionUtils.m_43579_((ItemStack)potionOutput)) == Potions.f_43599_ || Objects.equals(inputId, outputId = itemStackHelper.getUniqueId(potionOutput, UidContext.Recipe))) continue;
                String outputModId = itemStackHelper.getResourceLocation(potionOutput).m_135827_();
                String uidPath = inputPathId + ".to." + ResourceLocationUtil.sanitizePath(outputId);
                IJeiBrewingRecipe recipe = recipeFactory.createBrewingRecipe(List.of(potionReagent), potionInput.m_41777_(), potionOutput, new ResourceLocation(outputModId, uidPath));
                if (recipes.contains(recipe)) continue;
                recipes.add(recipe);
                newPotions.add(potionOutput);
            }
        }
        return newPotions;
    }

    private static ItemStack getOutput(ItemStack potion, ItemStack itemStack) {
        ItemStack result = PotionBrewing.m_43529_((ItemStack)itemStack, (ItemStack)potion);
        if (result != itemStack) {
            return result;
        }
        return ItemStack.f_41583_;
    }
}

