/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.placebo.menu;

import dev.shadowsoffire.placebo.mixin.AbstractContainerMenuInvoker;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiPredicate;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class QuickMoveHandler {
    protected List<QuickMoveRule> rules = new ArrayList<QuickMoveRule>();

    public ItemStack quickMoveStack(IExposedContainer container, Player player, int index) {
        if (this.rules.isEmpty()) {
            throw new RuntimeException("Quick Move requires at least one rule to be registered");
        }
        ItemStack slotStackCopy = ItemStack.f_41583_;
        Slot slot = container.getMenuSlot(index);
        if (slot != null && slot.m_6657_()) {
            ItemStack slotStack = slot.m_7993_();
            slotStackCopy = slotStack.m_41777_();
            boolean matched = false;
            for (QuickMoveRule rule : this.rules) {
                if (!rule.req.test(slotStack, index) || !slot.m_8010_(player)) continue;
                if (!container.moveMenuItemStackTo(slotStack, rule.startIdx, rule.endIdx, rule.reversed)) {
                    return ItemStack.f_41583_;
                }
                slot.m_142406_(player, slotStack);
                container.onQuickMove(slotStackCopy, slotStack, slot);
                matched = true;
                break;
            }
            if (!matched) {
                return ItemStack.f_41583_;
            }
            if (slotStack.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
        }
        return slotStackCopy;
    }

    public void registerRule(BiPredicate<ItemStack, Integer> req, int startIdx, int endIdx, boolean reversed) {
        this.rules.add(new QuickMoveRule(req, startIdx, endIdx, reversed));
    }

    public void registerRule(BiPredicate<ItemStack, Integer> req, int startIdx, int endIdx) {
        this.registerRule(req, startIdx, endIdx, false);
    }

    public static interface IExposedContainer {
        default public boolean moveMenuItemStackTo(ItemStack pStack, int pStartIndex, int pEndIndex, boolean pReverseDirection) {
            return ((AbstractContainerMenuInvoker)((Object)this))._moveItemStackTo(pStack, pStartIndex, pEndIndex, pReverseDirection);
        }

        default public Slot getMenuSlot(int index) {
            return ((AbstractContainerMenu)this).m_38853_(index);
        }

        default public void onQuickMove(ItemStack original, ItemStack remaining, Slot slot) {
            slot.m_6654_();
        }
    }

    protected record QuickMoveRule(BiPredicate<ItemStack, Integer> req, int startIdx, int endIdx, boolean reversed) {
    }
}

