/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism_integrations;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import de.teamlapen.lib.lib.util.IInitListener;
import de.teamlapen.lib.lib.util.VersionChecker;
import de.teamlapen.vampirism_integrations.Config;
import de.teamlapen.vampirism_integrations.EventHandler;
import de.teamlapen.vampirism_integrations.VampirismCompat;
import de.teamlapen.vampirism_integrations.bop.BOPCompat;
import de.teamlapen.vampirism_integrations.coldsweat.ColdSweatCompat;
import de.teamlapen.vampirism_integrations.consecration.ConsecrationCompat;
import de.teamlapen.vampirism_integrations.crafttweaker.CrafttweakerCompat;
import de.teamlapen.vampirism_integrations.ctov.ChoiceTheoremOverhauledVillage;
import de.teamlapen.vampirism_integrations.diet.DietCompat;
import de.teamlapen.vampirism_integrations.evilcraft.EvilCraftCompat;
import de.teamlapen.vampirism_integrations.graveyard.GraveyardCompat;
import de.teamlapen.vampirism_integrations.guardvillagers.GuardVillagerCompat;
import de.teamlapen.vampirism_integrations.jade.JadeModCompat;
import de.teamlapen.vampirism_integrations.mca.MCACompat;
import de.teamlapen.vampirism_integrations.player_companion.PlayerCompanionCompat;
import de.teamlapen.vampirism_integrations.survive.SurviveCompat;
import de.teamlapen.vampirism_integrations.tan.TANCompat;
import de.teamlapen.vampirism_integrations.util.IModCompat;
import de.teamlapen.vampirism_integrations.util.ModCompatLoader;
import de.teamlapen.vampirism_integrations.util.REFERENCE;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.SharedConstants;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.event.lifecycle.InterModProcessEvent;
import net.minecraftforge.fml.event.lifecycle.ParallelDispatchEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegisterEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.maven.artifact.versioning.ArtifactVersion;

@Mod(value="vampirism_integrations")
public class VampirismIntegrationsMod {
    public static final Logger LOGGER = LogManager.getLogger();
    public static VampirismIntegrationsMod instance;
    public static boolean inDev;
    @Nonnull
    public final ModCompatLoader compatLoader;
    private VersionChecker.VersionInfo versionInfo;

    public VampirismIntegrationsMod() {
        instance = this;
        this.checkDevEnv();
        Optional opt = ModList.get().getModContainerById("vampirism_integrations");
        if (opt.isPresent()) {
            REFERENCE.VERSION = ((ModContainer)opt.get()).getModInfo().getVersion();
        } else {
            LOGGER.warn("Cannot get version from mod info");
        }
        this.compatLoader = new ModCompatLoader();
        this.compatLoader.addModCompat(new VampirismCompat());
        this.compatLoader.addModCompat(new BOPCompat());
        this.compatLoader.addModCompat(new EvilCraftCompat());
        this.compatLoader.addModCompat(new DietCompat());
        this.compatLoader.addModCompat(new SurviveCompat());
        this.compatLoader.addModCompat(new CrafttweakerCompat());
        this.compatLoader.addModCompat(new GraveyardCompat());
        this.compatLoader.addModCompat(new TANCompat());
        this.compatLoader.addModCompat(new MCACompat());
        this.compatLoader.addModCompat(new ChoiceTheoremOverhauledVillage());
        this.compatLoader.addModCompat(new PlayerCompanionCompat());
        this.compatLoader.addModCompat(new ConsecrationCompat());
        this.compatLoader.addModCompat(new JadeModCompat());
        this.compatLoader.addModCompat(new ColdSweatCompat());
        this.compatLoader.addModCompat(new GuardVillagerCompat());
        FMLJavaModLoadingContext.get().getModEventBus().register((Object)this);
        MinecraftForge.EVENT_BUS.addListener(this::onCommandRegister);
        MinecraftForge.EVENT_BUS.register((Object)new EventHandler());
    }

    public VersionChecker.VersionInfo getVersionInfo() {
        return this.versionInfo;
    }

    @SubscribeEvent
    public void clientSetup(FMLClientSetupEvent event) {
        this.compatLoader.onInitStep(IInitListener.Step.CLIENT_SETUP, (ParallelDispatchEvent)event);
    }

    @SubscribeEvent
    public void loadComplete(FMLLoadCompleteEvent event) {
        this.compatLoader.onInitStep(IInitListener.Step.LOAD_COMPLETE, (ParallelDispatchEvent)event);
    }

    public void onCommandRegister(RegisterCommandsEvent event) {
        event.getDispatcher().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"vampirism-integrations").then(Commands.m_82127_((String)"loaded").executes(context -> {
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)"Loaded and active mods"), false);
            for (IModCompat compat : this.compatLoader.getLoadedModCompats()) {
                ModList.get().getModContainerById(compat.getModID()).ifPresent(container -> ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)("Active: " + compat.getModID() + " Version: " + container.getModInfo().getVersion().getQualifier())), false));
            }
            return 0;
        }))).then(Commands.m_82127_((String)"changelog").executes(context -> {
            if (!this.getVersionInfo().isNewVersionAvailable()) {
                ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237115_((String)"command.vampirism.base.changelog.newversion"), false);
                return 0;
            }
            VersionChecker.Version newVersion = this.getVersionInfo().getNewVersion();
            List changes = newVersion.getChanges();
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)(String.valueOf(ChatFormatting.GREEN) + "Vampirism Integrations" + newVersion.name + "(" + SharedConstants.m_183709_().m_132493_() + ")")), true);
            for (String c : changes) {
                ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)("-" + c)), false);
            }
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)""), false);
            String homepage = this.getVersionInfo().getHomePage();
            MutableComponent download = Component.m_237115_((String)"text.vampirism.update_message.download").m_130938_(style -> style.m_131142_(new ClickEvent(ClickEvent.Action.OPEN_URL, newVersion.getUrl() == null ? homepage : newVersion.getUrl())).m_131162_(Boolean.valueOf(true)).m_131140_(ChatFormatting.BLUE));
            MutableComponent changelog = Component.m_237115_((String)"text.vampirism.update_message.changelog").m_130938_(style -> style.m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/vampirism-integrations changelog")).m_131162_(Boolean.valueOf(true)));
            MutableComponent modpage = Component.m_237115_((String)"text.vampirism.update_message.modpage").m_130938_(style -> style.m_131142_(new ClickEvent(ClickEvent.Action.OPEN_URL, homepage)).m_131162_(Boolean.valueOf(true)).m_131140_(ChatFormatting.BLUE));
            ((CommandSourceStack)context.getSource()).m_288197_(() -> VampirismIntegrationsMod.lambda$onCommandRegister$11(download, (Component)changelog, (Component)modpage), false);
            return 0;
        })));
    }

    @SubscribeEvent
    public void enqueueIMC(InterModEnqueueEvent event) {
        this.compatLoader.onInitStep(IInitListener.Step.ENQUEUE_IMC, (ParallelDispatchEvent)event);
    }

    @SubscribeEvent
    public void processIMC(InterModProcessEvent event) {
        this.compatLoader.onInitStep(IInitListener.Step.PROCESS_IMC, (ParallelDispatchEvent)event);
    }

    @SubscribeEvent
    public void registerItems(RegisterEvent event) {
        if (event.getRegistryKey().equals((Object)ForgeRegistries.ITEMS.getRegistryKey())) {
            Config.buildConfiguration();
        }
    }

    @SubscribeEvent
    public void setup(FMLCommonSetupEvent event) {
        this.compatLoader.onInitStep(IInitListener.Step.COMMON_SETUP, (ParallelDispatchEvent)event);
        this.versionInfo = (Boolean)VampirismCompat.disableVersionCheck.get() != false ? new VersionChecker.VersionInfo(REFERENCE.VERSION) : VersionChecker.executeVersionCheck((String)"http://maxanier.de/projects/vampirism/versions_integrations.json", (ArtifactVersion)REFERENCE.VERSION, (boolean)false);
    }

    private void checkDevEnv() {
        String launchTarget = System.getenv().get("target");
        if (launchTarget != null && launchTarget.contains("dev")) {
            inDev = true;
        }
    }

    private static /* synthetic */ Component lambda$onCommandRegister$11(MutableComponent download, Component changelog, Component modpage) {
        return download.m_130946_(" ").m_7220_(changelog).m_130946_(" ").m_7220_(modpage);
    }

    static {
        inDev = false;
    }
}

