/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism_integrations.survive;

import com.stereowalker.survive.core.SurviveEntityStats;
import com.stereowalker.survive.needs.StaminaData;
import com.stereowalker.survive.needs.WaterData;
import com.stereowalker.survive.world.entity.ai.attributes.SAttributes;
import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.api.event.PlayerFactionEvent;
import de.teamlapen.vampirism.util.Helper;
import de.teamlapen.vampirism_integrations.survive.SurviveCompat;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SurviveHandler {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final UUID VAMPIRE_MOD_UUID = UUID.fromString("3625f8a1-3ac3-4289-8c26-b50ddccf066c");
    private static final ResourceLocation THIRST_OVERLAY = new ResourceLocation("survive", "thirst_level");
    private static final ResourceLocation STAMINA_OVERLAY = new ResourceLocation("survive", "stamina_level");
    private boolean warnThirst = true;
    private boolean warnTemperature = true;
    private boolean warnStamina = true;

    @SubscribeEvent
    public void onFactionLevelChanged(PlayerFactionEvent.FactionLevelChanged event) {
        block11: {
            if (((Boolean)SurviveCompat.enableTemperatureVampires.get()).booleanValue()) {
                try {
                    AttributeInstance heatRes;
                    boolean vamp = event.getCurrentFaction() == VReference.VAMPIRE_FACTION;
                    AttributeInstance coldRes = event.getPlayer().getPlayer().m_21051_(SAttributes.COLD_RESISTANCE);
                    if (coldRes != null) {
                        if (vamp) {
                            if (coldRes.m_22111_(VAMPIRE_MOD_UUID) == null) {
                                coldRes.m_22118_(new AttributeModifier(VAMPIRE_MOD_UUID, "vampire", 20.0, AttributeModifier.Operation.ADDITION));
                            }
                        } else {
                            coldRes.m_22120_(VAMPIRE_MOD_UUID);
                        }
                    }
                    if ((heatRes = event.getPlayer().getPlayer().m_21051_(SAttributes.HEAT_RESISTANCE)) != null) {
                        if (vamp) {
                            if (heatRes.m_22111_(VAMPIRE_MOD_UUID) == null) {
                                heatRes.m_22118_(new AttributeModifier(VAMPIRE_MOD_UUID, "vampire", -0.3, AttributeModifier.Operation.MULTIPLY_TOTAL));
                            }
                        } else {
                            heatRes.m_22120_(VAMPIRE_MOD_UUID);
                        }
                    }
                }
                catch (Throwable e) {
                    if (!this.warnTemperature) break block11;
                    LOGGER.error("Failed to modifiy temperature resistance for vampires", e);
                    this.warnTemperature = false;
                }
            }
        }
    }

    @SubscribeEvent
    public void onPlayerUpdate(LivingEvent.LivingTickEvent event) {
        block9: {
            WaterData stats;
            block8: {
                if (((Boolean)SurviveCompat.disableThirstForVampires.get()).booleanValue() && event.getEntity() instanceof ServerPlayer) {
                    try {
                        if (Helper.isVampire((Player)((Player)event.getEntity())) && (stats = SurviveEntityStats.getWaterStats((LivingEntity)event.getEntity())).needWater() && stats.getWaterLevel() < 20) {
                            stats.setWaterLevel(stats.getWaterLevel() + 1);
                            SurviveEntityStats.setWaterStats((LivingEntity)event.getEntity(), (WaterData)stats);
                        }
                    }
                    catch (Throwable e) {
                        if (!this.warnThirst) break block8;
                        LOGGER.error("Failed to disable thirst for vampire", e);
                        this.warnThirst = false;
                    }
                }
            }
            if (((Boolean)SurviveCompat.enableStaminaBoostVampires.get()).booleanValue() && event.getEntity() instanceof ServerPlayer) {
                try {
                    if (Helper.isVampire((Player)((Player)event.getEntity())) && event.getEntity().f_19797_ % 64 == 0 && (stats = SurviveEntityStats.getEnergyStats((LivingEntity)event.getEntity())).isTired()) {
                        stats.setEnergyLevel(stats.getEnergyLevel() + 1);
                        SurviveEntityStats.setStaminaStats((LivingEntity)event.getEntity(), (StaminaData)stats);
                    }
                }
                catch (Throwable e) {
                    if (!this.warnStamina) break block9;
                    LOGGER.error("Failed to grant stamina boost for vampire", e);
                    this.warnStamina = false;
                }
            }
        }
    }

    @SubscribeEvent
    public void onRenderOverlay(RenderGuiOverlayEvent event) {
        if (Minecraft.m_91087_().f_91074_ == null) {
            return;
        }
        if (event.getOverlay().id().equals((Object)THIRST_OVERLAY) && ((Boolean)SurviveCompat.disableThirstForVampires.get()).booleanValue() && Helper.isVampire((Player)Minecraft.m_91087_().f_91074_)) {
            event.setCanceled(true);
        }
        if (event.getOverlay().id().equals((Object)STAMINA_OVERLAY) && ((Boolean)SurviveCompat.enableStaminaBoostVampires.get()).booleanValue() && Helper.isVampire((Player)Minecraft.m_91087_().f_91074_)) {
            event.setCanceled(true);
        }
    }
}

