/*
 * Decompiled with CFR 0.152.
 */
package net.clearlagplus;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextColor;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class ClearLagExclusions {
    private static final Set<String> excludedEntities = new HashSet<String>();
    private static final Path EXCLUSIONS_FILE = Path.of("config/clearlagplus/excluded-entities.txt", new String[0]);

    public static void loadExclusions() {
        excludedEntities.clear();
        try {
            if (Files.exists(EXCLUSIONS_FILE, new LinkOption[0])) {
                List<String> lines = Files.readAllLines(EXCLUSIONS_FILE);
                for (String line : lines) {
                    if ((line = line.trim()).isEmpty() || line.startsWith("#")) continue;
                    excludedEntities.add(line);
                }
            } else {
                Files.createDirectories(EXCLUSIONS_FILE.getParent(), new FileAttribute[0]);
                Files.createFile(EXCLUSIONS_FILE, new FileAttribute[0]);
            }
        }
        catch (IOException e) {
            System.err.println("[ClearLag+] Erreur chargement exclusions: " + e);
        }
        System.out.println("[ClearLag+] Exclusions charg\u00e9es: " + excludedEntities);
    }

    public static void saveExclusions() {
        try (BufferedWriter writer = Files.newBufferedWriter(EXCLUSIONS_FILE, new OpenOption[0]);){
            for (String id : excludedEntities) {
                writer.write(id);
                writer.newLine();
            }
        }
        catch (IOException e) {
            System.err.println("[ClearLag+] Erreur sauvegarde exclusions: " + e);
        }
    }

    public static boolean isEntityExcluded(String entityId) {
        if (excludedEntities.contains(entityId)) {
            return true;
        }
        String modid = entityId.split(":")[0];
        return excludedEntities.contains(modid + ":*");
    }

    public static void addExcludedEntity(String entityId) {
        excludedEntities.add(entityId);
        ClearLagExclusions.saveExclusions();
    }

    public static void removeExcludedEntity(String entityId) {
        excludedEntities.remove(entityId);
        ClearLagExclusions.saveExclusions();
    }

    public static Set<String> getExcludedEntities() {
        return Collections.unmodifiableSet(excludedEntities);
    }

    @SubscribeEvent
    public static void onRegisterCommands(RegisterCommandsEvent event) {
        event.getDispatcher().register((LiteralArgumentBuilder)Commands.m_82127_((String)"clearlag").then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"exclude").requires(cs -> cs.m_6761_(4))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"add").requires(cs -> cs.m_6761_(4))).then(Commands.m_82129_((String)"entity", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> {
            String id = StringArgumentType.getString((CommandContext)ctx, (String)"entity").replace("\"", "");
            ClearLagExclusions.addExcludedEntity(id);
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237110_((String)"clearlagplus.exclude_added", (Object[])new Object[]{id}), true);
            return 1;
        })))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"remove").requires(cs -> cs.m_6761_(4))).then(Commands.m_82129_((String)"entity", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> {
            String id = StringArgumentType.getString((CommandContext)ctx, (String)"entity").replace("\"", "");
            ClearLagExclusions.removeExcludedEntity(id);
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237110_((String)"clearlagplus.exclude_removed", (Object[])new Object[]{id}), true);
            return 1;
        })))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"list").requires(cs -> cs.m_6761_(4))).executes(ctx -> {
            if (excludedEntities.isEmpty()) {
                ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237110_((String)"clearlagplus.excluded_entities_list", (Object[])new Object[]{"None"}), false);
                return 1;
            }
            for (String id : excludedEntities) {
                MutableComponent clickable = Component.m_237110_((String)"clearlagplus.exclude_remove_button", (Object[])new Object[]{id}).m_130938_(style -> style.m_131148_(TextColor.m_131266_((int)0xFF5555)).m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/clearlag exclude remove \"" + id + "\"")).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237110_((String)"clearlagplus.exclude_remove_hover", (Object[])new Object[]{id}))));
                ((CommandSourceStack)ctx.getSource()).m_288197_(() -> ClearLagExclusions.lambda$onRegisterCommands$10((Component)clickable), false);
            }
            return 1;
        }))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"reload").requires(cs -> cs.m_6761_(4))).executes(ctx -> {
            ClearLagExclusions.loadExclusions();
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237115_((String)"clearlagplus.exclusions_reloaded"), true);
            return 1;
        }))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"mods").requires(cs -> cs.m_6761_(4))).then(Commands.m_82129_((String)"page", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(ctx -> {
            int page = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"page");
            List<String> modids = ModList.get().getMods().stream().map(mod -> mod.getModId()).sorted().toList();
            int pageSize = 30;
            int fromIndex = (page - 1) * pageSize;
            int toIndex = Math.min(modids.size(), fromIndex + pageSize);
            if (fromIndex >= modids.size()) {
                ((CommandSourceStack)ctx.getSource()).m_81352_((Component)Component.m_237113_((String)"\u274c Page too high."));
                return 0;
            }
            List<String> pageList = modids.subList(fromIndex, toIndex);
            for (String modid : pageList) {
                MutableComponent clickable = Component.m_237110_((String)"clearlagplus.exclude_mod_click", (Object[])new Object[]{modid}).m_130938_(style -> style.m_131148_(TextColor.m_131266_((int)0x55FF55)).m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/clearlag exclude add \"" + modid + ":*\"")).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237110_((String)"clearlagplus.exclude_mod_hover", (Object[])new Object[]{modid}))));
                ((CommandSourceStack)ctx.getSource()).m_288197_(() -> ClearLagExclusions.lambda$onRegisterCommands$18((Component)clickable), false);
            }
            if (toIndex < modids.size()) {
                MutableComponent nextPage = Component.m_237115_((String)"clearlagplus.next_page").m_130938_(style -> style.m_131148_(TextColor.m_131266_((int)0xAAAAAA)).m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/clearlag exclude mods " + (page + 1))).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237115_((String)"clearlagplus.next_page_hover"))));
                ((CommandSourceStack)ctx.getSource()).m_288197_(() -> ClearLagExclusions.lambda$onRegisterCommands$20((Component)nextPage), false);
            }
            return 1;
        })))));
    }

    private static /* synthetic */ Component lambda$onRegisterCommands$20(Component nextPage) {
        return nextPage;
    }

    private static /* synthetic */ Component lambda$onRegisterCommands$18(Component clickable) {
        return clickable;
    }

    private static /* synthetic */ Component lambda$onRegisterCommands$10(Component clickable) {
        return clickable;
    }
}

