/*
 * Decompiled with CFR 0.152.
 */
package net.potionstudios.biomeswevegone.world.level.levelgen.structure.sharpenedrock;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import corgitaco.corgilib.math.blendingfunction.BlendingFunction;
import it.unimi.dsi.fastutil.Pair;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.Optional;
import java.util.function.BiPredicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.XoroshiroRandomSource;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.synth.ImprovedNoise;
import net.potionstudios.biomeswevegone.world.level.levelgen.structure.BWGStructureTypes;
import net.potionstudios.biomeswevegone.world.level.levelgen.structure.sharpenedrock.SharpenedRockConfig;
import net.potionstudios.biomeswevegone.world.level.levelgen.structure.sharpenedrock.SharpenedRockPiece;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaterniond;
import org.joml.Vector3d;

public class SharpenedRockStructure
extends Structure {
    public static final ImprovedNoise NOISE = new ImprovedNoise((RandomSource)new XoroshiroRandomSource(100L));
    public static final Codec<SharpenedRockStructure> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)SharpenedRockStructure.m_226567_((RecordCodecBuilder.Instance)builder), (App)SharpenedRockConfig.CODEC.fieldOf("config").forGetter(sharpenedRockStructure -> sharpenedRockStructure.config)).apply((Applicative)builder, SharpenedRockStructure::new)).codec();
    private final SharpenedRockConfig config;

    public SharpenedRockStructure(Structure.StructureSettings structureSettings, SharpenedRockConfig config) {
        super(structureSettings);
        this.config = config;
    }

    @NotNull
    protected Optional<Structure.GenerationStub> m_214086_(@NotNull Structure.GenerationContext context) {
        return SharpenedRockStructure.m_226585_((Structure.GenerationContext)context, (Heightmap.Types)Heightmap.Types.OCEAN_FLOOR_WG, piecesBuilder -> {
            WorldgenRandom random = context.f_226626_();
            RandomState randomState = context.f_226624_();
            ChunkGenerator chunkGenerator = context.f_226622_();
            int radius = this.config.radius().m_214085_((RandomSource)random);
            ChunkPos chunkPos = context.f_226628_();
            int blockX = chunkPos.m_151382_(random.m_188503_(16));
            int blockZ = chunkPos.m_151391_(random.m_188503_(16));
            BlockPos origin = new BlockPos(blockX, chunkGenerator.m_214096_(blockX, blockZ, Heightmap.Types.OCEAN_FLOOR_WG, context.f_226629_(), randomState) - (int)((double)radius * 0.7), blockZ);
            RandomSource randomSource = RandomSource.m_216335_((long)(context.f_226627_() + origin.m_121878_()));
            RandomSource angleRandom = RandomSource.m_216335_((long)(context.f_226627_() + (long)(origin.m_123341_() << 2) + (long)(origin.m_123343_() << 2)));
            float pitch = this.config.pitch().m_214084_((RandomSource)random);
            float yaw = this.config.yaw().m_214084_(angleRandom);
            Long2ObjectOpenHashMap chunks = new Long2ObjectOpenHashMap();
            Quaterniond quaternion = new Quaterniond();
            quaternion.rotateY(Math.toRadians(yaw));
            quaternion.rotateX(Math.toRadians(pitch));
            int[] heightCache = SharpenedRockStructure.createHeightCache(radius, origin);
            SharpenedRockStructure.generateFromCache(radius, heightCache, origin, quaternion, false, (rotatedPos, unRotatedPos) -> {
                Pair entry = (Pair)chunks.computeIfAbsent(ChunkPos.m_151388_((BlockPos)rotatedPos), aLong -> Pair.of((Object)Pair.of((Object)new MutableBoolean(true), (Object)new MutableBoolean(false)), (Object)new BoundingBox(rotatedPos)));
                ((BoundingBox)entry.right()).m_162371_(rotatedPos);
                ((MutableBoolean)((Pair)entry.left()).left()).setTrue();
                return true;
            });
            SharpenedRockStructure.generateFromCache(radius, heightCache, origin, quaternion, true, (rotatedPos, unRotatedPos) -> {
                Pair entry = (Pair)chunks.computeIfAbsent(ChunkPos.m_151388_((BlockPos)rotatedPos), aLong -> Pair.of((Object)Pair.of((Object)new MutableBoolean(false), (Object)new MutableBoolean(true)), (Object)new BoundingBox(rotatedPos)));
                ((BoundingBox)entry.right()).m_162371_(rotatedPos);
                ((MutableBoolean)((Pair)entry.left()).right()).setTrue();
                return true;
            });
            chunks.long2ObjectEntrySet().fastForEach(boundingBoxEntry -> piecesBuilder.m_142679_((StructurePiece)new SharpenedRockPiece(origin, radius, ((MutableBoolean)((Pair)((Pair)boundingBoxEntry.getValue()).left()).right()).isTrue(), ((MutableBoolean)((Pair)((Pair)boundingBoxEntry.getValue()).left()).left()).isTrue(), pitch, yaw, heightCache, 0, (BoundingBox)((Pair)boundingBoxEntry.getValue()).right())));
        });
    }

    public static int[] createHeightCache(int radius, BlockPos origin) {
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        int diameter = radius * 2;
        int[] heightCache = new int[diameter * diameter];
        for (double x = (double)(-radius); x <= (double)radius; x += 0.5) {
            for (double z = (double)(-radius); z <= (double)radius; z += 0.5) {
                mutableBlockPos.m_122154_((Vec3i)origin, (int)x, 0, (int)z);
                int idx = (int)x + radius + ((int)z + radius) * radius;
                if (!mutableBlockPos.m_123314_((Vec3i)origin, (double)radius)) continue;
                double height = SharpenedRockStructure.getHeight(radius, origin, mutableBlockPos);
                heightCache[idx] = (int)height;
            }
        }
        return heightCache;
    }

    public static void generateFromCache(int radius, int[] heights, BlockPos origin, Quaterniond quaternion, boolean reverse, BiPredicate<BlockPos, BlockPos> action) {
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        if (reverse) {
            quaternion.rotateX(Math.toRadians(180.0));
            quaternion.rotateY(Math.toRadians(180.0));
        }
        Vector3d vector3d = new Vector3d(0.0, 0.0, 0.0);
        for (double x = (double)(-radius); x <= (double)radius; x += 0.5) {
            block1: for (double z = (double)(-radius); z <= (double)radius; z += 0.5) {
                BlockPos.MutableBlockPos mutable1 = new BlockPos.MutableBlockPos();
                int height = heights[(int)x + radius + ((int)z + radius) * radius];
                for (int y = 0; y < height; ++y) {
                    mutableBlockPos.m_122154_((Vec3i)origin, (int)x, 0, (int)z);
                    if (!mutableBlockPos.m_123314_((Vec3i)origin, (double)radius)) continue;
                    vector3d.set(x, (double)y, z);
                    Vector3d transformed = quaternion.transform(vector3d);
                    mutable1.m_122154_((Vec3i)origin, (int)Math.round(transformed.x()), (int)Math.round(transformed.y()), (int)Math.round(transformed.z()));
                    if (!action.test((BlockPos)mutable1, (BlockPos)mutableBlockPos.m_142448_(y))) continue block1;
                }
            }
        }
        if (reverse) {
            quaternion.rotateY(Math.toRadians(180.0));
            quaternion.rotateX(Math.toRadians(180.0));
        }
    }

    private static double getHeight(int radius, BlockPos origin, BlockPos.MutableBlockPos mutableBlockPos) {
        double noise = NOISE.m_164308_((double)mutableBlockPos.m_123341_() * 0.1, 0.0, (double)mutableBlockPos.m_123343_() * 0.1);
        double factor = origin.m_123331_((Vec3i)mutableBlockPos) / (double)Mth.m_144944_((int)radius);
        double amplifier = BlendingFunction.EaseInCirc.INSTANCE.apply(1.0 - factor, 15.0, 100.0);
        double noiseAmp = noise * (amplifier * 2.0);
        return amplifier + noiseAmp;
    }

    @NotNull
    public StructureType<?> m_213658_() {
        return BWGStructureTypes.SHARPENED_ROCK.get();
    }
}

