/*
 * Decompiled with CFR 0.152.
 */
package com.periut.chisel.inventory;

import com.periut.chisel.block.ChiselGroupLookup;
import com.periut.chisel.inventory.IInventory;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class ChiselInventory
implements IInventory {
    private final NonNullList<ItemStack> inventory = NonNullList.m_122780_((int)61, (Object)ItemStack.f_41583_);

    @Override
    public NonNullList<ItemStack> getItems() {
        return this.inventory;
    }

    @Override
    public void m_6836_(int slot, ItemStack stack) {
        if (stack.m_41613_() <= 0 || stack.m_41613_() > 99) {
            stack = ItemStack.f_41583_;
        }
        this.getItems().set(slot, (Object)stack);
        if (slot == 0) {
            this.refresh(stack.m_41720_());
        }
    }

    @Override
    public ItemStack m_7407_(int slot, int count) {
        ItemStack result = ContainerHelper.m_18969_(this.getItems(), (int)slot, (int)count);
        if (!result.m_41619_()) {
            this.m_6596_();
            if (slot != 0 && !((ItemStack)this.inventory.get(0)).m_41619_()) {
                int c = ((ItemStack)this.inventory.get(0)).m_41613_();
                result.m_41764_(Math.max(1, Math.min(c, 99)));
            }
        }
        return result;
    }

    public void refresh(Item item) {
        if (!(item instanceof BlockItem)) {
            this.clearInv();
            return;
        }
        List<Item> chiselBlocks = ChiselGroupLookup.getBlocksInGroup(item);
        this.populate(chiselBlocks);
    }

    public void populate(List<Item> chiselBlocks) {
        this.clearInv();
        int baseCount = this.m_8020_(0).m_41613_();
        baseCount = Math.max(1, Math.min(baseCount, 99));
        for (int i = 0; i < 60 && i < chiselBlocks.size(); ++i) {
            this.m_6836_(i + 1, new ItemStack((ItemLike)chiselBlocks.get(i), baseCount));
        }
    }

    public void clearInv() {
        for (int i = 1; i < this.inventory.size(); ++i) {
            this.m_6836_(i, ItemStack.f_41583_);
        }
    }
}

