/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.base.config.definition;

import com.google.common.base.Preconditions;
import java.util.Locale;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraftforge.client.gui.widget.ForgeSlider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetmoon.quark.base.config.type.RGBAColorConfig;
import org.violetmoon.zeta.client.ZetaClient;
import org.violetmoon.zeta.client.config.definition.ClientDefinitionExt;
import org.violetmoon.zeta.client.config.screen.AbstractSectionInputScreen;
import org.violetmoon.zeta.client.config.widget.PencilButton;
import org.violetmoon.zeta.config.ChangeSet;
import org.violetmoon.zeta.config.SectionDefinition;
import org.violetmoon.zeta.config.ValueDefinition;

public class RGBClientDefinition
implements ClientDefinitionExt<SectionDefinition> {
    protected final ValueDefinition<Double> r;
    protected final ValueDefinition<Double> g;
    protected final ValueDefinition<Double> b;
    @Nullable
    protected final ValueDefinition<Double> a;

    public RGBClientDefinition(SectionDefinition def) {
        this.r = def.getValue("R", Double.class);
        this.g = def.getValue("G", Double.class);
        this.b = def.getValue("B", Double.class);
        this.a = def.getValue("A", Double.class);
        Preconditions.checkNotNull(this.r, (Object)"need an 'R' value in this section");
        Preconditions.checkNotNull(this.g, (Object)"need an 'G' value in this section");
        Preconditions.checkNotNull(this.b, (Object)"need an 'B' value in this section");
    }

    public String getSubtitle(ChangeSet changes, SectionDefinition def) {
        double r = (Double)changes.get(this.r);
        double g = (Double)changes.get(this.g);
        double b = (Double)changes.get(this.b);
        if (this.a == null) {
            return String.format(Locale.ROOT, "[%.1f, %.1f, %.1f]", r, g, b);
        }
        double a = (Double)changes.get(this.a);
        return String.format(Locale.ROOT, "[%.1f, %.1f, %.1f, %.1f]", r, g, b, a);
    }

    public void addWidgets(ZetaClient zc, Screen parent, ChangeSet changes, SectionDefinition def, Consumer<AbstractWidget> widgets) {
        RGBInputScreen newScreen = new RGBInputScreen(zc, parent, changes, def);
        widgets.accept((AbstractWidget)new PencilButton(zc, 230, 3, arg_0 -> RGBClientDefinition.lambda$addWidgets$0((Screen)newScreen, arg_0)));
    }

    private static /* synthetic */ void lambda$addWidgets$0(Screen newScreen, Button b1) {
        Minecraft.m_91087_().m_91152_(newScreen);
    }

    class RGBInputScreen
    extends AbstractSectionInputScreen {
        protected ForgeSlider rslide;
        protected ForgeSlider gslide;
        protected ForgeSlider bslide;
        @Nullable
        protected ForgeSlider aslide;
        private static final Component EMPTY = Component.m_237119_();

        public RGBInputScreen(ZetaClient zc, Screen parent, ChangeSet changes, SectionDefinition def) {
            super(zc, parent, changes, def);
        }

        protected void m_7856_() {
            super.m_7856_();
            int w = 100;
            int p = 12;
            int x = this.f_96543_ / 2 - 110;
            int y = 55;
            this.rslide = (ForgeSlider)this.m_142416_((GuiEventListener)this.makeSliderPlease(x, y, w - p, 20, RGBClientDefinition.this.r, "R =", 0xFF0000));
            this.gslide = (ForgeSlider)this.m_142416_((GuiEventListener)this.makeSliderPlease(x, y + 25, w - p, 20, RGBClientDefinition.this.g, "G = ", 65280));
            this.bslide = (ForgeSlider)this.m_142416_((GuiEventListener)this.makeSliderPlease(x, y + 50, w - p, 20, RGBClientDefinition.this.b, "B = ", 30719));
            if (RGBClientDefinition.this.a != null) {
                this.aslide = (ForgeSlider)this.m_142416_((GuiEventListener)this.makeSliderPlease(x, y + 75, w - p, 20, RGBClientDefinition.this.a, "A = ", 0xFFFFFF));
            }
            this.forceUpdateWidgets();
        }

        protected void forceUpdateWidgets() {
            this.rslide.m_93611_(((Double)this.changes.get(RGBClientDefinition.this.r)).doubleValue());
            this.gslide.m_93611_(((Double)this.changes.get(RGBClientDefinition.this.g)).doubleValue());
            this.bslide.m_93611_(((Double)this.changes.get(RGBClientDefinition.this.b)).doubleValue());
            if (this.aslide != null) {
                this.aslide.m_93611_(((Double)this.changes.get(RGBClientDefinition.this.a)).doubleValue());
            }
        }

        private ForgeSlider makeSliderPlease(final int x, final int y, int width, int height, final ValueDefinition<Double> binding, final String label, final int labelColor) {
            return new ForgeSlider(x, y + 50, width, height, EMPTY, EMPTY, 0.0, 1.0, 0.0, 0.0, 1, false){

                protected void m_5697_() {
                    this.m_93611_(RGBInputScreen.this.snap(this));
                    RGBInputScreen.this.changes.set(binding, (Object)this.getValue());
                }

                public void m_88315_(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
                    super.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
                    String displayVal = String.format(Locale.ROOT, "%.2f", this.getValue());
                    int valueColor = RGBInputScreen.this.changes.isDirty(binding) ? ChatFormatting.GOLD.m_126665_() : 0xFFFFFF;
                    guiGraphics.drawString(RGBInputScreen.this.f_96547_, displayVal, (float)x + (float)(this.m_5711_() / 2 - RGBInputScreen.this.f_96547_.m_92895_(displayVal) / 2), (float)(y + 6), valueColor, true);
                    guiGraphics.m_280056_(RGBInputScreen.this.f_96547_, label, x - 20, y + 5, labelColor, true);
                }
            };
        }

        public void m_86600_() {
            this.updateButtonStatus(true);
        }

        public void m_88315_(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
            this.m_280273_(guiGraphics);
            super.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
            int titleLeft = this.f_96543_ / 2;
            guiGraphics.m_280653_(this.f_96547_, (Component)Component.m_237113_((String)this.def.getTranslatedDisplayName(x$0 -> I18n.m_118938_((String)x$0, (Object[])new Object[0]))).m_130940_(ChatFormatting.BOLD), titleLeft, 20, 0xFFFFFF);
            int cx = this.f_96543_ / 2 + 20;
            int cy = 55;
            int size = 95;
            int color = RGBAColorConfig.forColor(this.rslide.getValue(), this.gslide.getValue(), this.bslide.getValue(), this.aslide == null ? 1.0 : this.aslide.getValue()).getColor();
            guiGraphics.m_280509_(cx - 1, cy - 1, cx + size + 1, cy + size + 1, -16777216);
            guiGraphics.m_280509_(cx, cy, cx + size, cy + size, -6710887);
            guiGraphics.m_280509_(cx, cy, cx + size / 2, cy + size / 2, -10066330);
            guiGraphics.m_280509_(cx + size / 2, cy + size / 2, cx + size, cy + size, -10066330);
            guiGraphics.m_280509_(cx, cy, cx + size, cy + size, color);
        }

        private double snap(ForgeSlider s) {
            double val = s.getValue();
            val = this.snap(val, 0.0, s);
            val = this.snap(val, 0.25, s);
            val = this.snap(val, 0.5, s);
            val = this.snap(val, 0.75, s);
            val = this.snap(val, 1.0, s);
            return val;
        }

        private double snap(double val, double target, ForgeSlider s) {
            if (Math.abs(val - target) < 0.02) {
                s.m_93611_(target);
                return target;
            }
            return val;
        }
    }
}

