/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.experimental.module;

import com.mojang.text2speech.Narrator;
import java.util.List;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.SignBlock;
import net.minecraft.world.level.block.entity.SignBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import net.minecraftforge.client.settings.KeyModifier;
import org.violetmoon.quark.base.QuarkClient;
import org.violetmoon.zeta.client.event.load.ZKeyMapping;
import org.violetmoon.zeta.client.event.play.ZInput;
import org.violetmoon.zeta.event.bus.LoadEvent;
import org.violetmoon.zeta.event.bus.PlayEvent;
import org.violetmoon.zeta.module.ZetaLoadModule;
import org.violetmoon.zeta.module.ZetaModule;

@ZetaLoadModule(category="experimental", enabledByDefault=false)
public class NarratorReadoutModule
extends ZetaModule {

    @ZetaLoadModule(clientReplacement=true)
    public static class Client
    extends NarratorReadoutModule {
        private KeyMapping keybind;
        private KeyMapping keybindFull;
        private float last;

        @LoadEvent
        public void registerKeybinds(ZKeyMapping event) {
            this.keybind = event.init("quark.keybind.narrator_readout", null, "quark.gui.keygroup.misc");
            this.keybindFull = event.init("quark.keybind.narrator_full_readout", null, "quark.gui.keygroup.misc");
        }

        @PlayEvent
        public void onMouseInput(ZInput.MouseButton event) {
            boolean down = this.isDown(event.getButton(), 0, true, this.keybind);
            boolean full = this.isDown(event.getButton(), 0, true, this.keybindFull);
            this.acceptInput(down || full, down);
        }

        @PlayEvent
        public void onKeyInput(ZInput.Key event) {
            boolean down = this.isDown(event.getKey(), event.getScanCode(), false, this.keybind);
            boolean full = this.isDown(event.getKey(), event.getScanCode(), false, this.keybindFull);
            this.acceptInput(down || full, down);
        }

        private boolean isDown(int key, int scancode, boolean mouse, KeyMapping keybind) {
            Minecraft mc = Minecraft.m_91087_();
            if (mc.f_91080_ != null) {
                if (mouse) {
                    return keybind.m_90830_(key) && (keybind.getKeyModifier() == KeyModifier.NONE || keybind.getKeyModifier().isActive((IKeyConflictContext)KeyConflictContext.GUI));
                }
                return keybind.m_90832_(key, scancode) && (keybind.getKeyModifier() == KeyModifier.NONE || keybind.getKeyModifier().isActive((IKeyConflictContext)KeyConflictContext.GUI));
            }
            return keybind.m_90857_();
        }

        private void acceptInput(boolean down, boolean full) {
            Minecraft mc = Minecraft.m_91087_();
            float curr = QuarkClient.ticker.total;
            if (down && curr - this.last > 10.0f) {
                Narrator narrator = Narrator.getNarrator();
                String readout = this.getReadout(mc, full);
                if (readout != null) {
                    narrator.say(readout, true);
                    this.last = curr;
                }
            }
        }

        private String getReadout(Minecraft mc, boolean full) {
            LocalPlayer player = mc.f_91074_;
            if (player == null) {
                return I18n.m_118938_((String)"quark.readout.not_ingame", (Object[])new Object[0]);
            }
            StringBuilder sb = new StringBuilder();
            if (mc.f_91080_ == null) {
                HitResult ray = mc.f_91077_;
                if (ray != null && ray.m_6662_() == HitResult.Type.BLOCK) {
                    BlockPos pos = ((BlockHitResult)ray).m_82425_();
                    BlockState state = mc.f_91073_.m_8055_(pos);
                    Item item = state.m_60734_().m_5456_();
                    if (item != null) {
                        sb.append(I18n.m_118938_((String)"quark.readout.looking", (Object[])new Object[]{item.m_7626_(new ItemStack((ItemLike)item)).getString()}));
                        if (full) {
                            sb.append(", ");
                        }
                    }
                    if (state.m_60734_() instanceof SignBlock) {
                        String msg;
                        SignBlockEntity tile = (SignBlockEntity)mc.f_91073_.m_7702_(pos);
                        sb.append(I18n.m_118938_((String)"quark.readout.sign_says", (Object[])new Object[0]));
                        for (Component cmp : tile.m_277142_().m_276945_(false)) {
                            msg = cmp.getString().trim();
                            if (msg.isEmpty()) continue;
                            sb.append(cmp.getString());
                            sb.append(" ");
                        }
                        sb.append(". ");
                        sb.append(I18n.m_118938_((String)"quark.readout.sign_says", (Object[])new Object[0]));
                        for (Component cmp : tile.m_277159_().m_276945_(false)) {
                            msg = cmp.getString().trim();
                            if (msg.isEmpty()) continue;
                            sb.append(cmp.getString());
                            sb.append(" ");
                        }
                        sb.append(". ");
                    }
                }
                if (full) {
                    ItemStack stack = player.m_21205_();
                    ItemStack stack2 = player.m_21206_();
                    if (stack.m_41619_()) {
                        stack = stack2;
                        stack2 = ItemStack.f_41583_;
                    }
                    if (!stack.m_41619_()) {
                        if (!stack2.m_41619_()) {
                            sb.append(I18n.m_118938_((String)"quark.readout.holding_with_off", (Object[])new Object[]{stack.m_41613_(), stack.m_41786_().getString(), stack2.m_41613_(), stack2.m_41786_().getString()}));
                        } else {
                            sb.append(I18n.m_118938_((String)"quark.readout.holding", (Object[])new Object[]{stack.m_41613_(), stack.m_41786_().getString()}));
                        }
                        sb.append(", ");
                    }
                    sb.append(I18n.m_118938_((String)"quark.readout.health", (Object[])new Object[]{(int)mc.f_91074_.m_21223_()}));
                    sb.append(", ");
                    sb.append(I18n.m_118938_((String)"quark.readout.food", (Object[])new Object[]{mc.f_91074_.m_36324_().m_38702_()}));
                }
            } else {
                Screen stack = mc.f_91080_;
                if (stack instanceof AbstractContainerScreen) {
                    ItemStack stack2;
                    AbstractContainerScreen cnt = (AbstractContainerScreen)stack;
                    Slot slot = cnt.getSlotUnderMouse();
                    ItemStack itemStack = stack2 = slot == null ? ItemStack.f_41583_ : slot.m_7993_();
                    if (stack2.m_41619_()) {
                        sb.append(I18n.m_118938_((String)"quark.readout.no_item", (Object[])new Object[0]));
                    } else {
                        List tooltip = Screen.m_280152_((Minecraft)mc, (ItemStack)stack2);
                        for (Component t : tooltip) {
                            MutableComponent print = t.m_6881_();
                            List bros = print.m_7360_();
                            for (Component sib : bros) {
                                TranslatableContents ttc;
                                MutableComponent mut;
                                ComponentContents componentContents;
                                if (!(sib instanceof MutableComponent) || !((componentContents = (mut = (MutableComponent)sib).m_214077_()) instanceof TranslatableContents) || !(ttc = (TranslatableContents)componentContents).m_237508_().contains("enchantment.level.")) continue;
                                bros.set(bros.indexOf(sib), Component.m_237115_((String)ttc.m_237508_().substring("enchantment.level.".length())));
                                break;
                            }
                            sb.append(print.getString());
                            if (full) {
                                sb.append(", ");
                                continue;
                            }
                            break;
                        }
                    }
                } else {
                    sb.append(mc.f_91080_.m_142562_());
                }
            }
            return sb.toString();
        }
    }
}

