/*
 * Decompiled with CFR 0.152.
 */
package immersive_aircraft.entity.weapon;

import immersive_aircraft.entity.VehicleEntity;
import immersive_aircraft.entity.misc.WeaponMount;
import immersive_aircraft.entity.weapon.RotationalManager;
import immersive_aircraft.entity.weapon.Weapon;
import immersive_aircraft.resources.bbmodel.BBAnimationVariables;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import org.joml.Vector3f;

public class Telescope
extends Weapon {
    private final RotationalManager rotationalManager = new RotationalManager(this);
    int lastFireTick = 0;

    public Telescope(VehicleEntity entity, ItemStack stack, WeaponMount mount, int slot) {
        super(entity, stack, mount, slot);
    }

    @Override
    public void tick() {
        LivingEntity pilot;
        this.rotationalManager.tick();
        this.rotationalManager.pointTo(this.getEntity());
        --this.lastFireTick;
        if (this.lastFireTick == 0 && (pilot = this.getEntity().m_6688_()) != null) {
            pilot.m_5496_(SoundEvents.f_144232_, 1.0f, 1.0f);
        }
    }

    @Override
    public void fire(Vector3f direction) {
    }

    @Override
    public void clientFire(int index) {
        LivingEntity pilot = this.getEntity().m_6688_();
        assert (pilot != null);
        if (this.lastFireTick <= 0) {
            pilot.m_5496_(SoundEvents.f_144231_, 1.0f, 1.0f);
        }
        this.lastFireTick = 2;
    }

    public Boolean isScoping() {
        return this.lastFireTick > 0;
    }

    @Override
    public <T extends VehicleEntity> void setAnimationVariables(T entity, float time) {
        super.setAnimationVariables(entity, time);
        float tickDelta = time % 1.0f;
        BBAnimationVariables.set("pitch", (float)((double)this.rotationalManager.getPitch(tickDelta) / Math.PI * 180.0));
        BBAnimationVariables.set("yaw", (float)((double)this.rotationalManager.getYaw(tickDelta) / Math.PI * 180.0));
        BBAnimationVariables.set("roll", (float)((double)this.rotationalManager.getRoll(tickDelta) / Math.PI * 180.0));
    }
}

