/*
 * Decompiled with CFR 0.152.
 */
package artifacts.loot;

import artifacts.Artifacts;
import artifacts.registry.ModLootFunctions;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public class ReplaceWithLootTableFunction
extends LootItemConditionalFunction {
    private final ResourceLocation lootTable;

    public ReplaceWithLootTableFunction(LootItemCondition[] conditions, ResourceLocation lootTable) {
        super(conditions);
        this.lootTable = lootTable;
    }

    public LootItemFunctionType m_7162_() {
        return ModLootFunctions.REPLACE_WITH_LOOT_TABLE.get();
    }

    protected ItemStack m_7372_(ItemStack stack, LootContext lootContext) {
        if (stack.m_41619_()) {
            return stack;
        }
        LootTable table = lootContext.m_78952_().m_7654_().m_278653_().m_278676_(this.lootTable);
        ObjectArrayList loot = new ObjectArrayList();
        table.m_79131_(lootContext, arg_0 -> ((ObjectArrayList)loot).add(arg_0));
        if (loot.size() > 1) {
            Artifacts.LOGGER.warn("Loot table {} in roll_loot_table function generated more than 1 item", (Object)this.lootTable.toString());
        } else if (loot.size() == 0) {
            Artifacts.LOGGER.warn("Failed to generate any loot from loot table {}", (Object)this.lootTable.toString());
            return ItemStack.f_41583_;
        }
        return (ItemStack)loot.get(0);
    }

    public static LootItemConditionalFunction.Builder<?> replaceWithLootTable(ResourceLocation lootTable) {
        return ReplaceWithLootTableFunction.m_80683_(conditions -> new ReplaceWithLootTableFunction((LootItemCondition[])conditions, lootTable));
    }

    public static class Serializer
    extends LootItemConditionalFunction.Serializer<ReplaceWithLootTableFunction> {
        public void serialize(JsonObject object, ReplaceWithLootTableFunction instance, JsonSerializationContext context) {
            super.m_6170_(object, (LootItemConditionalFunction)instance, context);
            object.addProperty("loot_table", instance.lootTable.toString());
        }

        public ReplaceWithLootTableFunction deserialize(JsonObject object, JsonDeserializationContext context, LootItemCondition[] conditions) {
            return new ReplaceWithLootTableFunction(conditions, new ResourceLocation(GsonHelper.m_13906_((JsonObject)object, (String)"loot_table")));
        }
    }
}

