/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.lootjs;

import com.almostreliable.lootjs.LootJSPlatform;
import com.almostreliable.lootjs.core.ILootAction;
import com.almostreliable.lootjs.core.ILootContextData;
import com.almostreliable.lootjs.core.LootJSParamSets;
import com.almostreliable.lootjs.filters.ResourceLocationFilter;
import com.almostreliable.lootjs.loot.results.LootContextInfo;
import com.almostreliable.lootjs.loot.results.LootInfoCollector;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LootModificationsAPI {
    public static final List<ResourceLocationFilter> FILTERS = new ArrayList<ResourceLocationFilter>();
    private static final Logger LOGGER = LogManager.getLogger();
    private static final List<ILootAction> actions = new ArrayList<ILootAction>();
    public static Consumer<String> DEBUG_ACTION = arg_0 -> ((Logger)LOGGER).info(arg_0);
    public static boolean LOOT_MODIFICATION_LOGGING = false;
    public static boolean DISABLE_WITHER_DROPPING_NETHER_STAR = false;
    public static boolean DISABLE_ZOMBIE_DROPPING_HEAD = false;
    public static boolean DISABLE_SKELETON_DROPPING_HEAD = false;
    public static boolean DISABLE_CREEPER_DROPPING_HEAD = false;

    private LootModificationsAPI() {
    }

    public static void reload() {
        actions.clear();
        LOOT_MODIFICATION_LOGGING = false;
        FILTERS.clear();
        FILTERS.add(new ResourceLocationFilter.ByLocation(new ResourceLocation("minecraft:blocks/fire")));
    }

    public static void invokeActions(List<ItemStack> loot, LootContext context) {
        ILootContextData contextData = (ILootContextData)context.m_78953_(LootJSParamSets.DATA);
        assert (contextData != null);
        for (ResourceLocationFilter filter : FILTERS) {
            if (!filter.test(LootJSPlatform.INSTANCE.getQueriedLootTableId(context))) continue;
            return;
        }
        context.m_78952_().m_46473_().m_6180_("LootModificationsAPI::invokeActions");
        ArrayList<ItemStack> emptyItems = new ArrayList<ItemStack>();
        ListIterator<ItemStack> it = loot.listIterator();
        while (it.hasNext()) {
            ItemStack item = it.next();
            if (!item.m_41619_()) continue;
            emptyItems.add(item);
            it.remove();
        }
        contextData.setGeneratedLoot(loot);
        LootContextInfo lootContextInfo = LootContextInfo.create(context);
        for (ILootAction modification : actions) {
            modification.applyLootHandler(context, loot);
            contextData.reset();
        }
        LootModificationsAPI.handleCollector(context, lootContextInfo);
        loot.addAll(emptyItems);
        context.m_78952_().m_46473_().m_7238_();
    }

    private static void handleCollector(LootContext context, @Nullable LootContextInfo lootContextInfo) {
        if (DEBUG_ACTION == null || !LOOT_MODIFICATION_LOGGING || lootContextInfo == null) {
            return;
        }
        LootInfoCollector collector = (LootInfoCollector)context.m_78953_(LootJSParamSets.RESULT_COLLECTOR);
        ILootContextData data = (ILootContextData)context.m_78953_(LootJSParamSets.DATA);
        if (collector == null || data == null || collector.getFirstLayer().isEmpty()) {
            return;
        }
        lootContextInfo.updateLoot(data.getGeneratedLoot());
        StringBuilder sb = new StringBuilder().append("\n").append("[ Loot information ]").append("\n");
        lootContextInfo.getCollector().append(sb, 1);
        sb.append("[ Modifications  ]").append("\n");
        collector.append(sb, 1);
        DEBUG_ACTION.accept(sb.toString());
    }

    public static void addModification(ILootAction action) {
        actions.add(action);
    }
}

